
#### the main frame. All other frames should be packed into this one
frame .mainframe
pack .mainframe -side top -fill x

#### simulation speed
frame .simsettings
label .labelSpeed -text "Simulation Speed:" -relief raised
radiobutton .r0 -text x2 -variable slowdown -value 2 -anchor w 
radiobutton .r1 -text x1 -variable slowdown -value 1 -anchor w 
radiobutton .r2 -text x1/2 -variable slowdown -value 0.5 -anchor w 
radiobutton .r4 -text x1/4 -variable slowdown -value 0.25 -anchor w 
radiobutton .r8 -text x1/32 -variable slowdown -value 0.03125 -anchor w 
radiobutton .r9 -text x1/100 -variable slowdown -value 0.01 -anchor w 
.r1 select
pack .labelSpeed -side top -fill x -in .simsettings -anchor w
pack .r0 .r1 .r2 .r4 .r9 -side left -fill x -in .simsettings

#### visualization options
frame .viewoptions
label .labelView -text "Options:" -relief raised
checkbutton .colprimitives -text "Show Collision Primitives" -variable drawCDPs -anchor w
checkbutton .forces -text "Show Contact Forces" -variable drawContactForces -anchor w
checkbutton .target -text "Show Target Pose" -variable drawDesiredPose -anchor w
checkbutton .fps -text "Add terrain" -variable drawFPS -anchor w
checkbutton .shadow -text "Show Shadows" -variable drawShadows -anchor w
checkbutton .ground -text "Show Ground Plane" -variable drawGroundPlane -anchor w
checkbutton .mesh -text "Show Mesh" -variable drawMesh -anchor w

checkbutton .virtualforces -text "Show Virtual Forces" -variable drawVirtualForces -anchor w
checkbutton .gaitWindow -text "Show Gait Pattern" -variable drawGaitPattern -anchor w
checkbutton .legFrameInfo -text "Show Leg Frame Positions" -variable drawLegFramePos -anchor w

.shadow select
.ground select
pack .labelView -side top -fill x -in .viewoptions -anchor w
pack .colprimitives .mesh .virtualforces .gaitWindow .legFrameInfo .shadow .ground .fps -side top -fill y -in .viewoptions -anchor w



#### camera options
frame .camerasettings
frame .followchar
button .v1 -text Side -anchor w -width 5 -command {camera c_front}
button .v2 -text Front -anchor w -width 5 -command {camera c_side}
button .v3 -text "  45" -anchor w -width 5 -command {camera c_45}
button .v4 -text " -45" -anchor w -width 5 -command {camera c_n45}
button .v8 -text Back  -anchor w -width 5 -command {camera c_back}
label .labelcamera -text "Camera:" -relief raised
checkbutton .camerafollowup -text "Follow Character" -variable followCharacter -anchor s

.camerafollowup select

pack .labelcamera -side top -fill x -in .camerasettings -anchor w
pack .v1 .v2 .v8 -side left -pady 3 -padx 4 -fill x -in .camerasettings -anchor e
pack .camerafollowup -side left -in .followchar -anchor n



#### simulator commands
frame .simulatorlabel
frame .simulatorframe -padx 15 -pady 5
label .labelsimulator -text "Animation:" -relief raised
image create photo reload -file [file join ../data/buttons/reload.gif]
image create photo restart -file [file join ../data/buttons/reload.gif]
image create photo start -file [file join ../data/buttons/start.gif]
image create photo pause -file [file join ../data/buttons/pause.gif]
image create photo step -file [file join ../data/buttons/step.gif]
image create photo record -file [file join ../data/buttons/rec.gif]
image create photo recordWorld -file [file join ../data/buttons/recW.gif]
button .simulstart -image start -anchor center -width 23 -height 23 -command {anim start}
button .simulpause -image pause -anchor center -width 23 -height 23 -command {anim pause}
button .simulstep -image step -anchor center -width 23 -height 23 -command {anim step}
button .simulrestart -image restart -anchor center -width 23 -height 23 -command {anim restart}
button .simulreload -image reload -anchor center -width 23 -height 23 -command reloadAnimation
checkbutton .record -image record -anchor center -width 21 -height 21 -selectcolor SeaGreen1 -indicatoron 0 -variable toggleScreenshots
pack .labelsimulator -side top -fill x -in .simulatorlabel -anchor w
pack .simulrestart .simulstart .simulpause -side left -in .simulatorframe -anchor w

#### other commands
frame .buttonframe -pady 5
label .otherlabel -text "" -relief raised
button .exit -text Quit -anchor center -width 15 -command {quit}
pack .otherlabel -side top -fill x -in .buttonframe -anchor w
pack .exit -in .buttonframe -pady 5 -side top


wm resizable . 0 0

pack .simsettings -in .mainframe -side top -fill x
pack .viewoptions -in .mainframe -side top -fill x
pack .simulatorlabel -in .mainframe -side top -fill x
pack .simulatorframe -in .mainframe -side top -fill x
pack .camerasettings .followchar -in .mainframe -side top -fill x
pack .characterframe -in .mainframe -side top -fill x
pack .conParams -in .mainframe -side top -fill x
pack .buttonframe -in .mainframe -side top -fill x
