#include "wall.h"

wall::wall()
{
	used = false;

	for(int i = 0;i<6; i++)
	{
		textures[i] = 0;
		walls[i] = 1;
	}
}

void wall::draw()
{
	float minx = min[0];
	float maxx = max[0];
	float miny = min[1];
	float maxy = max[1];
	float minz = min[2];
	float maxz = max[2];

	glColor3f(col[0], col[1], col[2]);

	glEnable(GL_TEXTURE_2D);


	if(walls[0]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[0]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(1,1);	
	glNormal3f(1,-1,1);
	glVertex3f(maxx,miny,maxz);
	glTexCoord2f(1,0);	
	glNormal3f(1,1,1);
	glVertex3f(maxx,maxy,maxz);
	glTexCoord2f(0,0);
	glNormal3f(-1,1,1);
	glVertex3f(minx,maxy,maxz);
	glTexCoord2f(0,1);	
	glNormal3f(-1,-1,1);
	glVertex3f(minx,miny,maxz);
	
	

	glEnd();
	}


	if(walls[3]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[3]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(0, 1);
	glNormal3f(1,-1,1);
	glVertex3f(maxx,miny,maxz);
	glTexCoord2f(1, 1);
	glNormal3f(1,-1,-1);
	glVertex3f(maxx,miny,minz);
	glTexCoord2f(1, 0);
	glNormal3f(1,1,-1);
	glVertex3f(maxx,maxy,minz);
	glTexCoord2f(0, 0);	
	glNormal3f(1,1,1);
	glVertex3f(maxx,maxy,maxz);
	
	
	
	glEnd();
	}


	if(walls[2]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[2]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(0,1);	
	glNormal3f(1,-1,-1);
	glVertex3i(maxx,miny,minz);
	glTexCoord2f(0,0);	
	glNormal3f(1,1,-1);
	glVertex3i(maxx,maxy,minz);
	glTexCoord2f(1,0);	
	glNormal3f(-1,1,-1);
	glVertex3i(minx,maxy,minz);
	glTexCoord2f(1,1);	
	glNormal3f(-1,-1,-1);
	glVertex3i(minx,miny,minz);
	glEnd();
	}


	if(walls[1]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[1]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(1, 1);
	glNormal3f(-1,-1,1);
	glVertex3i(minx,miny,maxz);
	glTexCoord2f(0, 1);
	glNormal3f(-1,-1,-1);
	glVertex3i(minx,miny,minz);
	glTexCoord2f(0, 0); 
	glNormal3f(-1,1,-1);
	glVertex3i(minx,maxy,minz);
	glTexCoord2f(1, 0);
	glNormal3f(-1,1,1);
	glVertex3i(minx,maxy,maxz);
	glEnd();
	}


	if(walls[4]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[4]]);
		
	glBegin(GL_POLYGON);
	glTexCoord2f(1, 1); 
	glNormal3f(1,1,1);
	glVertex3i(maxx,maxy,maxz);
	glTexCoord2f(1, 0.0f); 
	glNormal3f(-1,1,1);
	glVertex3i(minx,maxy,maxz);
	glTexCoord2f(0.0f, 0.0f); 
	glNormal3f(-1,1,-1);
	glVertex3i(minx,maxy,minz);
	glTexCoord2f(0.0f, 1); 
	glNormal3f(1,1,-1);
	glVertex3i(maxx,maxy,minz);
	glEnd();
	}


	if(walls[5]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[5]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(1,0); 
	glNormal3f(1,-1,-1);
	glVertex3i(maxx,miny,minz);
	glTexCoord2f(1, 1); 
	glNormal3f(-1,-1,-1);
	glVertex3i(minx,miny,minz);
	glTexCoord2f(0.0f, 1);
	glNormal3f(-1,-1,1);
	glVertex3i(minx,miny,maxz);
	glTexCoord2f(0.0f, 0.0f); 
	glNormal3f(1,-1,1);
	glVertex3i(maxx,miny,maxz);
	glEnd();
	}
  
}

void wall::SetDimensions( float xmin, float xmax, float ymin, float ymax, float zmin, float zmax, float *colors,int *wall, int *texture, unsigned int* texLst)
{
	min[0] = xmin;
	min[1] = ymin;
	min[2] = zmin;

	max[0] = xmax;
	max[1] = ymax;
	max[2] = zmax;

	col[0] = colors[0];
	col[1] = colors[1];
	col[2] = colors[2];

	for(int i = 0; i<6; i++)
	{
		textures[i] = texture[i];
		walls[i] = wall[i];
	}

	texList = texLst;

	bound.SetBoundry(xmin-0.3, xmax+0.3, ymin-0.3,ymax+0.3, zmin-0.3, zmax+0.3);

	used = true;
}

int wall::test(float x, float y, float z)
{
	return bound.test(x,y,z);
}
