#include "tree.h"

tree::tree()
{
	used = false;
}

void tree::draw()
{
	if(used)
	{

		glPushMatrix();
		glLoadIdentity();
		
		glTranslatef(0,13,0);
		
		glDisable(GL_TEXTURE_2D);
		float rad = 2.5;
		glBegin(GL_TRIANGLE_FAN);
			glNormal3f(0,1,0);
			glColor3f(1,1,1);
			glVertex3f(pos[0],pos[1]+5,pos[2]);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.7,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
			glNormal3f(1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+1*rad,pos[1],pos[2]);
			glNormal3f(1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(0,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]-1*rad);
			glNormal3f(-1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(-1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-1*rad,pos[1],pos[2]);
			glNormal3f(-1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
		glEnd();

		glTranslatef(0,-3,0);
		rad = 3;
		glBegin(GL_TRIANGLE_FAN);
			glNormal3f(0,1,0);
			glColor3f(1,1,1);
			glVertex3f(pos[0],pos[1]+5,pos[2]);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
			glNormal3f(1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+1*rad,pos[1],pos[2]);
			glNormal3f(1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(0,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]-1*rad);
			glNormal3f(-1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(-1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-1*rad,pos[1],pos[2]);
			glNormal3f(-1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
		glEnd();
		

		glTranslatef(0,-3,0);
		rad = 3.5;
		glBegin(GL_TRIANGLE_FAN);
			glNormal3f(0,1,0);
			glColor3f(1,1,1);
			glVertex3f(pos[0],pos[1]+5,pos[2]);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
			glNormal3f(1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+1*rad,pos[1],pos[2]);
			glNormal3f(1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(0,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]-1*rad);
			glNormal3f(-1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(-1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-1*rad,pos[1],pos[2]);
			glNormal3f(-1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
		glEnd();

		glTranslatef(0,-3,0);
		rad = 4;
		glBegin(GL_TRIANGLE_FAN);
			glNormal3f(0,1,0);
			glColor3f(1,1,1);
			glVertex3f(pos[0],pos[1]+5,pos[2]);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
			glNormal3f(1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+1*rad,pos[1],pos[2]);
			glNormal3f(1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]+0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(0,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]-1*rad);
			glNormal3f(-1,-1,-1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]-0.7*rad);
			glNormal3f(-1,-1,0);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-1*rad,pos[1],pos[2]);
			glNormal3f(-1,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0]-0.7*rad,pos[1],pos[2]+0.7*rad);
			glNormal3f(0,-1,1);
			glColor3f(0.55,0.6,0.55);
			glVertex3f(pos[0],pos[1],pos[2]+1*rad);
		glEnd();

		glLoadIdentity();
		glTranslatef(pos[0],pos[1]+4,pos[2]);
		glRotatef(rotation,0,1,0);
		glColor3f(0.5,0.3,0.25);
		glScalef(1,8,1);
		glutSolidCube(1);


		glEnable(GL_TEXTURE_2D);
		glPopMatrix();
	}

  
}

void tree::SetDimensions( float x, float y, float z, int textures, unsigned int* texLst)
{
	pos[0] = x;
	pos[1] = y;
	pos[2] = z;

	texture = textures;

	texList = texLst;

	rotation = 360*rand()/RAND_MAX;

	bound.SetBoundry(x-3, x+3, y+4,y+15, z-3, z+3);

	used = true;
}

int tree::test(float x, float y, float z)
{
	return bound.test(x,y,z);
}