#include "snowman.h"

snowman::snowman()
{
	used = false;
	fire = false;
	armAngle = 0;
	countDown = 0;
	timer = 0;
	angle = 180;


}
	
void snowman::Initialize(float x, float y, float z, int direction)
{
	used = true;

	pos[0] = x;
	pos[1] = y;
	pos[2] = z;

	angle = direction;

	SetBoundry(x, y, z);
}

void snowman::SetBoundry(float x, float y, float z)
{
	bound.SetBoundry(x-2, x+2, y-3,y+9, z-2, z+2);
}

void snowman::draw(float x, float y, float z, bool triggered)
{		
	

	if(fire)
		weapon.draw();

	if(!weapon.used)
	{
		fire = false;
	}

	if(used)
	{
		if(triggered)
		{
			
				float vel[] = {x-pos[0], y-pos[1], z-pos[2]};
				float temp = sqrt(pow(vel[0],2) + pow(vel[2],2));
		
				vel[0] /= temp;
				vel[2] /= temp;
						
				int theta;
				if((vel[0]>=0) & (vel[2]>0))
				{
					if(vel[0] > 0.195)
						theta = 22.5;
					else
						theta = 0;
					if(vel[0] > 0.555)
						theta = 45;
					if(vel[0] > 0.831)
						theta = 67.5;
					if(vel[0] > 0.98)
						theta = 90;

				}
	
				if((vel[0]>=0) & (vel[2]<0))
				{
					if(vel[0] > 0.195)
						theta = 157.5;
					else
						theta = 180;
					if(vel[0] > 0.555)
						theta = 135;
					if(vel[0] > 0.831)
						theta = 112.5;
					if(vel[0] > 0.98)
						theta = 90;
				}
	
				if((vel[0]<0) & (vel[2]<0))
				{
					if(vel[0] < -0.195)
						theta = 202.5;
					else
						theta = 180;
					if(vel[0] < -0.555)
						theta = 225;
					if(vel[0] < -0.831)
						theta = 247.5;
					if(vel[0] < -0.98)
						theta = 270;
					
				}
	
				if((vel[0]<0) & (vel[2]>0))
				{
					if(vel[0] < -0.195)
						theta = 337.5;
					else
						theta = 0;
					if(vel[0] < -0.555)
						theta = 315;
					if(vel[0] < -0.831)
						theta = 292.5;
					if(vel[0] < -0.98)
						theta = 270;
				}

				if(theta-angle > 180)
					theta -= 360;
				if(theta-angle < -180)
					theta +=360;

				if(theta>angle)
				{
					angle ++;
				}
				else if(theta < angle)
				{
					angle--;
				}

			if(!weapon.used && abs(theta-angle) < 46)
			{
					timer = 50+50*rand()/RAND_MAX;
					armAngle = 0;
					weapon.used = true;
	
			}

			if((timer <= 27) & !fire & (abs(theta-angle) < 46))
			{
	
				armAngle += 3;
				
			}
	
			if(armAngle >= 81)
			{
				fire = true;
				armAngle = 80;
				float c = 3.14159/180;
				weapon.Initialize(	pos[0]+5.1*sin(c*(angle-62)),
									pos[1]+6.9,
									pos[2]+5.1*cos(c*(angle-62)),
									x,y,z);
				weapon.draw();
			}
			
		}
		
	
			glColor3f(1,1,1);
			glDisable(GL_TEXTURE_2D);
			glPushMatrix();
			glLoadIdentity();
	
			glTranslatef(pos[0],pos[1],pos[2]);
			glRotatef(angle, 0,1,0);
			glutSolidSphere(3,10,10);
			glTranslatef(0,4,0);
			glutSolidSphere(2,10,10);
	
			//left arm first segment
		glPushMatrix();
		glColor3f(0,0,0);
		glTranslatef(2,0,0);
		glRotatef(-75,1,0,0);
		glTranslatef(0,-1.5,0);
		glPushMatrix();
		glScalef(0.08,2.5,0.08);
		glutSolidCube(1);
		glPopMatrix();

		//second segment
		glTranslatef(0,-1.3,0);
		glRotatef(75,0,0,1);
		glTranslatef(0,0.9,0);
		glPushMatrix();
		glScalef(0.08,1.8,0.08);
		glutSolidCube(1);
		glPopMatrix();

		//Fingers
		glTranslatef(0,0.85,0);
		glPushMatrix();
		glRotatef(80,1,0,0);
		glTranslatef(0,0.4,0);
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glRotatef(40,1,0,0);
		glTranslatef(0,0.4,0);
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glRotatef(0,1,0,0);
		glTranslatef(0,0.4,0);
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		
		glPopMatrix();

		//right arm first segment
		glPushMatrix();
		glColor3f(0,0,0);
		glTranslatef(-1.8,0,0);
		glRotatef(-90,0,0,1);
		glRotatef(-40+armAngle,0,1,0);
		glTranslatef(0,-1.5,0);
		glPushMatrix();
		glScalef(0.08,2.5,0.08);
		glutSolidCube(1);
		glPopMatrix();

		//second segment
		glTranslatef(0,-1.2,0);
		glRotatef(90,0,0,1);
		glTranslatef(0,0.9,0);
		glPushMatrix();
		glScalef(0.08,1.8,0.08);
		glutSolidCube(1);
		glPopMatrix();

		//Fingers
		glTranslatef(0,0.85,0);
		glPushMatrix();
		glRotatef(40,0,0,1);
		glTranslatef(0,0.4,0);
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glRotatef(0,0,0,1);
		glTranslatef(0,0.4,0);
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glRotatef(-40,0,0,1);
		glTranslatef(0,0.4,0);
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		if(!fire)
		{
			glPushMatrix();
			glColor3f(1,1,1);
			glTranslatef(0,2,0);
			glutSolidSphere(1.5,10,10);
			glPopMatrix();
		}
		
		glPopMatrix();

		//head;
		glColor3f(1,1,1);
		glTranslatef(0,3,0);
		glutSolidSphere(1.5,10,10);

		//Make eyes & mouth
		glPushMatrix();
		glTranslatef(0.5,0.1,1.5);
		glColor3f(0,0,0);
		glutSolidSphere(0.15,6,6);
		glPopMatrix();
		glPushMatrix();
		glTranslatef(-0.5,0.1,1.5);
		glutSolidSphere(0.15,6,6);
		glPopMatrix();
		glPushMatrix();
		glTranslatef(0,-0.2,1.5);
		glutSolidSphere(0.15,6,6);
		glPopMatrix();

		//Make eyebrows
		glPushMatrix();
		glTranslatef(0.35,0.35,1.5);
		glRotatef(30,0,0,1);
		glScalef(1.5,0.2,0.2);
		glutSolidCube(0.25);
		glPopMatrix();
		glPushMatrix();
		glTranslatef(-0.35,0.35,1.5);
		glRotatef(-30,0,0,1);
		glScalef(1.5,0.2,0.2);
		glutSolidCube(0.25);
		glPopMatrix();

		//mouth
		glPushMatrix();
		glTranslatef(0.2,-0.7,1.5);
		glRotatef(30,0,0,1);
		glScalef(3,0.2,0.2);
		glutSolidCube(0.25);
		glPopMatrix();

		//Hat
		glPushMatrix();
		glTranslatef(0.3,1.2,0.1);
		glRotatef(-15,0,0,1);
		glRotatef(-8,1,0,0);
		glPushMatrix();
		glScalef(1.8,0.1,1.8);
		glutSolidSphere(1, 10,10);
		glPopMatrix();
		glTranslatef(0,1,-0.2);
		glScalef(1.30,1.4,1.30);
		glutSolidCube(1.4);
		glPopMatrix();

		glPopMatrix();
		glEnable(GL_TEXTURE_2D);

		if(timer > 0)
			timer--;


	}
	else if(countDown > 0)
	{
		glColor3f(1,1,1);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		glTranslatef(pos[0],pos[1],pos[2]);
		glutSolidSphere(countDown,10,10);
		glPopMatrix();
		glEnable(GL_TEXTURE_2D);
		countDown-=0.2;

	}
}

void snowman::death()
{
	countDown = 5;
	used = false;
	fire = false;
}


int snowman::test(float x, float y, float z)
{
	if(used)
	{
		return bound.test(x,y,z);

	}

	return 0;


}

int snowman::checkWeaponBounds(float x,float y,float z)
{
	if(fire)
	{
		int temp = weapon.test(x,y,z);
		if(temp)
		{
			weapon.death();
			fire = false;
		}

		return temp;
	}
	return 0;
}
