#include "snowball.h"

snowball::snowball()
{
	timer = 0;
	used = false;
	notGone = false;
	life = 0;
}
	
void snowball::Initialize(float x, float y, float z, float dirx, float diry, float dirz)
{
	used = true;

	notGone = true;

	pos[0] = x;
	pos[1] = y;
	pos[2] = z;

	vel[0] = dirx-x; 
	vel[1] = diry-y;
	vel[2] = dirz-z;

	float temp = sqrt(pow(vel[0],2) + pow(vel[1],2) + pow(vel[2],2));
	
	vel[0] /= temp;
	vel[1] /= temp;
	vel[2] /= temp;

	life = 180;

	SetBoundry(x, y, z);
}

void snowball::SetBoundry(float x, float y, float z)
{
	bound.SetBoundry(x-1.8, x+1.8, y-1.8,y+1.8, z-1.8, z+1.8);
}

void snowball::draw()
{

	if(used)
	{
	
		pos[0] += 0.9*vel[0];
		pos[1] += 0.9*vel[1];
		pos[2] += 0.9*vel[2];
	
		SetBoundry(pos[0], pos[1], pos[2]);


		glColor3f(1,1,1);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		glLoadIdentity();
		glTranslatef(pos[0],pos[1],pos[2]);
		glutSolidSphere(1.5,10,10);
		glPopMatrix();
		glEnable(GL_TEXTURE_2D);

		life--;
	}
	else if(timer > 0)
	{
		glColor3f(1,1,1);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		glTranslatef(pos[0],pos[1],pos[2]);
		glutSolidSphere(timer,10,10);
		glPopMatrix();
		glEnable(GL_TEXTURE_2D);
		timer-=0.2;
		if(timer <= 0)
		{
			notGone = false;
		}
	}

	

	if(life <= 0)
	{
		death();
	}
}

void snowball::death()
{
	timer = 4;
	used = false;
	life = 0;
}


int snowball::test(float x, float y, float z)
{
	if(used)
	{
		return bound.test(x,y,z);
	}
	return 0;
}