#include "snowKing.h"

snowKing::snowKing()
{
	used = false;
	fire = false;
	extend = false;
	baseAngle = 0;
	countDown = 0;
	angle = 180;
	timer = 0;
	life = 10;


}
	
void snowKing::Initialize(float x, float y, float z,int direction, unsigned int* texLst)
{
	used = true;

	pos[0] = x;
	pos[1] = y;
	pos[2] = z;

	texList = texLst;

	angle = direction;

	SetBoundry(x, y, z);
}

void snowKing::SetBoundry(float x, float y, float z)
{
	bound.SetBoundry(x-5, x+5, y ,y+8, z-5, z+5);
}

void snowKing::draw(float x, float y, float z, bool triggered)
{		
	

	for(int i = 0; i<20;i++)
	{
		if(weapons[i].used)
			weapons[i].draw();
	}


	if(used)
	{
		if(triggered)
		{
			
			float vel[] = {x-pos[0], y-pos[1], z-pos[2]};
			float temp = sqrt(pow(vel[0],2) + pow(vel[2],2));
		
			vel[0] /= temp;
			vel[2] /= temp;

			pos[0] += 0.02*vel[0];
			pos[2] += 0.02*vel[2];
						
				int theta;
				if((vel[0]>=0) & (vel[2]>0))
				{
					if(vel[0] > 0.195)
						theta = 22.5;
					else
						theta = 0;
					if(vel[0] > 0.555)
						theta = 45;
					if(vel[0] > 0.831)
						theta = 67.5;
					if(vel[0] > 0.98)
						theta = 90;

				}
	
				if((vel[0]>=0) & (vel[2]<0))
				{
					if(vel[0] > 0.195)
						theta = 157.5;
					else
						theta = 180;
					if(vel[0] > 0.555)
						theta = 135;
					if(vel[0] > 0.831)
						theta = 112.5;
					if(vel[0] > 0.98)
						theta = 90;
				}
	
				if((vel[0]<0) & (vel[2]<0))
				{
					if(vel[0] < -0.195)
						theta = 202.5;
					else
						theta = 180;
					if(vel[0] < -0.555)
						theta = 225;
					if(vel[0] < -0.831)
						theta = 247.5;
					if(vel[0] < -0.98)
						theta = 270;
					
				}
	
				if((vel[0]<0) & (vel[2]>0))
				{
					if(vel[0] < -0.195)
						theta = 337.5;
					else
						theta = 0;
					if(vel[0] < -0.555)
						theta = 315;
					if(vel[0] < -0.831)
						theta = 292.5;
					if(vel[0] < -0.98)
						theta = 270;
				}

			if(theta-angle > 180)
				theta -= 360;
			if(theta-angle < -180)
				theta +=360;

			if(theta>angle)
			{
				angle++;
			}
			else if(theta < angle)
			{
				angle--;
			}
			

		

			if(extend)
			{
				baseAngle -= 1;
			}
		
			if(!extend)
			{
				baseAngle += 1;
			}

			if(baseAngle >= 60)
			{
				extend = true;
				if(abs(theta-angle) < 10)
				{
					fire1(x,y,z);
					fire2(x,y,z);
				}
			}

			if(baseAngle == 0)
			{
				if(abs(theta-angle) < 10)
				{
					fire1(x,y,z);
					fire2(x,y,z);
				}
			}


			if(baseAngle <= -60)
			{
				extend = false;
				if(abs(theta-angle) < 10)
				{
					fire1(x,y,z);
					fire2(x,y,z);
				};
			}
				
		}
	

		float c = 3.141592654/180;
		SetBoundry(	pos[0]+38*sin(-c*baseAngle/2),pos[1]+34*cos(-c*baseAngle/2),pos[2]);
	
		glColor3f(1,0.2,0.2);
		glColor3f(1,1,1);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		glLoadIdentity();

	
		glTranslatef(pos[0],pos[1],pos[2]);
		
		glutSolidSphere(7,10,10);
		glRotatef(baseAngle, 0,0,1);
		glTranslatef(0,11,0);
		//glColor3f(0.2,0.2,1);
		glutSolidSphere(6,10,10);

		float midAngle = -0.3*baseAngle;
		glRotatef(midAngle, 0,0,1);
		glTranslatef(0,8,0);
		//glColor3f(0.2,1,0.2);
		glutSolidSphere(5,10,10);

		float mid2Angle = -0.3*baseAngle;
		glRotatef(mid2Angle, 0,0,1);
		glTranslatef(0,7,0);
		//glColor3f(1,1,0.1);
		glutSolidSphere(4,10,10);

		float topAngle = -0.4*baseAngle;
		glRotatef(topAngle, 0,0,1);
		glTranslatef(0,8,0);
		glColor3f(1,1,1);
		glRotatef(angle+180, 0,1,0);//top rotation
		glutSolidSphere(6,10,10);

		//left arm
		
		glPushMatrix();

		glTranslatef(4,2.5,-3);
		glutSolidSphere(3,10,10);
		glTranslatef(4,-2.5,-2);
		glutSolidSphere(5,10,10);
		glTranslatef(4,0,-4);
		glutSolidSphere(4,10,10);
		glTranslatef(1,0,-5);
		glutSolidSphere(3,10,10);
		glTranslatef(0,0,-1.8);
		glColor3f(0,0,0);
		glutSolidSphere(2,6,6);
		glColor3f(1,1,1);


		glPopMatrix();


		//right arm
		glPushMatrix();

		glTranslatef(-4,2.5,-3);

		glutSolidSphere(3,10,10);
		glTranslatef(-4,-2.5,-2);
		glutSolidSphere(5,10,10);
		glTranslatef(-4,0,-4);
		glutSolidSphere(4,10,10);
		glTranslatef(-1,0,-5);
		glutSolidSphere(3,10,10);
		glTranslatef(0,0,-1.8);
		glColor3f(0,0,0);
		glutSolidSphere(2,6,6);

		glPopMatrix();

		//head
		glPushMatrix();
		glColor3f(1,1,1);
		glTranslatef(0,5,0);

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, texList[7]);

		glRotatef(-90,0,1,0);
		glRotatef(90,0,0,1);
	

		float x,y,z;
		for(int phi = -90; phi<=90; phi+=20)
		{
			glBegin(GL_QUAD_STRIP);
				for(int thet=-180; thet<= 180; thet += 20)
				{
					x=5*sin(c*thet)*cos(c*phi);
					y=5*cos(c*thet)*cos(c*phi);
					z=5*sin(c*phi);
					glTexCoord2f(1-((float)(phi+90)/180),1-(float)(thet+180)/360); 
					glVertex3d(x,y,z);
					x=5*sin(c*thet)*cos(c*(phi+20));
					y=5*cos(c*thet)*cos(c*(phi+20));
					z=5*sin(c*(phi+20));
					glTexCoord2f(((float)8/9)-((float)(phi+90)/180),1-(float)(thet+180)/360); 
					glVertex3d(x,y,z);
				}
			glEnd();
		}

		glBindTexture(GL_TEXTURE_2D, texList[0]);
		glDisable(GL_TEXTURE_2D);

		glPopMatrix();


		glPopMatrix();
		glEnable(GL_TEXTURE_2D);

		if(timer > 0)
			timer--;
		
	}
	else if(countDown > 0)
	{
		glColor3f(1,1,1);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		glLoadIdentity();

		glTranslatef(pos[0],pos[1],pos[2]);
		glutSolidSphere(9*countDown,10,10);
		glRotatef(baseAngle, 0,0,1);
		glTranslatef(0,11,0);
		glutSolidSphere(8*countDown,10,10);

		float midAngle = -0.3*baseAngle;
		glRotatef(midAngle, 0,0,1);
		glTranslatef(0,8,0);
		glutSolidSphere(7*countDown,10,10);

		float mid2Angle = -0.3*baseAngle;
		glRotatef(mid2Angle, 0,0,1);
		glTranslatef(0,7,0);
		glutSolidSphere(6*countDown,10,10);

		float topAngle = -0.4*baseAngle;
		glRotatef(topAngle, 0,0,1);
		glTranslatef(0,8,0);
		glRotatef(angle+180, 0,1,0);//top rotation
		glutSolidSphere(8*countDown,10,10);

		glPopMatrix();
		glEnable(GL_TEXTURE_2D);

		countDown-=0.02;
	}
}

void snowKing::fire1(float x, float y, float z)
{
	float c = 3.141592654/180;
	int val = NUMSHOTS;
	for(int i = NUMSHOTS-1; i>= 0; i--)
	{
		if(!weapons[i].used)
				val = i;
	}


	if(baseAngle == 0)
	{

		weapons[val].Initialize(pos[0]+21.8*cos(c*(angle-126.6)),pos[1]+34, pos[2]-21.8*sin(c*(angle-126.6)), x, y, z);
	}
	else if(baseAngle == 60)
	{
		weapons[val].Initialize(pos[0]-17.72648+21.8*cos(c*(angle-126.6)),pos[1]+25.84, pos[2]-21.8*sin(c*(angle-126.6)), x, y, z);
	}
	else if(baseAngle == -60)
	{
		weapons[val].Initialize(pos[0]+17.72648+21.8*cos(c*(angle-126.6)),pos[1]+25.84, pos[2]-21.8*sin(c*(angle-126.6)), x, y, z);
	}
	
}

void snowKing::fire2(float x, float y, float z)
{
	float c = 3.141592654/180;
	int val = NUMSHOTS;
	for(int i = NUMSHOTS-1; i>= 0; i--)
	{
		if(!weapons[i].used)
				val = i;
	}

	
	if(baseAngle == 0)
	{
		weapons[val].Initialize(pos[0]+21.8*cos(c*(angle-53.4)),pos[1]+34, pos[2]-21.8*sin(c*(angle-53.4)), x, y, z);
	}
	else if(baseAngle == 60)
	{
		weapons[val].Initialize(pos[0]-17.72648+21.8*cos(c*(angle-53.4)),pos[1]+25.84, pos[2]-21.8*sin(c*(angle-53.4)), x, y, z);
	}
	else if(baseAngle == -60)
	{
		weapons[val].Initialize(pos[0]+17.72648+21.8*cos(c*(angle-53.4)),pos[1]+25.84, pos[2]-21.8*sin(c*(angle-53.4)), x, y, z);
	}
}

int snowKing::hit()
{
	return --life;
}

void snowKing::death()
{
	countDown = 1;
	used = false;

	cout<<"**************************************"<<endl;
	cout<<"********SNOW KING IS DEFEATED!********"<<endl;
	cout<<"**************************************"<<endl;
}


int snowKing::test(float x, float y, float z)
{
	if(used)
	{
		return bound.test(x,y,z);

	}

	return 0;


}

int snowKing::checkWeaponBounds(float x,float y,float z)
{
	int temp;
	for(int i = 0; i<20;i++)
	{
		if(weapons[i].used)
		{
			temp = weapons[i].test(x,y,z);
			if(temp)
			{
				weapons[i].death();
				return temp;
			}
		}
	}
		

	return 0;
}