#include "snow.h"

snow::snow()
{
	time = 0;
	boundsDefined = 0;
}

void snow::SetBoundries(float xmax, float xmin, float ymax, float ymin, float zmax, float zmin)
{
	xMax = xmax;
	xMin = xmin;
	yMax = ymax;
	yMin = ymin+1.1;
	zMax = zmax;
	zMin = zmin;

	for (int i = 0; i<MAX; i++)
	{
		data[6*i] = (float) rand()*(yMax-yMin)/RAND_MAX+yMin;										//y
		data[6*i+1] = (float) rand()*(zMax-zMin)/RAND_MAX+zMin;	//z
		data[6*i+2] = (float) rand()*(xMax-xMin)/RAND_MAX+xMin;	//x
		data[6*i+3] = (int) rand()*2500/RAND_MAX;				//life
		data[6*i+4] = (float) rand()*360/RAND_MAX;				//angle offset
		data[6*i+5] = 0;										//snowflake at bottom
	}

	boundsDefined = 1;
}

void snow::draw()
{
	float c=3.141592654/180;
	glColor3f(1,1,1);
	glPointSize(3);

	GLfloat emission[] = {1,1,1,1.0};
	glPushAttrib(GL_LIGHTING_BIT);
	glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION,emission);

	glDisable(GL_TEXTURE_2D);
	glPushMatrix();
	glLoadIdentity();
	glBegin(GL_POINTS);
	if(boundsDefined)
	{
		for(int i = 0; i<MAX; i++)
		{	

			if(data[6*i+3] <= -300)
			{
				data[6*i] = yMax;
				data[6*i+3] = (int) rand()*2500/RAND_MAX;
				data[6*i+5] = 0;
			}

			if(data[6*i] <= yMin)
			{
				if(!data[6*i+5])
				{
					data[6*i+2] += (float) cos(c*(time + data[6*i+4]));
					data[6*i+1] += (float) sin(c*(time + data[6*i+4]));

					data[6*i+5] = 1;
				}
			
				if(data[6*i+3] > 0)
					glVertex3f(data[6*i+2], data[6*i], data[6*i+1]);
			}
			else
			{
				data[6*i] -= 0.05;
			}
				
			if((data[6*i] > yMin) & (data[6*i+3] > 0))
				glVertex3f(data[6*i+2] + (float) cos(c*(time + data[6*i+4])), data[6*i], (float) data[6*i+1]+sin(c*(time + data[6*i+4])));

			data[6*i+3]--;

		}


	}
	glEnd();
	glPopMatrix();
	glPopAttrib();
	glEnable(GL_TEXTURE_2D);

	time++;
	if(time >= 360)
		time -= 360;
}
