#include "shot.h"

shot::shot()
{
	inUse = false;
	requestExplosion = false;
}

void shot::draw()
{
	if(inUse)
	{
		if(life > 0)
		{
			glColor3f(1,1,1);
			glPointSize(3);

			GLfloat emission[] = {0,1,1,1.0};
	
			glDisable(GL_TEXTURE_2D);
			glPushMatrix();
			glPushAttrib(GL_LIGHTING_BIT);
			glLoadIdentity();
			glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION,emission);
			glTranslatef(p[0],p[1],p[2]);
			glutSolidSphere(0.1,20,20);
			glPopAttrib();
			glPopMatrix();
			glEnable(GL_TEXTURE_2D);
		
			for(int i = 0; i<3; i++)
			{
				p[i] += 2*v[i];
			}
		
			life--;
	
			if(life==0)
			{
				requestExplosion = true;
			}
				
		}
	}

}

void shot::explode()
{		
	requestExplosion = true;
	life = 0;

	for(int i = 0; i<3; i++)
	{
		p[i] -= 2*v[i];
	}
}

void shot::finish()
{
	requestExplosion = false;
	inUse = false;
}

void shot::Start(float posx, float posy, float posz, float vectx, float vecty, float vectz)
{
	p[0] = posx;
	p[1] = posy;
	p[2] = posz;

	v[0] = vectx;
	v[1] = vecty;
	v[2] = vectz;

	life = 60;
	inUse = true;
}