#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream.h>
#include "contain.h"
#include "wall.h"
#include "removeableWall.h"
#include "snow.h"
#include "tree.h"
#include "cyclone.h"
#include "snowman.h"
#include "demon.h"
#include "snowKing.h"

#ifndef ROOM_H
#define ROOM_H

class room{
public:

	#define NUMWALLS 40
	#define NUMSNOWMEN 15
	#define NUMDEMONS 15
	#define NUMREMO 1
	#define NUMTREES 30
	#define NUMCYCS 3

	contain bound;
	snow flakes;
	bool weather;
	
	wall walls[NUMWALLS];
	int  numWalls;

	removeableWall remoWalls[NUMREMO];
	int  numRemoWalls;

	tree trees[NUMTREES];
	int numTrees;

	cyclone cycs[NUMCYCS];
	int numCycs;

	snowman snowmen[NUMSNOWMEN];
	int  numSnowmen;

	demon demons[NUMDEMONS];
	int  numDemons;

	snowKing King;
	bool king;

	int TriggerList[8];
	bool triggered;

	float floor;

	room::room();
	room::draw(float x, float y, float z);

	void room::SetBoundries(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax);

	void room::SetTriggerList(int *Tlist);

	int room::test(float x, float y, float z);
	
	//returns -1 if no hit otherwise returns object number
	int room::checkStructureBounds(float x, float y, float z);

	int room::checkObjectBounds(float x, float y, float z);

	void room::checkOpenDoor(float x, float y, float z);

	void room::AddWall(int *tiling,int *walls, float xmin, float xmax, float ymin, float ymax, float zmin, float zmax, float *colors,unsigned int* texList);

	void room::AddRemoWall(int *tiling,int *walls, float xmin, float xmax, float ymin, float ymax, float zmin, float zmax, float *colors,unsigned int* texList,int dir);

	void room::AddTree(float x, float y, float z, int textures, unsigned int* texList);

	void room::AddTornado(float x, float y, float z, bool active, int height);

	bool room::CycInRange(float x, float y, float z);
	bool room::ParticleInRange(float x, float y, float z, bool* extra);
	void room::AddPoint(float color1, float color2, float color3, float xpos, float ypos, float zpos,int pointLife);

	void room::AddSnowman(float x, float y, float z, int direction);
	void room::AddDemon(float x, float y, float z, int direction);
	void room::AddKing(float x, float y, float z,int direction, unsigned int* texLst);


	void room::Trigger();

	void room::ToggleExtraParticles();

	void room::StartSnowing();

	void room::Reset();

	void room::CeaseFire();

	void room::UndoTrigger();
};
#endif