#include "room.h"

room::room()
{
	floor = 0;
	bool triggered = false;
	weather = false;

	//numTrees = 0;
	numSnowmen = 0;
	numDemons = 0;
	numWalls = 0;
	numRemoWalls = 0;

	for(int i = 0; i<4; i++)
	{
		TriggerList[i] = -1;
	}
}

room::draw(float x, float y, float z)
{
	for(int i = 0; i<numWalls; i++)
	{
		walls[i].draw();
	}

	for(int j = 0; j<numSnowmen; j++)
	{
		snowmen[j].draw(x,y,z, triggered);
	}

	for(int k = 0; k<numDemons; k++)
	{
		demons[k].draw(x,y,z, triggered);
	}

	if(king)
	{
		King.draw(x,y,z, triggered);
	}

	for(int l = 0; l<numRemoWalls; l++)
	{
		remoWalls[l].draw();
	}

	for(int m = 0; m<numTrees; m++)
	{
		trees[m].draw();
	}

	for(int n = 0; n<numCycs; n++)
	{
		cycs[n].draw(x,y,z,triggered);
	}

	if(weather)
	{
		flakes.draw();
	}
}

//
int room::test(float x, float y, float z)
{
	return bound.test(x,y,z);
}

//for checking if any objects have been hit by snowballs
int room::checkStructureBounds(float x, float y, float z)
{
	int temp;
	for(int i = 0; i<numWalls; i++)
	{
		temp = walls[i].test(x,y,z);
		if(temp)
		{
			return temp;
		}
	}

	for(i = 0; i<numRemoWalls; i++)
	{
		temp = remoWalls[i].test(x,y,z);
		if(temp)
		{
			return temp;
		}
	}

	for(i = 0; i<numTrees; i++)
	{
		temp = trees[i].test(x,y,z);
		if(temp)
		{
			return temp;
		}
	}

	return 0;
}

int room::checkObjectBounds(float x, float y, float z)
{
	int temp;
	for(int k = 0; k<numSnowmen; k++)
	{
		temp = snowmen[k].test(x,y,z);
		if(temp)
		{
			snowmen[k].death();
			return temp;
		}

		temp = snowmen[k].checkWeaponBounds(x,y,z);
		if(temp)
		{
			return temp;
		}
	}

	for(int i = 0; i<numDemons; i++)
	{
		temp = demons[i].test(x,y,z);
		if(temp)
		{
			demons[i].death();
			return temp;
		}
	}

	if(king)
	{
		temp = King.test(x,y,z);
		if(temp)
		{
			if(King.hit() <= 0)
				King.death();
	
			return temp;
		}

		temp = King.checkWeaponBounds(x,y,z);
		if(temp)
		{
			return temp;
		}
	}

	return 0;
}

void room::checkOpenDoor(float x, float y, float z)
{
	int temp;
	for(int i = 0; i<numRemoWalls; i++)
	{
		temp = remoWalls[i].test(x,y,z);
		if(temp)
		{
			remoWalls[i].removeWall();
			return;
		}
	}
}

void room::SetBoundries(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax)
{
	bound.SetBoundries(xmin, xmax, ymin, ymax, zmin, zmax);
}

void room::SetTriggerList(int *Tlist)
{
	for(int i = 0; i<8; i++)
	{
		TriggerList[i] = Tlist[i];
	}
}

void room::AddWall(int* tiling,int *wall, float xmin, float xmax, float ymin, float ymax, float zmin, float zmax, float *colors,unsigned int* texList)
{
	if(numWalls >=NUMWALLS)
	{
		cout<<"no more walls can go here"<<endl;
	}
	else
	{
		walls[numWalls].SetDimensions(xmin,xmax,ymin,ymax,zmin,zmax, colors, wall, tiling,texList);
		numWalls++;
	}
}

void room::AddRemoWall(int* tiling,int *wall, float xmin, float xmax, float ymin, float ymax, float zmin, float zmax, float *colors,unsigned int* texList, int dir)
{
	if(numRemoWalls >= NUMREMO)
	{
		cout<<"no more walls can go here"<<endl;
	}
	else
	{
		remoWalls[numRemoWalls].SetDimensions(xmin,xmax,ymin,ymax,zmin,zmax, colors, wall, tiling,texList, dir);
		numRemoWalls++;
	}
}

void room::AddTree(float x, float y, float z, int textures, unsigned int* texList)
{
	if(numTrees >= NUMTREES)
	{
		cout<<"no more trees can go here"<<endl;
	}
	else
	{
		if(y < floor)
			y = floor;
		trees[numTrees].SetDimensions(x,y,z, textures,texList);
		numTrees++;
	}
}

void room::AddTornado(float x, float y, float z, bool active, int height)
{
	if(numCycs >= NUMCYCS)
	{
		cout<<"no more cyclones can go here"<<endl;
	}
	else
	{
		if(y < floor)
			y = floor;
		cycs[numCycs].Initialize(x,y,z,active, height);
		numCycs++;
	}
}

bool room::CycInRange(float x, float y, float z)
{
	bool temp;
	for(int k = 0; k<numCycs; k++)
	{
		temp = cycs[k].inRange(x,y,z);
		if(temp)
		{
			return temp;
		}
	}
	return 0;
}

bool room::ParticleInRange(float x, float y, float z, bool* extra)
{
	bool temp;
	for(int k = 0; k<numCycs; k++)
	{
		temp = cycs[k].ParticleInRange(x,y,z, extra);
		if(temp)
		{
			return temp;
		}
	}
	return 0;
}

void room::AddPoint(float color1, float color2, float color3, float x, float y, float z,int pointLife)
{
	bool temp;
	bool *dummy = false;
	for(int k = 0; k<numCycs; k++)
	{
		temp = cycs[k].ParticleInRange(x,y,z, dummy);
		if(temp)
		{
			cycs[k].AddPoint(color1, color2, color3, x,y,z,pointLife);
			return;
		}
	}
	return;
}


void room::AddSnowman(float x, float y, float z, int direction)
{
	if(numSnowmen >=NUMSNOWMEN)
	{
		cout<<"no more snowmen can go here"<<endl;
	}
	else
	{
		if(y-2 < floor)
		{
			y = floor + 2;
		}
		snowmen[numSnowmen].Initialize(x,y,z,direction);
		numSnowmen++;
	}
}

void room::AddDemon(float x, float y, float z, int direction)
{
	if(numDemons >=NUMDEMONS)
	{
		cout<<"no more demons can go here"<<endl;
	}
	else
	{
		demons[numDemons].Initialize(x,y,z, direction);
		numDemons++;
	}
}

void room::AddKing(float x, float y, float z,int direction, unsigned int* texLst)
{
	if(king)
	{
		cout<<"King already placed in this room"<<endl;
	}
	else
	{
		if(y-6 < floor)
		{
			y = floor + 6;
		}
		King.Initialize(x,y,z,direction,texLst);
		king = true;
	}
}

void room::Trigger()
{
	triggered = true;
}

void room::ToggleExtraParticles()
{
	for(int k = 0; k<numCycs; k++)
	{
		cycs[k].ToggleExtraParticles();
	}
}

void room::StartSnowing()
{
	weather = true;
	flakes.SetBoundries(bound.max[0],bound.min[0],bound.max[1],bound.min[1],bound.max[2],bound.min[2]);
}

void room::Reset()
{
	CeaseFire();
	UndoTrigger();

	for(int k = 0; k<numDemons; k++)
	{
		demons[k].triggered = false;
	}

	numSnowmen = 0;
	numDemons = 0;

	King.life = 10;
	king = false;
}

void room::CeaseFire()
{
	for(int j = 0; j<numSnowmen; j++)
	{
		snowmen[j].weapon.death();
	}

	for(int i = 0; i<20; i++)
	{
		if(King.weapons[i].used)
			King.weapons[i].death();
	}
	
}

void room::UndoTrigger()
{
	
	triggered = false;
}