#include "removeableWall.h"

removeableWall::removeableWall()
{
	used = false;
	remove = false;
	timer = 0;
	direction = 1;
	distance = 0;
	displacement = 0;

	for(int i = 0;i<6; i++)
	{
		textures[i] = 0;
		walls[i] = 1;
	}
}

void removeableWall::draw()
{

	if((distance == 0) && remove)
		return;
	if(distance > 0)
	{
		if(direction < 0)
		{
			min[-direction-1] -= 0.25;//distance*0.05;
			max[-direction-1] -= 0.25;//distance*0.05;
		}
		else
		{
			min[direction-1] += 0.25;//distance*0.05;
			max[direction-1] += 0.25;//distance*0.05;
		}

		distance -= 0.25;
		
		if(distance < 0.25)
			distance = 0;
	}

	bound.SetBoundry(min[0]-0.3, max[0]+0.3, min[1]-0.3,max[1]+0.3, min[2]-0.3, max[2]+0.3);

	float minx = min[0];
	float maxx = max[0];
	float miny = min[1];
	float maxy = max[1];
	float minz = min[2];
	float maxz = max[2];

	glColor3f(col[0], col[1], col[2]);

	glEnable(GL_TEXTURE_2D);


	if(walls[0]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[0]]);
	

	glBegin(GL_POLYGON);
	glTexCoord2f(1,1);	
	glNormal3f(1,-1,1);
	glVertex3f(maxx,miny,maxz);
	glTexCoord2f(1,0);	
	glNormal3f(1,1,1);
	glVertex3f(maxx,maxy,maxz);
	glTexCoord2f(0,0);
	glNormal3f(-1,1,1);
	glVertex3f(minx,maxy,maxz);
	glTexCoord2f(0,1);	
	glNormal3f(-1,-1,1);
	glVertex3f(minx,miny,maxz);
	glEnd();
	}


	if(walls[3]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[3]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(0, 0);	
	glNormal3f(1,1,1);
	glVertex3f(maxx,maxy,maxz);
	glTexCoord2f(1, 0);
	glNormal3f(1,1,-1);
	glVertex3f(maxx,maxy,minz);
	glTexCoord2f(1, 1);
	glNormal3f(1,-1,-1);
	glVertex3f(maxx,miny,minz);
	glTexCoord2f(0, 1);
	glNormal3f(1,-1,1);
	glVertex3f(maxx,miny,maxz);
	glEnd();
	}


	if(walls[2]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[2]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(0,1);	
	glNormal3f(1,-1,-1);
	glVertex3f(maxx,miny,minz);
	glTexCoord2f(0,0);	
	glNormal3f(1,1,-1);
	glVertex3f(maxx,maxy,minz);
	glTexCoord2f(1,0);	
	glNormal3f(-1,1,-1);
	glVertex3f(minx,maxy,minz);
	glTexCoord2f(1,1);	
	glNormal3f(-1,-1,-1);
	glVertex3f(minx,miny,minz);
	glEnd();
	}


	if(walls[1]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[1]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(1, 1);
	glNormal3f(-1,-1,1);
	glVertex3f(minx,miny,maxz);
	glTexCoord2f(0, 1);
	glNormal3f(-1,-1,-1);
	glVertex3f(minx,miny,minz);
	glTexCoord2f(0, 0); 
	glNormal3f(-1,1,-1);
	glVertex3f(minx,maxy,minz);
	glTexCoord2f(1, 0);
	glNormal3f(-1,1,1);
	glVertex3f(minx,maxy,maxz);
	glEnd();
	}


	if(walls[4]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[4]]);
		
	glBegin(GL_POLYGON);
	glTexCoord2f(1, 1); 
	glNormal3f(1,1,1);
	glVertex3f(maxx,maxy,maxz);
	glTexCoord2f(1, 0.0f); 
	glNormal3f(-1,1,1);
	glVertex3f(minx,maxy,maxz);
	glTexCoord2f(0.0f, 0.0f); 
	glNormal3f(-1,1,-1);
	glVertex3f(minx,maxy,minz);
	glTexCoord2f(0.0f, 1); 
	glNormal3f(1,1,-1);
	glVertex3f(maxx,maxy,minz);
	glEnd();
	}


	if(walls[5]){
	glBindTexture(GL_TEXTURE_2D, texList[textures[5]]);

	glBegin(GL_POLYGON);
	glTexCoord2f(1,0); 
	glNormal3f(1,-1,-1);
	glVertex3f(maxx,miny,minz);
	glTexCoord2f(1, 1); 
	glNormal3f(-1,-1,-1);
	glVertex3f(minx,miny,minz);
	glTexCoord2f(0.0f, 1);
	glNormal3f(-1,-1,1);
	glVertex3f(minx,miny,maxz);
	glTexCoord2f(0.0f, 0.0f); 
	glNormal3f(1,-1,1);
	glVertex3f(maxx,miny,maxz);
	glEnd();
	}
  
	glDisable(GL_TEXTURE_2D);

}

void removeableWall::SetDimensions( float xmin, float xmax, float ymin, float ymax, float zmin, float zmax, float *colors,int *wall, int *texture, unsigned int* texLst, int dir)
{
	min[0] = xmin;
	min[1] = ymin;
	min[2] = zmin;

	max[0] = xmax;
	max[1] = ymax;
	max[2] = zmax;

	col[0] = colors[0];
	col[1] = colors[1];
	col[2] = colors[2];

	for(int i = 0; i<6; i++)
	{
		textures[i] = texture[i];
		walls[i] = wall[i];
	}

	texList = texLst;

	bound.SetBoundry(xmin-0.3, xmax+0.3, ymin-0.3,ymax+0.3, zmin-0.3, zmax+0.3);

	used = true;

	setMoveDirection(dir);
}

int removeableWall::test(float x, float y, float z)
{
	return bound.test(x,y,z);
}

void removeableWall::setMoveDirection(int dir)
{
	if(abs(dir) > 3 || dir == 0)
	{
		cout<<"Illegal wall move direction, could not set!"<<endl;
	}
	else{
		direction = dir;
	}
}
void removeableWall::removeWall()
{
	if(!remove)
	{
		switch(abs(direction)){
		case 1:
			distance = max[0] - min[0];
			break;
		case 2:
			distance = max[1] - min[1];
			break;
		case 3:
			distance = max[2] - min[2];
			break;
		}
		remove = true;
	}

	cout<<"Opened Door"<<endl;
}

