#include <GL/glut.h>
#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include "LineHolder.h"
#include "Targets.h"
#include "shot.h"
#include "map.h"
#include "string.h"

//Might need for building
// -lGL -lGLU -lglut 

//Function Definitions
void GenerateCubes();
void GenerateSpheres();
void idle();
void reset();
void stop();
void checkBoundry();
void bounce();
void calcCabinet();
void processHits(GLint hits, GLuint buffer[]);
void DisplayCallback();
void changeSize(int w1, int h1);
void eraseLines();
void startPicking();
void DrawBoundry();
void initMap();
void addBaddies();
void RemoDoorFix();
void OutputString ( float x, float y, char *string );
void OutputDead( float x, float y, char *string );
void draw_2D();


//end texture stuff
#define TRUE					1
#define FALSE					0

//texture stuff
unsigned char* loadPNM( const char *filename, unsigned int& width, unsigned int &height,unsigned int &numComponents );
bool texturing = FALSE;
int currentTexture = 1;

unsigned char camera = '1';
GLuint targetList;
GLuint lineList;

Targets targets;
LineHolder lineHolder;


//NEW STUFF//
int t = 0;

snow sn;
bool flagsnow = 0;

#define NUMEXPLOSIONS  5
explode bomb[NUMEXPLOSIONS];
bool flagexp = 0;
bool explosion = FALSE;

shot fire;
bool firing = FALSE;

map Map;
bool Action = false;

int armor = 5;
int timer = 0;
float hitTimer = 0;
float impactTimer = 0;
int jiggle = 0;

bool atKing;

//END NEW STUFF//

GLdouble rectangle[15];

bool background = TRUE;

int mouseCoords[] = {0,0};
double roll = 0;
double yaw = 0;
double pitch = 0;
double impulse = 0;
double speed = 0;
double strafe = 0;
double rise = 0;

//Projection Stuff
double oblique = 15;
int toggle = 1;

static GLdouble angle[] = {0,0,0};
static GLdouble position[] = {0,0,0};

//Orientation Vectors
static GLdouble view[] = {0,0,1};
static GLdouble normal[] = {0,1,0};
static GLdouble cross[] = {1,0,0};

//Picking Stuff
GLuint selectBuf[512];
#define RENDER					1
#define SELECT					2
int mode = RENDER;

//For cabinet projection
static GLdouble H[]={	1,0,0,0,
						0,1,0,0,
						-cos(15*3.141592/180)/2,-sin(15*3.141592/180)/2,1,0,
						0,0,0,1};

void KeyboardCallback(unsigned char c, int x, int y) {

	switch (c) {
	case 'q':
		exit (0);
		break;
	case '1':
		camera = '1';
		break;
	case '2':
		camera = '2';
		break;
	case '3':
		camera = '3';
		break;
	case '4':
	    camera = '4';
	    break;
	case '5':
		camera = '5';
		break;
	case '6':
	    camera = '6';
	    break;
	case '8':
		if(flagsnow)
			flagsnow = 0;
		else
			flagsnow = 1;
		break;
	case '!':
	  targets.SetTiling(1);
	    break;
	case '@':
	  targets.SetTiling(2);
	    break;
	case '#':
	  targets.SetTiling(3);
	    break;
	case '0':
	  targets.IncreaseTexture();
	    break;
	case '9':
	  targets.DecreaseTexture();
		break;
	case 'u':
		reset();
		addBaddies();
	case 'a':
		stop();
		break;
	case 'x':
		angle[2] += 0.1;
		break;
	case 'v':
		angle[2] -= 0.1;
		break;
	case 'e':
			speed += 0.05;
		break;
	case 'd':
			speed -= 0.05;
		break;
	case 's':
			strafe += 0.05;
		break;
	case 'f':
			strafe -= 0.05;
		break;
	case 'r':
			rise += 0.05;
		break;
	case 'w':
			rise -= 0.05;
		break;
	case 'p':
		toggle++;
		if (toggle>2)
			toggle -= 2;
		break;
	case 'y':
		Map.ToggleExtraParticles();
		break;
	case 'O':
		oblique++;
		calcCabinet();
		break;
	case 'o':
		oblique--;
		calcCabinet();
		break;
	case 'k':
	  if(targets.textures)
		{
			mouseCoords[0] = x;
			mouseCoords[1] = y;
     
			texturing = TRUE;
			mode = SELECT;
			DisplayCallback();
		}
		break;

	case ' ':
	
		Action = true;
	case 'l':
		mouseCoords[0] = x;
		mouseCoords[1] = y;


		GLint viewport[4];
		glGetIntegerv(GL_VIEWPORT,viewport);

		GLdouble modelView[16];
		glGetDoublev(GL_MODELVIEW_MATRIX,modelView);
		GLdouble Proj[16];
		glGetDoublev(GL_PROJECTION_MATRIX,Proj);

		GLfloat *data = new float;
		GLdouble *objx = new double;
        GLdouble *objy = new double;
        GLdouble *objz = new double;


		glReadPixels(mouseCoords[0],viewport[3]-mouseCoords[1],1,1,GL_DEPTH_COMPONENT,GL_FLOAT,data);
		gluUnProject(mouseCoords[0],viewport[3]-mouseCoords[1],*data,modelView,Proj,viewport,objx,objy,objz);
		rectangle[12] = *objx;
		rectangle[13] = *objy;
		rectangle[14] = *objz;

		int count = 0;
		for(int i=viewport[3]-mouseCoords[1]+1;i>=viewport[3]-mouseCoords[1]-1;i=i-2)
		{
			for(int k=mouseCoords[0]-1;k<=mouseCoords[0]+1;k=k+2)
			{
				glReadPixels(k,i,1,1,GL_DEPTH_COMPONENT,GL_FLOAT,data);
				gluUnProject(k,i,*data,modelView,Proj,viewport,objx,objy,objz);

				rectangle[count*3] = *objx;
				rectangle[count*3+1] = *objy;
				rectangle[count*3+2] = *objz;

				count++;
			}
		}



		mode = SELECT;
		DisplayCallback();
		break;
	}
}

void startPicking()
{
	GLint viewport[4];

	glSelectBuffer(512,selectBuf);

	glGetIntegerv(GL_VIEWPORT,viewport);

	glRenderMode(GL_SELECT);

	glInitNames();

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	gluPickMatrix(mouseCoords[0],viewport[3]-mouseCoords[1],3,3,viewport);
}

void stopPicking()
{
	GLint hits = 0;
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glFlush();
	hits = glRenderMode(GL_RENDER);
	if (hits != 0){
		processHits(hits,selectBuf);
	}
	mode = RENDER;
}

void processHits(GLint hits, GLuint buffer[])
{
	int p = 0;
	int cube = buffer[p+3];
	int face = buffer[p+4];
	unsigned int depth = buffer[p+1];
	for(p;p < (hits)*5;p+=5)
	{
		if(buffer[p] == 2 && depth > buffer[p+1])
		{
			depth = buffer[p+1];
			cube = buffer[p+3];
			face = buffer[p+4];
		}

	}

	if(Action)
	{
		Map.OpenDoor(rectangle[12],rectangle[13],rectangle[14]);
	}
	else if(explosion)
	{
		int i = NUMEXPLOSIONS-1;
		int val = NUMEXPLOSIONS;
		for(i; i >= 0; i--)
		{
			
			if(!bomb[i].Used())
				val = i;
		}

		if(val != NUMEXPLOSIONS)
		{
			bomb[val].SetPos(rectangle[12],rectangle[13],rectangle[14]);
			bomb[val].Start(&Map);
		}
		explosion = FALSE;

	}
	else if(!texturing)
	{
		//Calculate Normal of Rectangle
		double vect1[] = {rectangle[0]-rectangle[3],rectangle[1]-rectangle[4],rectangle[2]-rectangle[5]};
		double vect2[] = {rectangle[3]-rectangle[9],rectangle[4]-rectangle[10],rectangle[5]-rectangle[11]};
		double PolyNorm[] = {vect1[1]*vect2[2]-vect1[2]*vect2[1],vect1[0]*vect2[2]-vect1[2]*vect2[0],vect1[0]*vect2[1]-vect1[1]*vect2[0]};

		double temp = sqrt(pow(PolyNorm[0],2) + pow(PolyNorm[1],2) + pow(PolyNorm[2],2));
		PolyNorm[0] /= temp;
		PolyNorm[1] /= temp;
		PolyNorm[2] /= temp;

		for(int k = 0; k<15; k+=3)
		{
			rectangle[k] -= 0.05*PolyNorm[0];
			rectangle[k+1] += 0.05*PolyNorm[1];
			rectangle[k+2] -= 0.05*PolyNorm[2];
		}

		line rect;
		rect.setRect11(rectangle[0],rectangle[1],rectangle[2]);
		rect.setRect12(rectangle[3],rectangle[4],rectangle[5]);
		rect.setRect13(rectangle[9],rectangle[10],rectangle[11]);
		rect.setRect14(rectangle[6],rectangle[7],rectangle[8]);
		rect.setRect1C(rectangle[12],rectangle[13],rectangle[14]);

		rect.points = 1;
		rect.cube = cube;
		rect.face = face;

		lineHolder.checkCompanion(rect);
	
		lineList = glGenLists(1);
		glNewList(lineList,GL_COMPILE);
		lineHolder.printLines();
		glEndList();
	
	}
	else
	  {
	    if(targets.cubes)
	    {
	      targets.SetCubeTexture(cube,face);
	      targets.RemakeCubes();
	    }
	    else
	    {
	      targets.SetSphereTexture(cube);
	      targets.RemakeSpheres();
	    }
	    texturing = FALSE;
	  }
}

void Mouse(int btn, int state, int x, int y)
{
	if (state == GLUT_DOWN)
	{
		mouseCoords[0] = x;
		mouseCoords[1] = y;
	}

	if (state == GLUT_DOWN && btn==GLUT_LEFT_BUTTON)
	{

		fire.Start(	position[0]-normal[0]/2,position[1]-normal[1]/2,position[2]-normal[2]/2,
						view[0], view[1], view[2]);
	}

	if (state == GLUT_UP)
	{
		if(btn==GLUT_LEFT_BUTTON)
		{
			angle[2] = (double) (mouseCoords[0] - x)/75;
		}

		if(btn==GLUT_RIGHT_BUTTON)
		{
			angle[1] = (double) (mouseCoords[0] - x)/75;
			angle[0] = (double) (mouseCoords[1] - y)/75;
		}

	}

}

void idle()
{

	Map.CheckWeaponBounds();

	if(angle[2] <0.01 && angle[2] >-0.01)
	{
		angle[2] = 0;
	}

	roll = 0.03*angle[2];
	angle[2] *= 0.94;

	double i = normal[0];
	double j = normal[1];
	double k = normal[2];

	normal[0] += roll*cross[0];
	normal[1] += roll*cross[1];
	normal[2] += roll*cross[2];

	double temp = sqrt(pow(normal[0],2) + pow(normal[1],2) + pow(normal[2],2));

	normal[0] /= temp;
	normal[1] /= temp;
	normal[2] /= temp;

	cross[0] += roll*-i;
	cross[1] += roll*-j;
	cross[2] += roll*-k;

	temp = sqrt(pow(cross[0],2) + pow(cross[1],2) + pow(cross[2],2));

	cross[0] /= temp;
	cross[1] /= temp;
	cross[2] /= temp;



	//Now do yaw
	if(angle[1] <0.01 && angle[1] >-0.01)
	{
		angle[1] = 0;
	}

	yaw = 0.03*angle[1];
	angle[1] *= 0.94;

	i = view[0];
	j = view[1];
	k = view[2];

	view[0] += yaw*cross[0];
	view[1] += yaw*cross[1];
	view[2] += yaw*cross[2];

	temp = sqrt(pow(view[0],2) + pow(view[1],2) + pow(view[2],2));

	view[0] /= temp;
	view[1] /= temp;
	view[2] /= temp;

	cross[0] += yaw*-i;
	cross[1] += yaw*-j;
	cross[2] += yaw*-k;

	temp = sqrt(pow(cross[0],2) + pow(cross[1],2) + pow(cross[2],2));

	cross[0] /= temp;
	cross[1] /= temp;
	cross[2] /= temp;


	//now do pitch
	if(angle[0] <0.01 && angle[0] >-0.01)
	{
		angle[0] = 0;
	}

	pitch = 0.03*angle[0];
	angle[0] *= 0.94;

	i = normal[0];
	j = normal[1];
	k = normal[2];

	normal[0] += pitch*-view[0];
	normal[1] += pitch*-view[1];
	normal[2] += pitch*-view[2];

	temp = sqrt(pow(normal[0],2) + pow(normal[1],2) + pow(normal[2],2));

	normal[0] /= temp;
	normal[1] /= temp;
	normal[2] /= temp;

	view[0] += pitch*i;
	view[1] += pitch*j;
	view[2] += pitch*k;

	temp = sqrt(pow(view[0],2) + pow(view[1],2) + pow(view[2],2));

	view[0] /= temp;
	view[1] /= temp;
	view[2] /= temp;




	//Now calc pitch
	if(impulse < 0.0001 && impulse > -0.0001)
	{
		impulse = 0;
	}


	speed *= 0.97;
	strafe *= 0.97;
	rise *= 0.97;

	if (speed > 0.5)
	{
		speed = 0.5;
	}
	if (speed < -0.5)
	{
		speed = -0.5;
	}

	if (strafe > 0.5)
	{
		strafe = 0.5;
	}
	if (strafe < -0.5)
	{
		strafe = -0.5;
	}

	if (rise > 0.5)
	{
		rise = 0.5;
	}
	if (rise < -0.5)
	{
		rise = -0.5;
	}

	//do jiggle
	if(jiggle > 0)
	{
		if(jiggle%2)
		{
			angle[0] += (float) rand()/(2*RAND_MAX);
			angle[1] += (float) rand()/(2*RAND_MAX);
			angle[2] += (float) rand()/(2*RAND_MAX);
		}
		else
		{
			angle[0] -= (float) rand()/(2*RAND_MAX);
			angle[1] -= (float) rand()/(2*RAND_MAX);
			angle[2] -= (float) rand()/(2*RAND_MAX);
		}
		jiggle--;
	}


	position[0] += speed*view[0] + strafe*cross[0] + rise*normal[0];
	position[1] += speed*view[1] + strafe*cross[1] + rise*normal[1];
	position[2] += speed*view[2] + strafe*cross[2] + rise*normal[2];

	glutPostRedisplay();
}

void DisplayCallback()
{
	// clear the color buffer
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	// set up camera
	glMatrixMode( GL_PROJECTION );

	glLoadIdentity();

	if (mode == SELECT)
		startPicking();

	switch(toggle)
	{
	case 1:
		gluPerspective( 60, 1, 0.1, 1000.0 );
		break;
	case 2:
		glOrtho(-30,30,-30,30,0.1,100);
		glMultMatrixd(H);
		break;
	}

	
	if(Map.checkStructureBounds(position[0], position[1], position[2])) 
	{
		bounce();
	}

	int temp = Map.checkObjectBounds(position[0], position[1], position[2]);
	if(temp) 
	{
		cout<<"** You've been hit! **"<<endl;
		jiggle = 10;
		armor--;
		impactTimer = 1;
		
		if(armor <= 0)
		{
			cout<<"**********"<<endl;
			cout<<"** DEAD **"<<endl;
			cout<<"**********"<<endl;
			reset();
			Map.Died();
			timer = 80;
		}
	}
	
	

	if(Map.CycInRange(position[0],position[1],position[2]))
	{
		angle[0] -= cross[1]/4;
		angle[1] += normal[1]/4;
		angle[2] += view[1]/4;
	}


	  switch (camera)
	  {
		case '1':
			gluLookAt(	position[0],position[1],position[2],
			view[0]+position[0],view[1]+position[1],view[2]+position[2],
			normal[0],normal[1],normal[2]);
			break;
		case '2':
			gluLookAt(	position[0],position[1],position[2],
			cross[0]+position[0],cross[1]+position[1],cross[2]+position[2],
			normal[0],normal[1],normal[2]);
			break;
		case '3':
		    gluLookAt(	position[0],position[1],position[2],
			-cross[0]+position[0],-cross[1]+position[1],-cross[2]+position[2],
			normal[0],normal[1],normal[2]);
			break;
		case '4':
			gluLookAt(	position[0],position[1],position[2],
			-view[0]+position[0],-view[1]+position[1],-view[2]+position[2],
			normal[0],normal[1],normal[2]);
			break;
		case '5':
		    gluLookAt(	position[0],position[1],position[2],
			normal[0]+position[0],normal[1]+position[1],normal[2]+position[2],
			-view[0],-view[1],-view[2]);
			break;
		case '6':
		    gluLookAt(	position[0],position[1],position[2],
			-normal[0]+position[0],-normal[1]+position[1],-normal[2]+position[2],
			view[0],view[1],view[2]);
			break;
	  }


	  //Start Modelling
	  glMatrixMode( GL_MODELVIEW );
	  glLoadIdentity();

	  draw_2D();
	  


	  Map.draw(position[0], position[1], position[2]);

	if(fire.inUse && Map.checkStructureBounds(fire.p[0],fire.p[1],fire.p[2]))
	{
		fire.explode();
	}

	if(fire.inUse && Map.checkObjectBounds(fire.p[0],fire.p[1],fire.p[2]))
	{
		cout<<"Direct Hit!"<<endl;
		hitTimer = 1;
		fire.explode();
	}

	Map.changeRooms(position[0], position[1], position[2]);

	  if(fire.requestExplosion)
	  {
		int i = NUMEXPLOSIONS-1;
		int val = NUMEXPLOSIONS;
		for(i; i >= 0; i--)
		{
			
			if(!bomb[i].Used())
				val = i;
		}

		int floorVal;
		if(val != NUMEXPLOSIONS)
		{
			
			floorVal = Map.whichRoom(fire.p[0],fire.p[1],fire.p[2]);
			if(floorVal >= 0)
			{
				bomb[val].ymin = Map.RoomHolder[floorVal].floor;
			}

			bomb[val].SetPos(fire.p[0],fire.p[1],fire.p[2]);
			bomb[val].Start(&Map);
			


			
		}

		fire.finish();
		
	  }

	  fire.draw();


	  if(flagsnow)
	  {
		 sn.draw();
	  }


	  for(int i = 0; i<NUMEXPLOSIONS; i++)
	  {
		  if(bomb[i].Used())
		  {

			  bomb[i].draw(position[0],position[1],position[2]);
		  }

	  }

	  //lineHolder.printLines();
	  if(mode != SELECT)
	  {
		glCallList(lineList);
	  }

	
	  targets.Display();


  //****Finish****//
  // draw the buffer to the screen
	  if (mode == SELECT)
		  stopPicking();
	  else
		  glutSwapBuffers();
}

int main(int argc, char **argv)
{
  // create window and rendering context
  glutInit( &argc, argv );
  glutInitDisplayMode( GLUT_DEPTH | GLUT_RGB | GLUT_DOUBLE );
  glutInitWindowSize( 600, 600 );
  glutCreateWindow( "SnowKing Palace" );

  // register display callback
  glutDisplayFunc( DisplayCallback );
  glutKeyboardFunc( KeyboardCallback );
  glutReshapeFunc(changeSize);
  glutMouseFunc(Mouse);
  glutIdleFunc(idle);

  // register Idlefuncitons
  glViewport( 0, 0, 600, 600 );
  glEnable( GL_DEPTH_TEST );


  // lighting stuff
  GLfloat global[] = {1, 1, 1, 1.0};
  GLfloat ambient[] = {0.1, 0.1, 0.1, 1.0};
  GLfloat diffuse[] = {0.4, 0.4, 0.4, 1.0};
  GLfloat specular[] = {1.0, 1.0, 1.0, 1.0};
  GLfloat position0[] = {1.0, 0.5, 1.0, 0.0};
  glLightfv( GL_LIGHT0, GL_POSITION, position0 );
  glLightfv( GL_LIGHT0, GL_AMBIENT, ambient );
  glLightfv( GL_LIGHT0, GL_DIFFUSE, diffuse );
  glLightfv( GL_LIGHT0, GL_SPECULAR, specular );
  GLfloat position1[] = {-1.0, -0.5, -1.0, 0.0};
  glLightfv( GL_LIGHT1, GL_POSITION, position1 );
  glLightfv( GL_LIGHT1, GL_AMBIENT, ambient );
  glLightfv( GL_LIGHT1, GL_DIFFUSE, diffuse );
  glLightfv( GL_LIGHT1, GL_SPECULAR, specular );

  //glLightModelfv( GL_LIGHT_MODEL_AMBIENT, global);
  glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_TRUE);
  //glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);

  glEnable( GL_LIGHTING );
  glEnable( GL_LIGHT0 );
  glEnable( GL_LIGHT1 );
  glEnable( GL_COLOR_MATERIAL );
  
  
  glEnable(GL_TEXTURE_2D); 			// Enable Texture Mapping
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

  glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
  //glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_DECAL);
  //glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_BLEND);

  glShadeModel(GL_SMOOTH);



  Map.loadTexture();
  initMap();
  addBaddies();
  cout<<"Armor Left: 5"<<endl;

  // pass control over to GLUT
  glutMainLoop();

  return 0;       // never reached
}

void bounce()
{
	if(speed > 0)
	{
		position[0] -= speed*view[0];
		position[1] -= speed*view[1];
		position[2] -= speed*view[2];

		speed *=-1;
	}
	else
	{
		position[0] -= speed*view[0];
		position[1] -= speed*view[1];
		position[2] -= speed*view[2];

		speed *= -1;
	}

	
	if(strafe > 0)
	{
		position[0] -= strafe*cross[0];
		position[1] -= strafe*cross[1];
		position[2] -= strafe*cross[2];

		strafe *=-1;
	}
	else
	{
		position[0] -= strafe*cross[0];
		position[1] -= strafe*cross[1];
		position[2] -= strafe*cross[2];

		strafe *= -1;
	}

	if(rise > 0)
	{
		position[0] -= rise*normal[0];
		position[1] -= rise*normal[1];
		position[2] -= rise*normal[2];

		rise *=-1;
	}
	else
	{
		position[0] -= rise*normal[0];
		position[1] -= rise*normal[1];
		position[2] -= rise*normal[2];

		rise *= -1;
	}

}

void reset()
{

	if(Map.currentRoom == 19)
	{
		position[0] = 290;
		position[1] = -90;
		position[2] = -230;

		view[0] = -1;
		view[1] = 0;
		view[2] = 0;

		normal[0] = 0;
		normal[1] = 1;
		normal[2] = 0;

		cross[0] = 0;
		cross[1] = 0;
		cross[2] = 1;
	}
	else if((Map.currentRoom == 20) || (Map.currentRoom == 18) || (Map.currentRoom == 17) ||
			(Map.currentRoom == 16) || (Map.currentRoom == 15) || (Map.currentRoom == 14) ||
			(Map.currentRoom == 13))
	{
		position[0] = 335;
		position[1] = -30;
		position[2] = -85;

		view[0] = 0;
		view[1] = -1;
		view[2] = 0;

		normal[0] = 0;
		normal[1] = 0;
		normal[2] = -1;

		cross[0] = -1;
		cross[1] = 0;
		cross[2] = 0;
	}
	else
	{
		position[0] = 0;
		position[1] = 0;
		position[2] = 0;

		view[0] = 0;
		view[1] = 0;
		view[2] = 1;

		normal[0] = 0;
		normal[1] = 1;
		normal[2] = 0;

		cross[0] = 1;
		cross[1] = 0;
		cross[2] = 0;
	}
		armor = 5;
		Map.finished = false;
	
		RemoDoorFix();
	
		stop();
}

void stop()
{
	speed = 0;
	strafe = 0;
	rise = 0;

	angle[0] = 0;
	angle[1] = 0;
	angle[2] = 0;

	jiggle = 0;
}

void eraseLines()
{
	lineHolder.erase();

	lineList = glGenLists(1);
	glNewList(lineList,GL_COMPILE);
		lineHolder.printLines();
	glEndList();
}


void calcCabinet()
{
	if(oblique<0)
		oblique++;
	if(oblique>88)
		oblique--;
	H[8] = -cos(oblique*3.141592/180)/2;
	H[9] = -sin(oblique*3.141592/180)/2;
}


void changeSize(int w1, int h1) {

	float ratio;

	h1;
	w1;
	// Prevent a divide by zero, when window is too short
	// (you cant make a window of zero width).

	if(h1 == 0)
		h1 = 1;

	ratio = 1.0f * w1 / h1;
	// Reset the coordinate system before modifying
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	// Set the viewport to be the entire window
    glViewport(0, 0, w1, h1);

	// Set the clipping volume
	gluPerspective(60,ratio,0.1,1000);

	// setting the camera now
	glMatrixMode(GL_MODELVIEW);

	if(h1 == 0)
		h1 = 1;

	ratio = 1.0f * w1 / h1;
	// Reset the coordinate system before modifying
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	// Set the viewport to be the entire window
    glViewport(0, 0, w1, h1);

	// Set the clipping volume
	gluPerspective(60,ratio,0.1,1000);

	// setting the camera now
	glMatrixMode(GL_MODELVIEW);
}

void OutputString ( float x, float y, char *string )
{
	int length;
	length = strlen ( string );
	glRasterPos2f ( x, y );
	for (int i = 0; i < length; i++ )
		glutBitmapCharacter ( GLUT_BITMAP_9_BY_15, string[i] );
}

void OutputDead( float x, float y, char *string )
{
	int length;
	length = strlen ( string );
	glRasterPos2f ( x, y );
	for (int i = 0; i < length; i++ )
		glutBitmapCharacter ( GLUT_BITMAP_TIMES_ROMAN_24 , string[i] );
}

void draw_2D()
{
        glDisable ( GL_LIGHTING );
        glDisable ( GL_TEXTURE_2D );


        glMatrixMode ( GL_PROJECTION );
        glPushMatrix ( );
        glLoadIdentity ( );
 
        glOrtho ( 0.0, ( (double)600), 0.0,
                          ( (double)600 ), -0.0, 0.0 );


       glMatrixMode ( GL_MODELVIEW );
       glLoadIdentity ( );

	   if(timer > 0)
	   {
		   glColor3f ( 1,0,0);
		   OutputDead(-0.25, -0.03, "** DEATH **" );
		   timer--;
	   }
	   else
	   {
		   glColor3f   ( 0.7, 0.7, 0.7    );
		   OutputString ( -0.045, -0.03, "-|-" );
	   }

	   if(impactTimer > 0)
	   {
		   glColor3f   ( 1-impactTimer, 0.3, 0.3    );
		   OutputDead( -0.95, 0.77, "**Warning: Impact**" );

		   impactTimer -= 0.04;
	   }

	   if(hitTimer > 0)
	   {
		   glColor3f   ( 1-hitTimer, 0.3, 0.3    );
		   OutputDead( 0.6, 0.8, "**Hit**" );

		   hitTimer -= 0.04;
	   }
       

	   glColor3f   (1, 1, 1);
	   switch(armor){
	   case 1:
		   OutputString ( -0.98, 0.9, "Armor: 1" );
		   break;
	   case 2:
		   OutputString ( -0.98, 0.9, "Armor: 2" );
		   break;
	   case 3:
		   OutputString ( -0.98, 0.9, "Armor: 3" );
		   break;
	   case 4:
		   OutputString ( -0.98, 0.9, "Armor: 4" );
		   break;
	   case 5:
		   OutputString ( -0.98, 0.9, "Armor: 5" );
		   break;
	   }

       glMatrixMode ( GL_PROJECTION );
       glPopMatrix ( );

       glMatrixMode ( GL_MODELVIEW );
 
       glEnable ( GL_LIGHTING );
       glEnable ( GL_TEXTURE_2D );
}

void RemoDoorFix()
{
}



void initMap()
{
	//position[2] = -230;
	//position[1] = -90;
	//position[0] = 300;


	

	//Set up snow
	sn.SetBoundries(50,-50,50,-49.5,50,-50);

	float white[] = {1,1,1};
	float red[] = {1,0,0};
	float pink[] = {1,0.25,0.25};
	float grey[] = {0.3,0.3,0.3};
	float black[] = {0,0,0};
	float green[] = {0.1,0.4,0.1};

	int blank[] = {0,0,0,0,0,0};
	int side1[] = {1,0,0,0,0,0};
	int side2[] = {0,1,0,0,0,0};
	int side3[] = {0,0,1,0,0,0};
	int side4[] = {0,0,0,1,0,0};
	int side5[] = {0,0,0,0,1,0};
	int side6[] = {0,0,0,0,0,1};
	int front[] = {1,1,0,1,0,0};
	int frontBottom[] = {1,0,0,0,0,1};
	int all[] = {1,1,1,1,1,1};

	int topback[] = {0,0,1,0,1,0};
	int	topmajor[] = {1,0,1,0,1,0};
	int topminor[] = {0,1,0,1,1,0};
	int sidetop[] = {0,0,0,1,1,0};

	  
	//************MAKE ROOMS*************
	//room 0: beginning tube
	int room0[] = {1,2,3,4,-1,-1,-1,-1};
	Map.SetAdjacent(0,room0);
	Map.SetRoomBoundries(0, -10,10, -10,10, -10,74);
	Map.SetFloor(0,-9);
	Map.AddWall(0,blank,side6, -9,9,   9,10, -10,75,  white);
	Map.AddWall(0,blank,side5, -9,9, -10,-9, -10,74,  white);
	Map.AddWall(0,blank,side1, -10,10, -10,10, -10,-9,  white);
	Map.AddWall(0,blank,side4, -10,-9, -10,10, -10,74,  white);
	Map.AddWall(0,blank,side2,   9,10, -10,10, -10,74,  white);

	//room1
	int room1[] = {0,2,3,4,5,6,7,8};
	int trigger[] = {4,-1,2,-1};
	Map.SetAdjacent(1,room1);
	Map.SetRoomBoundries(1, -40,40, -40,40,    74,96);
	Map.SetFloor(1,-36);
	Map.SetTriggerList(1,trigger);
	Map.AddWall(1,side5,side5, -40,40,	-37,-36, 75,95,  white);//floor
	side1[0] = 4;
	Map.AddWall(1,side1,side1, -9,9,	9,40,	 74,75,  white);//back top square
	side1[0] = 1;
	Map.AddWall(1,blank,front, -40,-9,	-36,40,	 74,76,  red);//back right side
	Map.AddWall(1,blank,front, 9,40,	-36,40,	 74,76,  red);//back left side
	side1[0] = 5;
	Map.AddWall(1,side1,all, -9,9,	-16,-9, 74,75,  white);//beware sign
	side1[0] = 1;
	side3[2] = 6;
	Map.AddRemoWall(1,side3, side3, -9,9,-36,-16,74,75, red, -1);//door
	side3[2] = 1;
	
	
	trigger[1] = 1;
	//room2
	int room2[] = {0,1,3,4,5,6,7,8};
	Map.SetAdjacent(2,room2);
	Map.SetRoomBoundries(2, -40,40, -40,40,    96,106);
	Map.SetFloor(2,-32);
	Map.SetTriggerList(2,trigger);
	Map.AddWall(2,side5,side5, -40,40,	-33,-32, 95,105,  white);

	//room3
	int room3[] = {0,1,2,4,5,6,7,8};
	Map.SetAdjacent(3,room3);
	Map.SetRoomBoundries(3, -41,41, -40,41,    106,116);
	Map.SetFloor(3,-28);
	Map.SetTriggerList(3,trigger);
	Map.AddWall(3,side5,side5, -40,40,	-29,-28, 105,115,  white);
	Map.AddWall(3,blank,	side2,  39,41,  -36,40,   75,150,  red);//left wall
	Map.AddWall(3,blank,	side4, -41,-39,	-36,40,   75,150,  red);//right wall
	Map.AddWall(3,blank,	side6, -40,40,	39,41,   75,150,  white);//roof


	//room4: stage
	int room4[] = {0,1,2,3,5,6,7,8};
	Map.SetAdjacent(4,room4);
	Map.SetRoomBoundries(4, -40,40, -40,40,    116,150);
	Map.SetFloor(4,-24);
	Map.SetTriggerList(4,trigger);
	Map.AddWall(4,side5,side5, -40,40,	 -25,-24, 115,150,  white);//stage
	side3[2] = 4;
	Map.AddWall(4,side3,	side3, -40,40,  -24,40,  149,151,  pink);//stage wall
	side3[2] = 1;



	int i;	//Make steps in each room
	for(i = 0;i<20; i++)
	{
		Map.AddWall(3,side3,side3, -40+4*i,-36+4*i, -28,-24, 115,116,  white);
		Map.AddWall(2,side3,side3, -40+4*i,-36+4*i, -32,-28, 105,106,  white);//steps
		Map.AddWall(1,side3,side3, -40+4*i,-36+4*i, -36,-32, 95,96,	   white);
	}

	//room 5: passageway
	int room5[] = {2,3,4,1,6,7,8,-1};
	int trigger5[] = {1,2,3,4,-1,-1,-1,-1};
	Map.SetAdjacent(5,room5);
	Map.SetRoomBoundries(5, -10,10, -37,-15, -30,74);
	Map.SetFloor(5,-36);
	Map.SetTriggerList(5,trigger5);
	Map.AddWall(5,blank,side6,	-9,9,	-16,-14,	-40,74,	grey);
	Map.AddWall(5,blank,side5,	-9,9,	-38,-36,	-40,75,	grey);
	Map.AddWall(5,blank,side4,	-10,-9,	-36,-16,	-40,74, grey);
	Map.AddWall(5,blank,side2,	9,10,	-36,-16,	-40,74, grey);

	//room6: inlet and side attack
	int room6[] = {2,3,4,5,7,1,8,-1};
	int trigger6[] = {6,-1,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(6,room6);
	Map.SetRoomBoundries(6, -21,21, -37,-15, -51,-30);
	Map.SetFloor(6,-36);
	Map.SetTriggerList(6,trigger6);
	Map.AddWall(6,blank,side6,	-20,20,	-16,-14,	-50,-40,	grey);
	Map.AddWall(6,blank,side5,	-20,20,	-38,-36,	-50,-40,	grey);
	Map.AddWall(6,blank,side4,	-22,-20,-36,-16,	-50,-40,	grey);
	Map.AddWall(6,blank,side2,	20,22,	-36,-16,	-50,-40,	grey);
	Map.AddWall(6,blank,side3,	20,22,	-36,-16,	-40,-38,	grey);
	Map.AddWall(6,blank,side3,	9,20,	-36,-16,	-40,-38,	grey);
	Map.AddWall(6,blank,side3,	-20,-9,	-36,-16,	-40,-38,	grey);
	Map.AddWall(6,blank,side1,	9,20,	-36,-16,	-52,-50,	grey);
	Map.AddWall(6,blank,side1,	-20,-9,	-36,-16,	-52,-50,	grey);

	//room 7: more passageway
	int room7[] = {2,3,4,1,5,6,8,9};
	int trigger7[] = {6,-1,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(7,room7);
	Map.SetRoomBoundries(7, -10,10, -37,-15, -90,-50);
	Map.SetFloor(7,-36);
	Map.SetTriggerList(7,trigger7);
	Map.AddWall(7,blank,side6,	-9,9,	-16,-14,	-90,-50, grey);
	Map.AddWall(7,blank,side5,	-9,9,	-38,-36,	-90,-50, grey);
	Map.AddWall(7,blank,side4,	-10,-9,	-36,-16,	-90,-50, grey);
	Map.AddWall(7,blank,side2,	9,10,	-36,-16,	-80,-50, grey);

	//room 8: jog to courtyard
	int room8[] = {7,9,-1,-1,-1,-1,-1,-1};
	int trigger8[] = {9,-1,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(8,room8);
	Map.SetRoomBoundries(8, 10,40, -37,-15, -91,-79);
	Map.SetFloor(8,-36);
	Map.SetTriggerList(8,trigger8);
	Map.AddWall(8,blank,side6,	9,40,	-16,-14,	-90,-80, grey);
	Map.AddWall(8,blank,side5,	9,40,	-38,-36,	-90,-80, grey);
	Map.AddWall(8,blank,side3,	9,40,	-36,-16,	-80,-78,  grey);
	Map.AddWall(8,blank,side1,	-9,40,	-36,-16,	-92,-90, grey);

	//make stairs to courtyard

	//room 9: courtyard
	int room9[] = {7,8,10,11,12,-1,-1,-1};
	int trigger9[] = {9,10,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(9,room9);
	Map.SetRoomBoundries(9, 39,302, -37,71, -170,0);
	Map.SetFloor(9,-36);
	Map.StartSnowing(9);
	Map.SetTriggerList(9,trigger9);

	Map.AddWall(9,blank,blank,	40,300,	70,72,		-165,-5, white);
	side5[4] =8;
	Map.AddWall(9,side5,side5,	40,302,	-38,-36,	-165,-5, green);//grass
	side5[4] =1;
	Map.AddWall(9,blank,topmajor,	40,300,	-36,30,	-5,0,	 white);
	Map.AddWall(9,blank,topmajor,	40,300,	-36,30,	-170,-165, white);

	Map.AddWall(9,blank,blank,	40,300,	30,70,	-5,0,	 black);
	Map.AddWall(9,blank,blank,	40,300,	30,70,	-170,-165, black);

	Map.AddWall(9,blank,sidetop,	38,40,	-36,30,	-170,-90,	 white);
	Map.AddWall(9,blank,sidetop,	38,40,	-36,30,	-80,-0, white);

	Map.AddWall(9,blank,blank,	38,40,	30,70,	-166,0, black);
	side4[3] = 9;
	Map.AddWall(9,side4,sidetop,	38,40,	-16,30,	-90,-80, white);//vine
	side4[3] = 1;

	sidetop[3] = 0;
	sidetop[1] = 1;

	topmajor[1]=1;
	Map.AddWall(9,blank,topmajor,300,302,	-36,30,	-170,-90,	 white);
	Map.AddWall(9,blank,topmajor,300,302,	-36,30,	-80,-0, white);
	topmajor[1]=0;

	side2[1] = 9;
	sidetop[5] = 1;
	Map.AddWall(9,side2,sidetop,300,302,	-16,30,	-90,-80, white);//vine
	sidetop[5] = 0;

	Map.AddWall(9,blank,blank,	300,302,	30,70,	-166,0, black);


	side2[1] = 6;
	Map.AddRemoWall(9,side2,sidetop,301,302,-36,-16,-90,-80, white, 2);//door
	side2[1] = 1;

	
	Map.AddTree(9, 50, -37, -152, 0);
	Map.AddTree(9, 47, -37, -19, 0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);
	Map.AddTree(9, (290-47)*rand()/RAND_MAX+47, -37, (-10+160)*rand()/RAND_MAX-170,0);	

	//room 10: ceiling
	int room10[] = {8,9,-1,-1,-1,-1,-1,-1};
	int trigger10[] = {9,-1,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(10,room10);
	Map.SetRoomBoundries(10, -1000,1000, 71,200, -500,500);
	Map.SetFloor(10,-36);
	Map.SetTriggerList(10,trigger10);
	side6[5] = 10;
	Map.AddWall(10,side6,side6,	-1000,1000,	198,200, -500,500, white);
	side6[5] = 1;

	//room 11: jog from courtyard
	int room11[] = {9,10,12,20,-1,-1,-1,-1};
	int trigger11[] = {9,-1,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(11,room11);
	Map.SetRoomBoundries(11, 300,330, -37,-15, -91,-79);
	Map.SetFloor(11,-36);
	Map.SetTriggerList(11,trigger11);
	Map.AddWall(11,blank,side6,	302,340,	-16,-14,	-90,-80, grey);
	Map.AddWall(11,blank,side5,	302,330,	-38,-36,	-90,-80, grey);
	Map.AddWall(11,blank,side3,	302,340,	-36,-16,	-80,-78,  grey);
	Map.AddWall(11,blank,side1,	302,340,	-36,-16,	-92,-90, grey);

	//room 12: jog to tornado room
	int room12[] = {9,11,20,13,14,15,16,17};
	int trigger12[] = {-1,-1,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(12,room12);
	Map.SetRoomBoundries(12, 329,341, -69,-15, -91,-79);
	Map.SetFloor(12,-150);
	Map.SetTriggerList(12,trigger12);
	Map.AddWall(12,blank,side1,	330,340,	-70,-36,	-92,-90, grey);
	Map.AddWall(12,blank,side3,	330,340,	-70,-36,	-80,-78, grey);
	Map.AddWall(12,blank,side2,	340,342,	-70,-16,	-90,-80, grey);
	Map.AddWall(12,blank,side4,	328,330,	-70,-36,	-90,-80, grey);

	//room 20: tornado room
	int room20[] = {11,12,13,14,15,16,17,18};
	int trigger20[] = {20,13,14,-1,16,15,17,-1};
	Map.SetAdjacent(20,room20);
	Map.SetRoomBoundries(20, 289,381, -151,-69, -236,-79);
	Map.SetFloor(20,-150);
	Map.SetTriggerList(20,trigger20);
	side1[0] = 13;
	Map.AddWall(20,side1,side1,	290,380,	-150,-70,	-237,-235, red);
	side1[0] = 1;
	side3[2] = 13;
	Map.AddWall(20,side3,side3,	290,380,	-150,-70,	-80,-78,  red);
	side3[2] = 1;
	side2[1] = 13;
	Map.AddWall(20,side2,side2,	380,382,	-150,-70,	-235,-80, red);
	side2[1] = 1;
	side4[3] = 13;
	Map.AddWall(20,side4,side4,	288,290,	-150,-70,	-225,-80, red);
	side4[3] = 1;
	side5[4] = 12;
	Map.AddWall(20,side5,side5,	290,380,	-152,-150,	-235,-80, white);
	side5[4] = 1;
	Map.AddWall(20,blank,side6,	290,380,	-70,-68,	-235,-90, white);
	Map.AddWall(20,blank,side6,	290,330,	-70,-68,	-90,-80, white);
	Map.AddWall(20,blank,side6,	340,380,	-70,-68,	-90,-80, white);
	Map.AddTornado(20,320, -150, -200, 0, 80);
	Map.AddTornado(20,295, -100, -160, 1, 20);

	//room 13: column
	int room13[] = {12,20,14,15,16,17,18,-1};
	int trigger13[] = {20,17,16,15,14,13,-1,-1};
	Map.SetAdjacent(13,room13);
	Map.SetRoomBoundries(13, 315-5,315+5, -151,-69, -130-5,-130+5);
	Map.SetFloor(13,-110);
	Map.SetTriggerList(13,trigger13);
	Map.AddWall(13,blank,all,	315-5,315+5,	-150,-110,	-130-5,-130+5, green);

	//room 14: column
	int room14[] = {12,20,13,15,16,17,18,-1};
	int trigger14[] = {20,17,16,15,14,13,-1,-1};
	Map.SetAdjacent(14,room14);
	Map.SetRoomBoundries(14, 360-5,360+5, -151,-69, -110-5,-110+5);
	Map.SetFloor(14,-130);
	Map.SetTriggerList(14,trigger14);
	Map.AddWall(14,blank,all,	360-5,360+5,	-150,-130,	-110-5,-110+5, green);

	//room 15: column
	int room15[] = {12,20,13,14,16,17,18,-1};
	int trigger15[] = {20,17,16,15,14,13,-1,-1};
	Map.SetAdjacent(15,room15);
	Map.SetRoomBoundries(15, 340-5,340+5, -151,-69, -175-5,-175+5);
	Map.SetFloor(15,-85);
	Map.SetTriggerList(15,trigger15);
	Map.AddWall(15,blank,all,	340-5,340+5,	-150,-85,	-175-5,-175+5, green);

	//room 16: column
	int room16[] = {12,20,13,14,15,17,18,-1};
	int trigger16[] = {20,17,16,15,14,13,-1,-1};
	Map.SetAdjacent(16,room16);
	Map.SetRoomBoundries(16, 360-5,360+5, -151,-69, -200-5,-200+5);
	Map.SetFloor(16,-120);
	Map.SetTriggerList(16,trigger16);
	Map.AddWall(16,blank,all,	360-5,360+5,	-150,-120,	-200-5,-200+5, green);

	//room 17: column
	int room17[] = {12,20,13,14,15,16,18,-1};
	int trigger17[] = {20,17,16,15,14,13,-1,-1};
	Map.SetAdjacent(17,room17);
	Map.SetRoomBoundries(17, 295-5,295+5, -151,-69, -230-5,-230+5);
	Map.SetFloor(17,-100);
	Map.SetTriggerList(17,trigger17);
	Map.AddWall(17,blank,all,	295-5,295+5,	-150,-100,	-230-5,-230+5, green);

	//room 18: passsage to SnowKing
	int room18[] = {12,20,13,14,15,16,17,19};
	int trigger18[] = {-1,17,-1,-1,-1,-1,-1,18};
	Map.SetAdjacent(18,room18);
	Map.SetRoomBoundries(18, 199,290, -101,-69, -237,-224);
	Map.SetFloor(18,-100);
	Map.SetTriggerList(18,trigger18);
	Map.AddWall(18,blank,side6,	260,290,	-70,-68,	-235,-225, grey);
	Map.AddWall(18,blank,side5,	260,290,	-102,-100,	-235,-225, grey);
	Map.AddWall(18,blank,side1,	260,290,	-100,-70,	-237,-235, grey);
	Map.AddWall(18,blank,side3,	260,290,	-100,-70,	-225,-223, grey);
	side4[3] = 6;
	Map.AddRemoWall(18,side4,side4,258,260, -100,-70,	-235,-225, white, 2);//door
	side4[3] = 1;
	Map.AddWall(18,blank,side6,	200,260,	-70,-68,	-235,-225, grey);
	Map.AddWall(18,blank,side5,	200,260,	-102,-100,	-235,-225, grey);
	Map.AddWall(18,blank,side1,	210,260,	-100,-70,	-237,-235, grey);
	Map.AddWall(18,blank,side3,	200,260,	-100,-70,	-225,-223, grey);
	Map.AddWall(18,blank,side4,	198,200,	-100,-70,	-235,-225, grey);

	//room 19: SnowKing
	int room19[] = {19,18,-1,-1,-1,-1,-1,-1};
	int trigger19[] = {19,18,-1,-1,-1,-1,-1,-1};
	Map.SetAdjacent(19,room19);
	Map.SetRoomBoundries(19, 149,261, -101,-39, -351,-237);
	Map.SetFloor(19,-100);
	Map.SetTriggerList(19,trigger19);
	Map.AddWall(19,blank,side6,	200,210,	-70,-68,	-249,-235, grey);
	Map.AddWall(19,blank,side5,	200,210,	-102,-100,	-249,-235, grey);
	Map.AddWall(19,blank,side4,	198,200,	-100,-70,	-249,-235, grey);
	Map.AddWall(19,blank,side2,	210,212,	-100,-70,	-249,-235, grey);
	side1[0] = 6;
	Map.AddRemoWall(19,side1,side1,200,210, -100,-70,	-250,-248, white, 2);//door
	side1[0] = 1;
	Map.AddWall(19,blank,side6,	150,260,	-40,-38,	-350,-249, white);
	Map.AddWall(19,blank,side5,	150,260,	-102,-100,	-350,-249, white);
	Map.AddWall(19,blank,side4,	148,150,	-100,-40,	-350,-249, white);
	Map.AddWall(19,blank,side2,	260,262,	-100,-40,	-350,-248, white);
	Map.AddWall(19,blank,side1,	150,260,	-100,-40,	-352,-350, white);
	Map.AddWall(19,blank,side3,	150,200,	-100,-40,	-249,-247, white);
	Map.AddWall(19,blank,side3,	210,260,	-100,-40,	-249,-247, white);
	side3[2] = 11;
	Map.AddWall(19,side3,side3,	200,210,	-70,-40,	-249,-247, white);
	side3[2] = 1;
	Map.AddTree(19, 227, -100, -270, 0);
	Map.AddTree(19, 231, -100, -276, 0);
	Map.AddTree(19, 235, -100, -280, 0);
	Map.AddTree(19, 240, -100, -281, 0);

	Map.AddTree(19, 157, -100, -320, 0);
	Map.AddTree(19, 160, -100, -322, 0);
	Map.AddTree(19, 165, -100, -329, 0);
	Map.AddTree(19, 169, -100, -334, 0);

	Map.AddTree(19, 196, -100, -259, 0);
	Map.AddTree(19, 193, -100, -263, 0);
	Map.AddTree(19, 189, -100, -265, 0);
	Map.AddTree(19, 185, -100, -259, 0);
	Map.StartSnowing(19);
	

}

void addBaddies()
{
	Map.clearBaddies();


	Map.AddSnowman(4, -10,-24, 130, 180);
	Map.AddSnowman(4, 10,-24, 130, 180);

	Map.AddSnowman(6, 15,-36, -45, 270);
	Map.AddSnowman(6, -15,-36, -45, 90);

	Map.AddSnowman(9, 47,-37, -162, 0);
	Map.AddSnowman(9, 47,-37, -12, 180);
	Map.AddSnowman(9, 130,-37, -130, 270);
	Map.AddSnowman(9, 120,-37, -50, 270);
	Map.AddSnowman(9, 200,-37, -85, 270);
	Map.AddSnowman(9, 220,-37, -75, 270);
	Map.AddSnowman(9, 220,-37, -95, 270);
	Map.AddSnowman(9, 240,-37, -65, 270);
	Map.AddSnowman(9, 240,-37, -105, 0);
	Map.AddDemon(9, 240,-20, -65, 270);
	Map.AddDemon(9, 240,-20, -105, 270);
	Map.AddDemon(9, 280,-20, -35, 270);
	Map.AddDemon(9, 280,-20, -135, 270);

	Map.AddDemon(10, 300,130, -150, 270);
	Map.AddDemon(10, 300,130, -20, 270);
	
	Map.AddSnowman(13, 315,-110, -130, 0);
	Map.AddSnowman(14, 360,-130, -110, 0);
	Map.AddSnowman(15, 340,-85, -175, 0);
	Map.AddSnowman(16, 360,-120, -200, 0);
	Map.AddSnowman(17, 295,-100, -230, 0);

	Map.AddDemon(20, 335,-140, -140, 0);
	Map.AddDemon(20, 300,-95, -230, 0);
	Map.AddDemon(20, 370,-95, -230, 0);
	
	Map.AddSnowman(18, 250,-100, -230, 0);

	Map.AddKing(19, 213,-100,-320, 0);

}