#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream.h>
#include "room.h"
#include "explodePoint.h"

#ifndef MAP_H
#define MAP_H

class map{
public:

	#define ROOMS 30
	#define ADJACENT 8

	//use room bounds to decide which room you're in
	//use walls to contain
	room RoomHolder[ROOMS];
	int adjacent[ROOMS][ADJACENT];
	int currentRoom;
	unsigned int* texList;
	bool finished;

	map::map();
	void map::draw(float x, float y, float z);

	int map::checkBounds(float x, float y, float z);

	//check if violating any object borders
	int map::checkStructureBounds(float x, float y, float z);

	int map::checkObjectBounds(float x, float y, float z);

	void map::CheckWeaponBounds();

	void map::OpenDoor(float x, float y, float z);

	int map::whichRoom(float x, float y, float z);

	float map::floor(int room);

	void map::StartSnowing(int room);

	void map::SetFloor(int room, float val);

	//Update Rooms
	void map::changeRooms(float x, float y, float z);

	//for setting adjacent rooms
	void map::SetAdjacent(int room, int *adjacentRooms);

	void map::SetTriggerList(int room, int *Tlist);


	//functions for making rooms with things in them
	void map::SetRoomBoundries(int room, float xmin, float xmax,
								float ymin, float ymax, 
								float zmin, float zmax);

	bool map::VerifyDimensions(float xmin, float xmax,
								float ymin, float ymax, 
								float zmin, float zmax);

	void map::AddWall(int room, int *tiling, int *walls,
									float xmin, float xmax,
									float ymin, float ymax, 
									float zmin, float zmax,
									float *color);

	void map::AddRemoWall(int room, int *tiling, int *walls,
									float xmin, float xmax,
									float ymin, float ymax, 
									float zmin, float zmax,
									float *color, int dir);

	void map::AddTree(int room, float x, float y, float z, int textures);

	void map::AddTornado(int room, float x, float y, float z, bool active, int height);

	bool map::CycInRange(float x, float y, float z);
	bool map::ParticleInRange(float x, float y, float z, bool* extra);
	void map::AddPoint(float color1, float color2, float color3, float xpos, float ypos, float zpos,int pointLife);
	void map::ToggleExtraParticles();

	void map::AddSnowman(int room, float x, float y, float z, int direction);
	void map::AddDemon(int room, float x, float y, float z, int direction);
	void map::AddKing(int room, float x, float y, float z, int direction);

	void map::clearBaddies();

	void map::Died();

	void map::UnTrigger();

	void map::loadTexture();
	unsigned char* map::loadPNM( const char *filename, unsigned int& width, unsigned int &height,unsigned int &numComponents );
	
};

#endif