#include "map.h"

map::map()
{
	currentRoom = 0;

	for(int i = 0; i< ROOMS; i++)
	{
		for(int k = 0; k<ADJACENT; k++)
		{
			adjacent[i][k] = -1;
		}
	}

	finished = false;
}

void map::draw(float x, float y, float z)
{
	//you will need to check room boundries in here and adjust accordingly
	RoomHolder[currentRoom].draw(x,y,z);

	for(int i = 0; i<ADJACENT; i++)
	{
		if(adjacent[currentRoom][i] >= 0)
			RoomHolder[adjacent[currentRoom][i]].draw(x,y,z);

	}
}

//check boundries on room
int map::checkBounds(float x, float y, float z)
{
	return RoomHolder[currentRoom].test(x, y, z);
}

void map::CheckWeaponBounds()
{
	for(int i = 0; i< RoomHolder[currentRoom].numSnowmen; i++)
	{
		if(RoomHolder[currentRoom].snowmen[i].fire && checkStructureBounds(	RoomHolder[currentRoom].snowmen[i].weapon.pos[0],
																			RoomHolder[currentRoom].snowmen[i].weapon.pos[1],
																			RoomHolder[currentRoom].snowmen[i].weapon.pos[2]))
		{
			RoomHolder[currentRoom].snowmen[i].weapon.death();
		}
	}

	for(int k = 0; k<ADJACENT; k++)
	{
		if(adjacent[currentRoom][k] >= 0)
		{
			for(i = 0; i< RoomHolder[adjacent[currentRoom][k]].numSnowmen; i++)
			{
				if(RoomHolder[adjacent[currentRoom][k]].snowmen[i].fire && checkStructureBounds(RoomHolder[adjacent[currentRoom][k]].snowmen[i].weapon.pos[0],
																								RoomHolder[adjacent[currentRoom][k]].snowmen[i].weapon.pos[1],
																								RoomHolder[adjacent[currentRoom][k]].snowmen[i].weapon.pos[2]))
				{
					RoomHolder[adjacent[currentRoom][i]].snowmen[i].weapon.death();
				}
			}
		}
	}

	if(currentRoom == 19)
	{
		for(i = 0; i<20; i++)
		{
			if(RoomHolder[19].King.weapons[i].used && checkStructureBounds(	RoomHolder[19].King.weapons[i].pos[0],
																			RoomHolder[19].King.weapons[i].pos[1],
																			RoomHolder[19].King.weapons[i].pos[2]))
			{
				RoomHolder[19].King.weapons[i].death();
			}
		}
	}
}

//returns -1 if no hit otherwise returns object number
int map::checkStructureBounds(float x, float y, float z)
{
	int temp = RoomHolder[currentRoom].checkStructureBounds(x, y, z);
	if(temp)
		return temp;

	for(int i = 0; i<ADJACENT; i++)
		{
			if((adjacent[currentRoom][i] >= 0))
			{
				temp = RoomHolder[adjacent[currentRoom][i]].checkStructureBounds(x,y,z);
				if(temp)
				{
					return temp;
				}
			}
		}
	
	return 0;
}

int map::checkObjectBounds(float x, float y, float z)
{
	int temp = RoomHolder[currentRoom].checkObjectBounds(x, y, z);
	if(temp)
		return temp;

	for(int i = 0; i<ADJACENT; i++)
		{
			if((adjacent[currentRoom][i] >= 0))
			{
				temp = RoomHolder[adjacent[currentRoom][i]].checkObjectBounds(x,y,z);
				if(temp)
				{
					return temp;
				}
			}
		}
	
	return 0;
}

int map::whichRoom(float x, float y, float z)
{
	for(int i = 0; i<ROOMS; i++)
	{
		if(0 == RoomHolder[i].test(x,y,z))
			return i;
	}

	return -1;
}

float map::floor(int room){
	return RoomHolder[room].floor;

}

void map::SetFloor(int room, float val)
{
	RoomHolder[room].floor = val+0.3;
}

void map::StartSnowing(int room)
{
	RoomHolder[room].StartSnowing();
}

//This function must be talored to evey map
void map::changeRooms(float x, float y, float z)
{
	if(checkBounds(x,y,z))
	{
		for(int i = 0; i<ROOMS; i++)
		{
			if(0 == RoomHolder[i].test(x,y,z))
			{
				UnTrigger();
				for(int k = 0; k<8; k++)
				{
					if(RoomHolder[i].TriggerList[k] >= 0)
					{
						RoomHolder[RoomHolder[i].TriggerList[k]].Trigger();
					}
				}
				
				currentRoom = i;
			}
		}
	}

}

//for setting adjacent rooms
void map::SetAdjacent(int room, int *adjacentRooms)
{
	for(int i = 0; i<ADJACENT; i++)
	{
		adjacent[room][i] = adjacentRooms[i];
	}
}

void map::SetTriggerList(int room, int *Tlist)
{
	RoomHolder[room].SetTriggerList(Tlist);
}

void map::SetRoomBoundries(int room, float xmin, float xmax,
								float ymin, float ymax, 
								float zmin, float zmax)
{
	if(room < ROOMS)
	{
		if(VerifyDimensions(xmin, xmax, ymin, ymax, zmin, zmax))
			RoomHolder[room].SetBoundries(xmin, xmax, ymin, ymax, zmin, zmax);
		else
			cout<<"Illegal Boundries, could not set"<<endl;
	}
}

//returns 1 if ok, 0 if not
bool map::VerifyDimensions(float xmin, float xmax,
								float ymin, float ymax, 
								float zmin, float zmax)
{
	if(xmin>xmax)
		return 0;
	if(ymin>ymax)
		return 0;
	if(zmin>zmax)
		return 0;

	return 1;
}
	
void map::AddWall(int room, int *tiling, int *walls,
									float xmin, float xmax,
									float ymin, float ymax, 
									float zmin, float zmax,
									float *color)
{
	if(RoomHolder[room].test((xmin+xmax)/2,(ymin+ymax)/2 ,(zmin+zmax)/2))
	{
		cout<<"Wall cannot be placed in room "<<room<<endl;
	}
	else
	{
		if(VerifyDimensions(xmin, xmax, ymin, ymax, zmin, zmax))
			RoomHolder[room].AddWall(tiling, walls, xmin, xmax, ymin, ymax, zmin, zmax, color, texList);
		else
			cout<<"Illegal Dimensions, could not place wall"<<endl;
	}
}

void map::AddRemoWall(int room, int *tiling, int *walls,
									float xmin, float xmax,
									float ymin, float ymax, 
									float zmin, float zmax,
									float *color, int dir)
{
	if(RoomHolder[room].test((xmin+xmax)/2,(ymin+ymax)/2 ,(zmin+zmax)/2))
	{
		cout<<"RemoWall cannot be placed in room "<<room<<endl;
	}
	else
	{
		if(VerifyDimensions(xmin, xmax, ymin, ymax, zmin, zmax))
			RoomHolder[room].AddRemoWall(tiling, walls, xmin, xmax, ymin, ymax, zmin, zmax, color, texList, dir);
		else
			cout<<"Illegal Dimensions, could not place remo wall"<<endl;
	}
}

void map::AddTree(int room, float x, float y, float z, int textures)
{
	if(RoomHolder[room].test(x,y,z))
	{
		cout<<"Tree cannot be placed in room "<<room<<endl;
	}
	else
	{
		RoomHolder[room].AddTree(x,y,z, textures,texList);
	}
}

void map::AddTornado(int room, float x, float y, float z, bool active, int height)
{
	if(RoomHolder[room].test(x,y,z))
	{
		cout<<"Tornado cannot be placed in room "<<room<<endl;
	}
	else
	{
		RoomHolder[room].AddTornado(x,y,z, active, height);
	}
}

bool map::CycInRange(float x, float y, float z)
{
	bool temp = RoomHolder[currentRoom].CycInRange(x, y, z);
	if(temp)
		return temp;

	for(int i = 0; i<ADJACENT; i++)
		{
			if((adjacent[currentRoom][i] >= 0))
			{
				temp = RoomHolder[adjacent[currentRoom][i]].CycInRange(x,y,z);
				if(temp)
				{
					return temp;
				}
			}
		}
	
	return 0;
}

bool map::ParticleInRange(float x, float y, float z, bool* extra)
{
	bool temp = RoomHolder[currentRoom].ParticleInRange(x, y, z, extra);
	if(temp)
		return temp;

	for(int i = 0; i<ADJACENT; i++)
		{
			if((adjacent[currentRoom][i] >= 0))
			{
				temp = RoomHolder[adjacent[currentRoom][i]].ParticleInRange(x,y,z, extra);
				if(temp)
				{
					return temp;
				}
			}
		}
	
	return 0;
}

void map::AddPoint(float color1, float color2, float color3, float x, float y, float z,int pointLife)
{
	bool *dummy = 0;
	bool temp = RoomHolder[currentRoom].ParticleInRange(x, y, z, dummy);
	if(temp)
	{
		RoomHolder[currentRoom].AddPoint(color1, color2, color3, x,y,z,pointLife);
		return;
	}

	for(int i = 0; i<ADJACENT; i++)
		{
			if((adjacent[currentRoom][i] >= 0))
			{
				temp = RoomHolder[adjacent[currentRoom][i]].ParticleInRange(x,y,z,dummy);
				if(temp)
				{
					RoomHolder[currentRoom].AddPoint(color1, color2, color3, x,y,z,pointLife);
					return;
				}
			}
		}
	
	return;
}

void map::ToggleExtraParticles()
{
	RoomHolder[currentRoom].ToggleExtraParticles();

	for(int i = 0; i<ADJACENT; i++)
		{
			if((adjacent[currentRoom][i] >= 0))
			{
				RoomHolder[adjacent[currentRoom][i]].ToggleExtraParticles();
			}
		}
}

void map::OpenDoor(float x, float y, float z)
{
	RoomHolder[currentRoom].checkOpenDoor(x, y, z);

	for(int k = 0; k<4; k++)
	{
		if(RoomHolder[currentRoom].TriggerList[k] >= 0)
		{
			RoomHolder[RoomHolder[currentRoom].TriggerList[k]].checkOpenDoor(x,y,z);
		}
	}
}

void map::AddSnowman(int room, float x, float y, float z, int direction)
{
	if(RoomHolder[room].test(x,y,z))
	{
		cout<<"Snowman cannot be placed in room "<<room<<endl;
	}
	else
	{
		RoomHolder[room].AddSnowman(x,y,z, direction);
	}
	
}

void map::AddDemon(int room, float x, float y, float z, int direction)
{
	if(RoomHolder[room].test(x,y,z))
	{
		cout<<"Demon cannot be placed in room "<<room<<endl;
	}
	else
	{
		RoomHolder[room].AddDemon(x,y,z,direction);
	}
}

void map::AddKing(int room, float x, float y, float z, int direction)
{
	if(RoomHolder[room].test(x,y,z))
	{
		cout<<"SnowKing cannot be placed in room "<<room<<endl;
	}
	else
	{
		RoomHolder[room].AddKing(x,y,z,direction,texList);
	}
}

void map::clearBaddies()
{
	for(int i = 0; i<ROOMS; i++)
	{
		RoomHolder[i].Reset();
	}

	currentRoom = 0;
}

void map::Died()
{
	for(int i = 0; i<ROOMS; i++)
	{
		RoomHolder[i].UndoTrigger();
	}

	currentRoom = 0;
}

void map::UnTrigger()
{
	for(int k = 0; k<8; k++)
	{
		if(RoomHolder[currentRoom].TriggerList[k] >= 0)
		{
			RoomHolder[RoomHolder[currentRoom].TriggerList[k]].UndoTrigger();
		}
	}

}

void map::loadTexture()
{
   unsigned char* image = new unsigned char;
   texList = new unsigned int[13];
   glGenTextures(14, &texList[0]);

   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
   unsigned int w, h, components;
   image = loadPNM("elephant.rot.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[3]);

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);
   
   image = loadPNM("brick.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[2]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("checkerboard.bw.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[1]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   
   image = loadPNM("colordragon.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[4]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("beware.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[5]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("door.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[6]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("snowKing2.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[7]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("grass.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[8]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("vine.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[9]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("night.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[10]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("snowKing-Narrow-new.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[11]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("redtexturelarge-new.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[12]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("lor46-new.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[13]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

}

unsigned char* map::loadPNM( const char *filename, unsigned int& width, unsigned int &height,unsigned int &numComponents )
{
   FILE          *imgFile;
   char          buf[1024];
   char          type;
   unsigned int           i, j, k, l;
   unsigned char *imageData;

   imgFile= fopen( filename, "rb" );
   if( errno!= 0 )
     return NULL;
   // read PNM magic number (P1 to P6)
   if( fscanf( imgFile, "P%c \n", &type )!= 1 || type< '1' || type> '8')
   {
     fclose( imgFile );
     return NULL;
   }
   // skip comments
   while( fscanf( imgFile, "#%[^\n]\n", buf ) )
     ;
   // read width
   fscanf( imgFile, "%d", &width );
   /* skip comments */
   while( fscanf( imgFile, "#%[^\n]\n", buf ) )
     ;
   /* read height */
   fscanf( imgFile, "%d", &height );
   /* skip comments */
   while( fscanf( imgFile, "#%[^\n]\n", buf ) )
     ;
   /* skip max. component and exactly one whitespace */
   fscanf( imgFile, "%*d%*c" );

   switch( type )
   {
   case '1': // ASCII bitmap
   case '4': // binary bitmap
     cerr << "Bitmaps not implemented\n";
     fclose( imgFile );
     return NULL;
   case '2': // ASCII greymap
     imageData= new unsigned char[width*height];
     for( i= 0 ; i< height ; i++ )
       for( j= 0 ; j< width ; j++ )
       {
		   fscanf( imgFile, "%d", &l );
		   imageData[i*width+j]= l;
       }
     numComponents= 1;
     break;
   case '3': // ASCII RGB
     imageData= new unsigned char[width*height*3];
     for( i= 0 ; i< height ; i++ )
       for( j= 0 ; j< width ; j++ )
		   for( k= 0 ; k< 3 ; k++ )
		   {
			   fscanf( imgFile, "%d", &l );
			   imageData[(i*width+j)*3+k]= l;
		   }
     numComponents= 3;
     break;
   case '5': // binary greymap
     imageData= new unsigned char[width*height];
     fread( imageData, 1, width*height, imgFile );
     numComponents= 1;
     break;
   case '6': // binary RGB
     imageData= new unsigned char[width*height*3];
     fread( imageData, 1, width*height*3, imgFile );
     numComponents= 3;
     break;
   }
   fclose( imgFile );

   return imageData;
}