#include "explode.h"

explode::explode()
{
	inUse = 0;

	ymin = 0;

	for(int i = 0; i<3; i++)
	{
		pos[i] = 0;
	}
	pos[1] = 0;
}

void explode::draw(float x, float y, float z)
{
		float ymin;
		float c=3.141592654/180;
		float size = 4*((50-sqrt(pow(x-pos[0],2)+pow(y-pos[1],2)+pow(z-pos[2],2)))/50);
		bool* extra = false;
		if(size < 0.25)
			size = 0.25;
		glPointSize(size);
		glDisable(GL_TEXTURE_2D);
		int count = 0;

		GLfloat emission[] = {0.1,0.1,0.1,0};
		glPushAttrib(GL_LIGHTING_BIT);
		glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION,emission);
		

		glPushMatrix();
		glLoadIdentity();
		for(int i = 0; i<MAXPARS; i++)
		{
			ymin = -300;
			if(data[i].life > 0)
			{
				ymin = (*Map).floor((*Map).whichRoom(data[i].pos[0],data[i].pos[1],data[i].pos[2]));
				switch((*Map).checkStructureBounds(data[i].pos[0],data[i].pos[1],data[i].pos[2])){
				case 1:
					data[i].vel[0] *= -0.6;
					break;
				case 2:
					data[i].vel[1] *= -0.6;
					break;
				case 3:
					data[i].vel[2] *= -0.6;
					break;
				}
				if((*Map).ParticleInRange(data[i].pos[0],data[i].pos[1],data[i].pos[2], extra))
				{
						(*Map).AddPoint(data[i].color[0], data[i].color[1], data[i].color[2], data[i].pos[0], data[i].pos[1], data[i].pos[2],data[i].life);
						data[i].life = 0;
					
					
				}
				//if(data[i].pos[1] < ymin)
				//{
					
				//
				if(fabs(data[i].vel[1]) > 0.1 || data[i].pos[1] > ymin)
				{
					data[i].pos[0] += data[i].vel[0]*0.06;
					data[i].pos[1] += data[i].vel[1]*0.06 + 0.0018*(-9.8);
					data[i].pos[2] += data[i].vel[2]*0.06;
					data[i].vel[1] += -9.8*0.06;
				}
			
				
				glColor3f(data[i].color[0],data[i].color[1],data[i].color[2]);
				glBegin(GL_POINTS);
				glVertex3f(data[i].pos[0],data[i].pos[1],data[i].pos[2]);
				glEnd();
				count++;
			}
			data[i].life--;
		}
		glPopMatrix();
		glPopAttrib();

		glEnable(GL_TEXTURE_2D);

		if(pos[1] > ymin)
		{
			pos[1] += yvel*0.06 + 0.0018*(-9.8);
			yvel += -9.8*0.06;
		}


		if(count == 0)
		{
			inUse = 0;
		}
}

bool explode::Used()
{
	return inUse;
}

void explode::SetPos(float x, float y, float z)
{
	pos[0] = x;
	if(y<ymin)
		y = ymin+0.3;
	pos[1] = y;
	pos[2] = z;
	
}

void explode::Start(map *TheMap)
{
	Map = TheMap;
	float c=3.141592654/180;
	inUse = 1;
	float red;
	float green;
	float theta;
	float phi;
	float rad;
	for(int i = 0; i<MAXPARS; i++)
	{
		data[i].SetPos(pos[0]+rand()/(RAND_MAX),pos[1],pos[2]+rand()/(RAND_MAX));
		theta = 360*rand()/RAND_MAX;
		phi = 360*rand()/RAND_MAX;
		rad = 6*rand()/RAND_MAX+2;
		data[i].SetVel(rad*sin(c*phi)*cos(c*theta),rad*sin(c*phi)*sin(c*theta)+3,rad*cos(c*phi));
		red = 0.2+(float)rand()/RAND_MAX;
		green = (float)rand()/(2*RAND_MAX);

		if(green>red)
		{
			green = red;
		}

		data[i].SetColor(red,green,0);
		data[i].SetLife(80*rand()/RAND_MAX+10);		
	}
	yvel = 0;
}
