#include "demon.h"

demon::demon()
{
	timer = 0;
	used = false;
	wingAngle = 0;
	up = false;
	angle = 180;
	triggered = 0;
}
	
void demon::Initialize(float x, float y, float z, int direction)
{
	used = true;

	pos[0] = x;
	pos[1] = y;
	pos[2] = z;

	angle = direction;

	SetBoundry(x, y, z);
}

void demon::SetBoundry(float x, float y, float z)
{
	bound.SetBoundry(x-2.2, x+2.2, y-2.2,y+2.2, z-2.2, z+2.2);
}

void demon::draw(float x, float y, float z, bool trig)
{
	if(trig)
		triggered = true;

	if(used)
	{
		if(wingAngle >= 60)
		{
			up = false;
		}
		
		if(wingAngle <= -10)
		{
			up = true;
		}

		if(up)
		{
			wingAngle += 5;
		}
		else
		{
			wingAngle -= 5;
		}



		if(triggered)
		{
			float vel[] = {x-pos[0], y-pos[1], z-pos[2]};
			float temp = sqrt(pow(vel[0],2) + pow(vel[1],2) + pow(vel[2],2));
	
			vel[0] /= temp;
			vel[1] /= temp;
			vel[2] /= temp;
	
			pos[0] += 0.25*vel[0];
			pos[1] += 0.25*vel[1];
			pos[2] += 0.25*vel[2];
	
			SetBoundry(pos[0], pos[1], pos[2]);

			vel[0] = x-pos[0];
			vel[2] = z-pos[2];
			temp = sqrt(pow(vel[0],2) + pow(vel[2],2));
		
				vel[0] /= temp;
				vel[2] /= temp;
						
				int theta;
				if((vel[0]>=0) & (vel[2]>0))
				{
					if(vel[0] > 0.195)
						theta = 22.5;
					else
						theta = 0;
					if(vel[0] > 0.555)
						theta = 45;
					if(vel[0] > 0.831)
						theta = 67.5;
					if(vel[0] > 0.98)
						theta = 90;

				}
	
				if((vel[0]>=0) & (vel[2]<0))
				{
					if(vel[0] > 0.195)
						theta = 157.5;
					else
						theta = 180;
					if(vel[0] > 0.555)
						theta = 135;
					if(vel[0] > 0.831)
						theta = 112.5;
					if(vel[0] > 0.98)
						theta = 90;
				}
	
				if((vel[0]<0) & (vel[2]<0))
				{
					if(vel[0] < -0.195)
						theta = 202.5;
					else
						theta = 180;
					if(vel[0] < -0.555)
						theta = 225;
					if(vel[0] < -0.831)
						theta = 247.5;
					if(vel[0] < -0.98)
						theta = 270;
					
				}
	
				if((vel[0]<0) & (vel[2]>0))
				{
					if(vel[0] < -0.195)
						theta = 337.5;
					else
						theta = 0;
					if(vel[0] < -0.555)
						theta = 315;
					if(vel[0] < -0.831)
						theta = 292.5;
					if(vel[0] < -0.98)
						theta = 270;
				}
				if(theta-angle > 180)
					theta -= 360;
				if(theta-angle < -180)
					theta +=360;

				if(theta>angle)
				{
					angle++;
				}
				else if(theta < angle)
				{
					angle--;
				}
		}

		glColor3f(1,1,1);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();

		glLoadIdentity();
		glTranslatef(pos[0],pos[1],pos[2]);
		glRotatef(180+angle,0,1,0);
		glPushMatrix();
		glScalef(1,1,1.3);
		glutSolidSphere(1,12,12);
		glPopMatrix();

		//head
		glPushMatrix();
		glTranslatef(0,0.5,-1.3);
		glutSolidSphere(0.6,12,12);

		glPushMatrix();	//horn1
		glColor3f(0,0,0);
		glTranslatef(0.25,0.5,-0.3);
		glBegin(GL_TRIANGLES);
			glVertex3f(-0.15,0,0);
			glVertex3f(0.1,-0.2,0);
			glVertex3f(-0.2,0.4,0);
		glEnd();
		glPopMatrix();

		glPushMatrix();	//horn2
		glTranslatef(-0.25,0.5,-0.3);
		glBegin(GL_TRIANGLES);
			glVertex3f(0.15,0,0);
			glVertex3f(-0.1,-0.2,0);
			glVertex3f(0.2,0.4,0);
		glEnd();
		glPopMatrix();

		glPushMatrix();//eye1
		glTranslatef(0.2,0.2,-0.55);
		glRotatef(-20,0,1,0);
		glRotatef(20,0,0,1);
		glScalef(1,0.2,0.1);
		glutSolidSphere(0.2,12,12);
		glPopMatrix();

		glPushMatrix();//eye2
		glTranslatef(-0.2,0.2,-0.55);
		glRotatef(20,0,1,0);
		glRotatef(-20,0,0,1);
		glScalef(1,0.2,0.1);
		glutSolidSphere(0.2,12,12);
		glPopMatrix();


		if(0){
		glPushMatrix();//mouth
		glColor3f(0.4,0,0);
		glTranslatef(0,-0.2,-0.55);
		glScalef(0.8,0.4,0.2);
		glutSolidSphere(0.2,10,10);

		glPushMatrix();//blood spot
		glColor3f(1,0,0);
		glTranslatef(0.1,0,-0.1);
		glutSolidSphere(0.1,6,6);
		glPopMatrix();
		glPopMatrix();
		}


		glPopMatrix();

		//leg1
		glPushMatrix();
		glColor3f(0,0,0);
		glTranslatef(0.6,-0.7,-0.8);
		glRotatef(-15,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.6,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glTranslatef(0,-0.1,-0.375);//second segment
		glRotatef(115,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0,-0.4,0);//claw segment
		glRotatef(-90,1,0,0);
		glRotatef(25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();
		glPopMatrix();


		glTranslatef(0,-0.4,0);//claw2 segment
		glRotatef(-90,1,0,0);
		glRotatef(-25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPopMatrix();

		//leg2
		glPushMatrix();
		glColor3f(0,0,0);
		glTranslatef(-0.6,-0.7,-0.8);
				glRotatef(-15,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.6,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glTranslatef(0,-0.1,-0.375);//second segment
		glRotatef(115,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0,-0.4,0);//claw segment
		glRotatef(-90,1,0,0);
		glRotatef(25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();
		glPopMatrix();


		glTranslatef(0,-0.4,0);//claw2 segment
		glRotatef(-90,1,0,0);
		glRotatef(-25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPopMatrix();

		//leg3
		glPushMatrix();
		glColor3f(0,0,0);
		glTranslatef(0.6,-0.7,0.8);
				glRotatef(-15,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.6,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glTranslatef(0,-0.1,-0.375);//second segment
		glRotatef(115,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0,-0.4,0);//claw segment
		glRotatef(-90,1,0,0);
		glRotatef(25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();
		glPopMatrix();


		glTranslatef(0,-0.4,0);//claw segment
		glRotatef(-90,1,0,0);
		glRotatef(-25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPopMatrix();

		//leg4
		glPushMatrix();
		glColor3f(0,0,0);
		glTranslatef(-0.6,-0.7,0.8);
				glRotatef(-15,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.6,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glTranslatef(0,-0.1,-0.375);//second segment
		glRotatef(115,1,0,0);
		glPushMatrix();
		glScalef(0.05,0.8,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0,-0.4,0);//claw segment
		glRotatef(-90,1,0,0);
		glRotatef(25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();
		glPopMatrix();


		glTranslatef(0,-0.4,0);//claw2 segment
		glRotatef(-90,1,0,0);
		glRotatef(-25,1,0,1);
		glTranslatef(0,-0.2,0);
		glPushMatrix();
		glScalef(0.05,0.4,0.05);
		glutSolidCube(1);
		glPopMatrix();

		glPopMatrix();

		glPushMatrix();	//wing1
		glColor3f(0.8,0,0);
		glRotatef(30-wingAngle,0,0,1);
		glBegin(GL_POLYGON);
			glVertex3f(0.6,0.8,0.5);
			glVertex3f(0.6,0.8,-1);
			glVertex3f(2,1,-2);
			glVertex3f(3,-1,3);
		glEnd();
		glPopMatrix();

		glPushMatrix();	//wing2
		glRotatef(-30+wingAngle,0,0,1);
		glBegin(GL_POLYGON);
			glVertex3f(-0.6,0.8,0.5);
			glVertex3f(-0.6,0.8,-1);
			glVertex3f(-2,1,-2);
			glVertex3f(-3,-1,3);
		glEnd();
		glPopMatrix();

		glPushMatrix();	//wing2
		glPopMatrix();


		glPopMatrix();
		glEnable(GL_TEXTURE_2D);
	}
	else if(timer > 0)
	{
		glColor3f(1,1,1);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		glTranslatef(pos[0],pos[1],pos[2]);
		glutSolidSphere(timer,20,20);
		glPopMatrix();
		glEnable(GL_TEXTURE_2D);
		timer-=0.1;
	}
}

void demon::death()
{
	timer = 2;
	used = false;
}


int demon::test(float x, float y, float z)
{
	if(used)
	{
		return bound.test(x,y,z);
	}
	return 0;
}