#include "cyclone.h"

cyclone::cyclone()
{
	x = 0;
	y = 0;
	z = 0;

	drawExtra = true;

	for(int i = 0; i<NUMADDS; i++)
	{
		added[i].pos[0] = 0;
	}
}
	
void cyclone::draw(float X, float Y, float Z, bool triggered)
{
	if(attack && triggered)
	{
		Y -= 8;
		float vel[] = {X-x, Y-y, Z-z};
		float temp = sqrt(pow(vel[0],2) + pow(vel[1],2) + pow(vel[2],2));
		
		vel[0] /= temp;
		vel[1] /= temp;
		vel[2] /= temp;	

		x += 0.1*vel[0];
		y += 0.1*vel[1];
		z += 0.1*vel[2];


	}

	glColor3f(1,1,1);
	float c=3.141592654/180;
	glPointSize(3);

	glDisable(GL_TEXTURE_2D);
	glPushMatrix();
	glLoadIdentity();

	glTranslatef(x,y,z);
	glBegin(GL_POINTS);
		for(int i = 0; i<numFlakes; i++)
		{
			glVertex3f((float) data[3*i+1]*cos(c*(data[3*i+2]+t)), (float) data[3*i]+cos(c*(data[3*i+2]+t)/2),(float) data[3*i+1]*sin(c*(data[3*i+2]+t)));
		}
	glEnd();
	if(drawExtra){
	glBegin(GL_POINTS);
		for(i = 0; i<NUMADDS; i++)
		{
			if(added[i].pos[0] == 1)
			{
				added[i].vel[1] *= 0.6;
				added[i].pos[1] += 0.4*(float)rand()/RAND_MAX-0.2;
				added[i].pos[1] += added[i].vel[1]*0.06 + 0.0018*(-9.8);
				added[i].vel[2] += (added[i].vel[1]*0.06 + 0.0018*(-9.8)/2);
				added[i].vel[2] += 0.2*(float)rand()/RAND_MAX-0.1;
				added[i].vel[0] += (float)20*rand()/RAND_MAX;
				added[i].vel[1] += -9.8*0.06;

				glColor3f(added[i].color[0],added[i].color[1],added[i].color[2]);
				glVertex3f((float) added[i].vel[2]*cos(c*(added[i].vel[0]+t)), added[i].pos[1],(float) added[i].vel[2]*sin(c*(added[i].vel[0]+t)));
	
				added[i].life--; 

				if(added[i].life <= 0)
				{
					added[i].pos[0] = 0;
					added[i].pos[1] = -1;
					added[i].pos[2] = -1;
					added[i].vel[2] = -1;
					added[i].vel[1] = -1;
					added[i].vel[0] = -1;
					added[i].life = 0;

				}
			}
		}
	glEnd();
	}
	glPopMatrix();
	glEnable(GL_TEXTURE_2D);

	t += 5;
	if(t>=720)
		t -= 720;
}

void cyclone::Initialize(float X, float Y, float Z, bool active, int size)
{
	x = X;
	y = Y;
	z = Z;

	attack = active;

	height = size;

	for(int i = 0; i<numFlakes; i++)
	{
		data[3*i] = (float) rand()*height/RAND_MAX;					//height
		data[3*i+1] = (float) data[3*i]*rand()/(RAND_MAX*2);	//radius
		data[3*i+2] = (float) rand()*360/RAND_MAX;				//random angle

	}
}

bool cyclone::inRange(float X, float Y, float Z)
{
	float temp = sqrt(pow((X-x),2) + pow((Z-z),2));

	if((Y >= y) && (Y <= y+height) && (2*temp <= Y-y))
		return true;
	else
		return false;

	
}

bool cyclone::ParticleInRange(float X, float Y, float Z, bool *extra)
{

	float temp = sqrt(pow((X-x),2) + pow((Z-z),2));

	if((Y >= y) & (Y <= y+height) & (2*temp <= Y-y))
	{

		return true;
	}
	else
		return false;
}

void cyclone::AddPoint(float color1, float color2, float color3, float xpos, float ypos, float zpos,int pointLife)
{
	if(!drawExtra)
		return;
	
	int index = -1;
	for(int k = NUMADDS; k>=0; k--)
	{
		if(added[k].pos[0] == 0)
		{
			index = k;
			
		}
	}
	if(index >= 0){
	added[index].pos[1] = ypos-y;

	added[index].color[0] = color1;
	added[index].color[1] = color2;
	added[index].color[2] = color3;

	added[index].life = pointLife*2;


	float dirx = xpos-x;
	float dirz = zpos-z;
	float temp = sqrt(pow(dirx,2) + pow(dirz,2));
	added[index].vel[2] = temp;

	dirx /= temp;
	dirz /= temp;

	float xval = 2;
	float zval = 2;
	int angle = 0;
	for(float i = 0; i<360; i++)
	{
		temp = fabs((float)sin(i)-dirx);
		if(temp<xval)
		{
			xval = temp;
			angle = i;
		}
	}
	zval = (float)cos(angle);
	if((dirx > 0) & (dirz > 0))
	{
		if(zval<0)
		{
			angle = 180-angle;
		}

	}
	else if((dirx>0) & (dirz <0))
	{
		if(zval>0)
		{
			angle = 180-angle;
		}
	}
	else if((dirx <0) & (dirz > 0))
	{
		if(zval<0)
		{
			angle = 540-angle;
		}
	}
	else
	{
		if(zval>0)
		{
			angle = 540-angle;
		}
	}

	added[index].vel[0] = angle;
	added[index].pos[0] = 1;

	}
}

void cyclone::ToggleExtraParticles()
{
	if(drawExtra)
		drawExtra = false;
	else
		drawExtra = true;
}