#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include "CubeInfo.h"
#include "SphereInfo.h"

class Targets{
public:
	CubeInfo *cubeInfo;
	SphereInfo *sphereInfo;
	GLuint targetList;

	unsigned int* texList;
	bool textures;
	bool firstDraw;
	bool cubes;
	int currentTexture;
	int currentTiling;

Targets::Targets();
void Targets::SetCubeTexture(int Cube, int Face);
void Targets::SetSphereTexture(int Sphere);
void Targets::NewCubes();
void Targets::RemakeCubes();
void Targets::NewSpheres();
void Targets::RemakeSpheres();
void Targets::Display();
void Targets::DrawCube(int Cube);
void Targets::DrawSphere(int Sphere);
void Targets::ToggelTextures();
void Targets::loadTexture();
unsigned char* Targets::loadPNM( const char *filename, unsigned int& width, unsigned int &height,unsigned int &numComponents );
void Targets::IncreaseTexture();
void Targets::DecreaseTexture();
void Targets::SetTiling(int tiling);
void Targets::EraseTextures();
};
