#include <GL/glut.h>
#include <math.h>
#include <iostream.h>
#include "Targets.h"

Targets::Targets()
{
	cubeInfo = new CubeInfo[20];
	sphereInfo = new SphereInfo[20];

	firstDraw = 0;
	currentTexture = 1;
	currentTiling = 1;
	cubes = 1;
	textures = 0;
}

void Targets::SetCubeTexture(int Cube, int Face)
{
	cubeInfo[Cube].SetTexture(Face,currentTexture);
	cubeInfo[Cube].SetTiling(Face,currentTiling);

}

void Targets::SetSphereTexture(int Sphere)
{
	sphereInfo[Sphere].SetTexture(currentTexture);
	sphereInfo[Sphere].SetTiling(currentTiling);
}

void Targets::NewCubes()
{
	cubes = 1;

	targetList = glGenLists(1);
	glNewList(targetList,GL_COMPILE);
	for(int i=0; i<20; i++)
	{
		cubeInfo[i].SetCube(i);
		cubeInfo[i].SetColours((float) rand()/RAND_MAX,(float) rand()/RAND_MAX,(float) rand()/RAND_MAX);
		cubeInfo[i].SetPosition((float) rand()*90/RAND_MAX-45,(float) rand()*90/RAND_MAX-45,(float) rand()*90/RAND_MAX-45);
		cubeInfo[i].SetSize((int)((float)rand()*5/RAND_MAX+1));

		glPushMatrix();
		glPushName(i);
		glColor3f(cubeInfo[i].colourR, cubeInfo[i].colourG, cubeInfo[i].colourB);
		glTranslatef(cubeInfo[i].x, cubeInfo[i].y ,cubeInfo[i].z);
		DrawCube(i);
		glPopName();
		glPopMatrix();
	}
	glEndList();

	firstDraw = 1;

}

void Targets::RemakeCubes()
{
	targetList = glGenLists(1);
	glNewList(targetList,GL_COMPILE);
	for(int i=0; i<20; i++)
	{
		glPushMatrix();
		glPushName(i);
		glColor3f(cubeInfo[i].colourR, cubeInfo[i].colourG, cubeInfo[i].colourB);
		glTranslatef(cubeInfo[i].x, cubeInfo[i].y ,cubeInfo[i].z);
		DrawCube(i);
		glPopName();
		glPopMatrix();
	}
	glEndList();
}

void Targets::NewSpheres()
{
	cubes = 0;

	targetList = glGenLists(1);
	glNewList(targetList,GL_COMPILE);
	for(int i=0; i<20; i++)
	{
		sphereInfo[i].SetSphere(i);
		sphereInfo[i].SetColours((float) rand()/RAND_MAX,(float) rand()/RAND_MAX,(float) rand()/RAND_MAX);
		sphereInfo[i].SetPosition((float) rand()*90/RAND_MAX-45,(float) rand()*90/RAND_MAX-45,(float) rand()*90/RAND_MAX-45);
		sphereInfo[i].SetSize((int)((float)rand()*5/RAND_MAX+1));

		glPushMatrix();
		glPushName(i);
		glColor3f(sphereInfo[i].colourR, sphereInfo[i].colourG, sphereInfo[i].colourB);
		glTranslatef(sphereInfo[i].x, sphereInfo[i].y ,sphereInfo[i].z);
		DrawSphere(i);
		glPopName();
		glPopMatrix();
	}
	glEndList();

	firstDraw = 1;
}

void Targets::RemakeSpheres()
{
	targetList = glGenLists(1);
	glNewList(targetList,GL_COMPILE);
	for(int i=0; i<20; i++)
	{
		glPushMatrix();
		glPushName(i);
		glColor3f(sphereInfo[i].colourR, sphereInfo[i].colourG, sphereInfo[i].colourB);
		glTranslatef(sphereInfo[i].x, sphereInfo[i].y ,sphereInfo[i].z);
		DrawSphere(i);
		glPopName();
		glPopMatrix();
	}
	glEndList();
}

void Targets::Display()
{
	if(firstDraw)
	{
		glCallList(targetList);
	}
}

void Targets::DrawCube(int Cube)
{
	int size = cubeInfo[Cube].size;
	
	if(textures)
	  glBindTexture(GL_TEXTURE_2D, texList[0]);

	if(textures)
		glBindTexture(GL_TEXTURE_2D, texList[cubeInfo[Cube].Face101]);
	glPushName(101);
	glBegin(GL_POLYGON);
	glTexCoord2f(0,cubeInfo[Cube].tiling101);							
	glVertex3i(-size,-size,size);
	glTexCoord2f(cubeInfo[Cube].tiling101, cubeInfo[Cube].tiling101);	
	glVertex3i(-size,size,size);
	glTexCoord2f(cubeInfo[Cube].tiling101, 0.0f);						
	glVertex3i(size,size,size);
	glTexCoord2f(0.0f, 0.0f);											
	glVertex3i(size,-size,size);
	glEnd();
	glPopName();

	if(textures)
		glBindTexture(GL_TEXTURE_2D, texList[cubeInfo[Cube].Face102]);
	glPushName(102);
	glBegin(GL_POLYGON);
	glTexCoord2f(cubeInfo[Cube].tiling102, cubeInfo[Cube].tiling102);	
	glVertex3i(size,size,size);
	glTexCoord2f(cubeInfo[Cube].tiling102, 0.0f);						
	glVertex3i(size,size,-size);
	glTexCoord2f(0.0f, 0.0f);											
	glVertex3i(size,-size,-size);
	glTexCoord2f(0.0f, cubeInfo[Cube].tiling102);						
	glVertex3i(size,-size,size);
	glEnd();
	glPopName();

	if(textures)
		glBindTexture(GL_TEXTURE_2D, texList[cubeInfo[Cube].Face103]);
	glPushName(103);
	glBegin(GL_POLYGON);
	glTexCoord2f(0.0f, 0.0f);											
	glVertex3i(-size,-size,-size);
	glTexCoord2f(cubeInfo[Cube].tiling103, 0.0f);						
	glVertex3i(-size,size,-size);
	glTexCoord2f(cubeInfo[Cube].tiling103, cubeInfo[Cube].tiling103);	
	glVertex3i(size,size,-size);
	glTexCoord2f(0.0f, cubeInfo[Cube].tiling103);						
	glVertex3i(size,-size,-size);
	glEnd();
	glPopName();

	if(textures)
		glBindTexture(GL_TEXTURE_2D, texList[cubeInfo[Cube].Face104]);
	glPushName(104);
	glBegin(GL_POLYGON);
	glTexCoord2f(cubeInfo[Cube].tiling104, 0.0f); 
	glVertex3i(-size,size,size);
	glTexCoord2f(cubeInfo[Cube].tiling104, cubeInfo[Cube].tiling104); 
	glVertex3i(-size,size,-size);
	glTexCoord2f(0.0f, cubeInfo[Cube].tiling104); 
	glVertex3i(-size,-size,-size);
	glTexCoord2f(0.0f, 0.0f); 
	glVertex3i(-size,-size,size);
	glEnd();
	glPopName();

	if(textures)
		glBindTexture(GL_TEXTURE_2D, texList[cubeInfo[Cube].Face105]);
	glPushName(105);
	glBegin(GL_POLYGON);
	glTexCoord2f(cubeInfo[Cube].tiling105, cubeInfo[Cube].tiling105); 
	glVertex3i(size,size,size);
	glTexCoord2f(cubeInfo[Cube].tiling105, 0.0f); 
	glVertex3i(-size,size,size);
	glTexCoord2f(0.0f, 0.0f); 
	glVertex3i(-size,size,-size);
	glTexCoord2f(0.0f, cubeInfo[Cube].tiling105); 
	glVertex3i(size,size,-size);
	glEnd();
	glPopName();

	if(textures)
		glBindTexture(GL_TEXTURE_2D, texList[cubeInfo[Cube].Face106]);
	glPushName(106);
	glBegin(GL_POLYGON);
	glTexCoord2f(0.0f, 0.0f); 
	glVertex3i(size,-size,size);
	glTexCoord2f(0.0f, cubeInfo[Cube].tiling106); 
	glVertex3i(-size,-size,size);
	glTexCoord2f(cubeInfo[Cube].tiling106, cubeInfo[Cube].tiling106); 
	glVertex3i(-size,-size,-size);
	glTexCoord2f(cubeInfo[Cube].tiling106, 0.0f); 
	glVertex3i(size,-size,-size);
	glEnd();
	glPopName();
}

void Targets::DrawSphere(int Sphere)
{
	int size = sphereInfo[Sphere].size;
	int tiling = sphereInfo[Sphere].faceTiling;

	if(textures)
	  glBindTexture(GL_TEXTURE_2D, texList[0]);

	if(textures)
		glBindTexture(GL_TEXTURE_2D, texList[sphereInfo[Sphere].faceTexturing]);
	float x,y,z;
	float c=3.141592654/180;
	for(int phi = -90; phi<=90; phi+=20)
	{
		glBegin(GL_QUAD_STRIP);
			for(int theta=-180; theta<= 180; theta += 20)
			{
				x=size*sin(c*theta)*cos(c*phi);
				y=size*cos(c*theta)*cos(c*phi);
				z=size*sin(c*phi);
				glTexCoord2f(tiling-tiling*((float)(phi+90)/180),tiling-tiling*(float)(theta+180)/360); 
				glVertex3d(x,y,z);
				x=size*sin(c*theta)*cos(c*(phi+20));
				y=size*cos(c*theta)*cos(c*(phi+20));
				z=size*sin(c*(phi+20));
				glTexCoord2f(tiling*((float)8/9)-tiling*((float)(phi+90)/180),tiling-tiling*(float)(theta+180)/360); 
				glVertex3d(x,y,z);
			}
		glEnd();
	}
}

void Targets::ToggelTextures()
{
		if(textures)
		{
			glDisable(GL_TEXTURE_2D);
			textures = 0;
		}
		else
		{
			glEnable(GL_TEXTURE_2D);
			loadTexture();
			textures = 1;
		}
}

void Targets::loadTexture()
{
   unsigned char* image = new unsigned char;
   texList = new unsigned int[4];
   glGenTextures(4, &texList[0]);

   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
   unsigned int w, h, components;
   image = loadPNM("elephant.rot.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[3]);

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);
   
   image = loadPNM("brick.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[2]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

   image = loadPNM("checkerboard.bw.ppm",w,h,components);
   glBindTexture(GL_TEXTURE_2D, texList[1]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, w, h, GL_RGB, GL_UNSIGNED_BYTE, image);

}

unsigned char* Targets::loadPNM( const char *filename, unsigned int& width, unsigned int &height,unsigned int &numComponents )
{
   FILE          *imgFile;
   char          buf[1024];
   char          type;
   unsigned int           i, j, k, l;
   unsigned char *imageData;

   imgFile= fopen( filename, "rb" );
   if( errno!= 0 )
     return NULL;
   // read PNM magic number (P1 to P6)
   if( fscanf( imgFile, "P%c \n", &type )!= 1 || type< '1' || type> '8')
   {
     fclose( imgFile );
     return NULL;
   }
   // skip comments
   while( fscanf( imgFile, "#%[^\n]\n", buf ) )
     ;
   // read width
   fscanf( imgFile, "%d", &width );
   /* skip comments */
   while( fscanf( imgFile, "#%[^\n]\n", buf ) )
     ;
   /* read height */
   fscanf( imgFile, "%d", &height );
   /* skip comments */
   while( fscanf( imgFile, "#%[^\n]\n", buf ) )
     ;
   /* skip max. component and exactly one whitespace */
   fscanf( imgFile, "%*d%*c" );

   switch( type )
   {
   case '1': // ASCII bitmap
   case '4': // binary bitmap
     cerr << "Bitmaps not implemented\n";
     fclose( imgFile );
     return NULL;
   case '2': // ASCII greymap
     imageData= new unsigned char[width*height];
     for( i= 0 ; i< height ; i++ )
       for( j= 0 ; j< width ; j++ )
       {
		   fscanf( imgFile, "%d", &l );
		   imageData[i*width+j]= l;
       }
     numComponents= 1;
     break;
   case '3': // ASCII RGB
     imageData= new unsigned char[width*height*3];
     for( i= 0 ; i< height ; i++ )
       for( j= 0 ; j< width ; j++ )
		   for( k= 0 ; k< 3 ; k++ )
		   {
			   fscanf( imgFile, "%d", &l );
			   imageData[(i*width+j)*3+k]= l;
		   }
     numComponents= 3;
     break;
   case '5': // binary greymap
     imageData= new unsigned char[width*height];
     fread( imageData, 1, width*height, imgFile );
     numComponents= 1;
     break;
   case '6': // binary RGB
     imageData= new unsigned char[width*height*3];
     fread( imageData, 1, width*height*3, imgFile );
     numComponents= 3;
     break;
   }
   fclose( imgFile );

   return imageData;
}

void Targets::IncreaseTexture()
{
	currentTexture++;
	if (currentTexture >3)
		currentTexture -= 4;		
	switch(currentTexture)
	{
		case 0:
			cout<<"No Texture"<<endl;
			break;			
		case 1:
			cout<<"Checkers"<<endl;
			break;
		case 2:
			cout<<"Bricks"<<endl;
			break;
		case 3:
			cout<<"Elephant"<<endl;
			break;
	}
}
void Targets::DecreaseTexture()
{
	currentTexture--;
	if (currentTexture <0)
		currentTexture += 4;
	switch(currentTexture)
	{
		case 0:
			cout<<"No Texture"<<endl;
			break;
		case 1:
			cout<<"Checkers"<<endl;
			break;
		case 2:
			cout<<"Bricks"<<endl;
			break;
		case 3:
			cout<<"Elephant"<<endl;
			break;
	}
}

void Targets::SetTiling(int tiling)
{
	if(tiling>0 && tiling <4)
	{
		currentTiling = tiling;
	}
}

void Targets::EraseTextures()
{
	if(cubes)
	{
		for(int i = 0; i<20; i++)
		{
			cubeInfo[i].erase();
		}
		RemakeCubes();
	}
	else
	{
		for(int i = 0; i<20; i++)
		{
			sphereInfo[i].erase();
		}
		RemakeSpheres();
	}

	
}

