#include "LineHolder.h"

LineHolder::LineHolder()
{
	count = 0;
	max = 10;

	lines = new line[max];
}

void LineHolder::addLine(line newLine)
{
	if(count<max)
	{
		lines[count++] = newLine;
	}
	else
	{
		line* temp = new line[max+10];

		for(int i= 0; i<max; i++)
		{
			temp[i] = lines[i];
		}

		delete lines;
		lines = temp;
		lines[++count] = newLine;
		max += 10;
	}

}

void LineHolder::erase()
{
	delete lines;
	lines = new line[max];
	count = 0;
}

void LineHolder::printLines()
{
	for(int i = 0; i<count; i++)
	{
		lines[i].drawRect1();
		lines[i].drawRect2();
	}
}

int LineHolder::checkCompanion(line L)
{
	bool leave = 0;
	for(int i = 0; i<count; i++)
	{
		if(lines[i].cube == L.cube && lines[i].face == L.face && lines[i].points == 1)
		{
			lines[i].setRect21(L.rect11[0], L.rect11[1], L.rect11[2]);
			lines[i].setRect22(L.rect12[0], L.rect12[1], L.rect12[2]);
			lines[i].setRect23(L.rect13[0], L.rect13[1], L.rect13[2]);
			lines[i].setRect24(L.rect14[0], L.rect14[1], L.rect14[2]);
			lines[i].setRect2C(L.rect1C[0], L.rect1C[1], L.rect1C[2]);
			lines[i].points = 2;
			return 1;
		}
	}

	addLine(L);
	return 0;

}
