#include <GL/glut.h>
#include <stdlib.h>

unsigned char camera = 'r';

void KeyboardCallback(unsigned char c, int x, int y) {
  switch (c) {
  case 'q':
    exit (0);
    break;
  case 's':
    camera = 's';
    break;
  case 'f':
    camera = 'f';
    break;
  case 'b':
    camera = 'b';
    break;
  case 'a':
    camera = 'a';
    break;
  case 'u':
    camera = 'u';
    break;
  case 'r':
    camera = 'r';
    break;
  }
  glutPostRedisplay();
}

void DisplayCallback()
{
  // clear the color buffer
  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

  // set up camera
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  gluPerspective( 45, 1.0, 0.1, 10.0 );
  glTranslatef( 0.0, 0.0, -5.0 );
  switch (camera) {
  case 's':
    glRotatef( 180, 0.0, 1.0, 0.0 );
    break;
  case 'f':
    glRotatef( -90, 0.0, 1.0, 0.0 );
    break;
  case 'b':
    glRotatef( 90, 0.0, 1.0, 0.0 );
    break;
  case 'a':
    glRotatef( 90, 1.0, 0.0, 0.0 );
    break;
  case 'u':
    glRotatef( -90, 1.0, 0.0, 0.0 );
    break;
  case 'r':
    break;
  }

  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();
  
  glColor3f( .5, .5, .5 );
  glutSolidTeapot(1);
    //glutSolidSphere( 1.0, 10, 10 );
  
  // draw the buffer to the screen
  glutSwapBuffers();
}


int main(int argc, char **argv)
{
  // create window and rendering context
  glutInit( &argc, argv );
  glutInitDisplayMode( GLUT_DEPTH | GLUT_RGB | GLUT_DOUBLE );
  glutInitWindowSize( 500, 500 );
  glutCreateWindow( "Elephant" );
  
  // register display callback
  glutDisplayFunc( DisplayCallback );
  glutKeyboardFunc( KeyboardCallback );
  
  glViewport( 0, 0, 500, 500 );
  glEnable( GL_DEPTH_TEST );
  
  // lighting stuff
  GLfloat ambient[] = {0.0, 0.0, 0.0, 1.0};
  GLfloat diffuse[] = {1.0, 1.0, 1.0, 1.0};
  GLfloat specular[] = {1.0, 1.0, 1.0, 1.0};
  GLfloat position0[] = {1.0, 1.0, 1.0, 0.0};
  glLightfv( GL_LIGHT0, GL_POSITION, position0 );
  glLightfv( GL_LIGHT0, GL_AMBIENT, ambient );
  glLightfv( GL_LIGHT0, GL_DIFFUSE, diffuse );
  glLightfv( GL_LIGHT0, GL_SPECULAR, specular );
  GLfloat position1[] = {-1.0, -1.0, -1.0, 0.0};
  glLightfv( GL_LIGHT1, GL_POSITION, position1 );
  glLightfv( GL_LIGHT1, GL_AMBIENT, ambient );
  glLightfv( GL_LIGHT1, GL_DIFFUSE, diffuse );
  glLightfv( GL_LIGHT1, GL_SPECULAR, specular );
  
  glEnable( GL_LIGHTING );
  glEnable( GL_LIGHT0 );
  glEnable( GL_LIGHT1 );
  glEnable( GL_COLOR_MATERIAL );

  // pass control over to GLUT
  glutMainLoop();
  
  return 0;       // never reached
}

