#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>


int dumpPPM(int frameNum);
unsigned char camera = 'r';

int iCount = 0;       // used for numbering the PPM image files
int Width = 400;      // window width (pixels)
int Height = 400;     // window height (pixels)
bool Dump=false;      // flag set to true when dumping animation frames


void keyboardCallback(unsigned char c, int x, int y) {
  switch (c) {
  case 'q':
    exit (0);
    break;
  case 's':
    camera = 's';
    break;
  case 'f':
    camera = 'f';
    break;
  case 'b':
    camera = 'b';
    break;
  case 'a':
    camera = 'a';
    break;
  case 'u':
    camera = 'u';
    break;
  case 'r':
    camera = 'r';
    break;
  case 'i':
    dumpPPM(iCount);
    iCount++;
    break;
  case 'd':               // dump animation PPM frames
    iCount = 0;         // image file count
    Dump = !Dump;
    break;
  }
  glutPostRedisplay();
}

void reshapeCallback(int w, int h)
{
   Width = w;
   Height = h;
   glViewport(0, 0, w, h);
}

void displayCallback()
{
  // clear the color buffer
  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

  // set up camera
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  gluPerspective( 45, 1.0, 0.1, 200.0 );

  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();
  glTranslatef( 0.0, 0.0, -5.0 );
  switch (camera) {
  case 's':
    glRotatef( 180, 0.0, 1.0, 0.0 );
    break;
  case 'f':
    glRotatef( -90, 0.0, 1.0, 0.0 );
    break;
  case 'b':
    glRotatef( 90, 0.0, 1.0, 0.0 );
    break;
  case 'a':
    glRotatef( 90, 1.0, 0.0, 0.0 );
    break;
  case 'u':
    glRotatef( -90, 1.0, 0.0, 0.0 );
    break;
  case 'r':
    break;
  }

  
  glColor3f( .5, .5, .5 );
  glutSolidTeapot(1);

  // draw the buffer to the screen
  glutSwapBuffers();

  if (Dump) {               // save images to file
    dumpPPM(iCount);
    iCount++;
  }

  GLenum error = glGetError();
  if(error != GL_NO_ERROR)
    printf("ERROR: %s\n", gluErrorString(error));
}

//---------------------------------------------------------------

int dumpPPM(int frameNum)
{
  FILE *fp;
  const int maxVal=255;
  register int y;
  unsigned char *pixels;

  glReadBuffer( GL_FRONT );
  char fname[100];
  sprintf(fname,"./ppm/img%03d.ppm",frameNum);
  fp = fopen(fname,"wb");
  if (!fp) {
	printf("Unable to open file '%s'\n",fname);
	return 1;
  }
  printf("Saving image `%s`\n",fname);
  fprintf(fp, "P6 ");
  fprintf(fp, "%d %d ", Width, Height);
  fprintf(fp, "%d", maxVal);
  putc(13,fp);
  pixels = new unsigned char [3*Width];

  y = 0;
  glReadPixels(0,Height-1,Width,1,GL_RGB,GL_UNSIGNED_BYTE, (GLvoid *) pixels);

  for ( y = Height-1; y >=0; y-- ) {
	glReadPixels(0,y,Width,1,GL_RGB,GL_UNSIGNED_BYTE, (GLvoid *) pixels);
	for (int n=0; n<3*Width; n++) {
		putc(pixels[n],fp);
	}
  }
  fclose(fp);
  delete [] pixels;
  return 0;
}

//---------------------------------------------------------------

int main(int argc, char **argv)
{
  // create window and rendering context
  glutInit( &argc, argv );
  glutInitDisplayMode( GLUT_DEPTH | GLUT_RGB | GLUT_DOUBLE );
  glutInitWindowSize( Width, Height );
  glutCreateWindow( "Armadillo" );
  
  // register display callback
  glutDisplayFunc( displayCallback );
  glutKeyboardFunc( keyboardCallback );
  
  glViewport( 0, 0, Width, Height );
  glEnable( GL_DEPTH_TEST );
  glEnable( GL_NORMALIZE );
  
  // lighting stuff
  GLfloat ambient[] = {0.0, 0.0, 0.0, 1.0};
  GLfloat diffuse[] = {0.9, 0.9, 0.9, 1.0};
  GLfloat specular[] = {0.4, 0.4, 0.4, 1.0};
  GLfloat position0[] = {1.0, 1.0, 1.0, 0.0};
  glLightfv( GL_LIGHT0, GL_POSITION, position0 );
  glLightfv( GL_LIGHT0, GL_AMBIENT, ambient );
  glLightfv( GL_LIGHT0, GL_DIFFUSE, diffuse );
  glLightfv( GL_LIGHT0, GL_SPECULAR, specular );
  GLfloat position1[] = {-1.0, -1.0, -1.0, 0.0};
  glLightfv( GL_LIGHT1, GL_POSITION, position1 );
  glLightfv( GL_LIGHT1, GL_AMBIENT, ambient );
  glLightfv( GL_LIGHT1, GL_DIFFUSE, diffuse );
  glLightfv( GL_LIGHT1, GL_SPECULAR, specular );
  
  glEnable( GL_LIGHTING );
  glEnable( GL_LIGHT0 );
  glEnable( GL_LIGHT1 );
  glEnable( GL_COLOR_MATERIAL );

  // pass control over to GLUT
  glutMainLoop();
  
  return 0;       // never reached
}

