/* The Virtual Method Table (vmt) for Base */
struct Base_vmt {
 int (*Val)(struct Base*);
 void (*Inc)(struct Base*);
 void (*Dec)(struct Base*);
};

/* The class layout for Base */
struct Base {
 struct Base_vmt *vmt;
 int a;
};

/* Base::Val() */
int Base_Val(struct Base *this) {
 return this->a;
}

/* Base::Inc() */
void Base_Inc(struct Base *this) {
 this->a++;
}

/* Base::Dec() */
void Base_Dec(struct Base *this) {
 this->a--;
}

struct Base_vmt base_vmt = { Base_Val, Base_Inc, Base_Dec };

/* The Virtual Method Table (vmt) for Sub1 */
struct Sub1_vmt {
 int (*Val)(struct Sub1*);
 void (*Inc)(struct Sub1*);
 void (*Dec)(struct Sub1*);
};

/* The class layout for Sub1 */
struct Sub1 {
 struct Sub1_vmt *vmt;
 int a;
};

/* Sub1::Inc() */
void Sub1_Inc(struct Sub1 *this) {
 this->a += 4;
}

/* Sub1::Dec() */
void Sub1_Dec(struct Sub1 *this) {
 this->a -= 4;
}

struct Sub1_vmt sub1_vmt = { Base_Val, Sub1_Inc, Sub1_Dec };

/* The Virtual Method Table (vmt) for Sub2 */
struct Sub2_vmt {
 int (*Val)(struct Sub2*);
 void (*Inc)(struct Sub2*);
 void (*Dec)(struct Sub2*);
 void (*Set)(struct Sub2*,int);
 void (*AddB)(struct Sub2*);
};

/* The class layout for Sub2 */
struct Sub2 {
 struct Sub2_vmt *vmt;
 int a;
 int b;
};

/* Sub2::Inc() */
void Sub2_Inc(struct Sub2 *this) {
 this->a += 8;
}

/* Sub2::Dec() */
void Sub2_Dec(struct Sub2 *this) {
 this->a -= 8;
}

/* Sub2::Set() */
void Sub2_Set(struct Sub2 *this, int val) {
 this->b = val;
}

/* Sub2::AddB() */
void Sub2_AddB(struct Sub2 *this) {
 this->a += this->b;
}

struct Sub2_vmt sub2_vmt = { Base_Val, Sub2_Inc, Sub2_Dec, Sub2_Set, Sub2_AddB };

/* The Virtual Method Table (vmt) for Sub3 */
struct Sub3_vmt {
 int (*Val)(struct Sub3*);
 void (*Inc)(struct Sub3*);
 void (*Dec)(struct Sub3*);
 void (*Set)(struct Sub3*,int);
 void (*AddB)(struct Sub3*);
 void (*SubB)(stuct Sub3*);
};


/* The class layout for Sub3 */
struct Sub3 {
 struct Sub3_vmt *vmt;
 int a;
 int b;
};

/* Sub3::Set() */
void Sub3_Set(struct Sub3 *this, int val) {
 this->b = val + 4;
}

/* Sub3::SubB() */
void Sub3_SubB(struct Sub3 *this) {
 this->a -= this->b;
}

struct Sub3_vmt sub3_vmt = { Base_Val, Sub2_Inc, Sub2_Dec, Sub3_Set, Sub2_AddB, Sub3_SubB };

/* This is how the objects would look after initialisation by their
 constructors (not shown here), for simplicity. This is not valid C. */
struct Base *bobj = { &base_vmt, 3 };
struct Sub1 *sub1 = { &sub1_vmt, 2 };
struct Sub2 *sub2 = { &sub2_vmt, 6, 0 };
struct Sub3 *sub3 = { &sub3_vmt, 8, 0 };

void dostuff() {
 bobj->vmt->Inc(bobj);
 sub3->vmt->Set(sub3, sub2->vmt->Val(sub2));
 sub3->vmt->SubB(sub3);
 sub2->vmt->Dec(sub2);
 sub2->vmt->Set(sub2, sub1->vmt->Val(sub1));
 sub2->vmt->AddB(sub2);
}

/* called by stub */
dostuff();
