public class a6_ex3 {
    public abstract class ExprNode {
      public abstract int count();
      public abstract int eval();
    }

    public class BinaryExpr extendes ExprNode {
      protected ExprNode left;
      protected ExprNode right;

      public BinaryExpr(ExprNode left, ExprNode right) {
        this.left = left;
        this.right = right;
      }

      @Override
      public int count() {
        return 1 + left.count() + right.count();
      }
    }

    public class AndNode extends BinaryExpr {
      public AndNode(ExprNode left, ExprNode right) {
        super(left, right);
      }

      @Override
      public int eval() {
        return this.left.eval() & this.right.eval();
      }
    }

    public class SubNode extends ExprNode {
      public SubNode(ExprNode left, ExprNode right) {
        super(left, right);
      }

      @Override
      public int eval() {
        return this.left.eval() - this.right.eval();
      }
    }

    public class AddNode extends ExprNode {
      public AddNode(ExprNode left, ExprNode right) {
        super(left, right);
      }

      @Override
      public int eval() {
        return this.left.eval() + this.right.eval();
      }
    }

    public class DataNode extends ExprNode {
      private int val;

      public DataNode(int val) {
        this.val = val;
      }

      @Override
      public int count() {
        return 1;
      }

      @Override
      public int eval() {
        return this.val;
      }
    }

    public static int r;
    public static int c;
    /* Note that Java does not have truly static variables, so this is actually
       all dynamically allocated. */
    public static ExprNode root = new AndNode(
      new SubNode(
        new AddNode(new DataNode(4), new DataNode(3)),
        new AddNode(new DataNode(2), new DataNode(7))),
      new DataNode(704)
    );

    public static void doeval() {
      r = root.eval();
      c = root.count();
    }

    /* This is the stub */
    public static void main(String args[]) {
      doeval();
    }
}
