/* The Virtual Method Table (vmt) for ExprNode and its subclasses */
struct ExprNode_vmt {
 int (*count)(struct ExprNode*);
 int (*eval)(struct ExprNode*);
};

/* ExprNode has no data, only abstract methods */
struct ExprNode {
 struct ExprNode_vmt *vmt;
};

struct ExprNode_vmt expr_vmt = { 0, 0 };

/* BinaryExpr has a left and right field, and a count method. */
struct BinaryExpr {
 struct ExprNode_vmt *vmt;
 struct ExprNode *left;
 struct ExprNode *right;
};

/* BinaryExpr::count() */
int BinaryExpr_count(struct BinaryExpr* this) {
 return 1 + this->left->vmt->count(this->left)
          + this->right->vmt->count(this->right);
}

/* Note that eval() is still unimplemented */
struct ExprNode_vmt binary_vmt = { BinaryExpr_count, 0 };

/* AndNode extends BinaryExpr with only the eval() method. */
struct AndNode {
 struct ExprNode_vmt *vmt;
 struct ExprNode *left;
 struct ExprNode *right;
};

/* AndNode::eval() */
int AndNode_eval(struct AndNode *this) {
 return this->left->vmt->eval(this->left)
      & this->right->vmt->eval(this->right);
}

/* VMT for AndNode */
struct ExprNode_vmt and_vmt = { BinaryExpr_count, AndNode_eval };

/* SubNode extends BinaryExpr with only the eval() method. */
struct SubNode {
 struct ExprNode_vmt *vmt;
 struct ExprNode *left;
 struct ExprNode *right;
};

/* SubNode::eval() */
int SubNode_eval(struct SubNode *this) {
 return this->left->vmt->eval(this->left)
      - this->right->vmt->eval(this->right);
}

/* VMT for SubNode */
struct ExprNode_vmt sub_vmt = { BinaryExpr_count, SubNode_eval };

/* AddNode extends BinaryExpr with only the eval() method. */
struct AddNode {
 struct ExprNode_vmt *vmt;
 struct ExprNode *left;
 struct ExprNode *right;
};

/* AddNode::eval() */
int AddNode_eval(struct AddNode *this) {
 return this->left->vmt->eval(this->left)
      + this->right->vmt->eval(this->right);
}

/* VMT for AddNode */
struct ExprNode_vmt add_vmt = { BinaryExpr_count, AddNode_eval };

/* DataNode extends ExprNode and implements both methods */
struct DataNode {
 struct ExprNode_vmt *vmt;
 int val;
};

/* DataNode::count() */
int DataNode_count(struct DataNode *this) {
 return 1;
}

/* DataNode::eval() */
int DataNode_eval(struct DataNode *this) {
 return this->val;
}

/* VMT for DataNode */
struct ExprNode_vmt data_vmt = { DataNode_count, DataNode_eval };

/* This is how the tree of objects would look after initialisation by their
 constructors (not shown here), for simplicity. This is not valid C. */
struct ExprNode *root = {
 &and_vmt,
 {
  &sub_vmt,
  {
   &add_vmt,
   { &data_vmt, 4 },
   { &data_vmt, 3 }
  },
  {
   &add_vmt,
   { &data_vmt, 2 },
   { &data_vmt, 7 }
  }
 },
 {
  &data_vmt,
  704
 },
};

int r;
int c;

void doeval() {
 r = root->vmt->eval(root);
 c = root->vmt->count(root);
}

/* called by stub */
doeval();
