.pos 0x100
    # stub
start:
    ld $stacktop, r5
    gpc $6, r6
    j exec
    halt

# void exec()
exec:
    deca r5
    st r4, 0(r5)         # save r4 (allocated to a)
    deca r5
    st r6, 0(r5)         # save r6 (allocated to b)
    ld $0, r1            # r1:pc = 0
exec_while:
    ld $mem, r0          # r0 = address of mem
    ld (r0,r1,4), r2     # r2:u = mem[pc]
    inc r1               # pc++
    ld $255, r3          # r3 = 255
    and r3, r1           # pc &= 255
    mov r2, r3           # r3 = u
    shr $28, r3          # r3 = u >> 28
    ld $15, r0           # r0 = 15
    and r0, r3           # r3 = (u>>28) & 15
    # note that we can skip the lower bounds check since any value &15 will not be negative
    ld $0xFFFFFFF2, r0   # r0 = -14
    add r3, r0           # r0 = ((u>>28) & 15) - 14
    bgt r0, exec_default # goto exec_default if ((u>>28)&15) > 14
    ld $exec_switch, r0  # r0 = address of switch table
    j *(r0,r3,4)         # switch
exec_case0:
    ld $0xFFFFFF, r4     # r4:a = 0xFFFFFF
    and r2, r4           # a = u & 0xFFFFFF
    br exec_while        # break -- continue at top of while loop
exec_case1:
    ld $255, r0          # r0 = 255
    and r2, r0           # r0 = u & 255
    ld $mem, r3          # r3 = address of mem
    ld (r3,r0,4), r4     # a = mem[u & 255]
    br exec_while        # break -- continue at top of while loop
exec_case2:
    ld $255, r0          # r0 = 255
    and r2, r0           # r0 = u & 255
    ld $mem, r3          # r3 = address of mem
    st r4, (r3,r0,4)     # mem[u & 255] = a
    br exec_while        # break -- continue at top of while loop
exec_case3:
    ld $255, r0          # r0 = 255
    and r6, r0           # r0 = b & 255
    ld $mem, r3          # r3 = address of mem
    st r4, (r3,r0,4)     # mem[b & 255] = a
    br exec_while        # break -- continue at top of while loop
exec_case4:
    mov r4, r6           # b = a
    br exec_while        # break -- continue at top of while loop
exec_case5:
    mov r6, r4           # a = b
    br exec_while        # break -- continue at top of while loop
exec_case7:
    ld $0xFFFFFF, r0     # r0 = 0xFFFFFF
    and r2, r0           # r0 = u & 0xFFFFFF
    add r0, r4           # a = a + (u & 0xFFFFFF)
    br exec_while        # break -- continue at top of while loop
exec_case8:
    ld $255, r1          # pc = 255
    and r2, r1           # pc = u & 255
    br exec_while        # break -- continue at top of while loop
exec_case9:
    bgt r4, exec_case8   # goto do pc = u & 255 if a > 0
    br exec_while        # otherwise break -- continue at top of while loop
exec_case10:
    beq r4, exec_case8   # goto do pc = u & 255 if a == 0
    br exec_while        # otherwise break -- continue at top of while loop
exec_case12:
    ld $255, r0          # r0 = 255
    and r2, r0           # r0 = u & 255
    ld $mem, r3          # r3 = address of mem
    ld (r3,r0,4), r0     # r0 = mem[u & 255]
    add r0, r4           # a += mem[u & 255]
    br exec_while        # break -- continue at top of while loop
exec_case14:
    ld $255, r0          # r0 = 255
    and r6, r0           # r0 = b & 255
    ld $mem, r3          # r3 = address of mem
    ld (r3,r0,4), r4     # a = mem[b & 255]
    br exec_while        # break -- continue at top of while loop
exec_default:
    ld 0(r5), r6
    inca r5              # restore r6
    ld 0(r5), r4
    inca r5              # restore r4
    j 0(r6)              # return

.pos 0x200
# switch jump table
exec_switch:
    .long exec_case0     # 0
    .long exec_case1     # 1
    .long exec_case2     # 2
    .long exec_case3     # 3
    .long exec_case4     # 4
    .long exec_case5     # 5
    .long exec_default   # 6
    .long exec_case7     # 7
    .long exec_case8     # 8
    .long exec_case9     # 9
    .long exec_case10    # 10
    .long exec_default   # 11
    .long exec_case12    # 12
    .long exec_default   # 13
    .long exec_case14    # 14

.pos 0x280
# Static data area
mem:
    .long 0x10
    .long 0x40000000
    .long 0
    .long 0x2000000d
    .long 0xe0000000
    .long 0xa000000c
    .long 0xc000000d
    .long 0x2000000d
    .long 0x50000000
    .long 0xc000000e
    .long 0x40000000
    .long 0x80000004
    .long 0xf0000000
    .long 0
    .long 1
    .long 0
    .long 5
    .long 18
    .long 22
    .long 38
    .long 9
    .long 12
    .long 0

.pos 0x7FC0
# These are here so you can see (some of) the stack contents.
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
# Stack top (one word past end of stack)
stacktop:
    .long 0
