int mem[] = {
 0x00000010, 0x40000000, 0x00000000, 0x2000000d, 0xe0000000, 0xa000000c, 0xc000000d,
 0x2000000d, 0x50000000, 0xc000000e, 0x40000000, 0x80000004, 0xf0000000, 0x00000000,
 0x00000001, 0x00000000,
 5, 18, 22, 38, 9, 12, 0
};
/*
 This is an example of simulating a machine using another machine (SM213).
 The "memory" of this tiny machine contains the following short program,
 that sums up a list of numbers.
0  a = 16
1  b = a
2  a = 0
3  mem[13] = a
4  a = mem[b]
5  goto 12 if a == 0
6  a += mem[13]
7  mem[13] = a
8  a = b
9  a += mem[14]
10 b = a
11 goto 4
12 halt
13 .v 0
14 .v 1
15 .v 0
16 .v 5
17 .v 18
18 .v 22
19 .v 38
20 .v 9
21 .v 12
22 .v 0

 To avoid reentering the data, you may make use of the lines below.
mem:
    .long 0x10
    .long 0x40000000
    .long 0
    .long 0x2000000d
    .long 0xe0000000
    .long 0xa000000c
    .long 0xc000000d
    .long 0x2000000d
    .long 0x50000000
    .long 0xc000000e
    .long 0x40000000
    .long 0x80000004
    .long 0xf0000000
    .long 0
    .long 1
    .long 0
    .long 5
    .long 18
    .long 22
    .long 38
    .long 9
    .long 12
    .long 0
*/

void exec() {
 int a, b;
 int pc = 0;
 int u;
 while(1) {
  u = mem[pc];
  pc++;
  pc &= 255;
  switch((u>>28) & 15) {
  case 0:
   a = u & 0xFFFFFF;
   break;
  case 1:
   a = mem[u & 255];
   break;
  case 2:
   mem[u & 255] = a;
   break;
  case 3:
   mem[b & 255] = a;
   break;
  case 4:
   b = a;
   break;
  case 5:
   a = b;
   break;
  case 7:
   a = a + (u & 0xFFFFFF);
   break;
  case 8:
   pc = u & 255;
   break;
  case 9:
   if(a > 0)
    pc = u & 255;
   break;
  case 10:
   if(a == 0)
    pc = u & 255;
   break;
  case 12:
   a += mem[u & 255];
   break;
  case 14:
   a = mem[b & 255];
   break;
  default:
   return;
  }
 }
}

/* called by stub */
exec();
