.pos 0x100
    # stub
start:
    ld $stacktop, r5
    gpc $6, r6
    j eval
    halt

# int mul(int a, int b)
mul:
    ld 0(r5), r1         # r1:s = a
    ld 4(r5), r2         # r2:t = b
    bgt r1, mul_if1false # goto mul_if1false if s > 0
    not r1               # s = ~s
    inc r1               # s = -s
mul_if1false:
    bgt r2, mul_if2false # goto mul_if2false if t > 0
    not r2               # s = ~s
    inc r2               # t = -t
mul_if2false:
    ld $0, r0            # p = 0
mul_whilecheck:
    beq r2, mul_whiledone # goto mul_whiledone if t == 0
    ld $1, r3            # r3 = 1
    and r2, r3           # r3 = t & 1
    beq r3, mul_if3false # goto mul_if3false if t&1 == 0
    add r1, r0           # p += s
mul_if3false:
    shl $1, r1           # s <<= 1
    shr $1, r2           # t >>= 1
    br mul_whilecheck    # repeat while(t)
mul_whiledone:
    ld 0(r5), r1         # r1 = a
    ld 4(r5), r2         # r2 = b
    shr $31, r1          # r1 = a >> 31
    shr $31, r2          # r2 = b >> 31
    add r2, r1           # r1 = (a >> 31) + (b >> 31)
    ld $1, r2            # r2 = 1
    and r2, r1           # r1 = ((a >> 31) + (b >> 31)) & 1
    beq r1, mul_if4false
    not r0               # p = ~p
    inc r0               # p = -p
mul_if4false:
    j 0(r6)              # return with p in r0

# int div(int a, int b)
div:
    deca r5
    st r4, 0(r5)         # save r4
    ld 4(r5), r0         # r0:s = a
    bgt r0, div_if1false # goto div_if1false if s > 0
    not r0               # s = ~s
    inc r0               # s = -s
div_if1false:
    ld 8(r5), r1         # r1 = b
    bgt r1, div_if2false # goto div_if2false if b > 0
    not r1               # r1 = ~b
    inc r1               # r1 = -b
    st r1, 8(r5)         # b = -b
    ld 4(r5), r1         # r1 = a
    not r1               # r1 = ~a
    inc r1               # r1 = -a
    st r1, 4(r5)         # a = -a
div_if2false:
    ld $0, r2            # r2:c = 0
    ld $32, r1           # r1:i = 32
div_whilecheck:
    beq r1, div_whiledone # goto div_whiledone if i == 0
    shl $1, r2           # c <<= 1
    mov r0, r3           # r3 = s
    shr $31, r3          # r3 = s>>31
    ld $1, r4            # r4 = 1
    and r3, r4           # r4 = (s>>31) & 1
    add r4, r2           # c += (s>>31) & 1
    shl $1, r0           # s <<= 1
    mov r2, r3           # r3 = c
    not r3               # r3 = ~c
    inc r3               # r3 = -c
    ld 8(r5), r4         # r4 = b
    add r4, r3           # r3 = b - c
    bgt r3, div_if3false # goto div_if3false if b - c > 0 i.e. b > c, enter body if b <= c
    inc r0               # s++
    not r3               # r3 = ~(b - c)
    inc r3               # r3 = -(b - c) = c - b
    mov r3, r2           # r2:c = c - b i.e. c -= b
div_if3false:
    dec r1               # i--
    br div_whilecheck    # repeat while(i)
div_whiledone:
    ld 4(r5), r1         # r1 = a
    bgt r1, div_if4false # goto div_if4false if a > 0
    not r0               # s = ~s
    inc r0               # s = -s
div_if4false:
    ld 0(r5), r4
    inca r5              # restore r4
    j 0(r6)              # return with s in r0

# int n()
n:
    deca r5
    st r6, 0(r5)         # save r6
    ld $i, r0            # r0 = address of i
    ld 0(r0), r1         # r1 = i
    ld $expr, r2         # r2 = address of expr
    ld (r2,r1,4), r3     # r3:c = expr[i]
    mov r3, r2           # r2 = c
    not r2               # r2 = ~c
    inc r2               # r2 = -c
    ld $0x28, r1         # r1 = 0x28
    add r1, r2           # r2 = 0x28 - c
    bgt r2, n_default    # goto default if 0x28 - c > 0 i.e. c < 0x28
    not r2               # r2 = ~(0x28 - c)
    inc r2               # r2 = c - 0x28
    ld $0xFFFFFFEF, r1   # r1 = -17
    add r2, r1           # r1 = c - 0x28 - 0x11 = c - 0x39
    bgt r1, n_default    # goto default if c - 0x39 > 0 i.e. c > 0x39
    ld $n_switch, r1     # r1 = address of switch table
    j *(r1,r2,4)         # switch
n_case28:
    ld 0(r0), r1         # r1 = i
    inc r1               # r1 = i + 1
    st r1, 0(r0)         # i++
    gpc $6, r6
    j t                  # call t() --- note reassignment of c to r0
    ld $i, r1            # r1 = address of i
    ld 0(r1), r2         # r2 = i
    inc r2
    st r2, 0(r1)         # i++
    br n_ret             # return c (now in r0, conveniently)
n_case30_39:
    ld 0(r0), r1         # r1 = i
    inc r1               # r1 = i + 1
    st r1, 0(r0)         # i++
    ld $0xFFFFFFD0, r0   # r0 = -0x30
    add r3, r0           # r0 = c - 0x30
    br n_ret             # goto return c - 0x30
n_default:
    ld $0xFFFFFFFF, r0   # return -1
n_ret:
    ld 0(r5), r6
    inca r5              # restore r6
    j 0(r6)              # return

# int f()
f:
    deca r5
    st r4, 0(r5)         # save r4
    deca r5
    st r6, 0(r5)         # save r6
    gpc $6, r6
    j n                  # call n()
    mov r0, r4           # r4:v = n()
f_while:
    ld $i, r0            # r0 = address of i
    ld 0(r0), r1         # r1 = i
    ld $expr, r2         # r2 = address of expr
    ld (r2,r1,4), r1     # r1:c = expr[i]
    ld $0x2a, r2         # r2 = 0x2a
    mov r1, r3           # r3 = c
    not r3               # r3 = ~c
    inc r3               # r3 = -c
    add r3, r2           # r2 = 0x2a - c
    bgt r2, f_default    # goto default if 0x2a - c > 0 i.e. c < 0x2a
    not r2               # r2 = ~(0x2a - c)
    inc r2               # r2 = c - 0x2a
    ld $0xFFFFFFFB, r3   # r3 = -5
    add r2, r3           # r3 = c - 0x2a - 5 = c - 0x2f
    bgt r3, f_default    # goto default if c - 0x2f > 0 i.e. c > 0x2f
    ld $f_switch, r3     # r3 = address of switch table
    j *(r3,r2,4)         # switch
f_case2a:
    ld 0(r0), r1         # r1 = i
    inc r1               # r1 = i + 1
    st r1, 0(r0)         # i++
    gpc $6, r6
    j n                  # call n()
    deca r5
    st r0, 0(r5)         # push n()
    deca r5
    st r4, 0(r5)         # push v
    gpc $6, r6
    j mul                # call mul()
    inca r5
    inca r5              # discard pushed parameters
    mov r0, r4           # v = mul(v, n())
    br f_while           # back to loop
f_case2f:
    ld 0(r0), r1         # r1 = i
    inc r1               # r1 = i + 1
    st r1, 0(r0)         # i++
    gpc $6, r6
    j n                  # call n()
    deca r5
    st r0, 0(r5)         # push n()
    deca r5
    st r4, 0(r5)         # push v
    gpc $6, r6
    j div                # call div()
    inca r5
    inca r5              # discard pushed parameters
    mov r0, r4           # v = div(v, n())
    br f_while           # back to loop
f_default:
    mov r4, r0           # return v
f_ret:
    ld 0(r5), r6
    inca r5              # restore r6
    ld 0(r5), r4
    inca r5              # restore r4
    j 0(r6)              # return

# int t()
t:
    deca r5
    st r4, 0(r5)         # save r4
    deca r5
    st r6, 0(r5)         # save r6
    gpc $6, r6
    j f                  # call f()
    mov r0, r4           # r4:v = f()
t_while:
    ld $i, r0            # r0 = address of i
    ld 0(r0), r1         # r1 = i
    ld $expr, r2         # r2 = address of expr
    ld (r2,r1,4), r2     # r2:c = expr[i]
    ld $0x2b, r3         # r3 = 0x2b
    not r2               # r2 = ~c
    inc r2               # r2 = -c
    add r2, r3           # r3 = 0x2b - c
    bgt r3, t_default    # goto default if 0x2b - c > 0 i.e. c < 0x2b
    not r3               # r3 = ~(0x2b - c)
    inc r3               # r3 = c - 0x2b
    ld $0xFFFFFFFE, r2   # r2 = -2
    add r3, r2           # r2 = c - 0x2b - 2 = c - 0x2d
    bgt r2, t_default    # goto default if c - 0x2d > 0 i.e. c > 0x2d
    ld $t_switch, r2     # r2 = address of switch table
    j *(r2,r3,4)         # switch
t_case2b:
    inc r1               # r1 = i + 1
    st r1, 0(r0)         # i++
    gpc $6, r6
    j f                  # call f()
    add r0, r4           # v += f()
    br t_while
t_case2d:
    inc r1               # r1 = i + 1
    st r1, 0(r0)         # i++
    gpc $6, r6
    j f                  # call f()
    not r0               # r0 = ~f()
    inc r0               # r0 = -f()
    add r0, r4           # v -= f()
    br t_while
t_default:
    mov r4, r0           # return v
t_ret:
    ld 0(r5), r6
    inca r5              # restore r6
    ld 0(r5), r4
    inca r5              # restore r4
    j 0(r6)              # return

# int eval()
eval:
    deca r5
    st r6, 0(r5)         # save r6
    ld $0, r0            # r0 = 0
    ld $i, r1            # r1 = address of i
    st r0, 0(r1)         # i = 0
    gpc $6, r6
    j t                  # call t()
    ld $r, r1            # r1 = address of r
    st r0, 0(r1)         # r = t()
    ld 0(r5), r6
    inca r5              # restore r6
    j 0(r6)              # return

.pos 0x370
# switch jump tables
n_switch:
    .long n_case28       # 0x28
    .long n_default      # 0x29
    .long n_default      # 0x2a
    .long n_default      # 0x2b
    .long n_default      # 0x2c
    .long n_default      # 0x2d
    .long n_default      # 0x2e
    .long n_default      # 0x2f
    .long n_case30_39    # 0x30
    .long n_case30_39    # 0x31
    .long n_case30_39    # 0x32
    .long n_case30_39    # 0x33
    .long n_case30_39    # 0x34
    .long n_case30_39    # 0x35
    .long n_case30_39    # 0x36
    .long n_case30_39    # 0x37
    .long n_case30_39    # 0x38
    .long n_case30_39    # 0x39

f_switch:
    .long f_case2a       # 0x2a
    .long f_default      # 0x2b
    .long f_default      # 0x2c
    .long f_default      # 0x2d
    .long f_default      # 0x2e
    .long f_case2f       # 0x2f

t_switch:
    .long t_case2b       # 0x2b
    .long t_default      # 0x2c
    .long t_case2d       # 0x2d

.pos 0x400
# Static data area

i:  .long 0
r:  .long 0
expr:
    .long 0x34           # '4'
    .long 0x2a           # '*'
    .long 0x28           # '('
    .long 0x36           # '6'
    .long 0x2b           # '+'
    .long 0x38           # '8'
    .long 0x29           # ')'
    .long 0x2d           # '-'
    .long 0x39           # '9'
    .long 0x2f           # '/'
    .long 0x33           # '3'
    .long 0              # end

.pos 0x7FC0
# These are here so you can see (some of) the stack contents.
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
    .long 0
# Stack top (one word past end of stack)
stacktop:
    .long 0
