/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class BufferedTokenStream
implements TokenStream {
    protected TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(100);
    protected int lastMarker;
    protected int p = -1;
    protected int range = -1;

    public BufferedTokenStream() {
    }

    public BufferedTokenStream(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
    }

    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    public int index() {
        return this.p;
    }

    public int range() {
        return this.range;
    }

    public int mark() {
        if (this.p == -1) {
            this.setup();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int marker) {
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
    }

    public void seek(int index) {
        this.p = index;
    }

    public int size() {
        return this.tokens.size();
    }

    public void consume() {
        if (this.p == -1) {
            this.setup();
        }
        ++this.p;
        this.sync(this.p);
    }

    protected void sync(int i2) {
        int n2 = i2 - this.tokens.size() + 1;
        if (n2 > 0) {
            this.fetch(n2);
        }
    }

    protected void fetch(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            Token t2 = this.tokenSource.nextToken();
            t2.setTokenIndex(this.tokens.size());
            this.tokens.add(t2);
            if (t2.getType() == -1) break;
        }
    }

    public Token get(int i2) {
        if (i2 < 0 || i2 >= this.tokens.size()) {
            throw new NoSuchElementException("token index " + i2 + " out of range 0.." + (this.tokens.size() - 1));
        }
        return this.tokens.get(i2);
    }

    public List get(int start, int stop) {
        Token t2;
        if (start < 0 || stop < 0) {
            return null;
        }
        if (this.p == -1) {
            this.setup();
        }
        ArrayList<Token> subset = new ArrayList<Token>();
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        for (int i2 = start; i2 <= stop && (t2 = this.tokens.get(i2)).getType() != -1; ++i2) {
            subset.add(t2);
        }
        return subset;
    }

    public int LA(int i2) {
        return this.LT(i2).getType();
    }

    protected Token LB(int k2) {
        if (this.p - k2 < 0) {
            return null;
        }
        return this.tokens.get(this.p - k2);
    }

    public Token LT(int k2) {
        if (this.p == -1) {
            this.setup();
        }
        if (k2 == 0) {
            return null;
        }
        if (k2 < 0) {
            return this.LB(-k2);
        }
        int i2 = this.p + k2 - 1;
        this.sync(i2);
        if (i2 >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        if (i2 > this.range) {
            this.range = i2;
        }
        return this.tokens.get(i2);
    }

    protected void setup() {
        this.sync(0);
        this.p = 0;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.tokens.clear();
        this.p = -1;
    }

    public List getTokens() {
        return this.tokens;
    }

    public List getTokens(int start, int stop) {
        return this.getTokens(start, stop, (BitSet)null);
    }

    public List getTokens(int start, int stop, BitSet types) {
        if (this.p == -1) {
            this.setup();
        }
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > stop) {
            return null;
        }
        ArrayList<Token> filteredTokens = new ArrayList<Token>();
        for (int i2 = start; i2 <= stop; ++i2) {
            Token t2 = this.tokens.get(i2);
            if (types != null && !types.member(t2.getType())) continue;
            filteredTokens.add(t2);
        }
        if (filteredTokens.size() == 0) {
            filteredTokens = null;
        }
        return filteredTokens;
    }

    public List getTokens(int start, int stop, List types) {
        return this.getTokens(start, stop, new BitSet(types));
    }

    public List getTokens(int start, int stop, int ttype) {
        return this.getTokens(start, stop, BitSet.of(ttype));
    }

    public String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    public String toString() {
        if (this.p == -1) {
            this.setup();
        }
        this.fill();
        return this.toString(0, this.tokens.size() - 1);
    }

    public String toString(int start, int stop) {
        Token t2;
        if (start < 0 || stop < 0) {
            return null;
        }
        if (this.p == -1) {
            this.setup();
        }
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = start; i2 <= stop && (t2 = this.tokens.get(i2)).getType() != -1; ++i2) {
            buf.append(t2.getText());
        }
        return buf.toString();
    }

    public String toString(Token start, Token stop) {
        if (start != null && stop != null) {
            return this.toString(start.getTokenIndex(), stop.getTokenIndex());
        }
        return null;
    }

    public void fill() {
        if (this.p == -1) {
            this.setup();
        }
        if (this.tokens.get(this.p).getType() == -1) {
            return;
        }
        int i2 = this.p + 1;
        this.sync(i2);
        while (this.tokens.get(i2).getType() != -1) {
            this.sync(++i2);
        }
    }
}

