/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.HashMap;

public class UserVisibleException
extends Exception {
    private static String VISIBLE_CLASS_PREFIX = "arch.";
    private static HashMap<Class, Exception> lastNatural = new HashMap();
    private Exception naturalInstance = null;
    private int pc = -1;

    public UserVisibleException() {
        if (!this.getStackTrace()[0].getClassName().startsWith(VISIBLE_CLASS_PREFIX)) {
            this.naturalInstance = this;
            lastNatural.put(this.getClass(), this);
        } else {
            this.naturalInstance = lastNatural.get(this.getClass());
        }
    }

    public UserVisibleException(String aMessage, int aPC, Exception aCause) {
        super(aMessage);
        if (!this.getStackTrace()[0].getClassName().startsWith(VISIBLE_CLASS_PREFIX)) {
            this.naturalInstance = this;
            lastNatural.put(this.getClass(), this);
        } else {
            this.naturalInstance = lastNatural.get(this.getClass());
        }
        this.pc = aPC;
        if (aCause != null) {
            this.naturalInstance = aCause;
            lastNatural.put(this.getClass(), aCause);
        }
    }

    public UserVisibleException(String aMessage, Exception aCause) {
        this(aMessage, -1, aCause);
    }

    public UserVisibleException(String aMessage) {
        this(aMessage, -1, null);
    }

    public UserVisibleException(String aMessage, int aPC) {
        this(aMessage, aPC, null);
    }

    public String getMessage() {
        String dbgMsg = "";
        if (this.naturalInstance != null) {
            for (StackTraceElement ste : this.naturalInstance.getStackTrace()) {
                if (!ste.getClassName().startsWith(VISIBLE_CLASS_PREFIX) || ste.getLineNumber() <= 0) continue;
                String[] parts = ste.getClassName().split("\\.");
                String className = parts.length > 0 ? parts[parts.length - 1] : ste.getClassName();
                dbgMsg = String.format(", in %s.%s at line %d", className, ste.getMethodName(), ste.getLineNumber());
                break;
            }
        }
        return super.getMessage().concat(this.pc != -1 ? String.format(" at PC 0x%x", this.pc) : "").concat(dbgMsg).concat(".");
    }

    public void setPC(int aPC) {
        this.pc = aPC;
    }
}

