/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import util.AbstractDataModel;
import util.DataModel;
import util.DataModelEvent;
import util.TableCellIndex;

public class CompoundModel
extends AbstractDataModel
implements Observer {
    private DataModel modelA;
    private DataModel modelB;

    public CompoundModel(DataModel aModelA, DataModel aModelB) {
        this.modelA = aModelA;
        this.modelB = aModelB;
        this.modelA.addObserver(this);
        this.modelB.addObserver(this);
    }

    public boolean insertRow(int row) {
        if (this.canInsertRow(row)) {
            boolean inserted = this.modelA.insertRow(row);
            assert (inserted);
            inserted = this.modelB.insertRow(row);
            assert (inserted);
            return true;
        }
        return false;
    }

    public boolean deleteRow(int row) {
        if (this.canDeleteRow(row)) {
            boolean deleted = this.modelA.deleteRow(row);
            assert (deleted);
            deleted = this.modelB.deleteRow(row);
            assert (deleted);
            return true;
        }
        return false;
    }

    public boolean canInsertRow(int row) {
        return this.modelA.canInsertRow(row) && this.modelB.canInsertRow(row);
    }

    public boolean canDeleteRow(int row) {
        return this.modelA.canDeleteRow(row) && this.modelB.canInsertRow(row);
    }

    public void update(Observable o, Object arg) {
        DataModelEvent event = (DataModelEvent)arg;
        if (o == this.modelA) {
            this.tellObservers(event);
        } else {
            Vector<TableCellIndex> fireCells = new Vector<TableCellIndex>();
            for (TableCellIndex cell : event.getCells()) {
                fireCells.add(new TableCellIndex(cell.rowIndex, cell.columnIndex + this.modelA.getColumnCount()));
            }
            this.tellObservers(new DataModelEvent(event.getType(), fireCells));
        }
    }

    private DataModel baseModel(int columnIndex) {
        return columnIndex < this.modelA.getColumnCount() ? this.modelA : this.modelB;
    }

    private int baseColumnIndex(int columnIndex) {
        return columnIndex - (columnIndex < this.modelA.getColumnCount() ? 0 : this.modelA.getColumnCount());
    }

    public Class getColumnClass(int columnIndex) {
        return this.baseModel(columnIndex).getColumnClass(this.baseColumnIndex(columnIndex));
    }

    public int getColumnCount() {
        return this.modelA.getColumnCount() + this.modelB.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.baseModel(columnIndex).getColumnName(this.baseColumnIndex(columnIndex));
    }

    public int getRowCount() {
        return Math.max(this.modelA.getRowCount(), this.modelB.getRowCount());
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return rowIndex < this.baseModel(columnIndex).getRowCount() ? this.baseModel(columnIndex).getValueAt(rowIndex, this.baseColumnIndex(columnIndex)) : null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex < this.baseModel(columnIndex).getRowCount() ? Boolean.valueOf(this.baseModel(columnIndex).isCellEditable(rowIndex, this.baseColumnIndex(columnIndex))) : null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.baseModel(columnIndex).getRowCount()) {
            this.baseModel(columnIndex).setValueAt(aValue, rowIndex, this.baseColumnIndex(columnIndex));
        }
    }
}

