/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.DataModel;

public class BitString {
    int length;
    long value;

    public BitString(int aLength, long aValue) {
        this.length = aLength;
        this.value = 0L;
        for (int i = 0; i < this.length; ++i) {
            this.value = this.value << 1 | aValue >> this.length - 1 - i & 1L;
        }
    }

    public BitString(BitString bs) {
        this(bs.length, bs.value);
    }

    public BitString() {
        this(0, 0L);
    }

    public int length() {
        return this.length;
    }

    public long getValue() {
        return this.value;
    }

    public int getValueAt(int startBit, int numBits) {
        int v = 0;
        for (int i = startBit; i < startBit + numBits; ++i) {
            v = v << 1 | (int)(this.value >> this.length - i - 1 & 1L);
        }
        return v;
    }

    public BitString concat(BitString aBitString) {
        this.value = this.value << aBitString.length | aBitString.value;
        this.length += aBitString.length;
        return this;
    }

    public Byte[] toBytes() {
        int len = this.byteLength();
        Byte[] byteValue = new Byte[len];
        for (int i = 0; i < len; ++i) {
            byteValue[i] = new Byte((byte)(this.value >> (len - 1 - i) * 8));
        }
        return byteValue;
    }

    public void writeToByUser(DataModel model, int address) {
        model.setValueAtByUser(this.toBytes(), address, 1);
    }

    public int byteLength() {
        return (this.length + 7) / 8;
    }

    public boolean equals(Object o) {
        if (o instanceof BitString) {
            BitString b = (BitString)o;
            return this.length == b.length && this.value == b.value;
        }
        return false;
    }

    public int hashCode() {
        return this.length + (int)this.value;
    }
}

