/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Vector;
import util.BitString;
import util.DataModel;

public class BitStream {
    DataModel memory;
    int address;
    Vector<Byte> bytes;
    int curBitOffset;
    int markedBitOffset;

    public BitStream(DataModel aMemory, int anAddress) {
        this.memory = aMemory;
        this.address = anAddress;
        this.curBitOffset = 0;
        this.markedBitOffset = 0;
        this.bytes = new Vector();
    }

    public byte getByteAt(int offset) {
        if (this.bytes.size() <= offset || this.bytes.get(offset) == null) {
            this.bytes.add(offset, (Byte)this.memory.getValueAt(this.address + offset, 1));
        }
        return this.bytes.get(offset);
    }

    public BitString getValue(int length) {
        int offsetInByte = this.curBitOffset % 8;
        if (length == 0) {
            return new BitString();
        }
        if (offsetInByte + length > 8) {
            return this.getValue(8 - offsetInByte).concat(this.getValue(length - (8 - offsetInByte)));
        }
        int curByte = this.getByteAt(this.curBitOffset / 8) & 0xFF;
        BitString bitString = new BitString(length, curByte << offsetInByte >> 8 - length & 0xFF);
        this.curBitOffset += length;
        return bitString;
    }

    public void skip(int bitLength) {
        this.curBitOffset += bitLength;
    }

    public void mark() {
        this.markedBitOffset = this.curBitOffset;
    }

    public void rewind() {
        this.curBitOffset = this.markedBitOffset;
    }
}

