/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.View;
import ui.gui.UI;
import ui.gui.ViewFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewTextField
extends ViewFormat {
    private AlphaTextField rendererPrototype;
    private AlphaTextField editorPrototype;
    private Object rendererValue;
    private Object editorValue;
    private boolean isWidthVariable;

    ViewTextField(int columns, int horizontalAlignment, Font font, Color color, ViewFormat.HighlightControl highlightControl, List<ViewFormat.Format> formats) {
        super(formats);
        this.isWidthVariable = columns < 0;
        columns = Math.abs(columns);
        this.rendererPrototype = this.newPrototype(columns, horizontalAlignment, font, color);
        this.editorPrototype = this.newPrototype(columns, horizontalAlignment, font, color);
        this.setHighlightControl(highlightControl, this.rendererPrototype);
    }

    ViewTextField(int columns, int horizontalAlignment, Font font, Color color, ViewFormat.HighlightControl highlightControl, ViewFormat.Format format) {
        this(columns, horizontalAlignment, font, color, highlightControl, Arrays.asList(format));
    }

    AlphaTextField newPrototype(int columns, int horizontalAlignment, Font font, Color color) {
        AlphaTextField prototype = new AlphaTextField();
        prototype.setColumns(columns);
        prototype.setHorizontalAlignment(horizontalAlignment);
        if (font != null) {
            prototype.setFont(font);
        }
        if (color != null) {
            prototype.setForeground(color);
        }
        Insets insets = prototype.getBorder().getBorderInsets(prototype);
        if (insets.top >= 2 && insets.bottom >= 2) {
            --insets.top;
            --insets.bottom;
        }
        prototype.setBorder(new CompoundBorder(new LineBorder(UI.CELL_BORDER_COLOR, 1), new EmptyBorder(insets.top - 1, 2, insets.bottom - 1, 2)));
        prototype.setBackground(UI.BACKGROUND_COLOR);
        if (font.getFamily().equals("Consolas") && prototype.getUI() instanceof MetalTextFieldUI) {
            prototype.setUI(new MetalTextFieldUI(){

                public View create(Element element) {
                    return new FieldView(element){

                        protected Shape adjustAllocation(Shape shape) {
                            if (shape != null) {
                                Rectangle bounds = shape.getBounds();
                                bounds = (Rectangle)super.adjustAllocation(bounds);
                                ++bounds.y;
                                --bounds.height;
                                return bounds;
                            }
                            return null;
                        }
                    };
                }
            });
        }
        return prototype;
    }

    @Override
    void adjustFontSize(int increment) {
        this.adjustFontSize(this.rendererPrototype, increment);
        this.adjustFontSize(this.editorPrototype, increment);
    }

    private void adjustFontSize(JTextField textField, int increment) {
        Font font = textField.getFont();
        textField.setFont(font.deriveFont(Float.valueOf(font.getSize() + increment).floatValue()));
    }

    @Override
    int getWidth() {
        return this.getEditorPrototype().getPreferredSize().width + 2;
    }

    @Override
    boolean isWidthVariable() {
        return this.isWidthVariable;
    }

    @Override
    void setWidth(int width) {
        this.rendererPrototype.setColumns(width);
        this.rendererPrototype.setMinimumSize(this.rendererPrototype.getPreferredSize());
        this.editorPrototype.setColumns(width);
        this.editorPrototype.setMinimumSize(this.editorPrototype.getPreferredSize());
    }

    @Override
    boolean isEditable() {
        return true;
    }

    @Override
    JComponent getRendererPrototype() {
        return this.rendererPrototype;
    }

    @Override
    JComponent getEditorPrototype() {
        return this.editorPrototype;
    }

    @Override
    void setRendererPrototypeValue(Object value, boolean isSelected) {
        String text = this.valueToText(value, isSelected);
        this.rendererPrototype.setText(text);
        if (text.length() > this.rendererPrototype.getColumns()) {
            this.rendererPrototype.setToolTipText(text);
        } else {
            this.rendererPrototype.setToolTipText(null);
        }
        this.rendererValue = value;
    }

    @Override
    void setEditorPrototypeValue(Object value) {
        this.editorPrototype.setText(this.valueToText(value, true));
        this.editorValue = value;
    }

    @Override
    Object getEditorPrototypeValue() {
        return this.textToValue(this.editorPrototype.getText(), this.editorValue);
    }

    @Override
    String checkRendererPrototypeValidity() {
        return this.checkValidity(this.rendererPrototype.getText(), this.rendererValue);
    }

    @Override
    void setRendererPrototypeError(boolean isError) {
        Insets insets = this.rendererPrototype.getBorder().getBorderInsets(this.rendererPrototype);
        if (isError) {
            this.rendererPrototype.setBorder(new CompoundBorder(new LineBorder(UI.ERROR_BORDER_COLOR, 1), new EmptyBorder(insets.top - 1, 2, insets.bottom - 1, 2)));
        } else {
            this.rendererPrototype.setBorder(new CompoundBorder(new LineBorder(UI.CELL_BORDER_COLOR, 1), new EmptyBorder(insets.top - 1, 2, insets.bottom - 1, 2)));
        }
    }

    @Override
    String checkEditorPrototypeValidity() {
        return this.checkValidity(this.editorPrototype.getText(), this.editorValue);
    }

    @Override
    void setEditorPrototypeError(boolean isError) {
        Insets insets = this.editorPrototype.getBorder().getBorderInsets(this.editorPrototype);
        if (isError) {
            this.editorPrototype.setBorder(new CompoundBorder(new LineBorder(UI.ERROR_BORDER_COLOR, 1), new EmptyBorder(insets.top - 1, 2, insets.bottom - 1, 2)));
        } else {
            this.editorPrototype.setBorder(new CompoundBorder(new LineBorder(UI.CELL_BORDER_COLOR, 1), new EmptyBorder(insets.top - 1, 2, insets.bottom - 1, 2)));
        }
    }

    class AlphaTextField
    extends JTextField {
        public AlphaTextField() {
            this.setOpaque(false);
        }

        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    }
}

