/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import util.DataModel;
import util.DataModelEvent;
import util.TableCellIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewModel
extends AbstractTableModel
implements Observer {
    private DataModel dataModel;
    private int startingDataModelRowIndex;
    private int length;
    private List<Integer> labelColumns;
    private List<Integer> dataColumns;
    private int dataModelRowsPerTableRow;
    private List<String> columnNames;
    private List<Listener> listeners = new Vector<Listener>();

    ViewModel(DataModel aDataModel, int aStartingDataModelRowIndex, int aLength, int aDataModelRowsPerTableRow, List<Integer> aLabelColumns, List<Integer> aDataColumns, List<String> aColumnNames) {
        this.dataModel = aDataModel;
        this.startingDataModelRowIndex = aStartingDataModelRowIndex;
        this.length = aLength;
        this.labelColumns = aLabelColumns != null ? aLabelColumns : new Vector();
        this.dataColumns = aDataColumns != null ? aDataColumns : new Vector();
        this.dataModelRowsPerTableRow = aDataModelRowsPerTableRow;
        this.columnNames = aColumnNames;
        this.dataModel.addObserver(this);
    }

    public int getStartingDataModelRowIndex() {
        return this.startingDataModelRowIndex;
    }

    public int getDataModelLength() {
        return this.length * this.dataModelRowsPerTableRow;
    }

    public void setLength(int len) {
        int oldLength = this.length;
        this.length = len;
        if (this.length > oldLength) {
            this.fireTableRowsInserted(oldLength, this.length - 1);
        } else if (this.length < oldLength) {
            this.fireTableRowsDeleted(this.length, oldLength - 1);
        }
    }

    public int length() {
        return this.length;
    }

    public boolean isLabelColumn(int col) {
        return col < this.labelColumns.size();
    }

    public boolean insertRow(int row) {
        assert (row >= 0 && row <= this.length * this.dataModelRowsPerTableRow);
        boolean inserted = false;
        for (int i = 0; i < this.dataModelRowsPerTableRow; ++i) {
            boolean ins = this.dataModel.insertRow(this.dataModelIndexFromTableIndex((int)row, (int)0).rowIndex + i);
            assert (!inserted || ins);
            inserted = ins;
        }
        return inserted;
    }

    public boolean deleteRow(int row) {
        assert (row >= 0 && row < this.length * this.dataModelRowsPerTableRow);
        boolean deleted = false;
        for (int i = 0; i < this.dataModelRowsPerTableRow; ++i) {
            boolean del = this.dataModel.deleteRow(this.dataModelIndexFromTableIndex((int)row, (int)0).rowIndex + i);
            assert (!deleted || del);
            deleted = del;
        }
        return deleted;
    }

    public TableCellIndex prevDataCell(TableCellIndex cell) {
        int rowIndex = cell.rowIndex;
        int colIndex = cell.columnIndex - 1;
        if (colIndex == this.labelColumns.size() - 1) {
            --rowIndex;
            colIndex = this.labelColumns.size() + this.dataColumns.size() * this.dataModelRowsPerTableRow - 1;
        }
        return rowIndex == -1 ? null : new TableCellIndex(rowIndex, colIndex);
    }

    public TableCellIndex nextDataCell(TableCellIndex cell) {
        int rowIndex = cell.rowIndex;
        int colIndex = cell.columnIndex + 1;
        if (colIndex == this.labelColumns.size() + this.dataColumns.size() * this.dataModelRowsPerTableRow) {
            ++rowIndex;
            colIndex = this.labelColumns.size();
        }
        return rowIndex >= this.length ? null : new TableCellIndex(rowIndex, colIndex);
    }

    private TableCellIndex tableIndexFromDataModelIndex(int modelRow, int modelCol) {
        int tableCol;
        int normalizedRow = modelRow - this.startingDataModelRowIndex;
        int tableRow = normalizedRow / this.dataModelRowsPerTableRow;
        if (this.labelColumns.contains(modelCol)) {
            tableCol = this.labelColumns.indexOf(modelCol);
        } else {
            assert (this.dataColumns.contains(modelCol));
            tableCol = this.labelColumns.size() + this.dataColumns.indexOf(modelCol) + normalizedRow % this.dataModelRowsPerTableRow * this.dataColumns.size();
        }
        return new TableCellIndex(tableRow, tableCol);
    }

    private TableCellIndex dataModelIndexFromTableIndex(int tableRow, int tableCol) {
        int modelCol;
        int modelRow = tableRow * this.dataModelRowsPerTableRow + this.startingDataModelRowIndex;
        if (tableCol < this.labelColumns.size()) {
            modelCol = this.labelColumns.get(tableCol);
        } else {
            int normalizedCol = tableCol - this.labelColumns.size();
            modelRow += normalizedCol / this.dataColumns.size();
            modelCol = this.dataColumns.get(normalizedCol % this.dataColumns.size());
        }
        return new TableCellIndex(modelRow, modelCol);
    }

    @Override
    public void update(Observable o, Object arg) {
        DataModelEvent event = (DataModelEvent)arg;
        if (event.getType() == DataModelEvent.Type.CHANGING) {
            Vector<TableCellIndex> tableCells = new Vector<TableCellIndex>();
            for (TableCellIndex modelCell : event.getCells()) {
                if (!this.dataColumns.contains(modelCell.columnIndex)) continue;
                tableCells.add(this.tableIndexFromDataModelIndex(modelCell.rowIndex, modelCell.columnIndex));
            }
            this.fireChangingModel(true, tableCells);
        } else if (event.getType() == DataModelEvent.Type.ROWS_INSERTED) {
            this.length += event.getCells().get((int)0).columnIndex - event.getCells().get((int)0).rowIndex + 1;
            this.fireTableRowsInserted(event.getCells().get((int)0).rowIndex, event.getCells().get((int)0).columnIndex);
        } else if (event.getType() == DataModelEvent.Type.ROWS_DELETED) {
            this.length -= event.getCells().get((int)0).columnIndex - event.getCells().get((int)0).rowIndex + 1;
            this.fireTableRowsDeleted(event.getCells().get((int)0).rowIndex, event.getCells().get((int)0).columnIndex);
        } else {
            Vector<TableCellIndex> tableCells = new Vector<TableCellIndex>();
            for (TableCellIndex modelCell : event.getCells()) {
                if (modelCell.rowIndex < this.startingDataModelRowIndex || modelCell.rowIndex >= this.startingDataModelRowIndex + this.length * this.dataModelRowsPerTableRow || !this.labelColumns.contains(modelCell.columnIndex) && !this.dataColumns.contains(modelCell.columnIndex)) continue;
                tableCells.add(this.tableIndexFromDataModelIndex(modelCell.rowIndex, modelCell.columnIndex));
            }
            event = new DataModelEvent(event.getType(), tableCells);
            this.fireModelTouched(event);
            if (event.getType() == DataModelEvent.Type.WRITE || event.getType() == DataModelEvent.Type.WRITE_BY_USER || !this.listeners.isEmpty()) {
                for (TableCellIndex tableCell : tableCells) {
                    assert (tableCell.rowIndex >= 0 && tableCell.rowIndex < this.length);
                    assert (tableCell.columnIndex >= 0 && tableCell.columnIndex < this.getColumnCount());
                    this.fireTableCellUpdated(tableCell.rowIndex, tableCell.columnIndex);
                }
            }
        }
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.columnNames != null && this.columnNames.get(columnIndex) != null) {
            return this.columnNames.get(columnIndex);
        }
        return this.dataModel.getColumnName(this.dataModelIndexFromTableIndex((int)0, (int)columnIndex).columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.dataModel.getColumnClass(this.dataModelIndexFromTableIndex((int)0, (int)columnIndex).columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.length;
    }

    @Override
    public int getColumnCount() {
        return this.labelColumns.size() + this.dataColumns.size() * this.dataModelRowsPerTableRow;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableCellIndex dataModelCell = this.dataModelIndexFromTableIndex(rowIndex, columnIndex);
        if (dataModelCell.rowIndex < this.dataModel.getRowCount()) {
            return this.dataModel.getValueAt(dataModelCell.rowIndex, dataModelCell.columnIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        TableCellIndex dataModelCell = this.dataModelIndexFromTableIndex(rowIndex, columnIndex);
        if (dataModelCell.rowIndex < this.dataModel.getRowCount()) {
            return this.dataModel.isCellEditable(dataModelCell.rowIndex, dataModelCell.columnIndex);
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        TableCellIndex dataModelCell = this.dataModelIndexFromTableIndex(rowIndex, columnIndex);
        this.fireChangingModel(false, Arrays.asList(new TableCellIndex(rowIndex, columnIndex)));
        this.dataModel.setValueAtByUser(value, dataModelCell.rowIndex, dataModelCell.columnIndex);
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void fireModelTouched(DataModelEvent event) {
        for (Listener l : this.listeners) {
            l.modelTouched(event);
        }
    }

    public void fireChangingModel(boolean cancelEditing, List<TableCellIndex> cells) {
        for (Listener l : this.listeners) {
            l.changingModel(cancelEditing, cells);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Listener {
        public void changingModel(boolean var1, List<TableCellIndex> var2);

        public void modelTouched(DataModelEvent var1);
    }
}

