/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.metal.MetalLabelUI;
import ui.gui.ViewFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewLabel
extends ViewFormat {
    private final boolean isWidthVariable;
    private final JLabel prototype = new JLabel();
    private final int baseWidth;
    private final int baseCharWidth;

    ViewLabel(int width, int horizontalAlignment, Font font, Color color, ViewFormat.HighlightControl highlightControl, List<ViewFormat.Format> formats) {
        super(formats);
        this.isWidthVariable = width < 0;
        this.baseWidth = width = Math.abs(width);
        this.baseCharWidth = this.prototype.getFontMetrics(font).charWidth('W');
        Dimension sz = new Dimension(width, this.prototype.getPreferredSize().height);
        this.prototype.setMinimumSize(sz);
        this.prototype.setPreferredSize(sz);
        this.prototype.setMaximumSize(sz);
        this.prototype.setHorizontalAlignment(horizontalAlignment);
        if (font != null) {
            this.prototype.setFont(font);
        }
        if (color != null) {
            this.prototype.setForeground(color);
        }
        this.setHighlightControl(highlightControl, this.prototype);
        if (font.getFamily().equals("Consolas") && this.prototype.getUI() instanceof MetalLabelUI) {
            this.prototype.setUI(new MetalLabelUI(){

                protected void paintEnabledText(JLabel l, Graphics g, String s, int x, int y) {
                    super.paintEnabledText(l, g, s, x, y + 1);
                }
            });
        }
    }

    ViewLabel(int width, int horizontalAlignment, Font font, Color color, ViewFormat.HighlightControl highlightControl, ViewFormat.Format format) {
        this(width, horizontalAlignment, font, color, highlightControl, Arrays.asList(format));
    }

    @Override
    JComponent getRendererPrototype() {
        return this.prototype;
    }

    @Override
    void setRendererPrototypeValue(Object value, boolean isSelected) {
        this.prototype.setText(this.valueToText(value, isSelected));
    }

    @Override
    void adjustFontSize(int increment) {
        Font oldFont = this.prototype.getFont();
        Font newFont = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() + increment);
        this.prototype.setFont(newFont);
        int width = (this.baseWidth * this.prototype.getFontMetrics(newFont).charWidth('W') + this.baseCharWidth / 2 + 1) / this.baseCharWidth;
        Dimension sz = new Dimension(width, this.prototype.getPreferredSize().height);
        this.prototype.setMinimumSize(sz);
        this.prototype.setPreferredSize(sz);
        this.prototype.setMaximumSize(sz);
    }

    @Override
    void setWidth(int width) {
        Dimension sz = new Dimension(width, this.prototype.getPreferredSize().height);
        this.prototype.setMinimumSize(sz);
        this.prototype.setPreferredSize(sz);
        this.prototype.setMaximumSize(sz);
    }

    @Override
    boolean isWidthVariable() {
        return this.isWidthVariable;
    }
}

