/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.awt.Color;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import util.DataModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ViewFormat {
    private HighlightControl highlightControl = null;
    private List<Format> formats;

    ViewFormat(List<Format> aFormats) {
        this.formats = aFormats;
    }

    protected void setHighlightControl(HighlightControl aHighlightControl, JComponent referenceComponent) {
        this.highlightControl = aHighlightControl;
        if (this.highlightControl != null) {
            this.highlightControl.setReferenceComponent(referenceComponent);
        }
    }

    protected String valueToText(Object value, boolean isSelected) {
        if (value != null) {
            for (Format f : this.formats) {
                if (!f.matches(value)) continue;
                return f.valueToText(value, isSelected);
            }
            try {
                if (isSelected) {
                    try {
                        value = value.getClass().getDeclaredMethod("toSelectedString", new Class[0]).invoke(value, new Object[0]);
                    }
                    catch (Exception e) {
                        isSelected = false;
                    }
                }
                if (!isSelected) {
                    value = value.getClass().getDeclaredMethod("toString", new Class[0]).invoke(value, new Object[0]);
                }
                for (Format f : this.formats) {
                    if (!f.matches(value)) continue;
                    return f.valueToText(value, isSelected);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClassCastException(value.getClass().getName());
        }
        return "";
    }

    protected Object textToValue(String text, Object value) {
        try {
            return this.formats.get(0).textToValue(text, value);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected String checkValidity(String text, Object value) {
        return this.formats.get(0).checkValidity(text, value);
    }

    int getWidth() {
        return this.getRendererPrototype().getMinimumSize().width;
    }

    boolean isWidthVariable() {
        return false;
    }

    void clearRendererPrototypeHighlight() {
        if (this.highlightControl != null) {
            this.highlightControl.clear(this.getRendererPrototype());
        }
    }

    void setRendererPrototypeHighlight(HighlightCell highlightCell) {
        if (this.highlightControl != null) {
            this.highlightControl.set(highlightCell, this.getRendererPrototype());
        }
    }

    void clearEditorPrototypeHighlight() {
        if (this.highlightControl != null) {
            this.highlightControl.clear(this.getEditorPrototype());
        }
    }

    void setEditorPrototypeHighlight(HighlightCell highlightCell) {
        if (this.highlightControl != null) {
            this.highlightControl.set(highlightCell, this.getEditorPrototype());
        }
    }

    void adjustFontSize(int increment) {
    }

    void setWidth(int width) {
    }

    boolean isEditable() {
        return false;
    }

    JComponent getEditorPrototype() {
        throw new AssertionError((Object)"Format is not editable.");
    }

    void setEditorPrototypeValue(Object value) {
        throw new AssertionError((Object)"Format is not editable.");
    }

    Object getEditorPrototypeValue() {
        throw new AssertionError((Object)"Format is not editable.");
    }

    String checkRendererPrototypeValidity() {
        return null;
    }

    void setRendererPrototypeError(boolean isError) {
    }

    String checkEditorPrototypeValidity() {
        throw new AssertionError((Object)"Format is not editable.");
    }

    void setEditorPrototypeError(boolean isError) {
        throw new AssertionError((Object)"Format is not editable.");
    }

    abstract void setRendererPrototypeValue(Object var1, boolean var2);

    abstract JComponent getRendererPrototype();

    static class BorderHighlight
    implements Highlight {
        final int width = 2;
        private Border clearBorder;
        private Color color;
        private Color background;
        private Color clearBackground;

        BorderHighlight(Color aColor) {
            this.color = aColor;
            this.background = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 60);
            this.clearBorder = null;
            this.clearBackground = null;
        }

        public void setReferenceComponent(JComponent component) {
            this.clearBorder = component.getBorder();
            this.clearBackground = component.getBackground();
        }

        public void clear(JComponent component) {
            component.setBorder(this.clearBorder);
            component.setBackground(this.clearBackground);
        }

        public void set(boolean isStart, boolean isEnd, double fadeFactor, JComponent component) {
            int l = isStart ? 2 : 0;
            int r = isEnd ? 2 : 0;
            Color bg = new Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue(), (int)((double)this.background.getAlpha() * fadeFactor));
            Color bd = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)((double)this.color.getAlpha() * fadeFactor));
            Color ln = new Color((int)(200.0 * (1.0 - fadeFactor) + (double)this.background.getRed() * fadeFactor), (int)(200.0 * (1.0 - fadeFactor) + (double)this.background.getGreen() * fadeFactor), (int)(200.0 * (1.0 - fadeFactor) + (double)this.background.getBlue() * fadeFactor));
            component.setBackground(bg);
            Insets insets = component.getBorder().getBorderInsets(component);
            component.setBorder(new CompoundBorder(new CompoundBorder(new MatteBorder(1, l > 0 ? 1 : 0, 1, r > 0 ? 1 : 0, ln), new MatteBorder(1, l > 0 ? l - 1 : 0, 1, r > 0 ? r - 1 : 0, bd)), new EmptyBorder(insets.top - 2, 3 - l, insets.bottom - 2, 3 - r)));
        }
    }

    static interface Highlight {
        public void setReferenceComponent(JComponent var1);

        public void clear(JComponent var1);

        public void set(boolean var1, boolean var2, double var3, JComponent var5);
    }

    static class HighlightCell {
        static final int FADE_STEPS = 5;
        DataModelEvent.Type type;
        boolean isStart;
        boolean isEnd;
        double fadeFactor = 1.0;

        HighlightCell(DataModelEvent.Type aType, boolean anIsStart, boolean anIsEnd) {
            this.type = aType;
            this.isStart = anIsStart;
            this.isEnd = anIsEnd;
        }

        boolean fade() {
            if (this.type != DataModelEvent.Type.CURSOR_SET && this.type != DataModelEvent.Type.CURSOR_CLEAR) {
                this.fadeFactor -= 0.2 * (this.fadeFactor == 1.0 ? 3.1 : 1.0);
                return this.fadeFactor <= 0.0;
            }
            return false;
        }
    }

    static class HighlightControl {
        Map<DataModelEvent.Type, Highlight> highlights = new EnumMap<DataModelEvent.Type, Highlight>(DataModelEvent.Type.class);

        HighlightControl(Highlight aRead, Highlight aWrite, Highlight aCursorSet, Highlight aCursorClear) {
            this.highlights.put(DataModelEvent.Type.READ, aRead);
            this.highlights.put(DataModelEvent.Type.WRITE, aWrite);
            this.highlights.put(DataModelEvent.Type.CURSOR_SET, aCursorSet);
            this.highlights.put(DataModelEvent.Type.CURSOR_CLEAR, aCursorClear);
        }

        static boolean isHighlightType(DataModelEvent.Type type) {
            return type == DataModelEvent.Type.READ || type == DataModelEvent.Type.WRITE || type == DataModelEvent.Type.CURSOR_SET || type == DataModelEvent.Type.CURSOR_CLEAR;
        }

        void setReferenceComponent(JComponent component) {
            for (DataModelEvent.Type type : DataModelEvent.Type.values()) {
                Highlight highlight = this.highlights.get((Object)type);
                if (highlight == null) continue;
                highlight.setReferenceComponent(component);
            }
        }

        void clear(JComponent component) {
            Highlight highlight = this.highlights.get((Object)DataModelEvent.Type.READ);
            if (highlight != null) {
                highlight.clear(component);
            }
        }

        void set(HighlightCell cell, JComponent component) {
            Highlight highlight = this.highlights.get((Object)cell.type);
            if (highlight != null) {
                highlight.set(cell.isStart, cell.isEnd, cell.fadeFactor, component);
            }
        }
    }

    static class TwoIntegerFormat
    extends NumberFormat {
        TwoIntegerFormat(Class aClass, String aFormat, int aRadix) {
            super(aClass, aFormat, aRadix);
        }

        String valueToText(Object value, boolean isSelected) {
            try {
                long number = ((Number)value).longValue();
                return String.format(this.formatString, number >>> 32, number << 32 >>> 32);
            }
            catch (Exception e) {
                throw new FormatException("Invalid format.");
            }
        }
    }

    static class NumberFormat
    extends Format {
        protected int formatRadix;

        NumberFormat(Class aClass, String aFormat, int aRadix) {
            super(aClass, aFormat);
            this.formatRadix = aRadix;
        }

        String valueToText(Object value, boolean isSelected) {
            try {
                value = value.getClass().getDeclaredMethod("toNumber", new Class[0]).invoke(value, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.format(this.formatString, value);
        }

        /*
         * Loose catch block
         */
        Object textToValue(String text, Object value) {
            Class<?> valueClass;
            block9: {
                valueClass = value.getClass();
                if (this.formatRadix == 10) break block9;
                long num = Long.valueOf(text, this.formatRadix);
                if (num > valueClass.getField("MAX_VALUE").getLong(null)) {
                    num -= valueClass.getField("MAX_VALUE").getLong(null) * 2L + 2L;
                }
                if (valueClass == Byte.class) {
                    return new Byte((byte)num);
                }
                if (valueClass == Short.class) {
                    return new Short((short)num);
                }
                if (valueClass == Integer.class) {
                    return new Integer((int)num);
                }
                return new Long(num);
                {
                    catch (Exception e) {
                        throw new FormatException("Invalid format.");
                    }
                }
            }
            try {
                value.getClass().getDeclaredMethod("setValue", String.class, Integer.TYPE).invoke(value, text, this.formatRadix);
                return value;
            }
            catch (Exception e) {
                return valueClass.getDeclaredMethod("valueOf", String.class, Integer.TYPE).invoke(null, text, this.formatRadix);
            }
        }
    }

    static class Format {
        protected Class formatClass;
        protected String formatString;

        Format(Class aClass, String aFormat) {
            this.formatClass = aClass;
            this.formatString = aFormat;
        }

        boolean matches(Object value) {
            return this.formatClass.isInstance(value);
        }

        String valueToText(Object value, boolean isSelected) {
            return String.format(this.formatString, value);
        }

        Object textToValue(String text, Object value) throws Throwable {
            if (value.getClass() == String.class) {
                return text;
            }
            try {
                value.getClass().getDeclaredMethod("setValue", String.class).invoke(value, text);
                return value;
            }
            catch (InvocationTargetException it) {
                throw (RuntimeException)it.getTargetException();
            }
            catch (Exception e) {
                try {
                    return value.getClass().getDeclaredMethod("toValue", String.class).invoke(null, text);
                }
                catch (InvocationTargetException it) {
                    throw (RuntimeException)it.getTargetException();
                }
                catch (Exception ee) {
                    throw new FormatException("Invalid format.");
                }
            }
        }

        String checkValidity(String text, Object value) {
            try {
                this.textToValue(text, value);
                return null;
            }
            catch (Throwable e) {
                return e.toString();
            }
        }
    }

    public static class FormatException
    extends RuntimeException {
        FormatException(String msg) {
            super(msg);
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

