/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.metal.MetalCheckBoxIcon;
import ui.gui.UI;
import ui.gui.ViewFormat;

class ViewCheckBox
extends ViewFormat {
    private JCheckBox rendererPrototype;
    private JCheckBox editorPrototype;
    private Color checkColor;

    ViewCheckBox(Color aCheckColor) {
        super(null);
        this.checkColor = aCheckColor;
        this.rendererPrototype = new JCheckBox(new CheckBoxIcon());
        this.rendererPrototype.setBackground(UI.BACKGROUND_COLOR);
        this.editorPrototype = new JCheckBox(new CheckBoxIcon());
    }

    int getWidth() {
        return Math.max(super.getWidth(), this.getEditorPrototype().getPreferredSize().width + 2);
    }

    boolean isEditable() {
        return true;
    }

    JComponent getRendererPrototype() {
        return this.rendererPrototype;
    }

    JComponent getEditorPrototype() {
        return this.editorPrototype;
    }

    void setRendererPrototypeValue(Object value, boolean isSelected) {
        this.rendererPrototype.setSelected((Boolean)value);
    }

    void setEditorPrototypeValue(Object value) {
        this.editorPrototype.setSelected((Boolean)value);
    }

    Object getEditorPrototypeValue() {
        return this.editorPrototype.isSelected();
    }

    String checkEditorPrototypeValidity() {
        return null;
    }

    void setEditorPrototypeError(boolean isError) {
    }

    class CheckBoxIcon
    extends MetalCheckBoxIcon {
        CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 9;
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.setColor(ViewCheckBox.this.checkColor);
            g.fillRect(x + 1, y + 1, controlSize - 2, controlSize - 2);
        }
    }
}

