/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import util.AbstractDataModel;
import util.DataModel;
import util.DataModelEvent;
import util.MapModel;
import util.TableCellIndex;

class ValueView
extends AbstractDataModel
implements Observer {
    DataModel baseModel;
    int baseColumnIndex;
    MapModel mapModel;
    String stringName;
    Vector<Object> lastRequestedValue;

    ValueView(DataModel aBaseModel, int aBaseColumnIndex, MapModel aMapModel, String aStringName) {
        this.baseModel = aBaseModel;
        this.baseColumnIndex = aBaseColumnIndex;
        this.mapModel = aMapModel;
        this.stringName = aStringName;
        this.lastRequestedValue = new Vector();
        this.lastRequestedValue.setSize(this.getRowCount());
        this.baseModel.addObserver(this);
        this.mapModel.addObserver(this);
    }

    public void update(Observable o, Object arg) {
        if (o == this.baseModel) {
            DataModelEvent event = (DataModelEvent)arg;
            this.tellObservers(new DataModelEvent(event.getType(), Arrays.asList(new TableCellIndex(event.getRowIndex(), 0), new TableCellIndex(event.getRowIndex(), 1))));
        } else if (o == this.mapModel) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object key = this.baseModel.getValueAt(row, this.baseColumnIndex);
                Object value = this.mapModel.get(key);
                Object lastValue = this.lastRequestedValue.get(row);
                if ((lastValue != null && value != null || lastValue == value) && (value == null || lastValue == null || value.equals(lastValue))) continue;
                this.lastRequestedValue.set(row, value);
                this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, row, 1));
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        throw new AssertionError();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "As Int";
        }
        if (columnIndex == 1) {
            return "As ".concat(this.stringName);
        }
        throw new AssertionError();
    }

    public int getRowCount() {
        return this.baseModel.getRowCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return new Value((Integer)this.baseModel.getValueAt(rowIndex, this.baseColumnIndex));
        }
        if (columnIndex == 1) {
            Object value = this.mapModel.get(this.baseModel.getValueAt(rowIndex, this.baseColumnIndex));
            return value != null ? value : "";
        }
        throw new AssertionError();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        assert (columnIndex == 0);
        this.baseModel.setValueAtByUser(((Value)aValue).toNumber(), rowIndex, this.baseColumnIndex);
    }

    public class Value {
        Integer value;

        Value(Integer aValue) {
            this.value = aValue;
        }

        public String toString() {
            return this.value.toString();
        }

        public Integer toNumber() {
            return this.value;
        }

        public void setValue(String text) {
            this.setValue(text, 10);
        }

        public void setValue(String text, int radix) {
            if (text.matches("\\s*-?[0-9]+\\s*")) {
                this.value = Integer.valueOf(text, radix);
            } else if (text.matches("\\s*-?0x[0-9,a-f,A-F]+\\s*")) {
                this.value = Integer.valueOf(text.split("0x", 2)[1], 16);
            } else {
                Integer v = (Integer)ValueView.this.mapModel.reverseGet(text);
                if (v != null) {
                    this.value = v;
                } else {
                    throw new NumberFormatException();
                }
            }
        }
    }
}

