/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import isa.DataRegion;
import isa.InstructionModel;
import isa.InstructionRegion;
import isa.Memory;
import isa.Region;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import machine.Register;
import machine.RegisterSet;
import ui.AbstractUI;
import ui.Machine;
import ui.gui.Animator;
import ui.gui.MessageBoard;
import ui.gui.OSXAdapter;
import ui.gui.ValueView;
import ui.gui.View;
import ui.gui.ViewCheckBox;
import ui.gui.ViewFormat;
import ui.gui.ViewLabel;
import ui.gui.ViewModel;
import ui.gui.ViewPane;
import ui.gui.ViewTextField;
import util.AbstractDataModel;
import util.CompoundModel;
import util.DataModel;
import util.DataModelEvent;
import util.HalfByteNumber;
import util.PickModel;
import util.SixByteNumber;
import util.TableCellIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UI
extends AbstractUI {
    private static final Color READ_HL = new Color(120, 120, 240);
    private static final Color WRITE_HL = new Color(240, 120, 120);
    private static final Color CURSOR_HL = new Color(100, 240, 100);
    private final ViewFormat.HighlightControl MEMORY_HIGHLIGHT = new ViewFormat.HighlightControl(new ViewFormat.BorderHighlight(READ_HL), new ViewFormat.BorderHighlight(WRITE_HL), new ViewFormat.BorderHighlight(CURSOR_HL), null);
    private final ViewFormat.HighlightControl CODE_HIGHLIGHT = new ViewFormat.HighlightControl(new ViewFormat.BorderHighlight(READ_HL), new ViewFormat.BorderHighlight(WRITE_HL), new ViewFormat.BorderHighlight(CURSOR_HL), null);
    private final String monoSpaceFont = UI.pickMonoSpaceFont();
    private final Font addressFont = new Font(this.monoSpaceFont, 0, 10);
    private final Font cellFont = new Font(this.monoSpaceFont, 0, 10);
    private final Font memAddressFont = new Font(this.monoSpaceFont, 0, 9);
    private final Font memCellFont = new Font(this.monoSpaceFont, 0, 9);
    private final Font macFont = new Font(this.monoSpaceFont, 0, 8);
    private final Font labelFont = new Font(this.monoSpaceFont, 0, 10);
    private final Font animationFont = new Font(this.monoSpaceFont, 1, 12);
    private final Font titleFont = new Font("Default", 1, 14);
    private final Font subTitleFont = new Font("Default", 1, 12);
    private final Font aboutFont = new Font("Default", 0, 10);
    private final Font nameFont = new Font("Default", 0, 10);
    private final Font commentFont = new Font("Arial", 0, 10);
    private final Font statusMessageFont = new Font("Default", 0, 11);
    private final Font curInsFont = new Font("Default", 0, 20);
    private final Font curInsDscFont = new Font("Default", 0, 11);
    private final Font curInsTwoColFont = new Font("Default", 0, 13);
    private final Font curInsDscTwoColFont = new Font("Default", 0, 9);
    private final Color strutColor = new Color(200, 200, 200);
    private final Color toolBarColor = new Color(180, 180, 180);
    private final Color toolBarBorder = new Color(64, 64, 64);
    private final Color statusBarBorder = new Color(128, 128, 128);
    private final Color macColor = new Color(100, 100, 100);
    private final Color labelColor = new Color(130, 0, 130);
    private final Color codeColor = new Color(0, 0, 180);
    private final Color commentColor = new Color(0, 100, 0);
    private final Color addressColor = new Color(50, 50, 50);
    private final Color nameColor = new Color(50, 50, 50);
    private final Color breakpointColor = new Color(240, 0, 0);
    private final int PAUSE_MS = 1400;
    private final int PAUSE_MIN_MS = 200;
    private final int PAUSE_MAX_MS = 5000;
    private final int PAUSE_INC_MS = 200;
    public static final boolean IS_MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    public static final boolean IS_MS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private final int platformAgnosticMetaMask;
    private static final String ICON_RESOURCE_NAME = "/images/icon.png";
    static final Font TITLE_FONT = new Font("Default", 1, 12);
    static final Color BACKGROUND_COLOR = new Color(250, 250, 250);
    static final Color CELL_BORDER_COLOR = new Color(200, 200, 200);
    static final Color PANE_BORDER_COLOR = new Color(160, 160, 160);
    static final Color SELECTION_COLOR = new Color(255, 210, 0);
    static final Color ERROR_BORDER_COLOR = new Color(255, 0, 0);
    protected boolean isMacShown;
    protected boolean isTwoProcStateCols;
    protected boolean isSmallInsMemDpy;
    protected boolean isRegFileInOwnCol;
    protected boolean isSmallCurInsDpy;
    protected boolean isDataAddrShown;
    protected boolean isAnimationAvailable;
    protected Application application;

    private static String pickMonoSpaceFont() {
        String[] fontsToTry;
        for (String fontFamily : fontsToTry = new String[]{"Menlo", "Consolas", "Monaco", "Courier New"}) {
            if (!new Font(fontFamily, 0, 10).getFamily().equals(fontFamily)) continue;
            return fontFamily;
        }
        return "";
    }

    public UI(ArrayList<String> args) throws AbstractUI.ArgException {
        super(args);
        int n = this.platformAgnosticMetaMask = IS_MAC_OS_X ? 4 : 2;
        if (args.size() != 0) {
            throw new AbstractUI.ArgException("Invalid command-line syntax.\n");
        }
        this.isMacShown = this.machine.options.contains("[showMac]");
        this.isTwoProcStateCols = this.machine.options.contains("[twoProcStateCols]");
        this.isSmallInsMemDpy = this.machine.options.contains("[smallInsMemDpy]");
        this.isRegFileInOwnCol = this.machine.options.contains("[regFileInOwnCol]");
        this.isSmallCurInsDpy = this.machine.options.contains("[smallCurInsDpy]");
        this.isDataAddrShown = this.machine.options.contains("[showDataAddr]");
        this.isAnimationAvailable = this.machine.options.contains("[animation]");
    }

    @Override
    public void run() {
        this.application = new Application();
    }

    static {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    class Application
    extends JFrame
    implements Observer {
        AboutBox aboutBox;
        ImageIcon icon;
        MainPane mainPane;
        StatusBar statusBar;
        Vector<IsRunningListener> isRunningListeners;
        MasterSelectionListner masterSelectionListener;
        ApplicationUndoManager undoManager;
        boolean isRunning;
        int screenWidth;
        int screenHeight;
        Animator animator;
        private final RunSlowerAction runSlower;
        private final RunFasterAction runFaster;
        private final AnimationOnAction animationOn;
        private final AnimationPauseAction animationPause;
        private final RunAction run;

        Application() {
            super(UI.this.applicationFullName);
            this.icon = null;
            this.isRunningListeners = new Vector();
            this.masterSelectionListener = new MasterSelectionListner();
            this.undoManager = new ApplicationUndoManager();
            this.isRunning = false;
            this.screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
            this.screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
            this.animator = null;
            this.runSlower = new RunSlowerAction();
            this.runFaster = new RunFasterAction();
            this.animationOn = new AnimationOnAction();
            this.animationPause = new AnimationPauseAction();
            this.run = new RunAction();
            this.animationOn.addPropertyChangeListener(this.animationPause);
            this.animationOn.addPropertyChangeListener(this.runSlower);
            this.animationOn.addPropertyChangeListener(this.runFaster);
            this.run.addPropertyChangeListener(this.animationPause);
            this.setTransferHandler(new TransferHandler(){

                public boolean canImport(TransferHandler.TransferSupport support) {
                    return true;
                }

                public boolean importData(TransferHandler.TransferSupport support) {
                    Transferable tf = support.getTransferable();
                    for (DataFlavor df : tf.getTransferDataFlavors()) {
                        try {
                            Object data = tf.getTransferData(df);
                            if (!(data instanceof String)) continue;
                            if (Application.this.isRunning || !Application.this.quit()) break;
                            Application.this.loadFile(URLDecoder.decode(new URL((String)data).getFile(), "UTF-8"));
                            break;
                        }
                        catch (UnsupportedFlavorException e) {
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return true;
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent e) {
                    Application.this.setMaximizedBounds();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent ce) {
                    Application.this.setSize(Math.max(Application.this.getMinimumSize().width, Application.this.getWidth()), Math.max(Application.this.getMinimumSize().height, Application.this.getHeight()));
                }
            });
            URL iconURL = this.getClass().getResource(UI.ICON_RESOURCE_NAME);
            if (iconURL != null) {
                this.icon = new ImageIcon(iconURL);
                this.setIconImage(this.icon.getImage());
            }
            UI.this.machine.addObserver(this);
            ((UI)UI.this).machine.memory.addUndoableEditListener(this.undoManager);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (Application.this.quit()) {
                        System.exit(0);
                    }
                }
            });
            this.setJMenuBar(new MenuBar());
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            this.statusBar = new StatusBar();
            this.mainPane = new MainPane();
            cp.add((Component)new ToolBar(), "North");
            cp.add((Component)this.mainPane, "Center");
            cp.add((Component)this.statusBar, "South");
            this.doPlatformSpecificInitialization();
            this.aboutBox = new AboutBox();
            this.pack();
            this.setVisible(true);
        }

        void adjustHighlights(boolean clear) {
            this.mainPane.adjustHighlights(clear);
        }

        void setRunning(boolean anIsRunning) {
            this.isRunning = anIsRunning;
            this.fireIsRunningChanged();
        }

        void doPlatformSpecificInitialization() {
            if (IS_MAC_OS_X) {
                try {
                    OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAbout", null));
                    OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quit", null));
                    if (this.icon != null) {
                        Class<?> appClass = Class.forName("com.apple.eawt.Application");
                        Method getApplication = appClass.getDeclaredMethod("getApplication", new Class[0]);
                        Method setDockIconImage = appClass.getDeclaredMethod("setDockIconImage", Image.class);
                        Object app = getApplication.invoke(null, new Object[0]);
                        setDockIconImage.invoke(app, this.icon.getImage());
                    }
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        boolean quit() {
            if (((UI)UI.this).machine.memory.hasUnsavedChanges()) {
                int option = JOptionPane.showOptionDialog(this, "You have unsaved changes.  Do you really want to quit and lose them?", "Quit with UnsavedChanges", -1, 2, null, new String[]{"Discard Changes", "Cancel"}, "Cancel");
                return option == 0;
            }
            return true;
        }

        void showAbout() {
            this.aboutBox.setLocation((int)this.getLocation().getX() + 22, (int)this.getLocation().getY() + 22);
            this.aboutBox.setVisible(true);
        }

        void loadFile(String fileName) {
            try {
                this.animator = new Animator(this, ((UI)UI.this).machine.memory, this.mainPane.cpuPane.processorStatePane, 1400, UI.this.animationFont, this.mainPane.cpuPane.registerViewPane, this.mainPane.allMemoryPane.instructionMemoryPane, this.statusBar, this.mainPane.cpuPane.processorStatePane);
                ((UI)UI.this).machine.memory.loadFile(fileName);
                this.updateMemoryView();
                this.statusBar.showMessage("File loaded into memory.");
            }
            catch (Memory.FileTypeException fte) {
                this.statusBar.showMessage("Unable to load file; invalid file type.");
            }
            catch (Memory.InputFileSyntaxException ifse) {
                this.statusBar.showMessage(ifse.toString());
            }
            catch (Exception ex) {
                throw new AssertionError((Object)ex);
            }
        }

        void setMaximizedBounds() {
            this.setMaximizedBounds(new Rectangle(this.getX(), this.getY(), Math.min(this.getMaximizedWidth(), this.screenWidth), Math.min(this.getMaximizedHeight(), this.screenHeight)));
        }

        int getMaximizedWidth() {
            return this.mainPane.getMaximizedWidth();
        }

        int getMaximizedHeight() {
            int oh = this.getPreferredSize().height - this.mainPane.getPreferredSize().height;
            return this.mainPane.getMaximizedHeight() + oh;
        }

        void fireIsRunningChanged() {
            for (IsRunningListener l : this.isRunningListeners) {
                l.isRunningChanged();
            }
        }

        ViewPane getSelectedPane() {
            return this.mainPane.allMemoryPane.getSelectedPane();
        }

        boolean stopEditing() {
            ViewPane sp = this.getSelectedPane();
            if (sp != null && sp.view.getCellEditor() != null) {
                return sp.view.getCellEditor().stopCellEditing();
            }
            return true;
        }

        void updateMemoryView() {
            if (((UI)UI.this).machine.memory.hasLoadedFile()) {
                this.setTitle(UI.this.applicationFullName.concat(" - ").concat(((UI)UI.this).machine.memory.getLoadedFilename()));
                this.getRootPane().putClientProperty("Window.documentFile", new File(((UI)UI.this).machine.memory.getLoadedPathname()));
                boolean haveSetStartingPC = false;
                this.mainPane.allMemoryPane.clear();
                for (Region r : ((UI)UI.this).machine.memory.getRegions()) {
                    MemoryRegionPane p0 = new MemoryRegionPane(r);
                    MemoryRegionPane p1 = new MemoryRegionPane(r);
                    this.mainPane.allMemoryPane.add(p0, p1);
                    if (r.getType() != Region.Type.INSTRUCTIONS || haveSetStartingPC) continue;
                    UI.this.machine.gotoPC(r.getAddress());
                    haveSetStartingPC = true;
                }
                this.pack();
                this.setMaximizedBounds();
            }
        }

        public void update(Observable o, Object arg) {
            if (o instanceof Machine) {
                Machine.Event e = (Machine.Event)arg;
                block0 : switch (e.type) {
                    case INSTRUCTION_PROLOG: {
                        this.animator.clear();
                        this.adjustHighlights(false);
                        break;
                    }
                    case TRACE_POINT: {
                        Machine.DebugEvent de = (Machine.DebugEvent)e;
                        switch (de.debugType) {
                            case BREAK: {
                                assert (de.point == Machine.DebugPoint.INSTRUCTION);
                                this.statusBar.showMessage(String.format("Breakpoint at instruction 0x%x", de.value));
                                break block0;
                            }
                        }
                    }
                }
            }
        }

        class RunningSpeedSlider
        extends JFrame {
            RunningSpeedSlider() {
                Container cp = this.getContentPane();
                cp.setLayout(new BorderLayout());
                JLabel tl = new JLabel("Running Speed", 0);
                tl.setFont(TITLE_FONT);
                cp.add((Component)tl, "North");
                JSlider slider = new JSlider(1, 5000, 1500);
                Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
                labels.put(1, new JLabel("0s"));
                for (int i = 1000; i <= 5000; i += 1000) {
                    labels.put(i, new JLabel(String.format("%ds", i / 1000)));
                }
                slider.setMajorTickSpacing(1000);
                slider.setLabelTable(labels);
                slider.setPaintLabels(true);
                slider.setPaintTicks(true);
                cp.add((Component)slider, "Center");
                this.setVisible(true);
            }
        }

        class MemoryRegionPane
        extends JPanel {
            Region region;
            MemoryPane pane;
            ViewPane isaPane;

            MemoryRegionPane(Region aRegion) {
                this.region = aRegion;
                this.setLayout(new BoxLayout(this, 2));
                this.pane = new MemoryPane(this.region.getAddress(), this.region.byteLength(), this.region.getType() == Region.Type.INSTRUCTIONS);
                this.pane.setAlignmentY(0.0f);
                this.add(this.pane);
                Dimension sz = new Dimension(1, 0);
                this.add(new Box.Filler(sz, sz, sz));
                if (this.region.getType() == Region.Type.INSTRUCTIONS) {
                    this.isaPane = new InstructionsPane((InstructionRegion)this.region, this.pane);
                } else if (this.region.getType() == Region.Type.DATA) {
                    this.isaPane = new DataPane((DataRegion)this.region, this.pane);
                } else {
                    throw new AssertionError((Object)this.region.getType());
                }
                this.isaPane.view.setRowSelectionAllowed(true);
                this.isaPane.setAlignmentY(0.0f);
                this.add(this.isaPane);
                this.setAlignmentX(0.0f);
                this.isaPane.view.addSelectionListener(Application.this.masterSelectionListener);
            }

            void adjustHighlights(boolean clear) {
                this.pane.adjustHighlights(clear);
                this.isaPane.adjustHighlights(clear);
            }

            void adjustFontSize(int increment) {
                this.pane.adjustFontSize(increment);
                this.isaPane.adjustFontSize(increment);
            }

            void setCommentColumns(int columns) {
                if (this.region.getType() == Region.Type.INSTRUCTIONS) {
                    ((InstructionsPane)this.isaPane).setCommentColumns(columns);
                } else {
                    ((DataPane)this.isaPane).setCommentColumns(columns);
                }
            }

            JComponent getCommentPrototype() {
                if (this.region.getType() == Region.Type.INSTRUCTIONS) {
                    return ((InstructionsPane)this.isaPane).getCommentPrototype();
                }
                return ((DataPane)this.isaPane).getCommentPrototype();
            }
        }

        class DataPane
        extends ViewPane
        implements Region.ByteLengthChangedListener {
            MemoryPane memoryPane;
            Region region;

            DataPane(DataRegion aRegion, MemoryPane aMemoryPane) {
                super(String.format("Data - %x", aRegion.getAddress(), aRegion.length()), new ViewModel(aRegion, 0, aRegion.length(), 1, UI.this.isDataAddrShown ? Arrays.asList(0) : null, Arrays.asList(1, 2, 3, 4), null), Application.this.statusBar, UI.this.isDataAddrShown ? Arrays.asList(new ViewLabel(44, 4, UI.this.addressFont, UI.this.addressColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.NumberFormat(Integer.class, "0x%x:", 16)), new ViewTextField(6, 4, UI.this.labelFont, Color.BLACK, UI.this.CODE_HIGHLIGHT, new ViewFormat.NumberFormat(DataRegion.Value.class, "%d", 10)), new ViewTextField(8, 4, UI.this.labelFont, UI.this.codeColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(8, 4, UI.this.labelFont, UI.this.labelColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(-10, 2, UI.this.commentFont, UI.this.commentColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s"))) : Arrays.asList(new ViewTextField(6, 4, UI.this.labelFont, Color.BLACK, UI.this.CODE_HIGHLIGHT, new ViewFormat.NumberFormat(DataRegion.Value.class, "%d", 10)), new ViewTextField(8, 4, UI.this.labelFont, UI.this.codeColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(8, 4, UI.this.labelFont, UI.this.labelColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(-10, 2, UI.this.commentFont, UI.this.commentColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s"))));
                this.memoryPane = aMemoryPane;
                this.region = aRegion;
                this.region.addByteLengthChangedListener(this);
            }

            public void byteLengthChanged() {
                this.memoryPane.setLength(this.region.byteLength());
            }

            public void setCommentColumns(int columns) {
                this.view.setColumnWidth(UI.this.isDataAddrShown ? 4 : 3, columns);
                this.adjustSize();
            }

            JComponent getCommentPrototype() {
                return this.view.getColumnFormat(UI.this.isDataAddrShown ? 4 : 3).getRendererPrototype();
            }
        }

        class InstructionsPane
        extends ViewPane
        implements Region.ByteLengthChangedListener {
            JComponent context;
            MemoryPane memoryPane;
            Region region;

            InstructionsPane(InstructionRegion aRegion, MemoryPane aMemoryPane) {
                super(String.format("Instructions - %x", aRegion.getAddress(), aRegion.length()), new ViewModel(new CompoundModel(aRegion, new BreakpointControlModel(aRegion)), 0, aRegion.length(), 1, Arrays.asList(5, 0), UI.this.isMacShown ? Arrays.asList(1, 2, 3, 4) : Arrays.asList(2, 3, 4), null), Application.this.statusBar, UI.this.isMacShown ? Arrays.asList(new ViewCheckBox(UI.this.breakpointColor), new ViewLabel(44, 4, UI.this.addressFont, UI.this.addressColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.NumberFormat(Integer.class, "0x%x:", 16)), new ViewTextField(13, 2, UI.this.macFont, UI.this.macColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(8, 4, UI.this.labelFont, UI.this.labelColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(20, 2, UI.this.cellFont, UI.this.codeColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(-20, 2, UI.this.commentFont, UI.this.commentColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s"))) : Arrays.asList(new ViewCheckBox(UI.this.breakpointColor), new ViewLabel(44, 4, UI.this.addressFont, UI.this.addressColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.NumberFormat(Integer.class, "0x%x:", 16)), new ViewTextField(8, 4, UI.this.labelFont, UI.this.labelColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(26, 2, UI.this.cellFont, UI.this.codeColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s")), new ViewTextField(-20, 2, UI.this.commentFont, UI.this.commentColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s"))));
                this.context = null;
                this.memoryPane = aMemoryPane;
                this.region = aRegion;
                this.region.addByteLengthChangedListener(this);
                this.view.addUndoableEditListener(Application.this.undoManager);
                this.view.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && InstructionsPane.this.view.getSelectedColumn() == 1) {
                            Application.this.mainPane.adjustHighlights(true);
                            UI.this.machine.gotoPC((Integer)InstructionsPane.this.view.getValueAt(InstructionsPane.this.view.getSelectedRow(), 1));
                        }
                    }
                });
                this.view.addAccessListener(new View.AccessListener(){

                    public void access(View.AccessListener.Type alType, int row, int col, int count) {
                        if (col == 1 && Animator.Type.valueOf(alType) == Animator.Type.CONTROL_FLOW) {
                            if (InstructionsPane.this.context == null) {
                                MemoryRegionSplitPane splitPane = Application.this.mainPane.allMemoryPane.instructionMemoryPane;
                                ArrayList<MemoryRegionListPane> regionListPanes = new ArrayList<MemoryRegionListPane>();
                                regionListPanes.add((MemoryRegionListPane)splitPane.getTopComponent());
                                regionListPanes.add((MemoryRegionListPane)splitPane.getBottomComponent());
                                for (MemoryRegionListPane regionListPane : regionListPanes) {
                                    for (MemoryRegionPane regionPane : regionListPane.regionPanes) {
                                        if (regionPane.isaPane != InstructionsPane.this) continue;
                                        InstructionsPane.this.context = regionListPane;
                                    }
                                }
                            }
                            assert (InstructionsPane.this.context != null);
                            if (Application.this.isRunning) {
                                Application.this.animator.setControlFlowStart(InstructionsPane.this.context);
                            }
                            Application.this.animator.recordControlFlow(InstructionsPane.this.context, InstructionsPane.this.view, row);
                        }
                    }
                });
            }

            public void byteLengthChanged() {
                this.memoryPane.setLength(this.region.byteLength());
            }

            public void setCommentColumns(int columns) {
                this.view.setColumnWidth(UI.this.isMacShown ? 5 : 4, columns);
                this.adjustSize();
            }

            JComponent getCommentPrototype() {
                return this.view.getColumnFormat(UI.this.isMacShown ? 5 : 4).getRendererPrototype();
            }
        }

        class MemoryPane
        extends ViewPane {
            MemoryPane(int address, int length, boolean isInsMem) {
                super(String.format("Memory - %x", address, length), new ViewModel(((UI)UI.this).machine.memory, address, (length + 3) / 4, 4, Arrays.asList(0), Arrays.asList(1), Arrays.asList("Addr", "0", "1", "2", "3")), Application.this.statusBar, UI.this.isSmallInsMemDpy && isInsMem ? Arrays.asList(new ViewLabel(24, 4, UI.this.memAddressFont, UI.this.addressColor, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Integer.class, "0x%x:", 16)), new ViewTextField(2, 0, UI.this.memCellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16)), new ViewTextField(2, 0, UI.this.memCellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16)), new ViewTextField(2, 0, UI.this.memCellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16)), new ViewTextField(2, 0, UI.this.memCellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16))) : Arrays.asList(new ViewLabel(44, 4, UI.this.addressFont, UI.this.addressColor, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Integer.class, "0x%x:", 16)), new ViewTextField(2, 0, UI.this.cellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16)), new ViewTextField(2, 0, UI.this.cellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16)), new ViewTextField(2, 0, UI.this.cellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16)), new ViewTextField(2, 0, UI.this.cellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Byte.class, "%02x", 16))));
                if (isInsMem) {
                    this.view.addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent e) {
                            if (e.getClickCount() == 2 && MemoryPane.this.view.getSelectedColumn() == 0) {
                                Application.this.mainPane.adjustHighlights(true);
                                UI.this.machine.gotoPC(((UI)UI.this).machine.memory.getAlignedInstructionAddress((Integer)MemoryPane.this.view.getValueAt(MemoryPane.this.view.getSelectedRow(), 0)));
                            }
                        }
                    });
                } else {
                    this.view.addAccessListener(new View.AccessListener(){

                        public void access(View.AccessListener.Type alType, int row, int col, int count) {
                            if (col == 1 && Animator.Type.valueOf(alType) != null) {
                                Application.this.animator.renderDataFlow(Animator.Target.MEMORY, Animator.Type.valueOf(alType), MemoryPane.this.view, 0, row, col, count);
                            }
                        }
                    });
                }
            }

            public void setLength(int len) {
                ((ViewModel)this.view.getModel()).setLength((len + 3) / 4);
            }
        }

        class CurInsDescriptionPane
        extends ViewPane {
            CurInsDescriptionPane(int width, DataModel curInsAddr) {
                super("", new ViewModel(new PickModel(new InstructionModel(((UI)UI.this).machine.memory), Arrays.asList(curInsAddr), Arrays.asList(0), Arrays.asList(1)), 0, 1, 1, null, Arrays.asList(2), Arrays.asList("")), Application.this.statusBar, Arrays.asList(new ViewLabel(-width, 0, UI.this.isTwoProcStateCols ? UI.this.curInsDscTwoColFont : UI.this.curInsDscFont, UI.this.macColor, null, new ViewFormat.Format(String.class, "%s"))));
                this.view.setRowHeight(this.view.getRowHeight() - (UI.this.isTwoProcStateCols ? 6 : 3));
                this.adjustSize();
            }

            public void setWidth(int width) {
                this.view.setColumnWidth(0, width);
                this.adjustSize();
            }
        }

        class CurrentInstructionPane
        extends ViewPane {
            CurrentInstructionPane(String name, int width, DataModel curInsAddr) {
                super(name, new ViewModel(new PickModel(new InstructionModel(((UI)UI.this).machine.memory), Arrays.asList(curInsAddr), Arrays.asList(0), Arrays.asList(1)), 0, 1, 1, null, Arrays.asList(1), Arrays.asList(UI.this.isSmallCurInsDpy ? "" : "Current Instruction")), Application.this.statusBar, Arrays.asList(new ViewLabel(-width, 0, UI.this.isTwoProcStateCols ? UI.this.curInsTwoColFont : UI.this.curInsFont, UI.this.codeColor, null, new ViewFormat.Format(String.class, "%s"))));
                this.view.setRowHeight(this.view.getRowHeight() + (UI.this.isTwoProcStateCols ? 0 : 10));
                this.adjustSize();
            }

            public void setWidth(int width) {
                this.view.setColumnWidth(0, width);
                this.adjustSize();
            }
        }

        class MemoryRegionListPane
        extends JScrollPane {
            ArrayList<MemoryRegionPane> regionPanes = new ArrayList();

            MemoryRegionListPane() {
                this.setHorizontalScrollBarPolicy(31);
                this.setVerticalScrollBarPolicy(22);
                this.setBorder(null);
            }

            public void add(MemoryRegionPane regionPane) {
                if (this.regionPanes.isEmpty()) {
                    VSPanel p = new VSPanel(regionPane.isaPane.view);
                    p.setLayout(new BoxLayout(p, 3));
                    p.add(regionPane);
                    this.setViewportView(p);
                    this.getViewport().setBackground(Application.this.getBackground());
                    this.setVisible(true);
                } else {
                    ((JPanel)this.getViewport().getView()).add(regionPane);
                }
                this.regionPanes.add(regionPane);
                this.setMinimumSize(new Dimension(regionPane.getMinimumSize().width + this.getVerticalScrollBar().getWidth(), this.getMinimumSize().height));
            }

            public void removeAll() {
                this.setViewportView(null);
                this.regionPanes.clear();
                this.setVisible(false);
            }

            public void adjustFontSize(int increment) {
                for (MemoryRegionPane regionPane : this.regionPanes) {
                    regionPane.adjustFontSize(increment);
                }
            }

            public void adjustHighlights(boolean clear) {
                for (MemoryRegionPane regionPane : this.regionPanes) {
                    regionPane.adjustHighlights(clear);
                }
                if (!this.regionPanes.isEmpty()) {
                    this.setMinimumSize(null);
                    this.setMinimumSize(new Dimension(this.regionPanes.get((int)0).getMinimumSize().width + this.getVerticalScrollBar().getWidth(), this.getMinimumSize().height));
                }
            }
        }

        class VSPanel
        extends JPanel
        implements Scrollable {
            View view;

            VSPanel(View aView) {
                this.view = aView;
            }

            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            public int getScrollableBlockIncrement(Rectangle r, int o, int d) {
                return this.view.getScrollableBlockIncrement(r, o, d);
            }

            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            public int getScrollableUnitIncrement(Rectangle r, int o, int d) {
                return this.view.getScrollableUnitIncrement(r, o, d);
            }
        }

        class MemoryRegionSplitPane
        extends JSplitPane {
            MemoryRegionSplitPane() {
                super(0, true, new MemoryRegionListPane(), new MemoryRegionListPane());
                this.setResizeWeight(1.0);
                this.setDividerLocation(Application.this.screenHeight + 1);
                this.setOneTouchExpandable(true);
                this.setVisible(false);
            }

            public void add(MemoryRegionPane regionPane0, MemoryRegionPane regionPane1) {
                ((MemoryRegionListPane)this.getTopComponent()).add(regionPane0);
                ((MemoryRegionListPane)this.getBottomComponent()).add(regionPane1);
                this.setVisible(true);
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, regionPane0.getPreferredSize().height));
            }

            public void removeAll() {
                this.setVisible(false);
                ((MemoryRegionListPane)this.getTopComponent()).removeAll();
                ((MemoryRegionListPane)this.getBottomComponent()).removeAll();
            }

            public void adjustFontSize(int increment) {
                ((MemoryRegionListPane)this.getTopComponent()).adjustFontSize(increment);
                ((MemoryRegionListPane)this.getBottomComponent()).adjustFontSize(increment);
                this.setPreferredSize(null);
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getTopComponent().getPreferredSize().height));
            }

            public void adjustHighlights(boolean clear) {
                ((MemoryRegionListPane)this.getTopComponent()).adjustHighlights(clear);
                ((MemoryRegionListPane)this.getBottomComponent()).adjustHighlights(clear);
            }
        }

        class AllMemoryPane
        extends JPanel {
            MemoryRegionSplitPane instructionMemoryPane;
            MemoryRegionSplitPane dataMemoryPane;
            Vector<MemoryRegionPane> regionPanes = new Vector();
            int numCols;

            AllMemoryPane() {
                this.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent ce) {
                        if (((UI)UI.this).machine.memory.hasLoadedFile()) {
                            AllMemoryPane.this.setNumColumns(Application.this.getWidth() >= Application.this.getMaximizedWidth() ? 2 : 1);
                        }
                    }
                });
                this.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent ce) {
                        Application.this.setMaximizedBounds();
                    }
                });
                UIDefaults uidefs = UIManager.getLookAndFeelDefaults();
                uidefs.put("SplitPane.background", new ColorUIResource(UI.this.strutColor));
                uidefs.put("SplitPaneDivider.border", new BorderUIResource(new CompoundBorder(new MatteBorder(1, 0, 1, 0, UI.this.strutColor.darker()), new MatteBorder(0, 0, 0, 0, UI.this.strutColor))));
                this.setLayout(new BoxLayout(this, 2));
                this.instructionMemoryPane = new MemoryRegionSplitPane();
                this.instructionMemoryPane.setBorder(new CompoundBorder(new CompoundBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker()), new MatteBorder(0, 3, 0, 0, UI.this.strutColor)), new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker())), new MatteBorder(4, 0, 2, 0, Application.this.getBackground())));
                this.dataMemoryPane = new MemoryRegionSplitPane();
                this.dataMemoryPane.setBorder(new CompoundBorder(new CompoundBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker()), new MatteBorder(0, 3, 0, 0, UI.this.strutColor)), new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker())), new MatteBorder(4, 0, 2, 0, Application.this.getBackground())));
                this.numCols = 2;
                this.instructionMemoryPane.setAlignmentY(0.0f);
                this.dataMemoryPane.setAlignmentY(0.0f);
                this.add(this.instructionMemoryPane);
                this.add(this.dataMemoryPane);
            }

            int getMaximizedWidth() {
                int oh;
                int iw = 0;
                int dw = 0;
                for (MemoryRegionPane rp : this.regionPanes) {
                    if (rp.region.getType() == Region.Type.DATA) {
                        dw = rp.getPreferredSize().width;
                    } else if (rp.region.getType() == Region.Type.INSTRUCTIONS) {
                        iw = rp.getPreferredSize().width;
                    }
                    if (dw == 0 || iw == 0) continue;
                    break;
                }
                if ((oh = this.instructionMemoryPane.getPreferredSize().width - iw) <= 10 || oh >= 30) {
                    oh = 20;
                }
                return iw + oh + dw + (dw > 0 ? oh : 0);
            }

            int getMaximizedHeight() {
                int ih = 0;
                int dh = 0;
                for (MemoryRegionPane rp : this.regionPanes) {
                    if (rp.region.getType() == Region.Type.DATA) {
                        dh += rp.getPreferredSize().height;
                        continue;
                    }
                    if (rp.region.getType() != Region.Type.INSTRUCTIONS) continue;
                    ih += rp.getPreferredSize().height;
                }
                int ch = this.instructionMemoryPane == this.dataMemoryPane ? dh + ih : Math.max(dh, ih);
                int oh = this.getPreferredSize().height - ch;
                return Math.max(dh, ih) + oh;
            }

            void setNumColumns(int aNum) {
                if (aNum != this.numCols) {
                    this.numCols = aNum;
                    this.instructionMemoryPane.removeAll();
                    this.dataMemoryPane.removeAll();
                    if (this.numCols == 2) {
                        this.dataMemoryPane = new MemoryRegionSplitPane();
                        this.dataMemoryPane.setBorder(new CompoundBorder(new CompoundBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker()), new MatteBorder(0, 3, 0, 0, UI.this.strutColor)), new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker())), new MatteBorder(4, 0, 2, 0, Application.this.getBackground())));
                        this.dataMemoryPane.setAlignmentY(0.0f);
                        this.add(this.dataMemoryPane);
                    } else {
                        this.remove(this.dataMemoryPane);
                        this.dataMemoryPane = this.instructionMemoryPane;
                    }
                    for (int i = 0; i < this.regionPanes.size(); i += 2) {
                        MemoryRegionPane regionPane0 = this.regionPanes.get(i);
                        MemoryRegionPane regionPane1 = this.regionPanes.get(i + 1);
                        if (regionPane0.region.getType() == Region.Type.INSTRUCTIONS) {
                            this.instructionMemoryPane.add(regionPane0, regionPane1);
                            continue;
                        }
                        this.dataMemoryPane.add(regionPane0, regionPane1);
                    }
                    this.revalidate();
                }
            }

            void clear() {
                this.regionPanes.clear();
                this.instructionMemoryPane.removeAll();
                this.dataMemoryPane.removeAll();
            }

            void add(MemoryRegionPane regionPane0, MemoryRegionPane regionPane1) {
                if (Application.this.mainPane.fontSizeAdjustment != 0) {
                    regionPane0.adjustFontSize(Application.this.mainPane.fontSizeAdjustment);
                    regionPane1.adjustFontSize(Application.this.mainPane.fontSizeAdjustment);
                }
                this.regionPanes.add(regionPane0);
                this.regionPanes.add(regionPane1);
                if (regionPane0.region.getType() == Region.Type.INSTRUCTIONS) {
                    this.instructionMemoryPane.add(regionPane0, regionPane1);
                } else {
                    this.dataMemoryPane.add(regionPane0, regionPane1);
                }
            }

            void adjustHighlights(boolean clear) {
                this.instructionMemoryPane.adjustHighlights(clear);
                if (this.dataMemoryPane != this.instructionMemoryPane) {
                    this.dataMemoryPane.adjustHighlights(clear);
                }
            }

            void adjustFontSize(int increment) {
                this.instructionMemoryPane.adjustFontSize(increment);
                if (this.dataMemoryPane != this.instructionMemoryPane) {
                    this.dataMemoryPane.adjustFontSize(increment);
                }
            }

            ViewPane getSelectedPane() {
                for (MemoryRegionPane region : this.regionPanes) {
                    if ((region.isaPane.view.getSelectedRow() == -1 || !region.isaPane.view.isCellEditable(region.isaPane.view.getSelectedRow(), region.isaPane.view.getSelectedColumn())) && region.isaPane.view.getEditorComponent() == null) continue;
                    return region.isaPane;
                }
                return null;
            }
        }

        class RegisterViewPane
        extends ViewPane {
            RegisterViewPane() {
                super("Reg Views", new ViewModel(new ValueView(((UI)UI.this).machine.registerFile, 1, ((UI)UI.this).machine.memory.getLabelMap(), "Ref"), 0, ((UI)UI.this).machine.registerFile.getRowCount(), 1, null, Arrays.asList(0, 1), null), Application.this.statusBar, Arrays.asList(new ViewTextField(-6, 4, UI.this.labelFont, Color.BLACK, UI.this.CODE_HIGHLIGHT, new ViewFormat.NumberFormat(ValueView.Value.class, "%d", 10)), new ViewTextField(-8, 4, UI.this.labelFont, UI.this.codeColor, UI.this.CODE_HIGHLIGHT, new ViewFormat.Format(String.class, "%s"))));
            }
        }

        class RegisterPane
        extends ViewPane {
            RegisterPane() {
                super("Register File", new ViewModel(((UI)UI.this).machine.registerFile, 0, ((UI)UI.this).machine.registerFile.getRowCount(), 1, Arrays.asList(0), Arrays.asList(1), null), Application.this.statusBar, Arrays.asList(new ViewLabel(-28, 4, UI.this.addressFont, UI.this.addressColor, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.Format(String.class, "%s:")), new ViewTextField(8, 0, UI.this.cellFont, null, UI.this.MEMORY_HIGHLIGHT, new ViewFormat.NumberFormat(Integer.class, "%08x", 16))));
                this.view.addAccessListener(new View.AccessListener(){

                    public void access(View.AccessListener.Type alType, int row, int col, int count) {
                        if (col == 1) {
                            Application.this.animator.renderDataFlow(Animator.Target.REGISTER, Animator.Type.valueOf(alType), RegisterPane.this.view, 0, row, col, count);
                        }
                    }
                });
            }
        }

        class ProcessorStatePaneContent
        extends JPanel
        implements Scrollable {
            Vector<ViewPane> panes = new Vector();
            Vector<JPanel> struts = new Vector();

            ProcessorStatePaneContent() {
                this.setLayout(new BoxLayout(this, 3));
                for (RegisterSet regSet : ((UI)UI.this).machine.processorState) {
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p, 2));
                    p.setAlignmentY(0.0f);
                    p.setAlignmentX(0.0f);
                    if (UI.this.isTwoProcStateCols) {
                        JLabel l = new JLabel(regSet.getName());
                        l.setHorizontalAlignment(2);
                        l.setFont(UI.this.subTitleFont);
                        l.setAlignmentY(0.0f);
                        l.setPreferredSize(new Dimension(13, l.getPreferredSize().height));
                        JPanel tp = new JPanel(new GridLayout());
                        tp.add(l);
                        tp.setBorder(new EmptyBorder(0, 2, 0, 0));
                        tp.setMinimumSize(new Dimension(15, tp.getPreferredSize().height));
                        tp.setMaximumSize(new Dimension(15, tp.getPreferredSize().height));
                        tp.setAlignmentY(0.0f);
                        tp.setAlignmentX(0.0f);
                        p.add(tp);
                    }
                    JPanel dp = new JPanel();
                    dp.setLayout(new BoxLayout(dp, 3));
                    dp.setAlignmentY(0.0f);
                    dp.setAlignmentX(0.0f);
                    Register curInsAddr = regSet.getRegister(((UI)UI.this).machine.curInsAddrRegName);
                    ViewPane pane = UI.this.isTwoProcStateCols ? new ViewPane("", new ViewModel(regSet, 0, (regSet.getRowCount() + 1) / 2, 2, null, Arrays.asList(0, 1), Arrays.asList("", "", "", "")), Application.this.statusBar, Arrays.asList(new ViewLabel(-30, 4, UI.this.nameFont, UI.this.nameColor, null, new ViewFormat.Format(String.class, "%s:")), new ViewTextField(8, 2, UI.this.cellFont, null, null, Arrays.asList(new ViewFormat.NumberFormat(Integer.class, "%08x", 16), new ViewFormat.NumberFormat(Long.class, "%d", 10), new ViewFormat.NumberFormat(HalfByteNumber.class, "%01x", 16), new ViewFormat.NumberFormat(Byte.class, "%02x", 16), new ViewFormat.NumberFormat(Short.class, "%03x", 16), new ViewFormat.TwoIntegerFormat(SixByteNumber.class, "%04x %08x", 16))), new ViewLabel(-30, 4, UI.this.nameFont, UI.this.nameColor, null, new ViewFormat.Format(String.class, "%s:")), new ViewTextField(8, 2, UI.this.cellFont, null, null, Arrays.asList(new ViewFormat.NumberFormat(Integer.class, "%08x", 16), new ViewFormat.NumberFormat(Long.class, "%d", 10), new ViewFormat.NumberFormat(HalfByteNumber.class, "%01x", 16), new ViewFormat.NumberFormat(Byte.class, "%02x", 16), new ViewFormat.NumberFormat(Short.class, "%03x", 16), new ViewFormat.TwoIntegerFormat(SixByteNumber.class, "%04x %08x", 16))))) : new ViewPane(curInsAddr != null ? "" : regSet.getName(), new ViewModel(regSet, 0, regSet.getRowCount(), 1, null, Arrays.asList(0, 1), null), Application.this.statusBar, Arrays.asList(new ViewLabel(-99, 4, UI.this.nameFont, UI.this.nameColor, null, new ViewFormat.Format(String.class, "%s:")), new ViewTextField(13, 2, UI.this.cellFont, null, null, Arrays.asList(new ViewFormat.NumberFormat(Integer.class, "%08x", 16), new ViewFormat.NumberFormat(Long.class, "%d", 10), new ViewFormat.NumberFormat(HalfByteNumber.class, "%01x", 16), new ViewFormat.NumberFormat(Byte.class, "%02x", 16), new ViewFormat.NumberFormat(Short.class, "%03x", 16), new ViewFormat.TwoIntegerFormat(SixByteNumber.class, "%04x %08x", 16)))));
                    int width = pane.getPreferredSize().width;
                    if (curInsAddr != null) {
                        ViewPane ip = new CurrentInstructionPane("", width - 3, curInsAddr);
                        dp.add(ip);
                        this.panes.add(ip);
                        if (!UI.this.isSmallCurInsDpy) {
                            ip = new CurInsDescriptionPane(width - 3, curInsAddr);
                            dp.add(ip);
                            this.panes.add(ip);
                        }
                    }
                    this.panes.add(pane);
                    dp.add(pane);
                    p.add(dp);
                    this.add(p);
                    if (!UI.this.isTwoProcStateCols || ((UI)UI.this).machine.processorState.lastIndexOf(regSet) == ((UI)UI.this).machine.processorState.size() - 1) continue;
                    JPanel s = new JPanel();
                    s.setBorder(new CompoundBorder(new MatteBorder(1, 0, 1, 0, Application.this.getBackground()), new CompoundBorder(new MatteBorder(1, 0, 0, 0, UI.this.strutColor.darker()), new MatteBorder(0, 0, 0, 0, UI.this.strutColor))));
                    s.setPreferredSize(new Dimension(s.getPreferredSize().width, 3));
                    this.add(s);
                    s.setAlignmentX(0.0f);
                    this.struts.add(s);
                }
            }

            void adjustHighlights(boolean clear) {
                for (ViewPane pane : this.panes) {
                    pane.adjustHighlights(clear);
                }
            }

            void adjustFontSize(int increment) {
                for (ViewPane pane : this.panes) {
                    pane.adjustFontSize(increment);
                }
            }

            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            public int getScrollableBlockIncrement(Rectangle r, int o, int d) {
                return this.panes.get((int)0).view.getScrollableBlockIncrement(r, o, d);
            }

            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            public int getScrollableUnitIncrement(Rectangle r, int o, int d) {
                return this.panes.get((int)0).view.getScrollableUnitIncrement(r, o, d);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ProcessorStatePane
        extends ScrollPane<ProcessorStatePaneContent> {
            ProcessorStatePane() {
                super(Application.this, (Component)new ProcessorStatePaneContent());
            }

            void adjustHighlights(boolean clear) {
                ((ProcessorStatePaneContent)this.content).adjustHighlights(clear);
            }

            void adjustFontSize(int increment) {
                ((ProcessorStatePaneContent)this.content).adjustFontSize(increment);
                this.setPreferredSize(null);
                this.setMaximumSize(new Dimension(this.getMaximumSize().width, this.getPreferredSize().height));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ScrollPane<T extends Component>
        extends JScrollPane {
            final T content;
            private final JScrollBar vsb;
            final /* synthetic */ Application this$1;

            ScrollPane(T aContent) {
                this.this$1 = var1_1;
                super((Component)aContent, 20, 31);
                this.vsb = this.getVerticalScrollBar();
                this.content = aContent;
                this.setBorder(null);
                this.setMinimumSize(new Dimension(((Component)this.content).getMinimumSize().width, this.getMinimumSize().height));
                this.setPreferredSize(new Dimension(((Component)this.content).getPreferredSize().width, this.getPreferredSize().height));
                this.setMaximumSize(new Dimension(this.getMaximumSize().width, this.getPreferredSize().height));
                this.vsb.addComponentListener(new ComponentAdapter(){

                    public void componentHidden(ComponentEvent e) {
                        ScrollPane.this.setMinimumSize(null);
                        ScrollPane.this.setMinimumSize(new Dimension(((Component)ScrollPane.this.content).getMinimumSize().width, ScrollPane.this.getMinimumSize().height));
                        ScrollPane.this.setPreferredSize(null);
                        ScrollPane.this.setPreferredSize(new Dimension(((Component)ScrollPane.this.content).getPreferredSize().width, ScrollPane.this.getPreferredSize().height));
                        ScrollPane.this.setMaximumSize(new Dimension(ScrollPane.this.getMaximumSize().width, ScrollPane.this.getPreferredSize().height));
                        ((JComponent)ScrollPane.this.getParent()).revalidate();
                    }

                    public void componentShown(ComponentEvent e) {
                        ScrollPane.this.setMinimumSize(null);
                        ScrollPane.this.setMinimumSize(new Dimension(((Component)ScrollPane.this.content).getMinimumSize().width + ScrollPane.this.vsb.getWidth(), ScrollPane.this.getMinimumSize().height));
                        ScrollPane.this.setPreferredSize(null);
                        ScrollPane.this.setPreferredSize(new Dimension(((Component)ScrollPane.this.content).getPreferredSize().width + ScrollPane.this.vsb.getWidth(), ScrollPane.this.getPreferredSize().height));
                        ScrollPane.this.setMaximumSize(new Dimension(ScrollPane.this.getMaximumSize().width, ScrollPane.this.getPreferredSize().height));
                        ((JComponent)ScrollPane.this.getParent()).revalidate();
                    }
                });
            }
        }

        class CpuPane
        extends JPanel {
            RegisterPane registerPane;
            RegisterViewPane registerViewPane;
            ProcessorStatePane processorStatePane;
            JPanel strut = null;

            CpuPane() {
                this.setLayout(new BoxLayout(this, 2));
                JPanel col0 = new JPanel();
                JPanel col1 = null;
                col0.setLayout(new BoxLayout(col0, 3));
                col0.setBorder(new MatteBorder(4, 0, 2, 0, Application.this.getBackground()));
                col0.setAlignmentY(0.0f);
                this.registerPane = new RegisterPane();
                this.registerViewPane = new RegisterViewPane();
                this.processorStatePane = new ProcessorStatePane();
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 2));
                p.setAlignmentX(0.0f);
                this.registerPane.setAlignmentY(0.0f);
                this.registerViewPane.setAlignmentY(0.0f);
                JPanel regGrp = new JPanel();
                regGrp.setLayout(new BoxLayout(regGrp, 2));
                Dimension sz = new Dimension(0, 0);
                regGrp.add(new Box.Filler(sz, sz, sz));
                regGrp.add(this.registerPane);
                regGrp.add(this.registerViewPane);
                regGrp.add(new Box.Filler(sz, sz, sz));
                p.add(regGrp);
                if (UI.this.isRegFileInOwnCol) {
                    col1 = new JPanel();
                    col1.setLayout(new BoxLayout(col1, 3));
                    col1.setBorder(new CompoundBorder(new CompoundBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker()), new MatteBorder(0, 3, 0, 0, UI.this.strutColor)), new MatteBorder(0, 1, 0, 0, UI.this.strutColor.darker())), new MatteBorder(4, 0, 2, 0, Application.this.getBackground())));
                    col1.add(p);
                    col1.add(Box.createVerticalGlue());
                    col1.setAlignmentY(0.0f);
                } else {
                    col0.add(p);
                    this.strut = new JPanel();
                    this.strut.setPreferredSize(new Dimension(this.getPreferredSize().width, 9));
                    this.strut.setBorder(new CompoundBorder(new MatteBorder(2, 0, 2, 0, Application.this.getBackground()), new CompoundBorder(new MatteBorder(1, 0, 1, 0, UI.this.strutColor.darker()), new MatteBorder(2, 0, 2, 0, UI.this.strutColor))));
                    col0.add(this.strut);
                    this.strut.setAlignmentX(0.0f);
                }
                p = new JPanel();
                p.setLayout(new BoxLayout(p, 3));
                p.setAlignmentX(0.0f);
                p.setAlignmentY(1.0f);
                p.add(this.processorStatePane);
                col0.add(p);
                this.add(col0);
                if (col1 != null) {
                    this.add(col1);
                }
                this.setMaximumSize(new Dimension(this.getPreferredSize().width, this.getMaximumSize().height));
            }

            void adjustHighlights(boolean clear) {
                this.registerPane.adjustHighlights(clear);
                this.registerViewPane.adjustHighlights(clear);
                this.processorStatePane.adjustHighlights(clear);
            }

            void adjustFontSize(int increment) {
                this.registerPane.adjustFontSize(increment);
                this.registerViewPane.adjustFontSize(increment);
                this.processorStatePane.adjustFontSize(increment);
                this.setMaximumSize(new Dimension(this.getPreferredSize().width, this.getMaximumSize().height));
            }

            int getMaximizedWidth() {
                return this.getPreferredSize().width;
            }

            int getMaximizedHeight() {
                return this.getPreferredSize().height;
            }
        }

        class MainPane
        extends JPanel {
            CpuPane cpuPane;
            AllMemoryPane allMemoryPane;
            int fontSizeAdjustment = 0;

            MainPane() {
                this.setLayout(new BoxLayout(this, 2));
                this.cpuPane = new CpuPane();
                this.allMemoryPane = new AllMemoryPane();
                this.cpuPane.setAlignmentY(0.0f);
                this.allMemoryPane.setAlignmentY(0.0f);
                this.add(this.cpuPane);
                this.add(this.allMemoryPane);
            }

            void adjustHighlights(boolean clear) {
                this.cpuPane.adjustHighlights(clear);
                this.allMemoryPane.adjustHighlights(clear);
            }

            void adjustFontSize(int increment) {
                if (this.fontSizeAdjustment > -7 || increment > 0) {
                    this.fontSizeAdjustment += increment;
                    this.cpuPane.adjustFontSize(increment);
                    this.allMemoryPane.adjustFontSize(increment);
                }
            }

            int getMaximizedWidth() {
                return this.cpuPane.getMaximizedWidth() + this.allMemoryPane.getMaximizedWidth();
            }

            int getMaximizedHeight() {
                return Math.max(this.cpuPane.getMaximizedHeight(), this.allMemoryPane.getMaximizedHeight());
            }
        }

        class ApplicationUndoManager
        extends UndoManager {
            private Vector<StateChangedListener> stateChangedListeners = new Vector();

            ApplicationUndoManager() {
            }

            private void fireStateChanged() {
                for (StateChangedListener l : this.stateChangedListeners) {
                    l.stateChanged(this);
                }
            }

            void addStateChangedListener(StateChangedListener l) {
                this.stateChangedListeners.add(l);
            }

            public boolean addEdit(UndoableEdit e) {
                boolean r = super.addEdit(e);
                if (r) {
                    this.fireStateChanged();
                }
                return r;
            }

            public void undo() {
                super.undo();
                this.fireStateChanged();
            }

            public void redo() {
                super.redo();
                this.fireStateChanged();
            }
        }

        class BreakpointControlModel
        extends AbstractDataModel
        implements Observer {
            Region region;
            Machine.DebugPoint debugPoint;

            BreakpointControlModel(Region aRegion) {
                this.region = aRegion;
                this.debugPoint = this.region.getType() == Region.Type.INSTRUCTIONS ? Machine.DebugPoint.INSTRUCTION : Machine.DebugPoint.MEMORY_READ;
                UI.this.machine.addDebugPointObserver(this);
            }

            public boolean insertRow(int row) {
                for (int r = row + 1; r < this.region.length(); ++r) {
                    if (!UI.this.machine.isDebugPointEnabled(Machine.DebugType.BREAK, this.debugPoint, this.region.getCellForRowIndex(r).getAddress())) continue;
                    this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, Arrays.asList(new TableCellIndex(r - 1, 0), new TableCellIndex(r, 0))));
                }
                return true;
            }

            public boolean deleteRow(int row) {
                for (int r = row; r < this.region.length() - 1; ++r) {
                    if (!UI.this.machine.isDebugPointEnabled(Machine.DebugType.BREAK, this.debugPoint, this.region.getCellForRowIndex(r).getAddress())) continue;
                    this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, Arrays.asList(new TableCellIndex(r, 0), new TableCellIndex(r + 1, 0))));
                }
                return true;
            }

            public boolean canInsertRow(int row) {
                return true;
            }

            public boolean canDeleteRow(int row) {
                return true;
            }

            public void update(Observable o, Object arg) {
                Vector<TableCellIndex> updatedCells = new Vector<TableCellIndex>();
                DataModelEvent event = (DataModelEvent)arg;
                if (event.getType() == DataModelEvent.Type.WRITE || event.getType() == DataModelEvent.Type.WRITE_BY_USER) {
                    for (TableCellIndex cell : event.getCells()) {
                        updatedCells.add(new TableCellIndex(this.region.getRowIndexForAddress(cell.rowIndex), 0));
                    }
                }
                this.tellObservers(new DataModelEvent(event.getType(), updatedCells));
            }

            public Class getColumnClass(int columnIndex) {
                return Boolean.class;
            }

            public int getColumnCount() {
                return 1;
            }

            public String getColumnName(int columnIndex) {
                return "B";
            }

            public int getRowCount() {
                return this.region.getRowCount();
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return UI.this.machine.isDebugPointEnabled(Machine.DebugType.BREAK, this.debugPoint, this.region.getCellForRowIndex(rowIndex).getAddress());
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                UI.this.machine.setDebugPoint(Machine.DebugType.BREAK, this.debugPoint, this.region.getCellForRowIndex(rowIndex).getAddress(), (Boolean)aValue);
            }
        }

        class DeleteAction
        extends AbstractAction
        implements IsRunningListener,
        View.SelectionListener {
            public DeleteAction() {
                this.putValue("Name", "Delete");
                this.putValue("MnemonicKey", 68);
                if (IS_MS_WINDOWS) {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 8));
                } else {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, UI.this.platformAgnosticMetaMask));
                }
                this.putValue("ShortDescription", "Delete row.");
                this.setEnabled(false);
                Application.this.masterSelectionListener.add(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                ViewPane pane = Application.this.getSelectedPane();
                if (pane != null) {
                    boolean deleted;
                    if (Application.this.stopEditing() && !(deleted = pane.view.deleteSelection())) {
                        Application.this.statusBar.showMessage("Unable to delete row.");
                    }
                } else {
                    Application.this.statusBar.showMessage("No row selected for Delete.");
                }
            }

            private void setEnabled() {
                this.setEnabled(!Application.this.isRunning && Application.this.getSelectedPane() != null);
            }

            public void isRunningChanged() {
                this.setEnabled();
            }

            public void selectionMayHaveChanged(boolean isKnownToBeSelected) {
                if (isKnownToBeSelected) {
                    this.setEnabled(!Application.this.isRunning);
                } else {
                    this.setEnabled();
                }
            }
        }

        class InsertBelowAction
        extends AbstractAction
        implements IsRunningListener,
        View.SelectionListener {
            public InsertBelowAction() {
                this.putValue("Name", "Insert Below");
                this.putValue("MnemonicKey", 66);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Insert row below selected row.");
                this.setEnabled(false);
                Application.this.masterSelectionListener.add(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                ViewPane pane = Application.this.getSelectedPane();
                if (pane != null) {
                    if (Application.this.stopEditing()) {
                        boolean inserted = pane.view.insertBelowSelection();
                        if (inserted) {
                            Application.this.statusBar.showMessage("Row inserted.");
                        } else {
                            Application.this.statusBar.showMessage("Unable to insert new row.");
                        }
                    }
                } else {
                    Application.this.statusBar.showMessage("No row selected for Insert Before.");
                }
            }

            private void setEnabled() {
                this.setEnabled(!Application.this.isRunning && Application.this.getSelectedPane() != null);
            }

            public void isRunningChanged() {
                this.setEnabled();
            }

            public void selectionMayHaveChanged(boolean isKnownToBeSelected) {
                if (isKnownToBeSelected) {
                    this.setEnabled(!Application.this.isRunning);
                } else {
                    this.setEnabled();
                }
            }
        }

        class InsertAboveAction
        extends AbstractAction
        implements IsRunningListener,
        View.SelectionListener {
            public InsertAboveAction() {
                this.putValue("Name", "Insert Above");
                this.putValue("MnemonicKey", 66);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, UI.this.platformAgnosticMetaMask | 8));
                this.putValue("ShortDescription", "Insert row above selected row.");
                this.setEnabled(false);
                Application.this.masterSelectionListener.add(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                ViewPane pane = Application.this.getSelectedPane();
                if (pane != null) {
                    if (Application.this.stopEditing()) {
                        boolean inserted = pane.view.insertAboveSelection();
                        if (inserted) {
                            Application.this.statusBar.showMessage("Row inserted.");
                        } else {
                            Application.this.statusBar.showMessage("Unable to insert new row.");
                        }
                    }
                } else {
                    Application.this.statusBar.showMessage("No row selected for Insert.");
                }
            }

            private void setEnabled() {
                this.setEnabled(!Application.this.isRunning && Application.this.getSelectedPane() != null);
            }

            public void isRunningChanged() {
                this.setEnabled();
            }

            public void selectionMayHaveChanged(boolean isKnownToBeSelected) {
                if (isKnownToBeSelected) {
                    this.setEnabled(!Application.this.isRunning);
                } else {
                    this.setEnabled();
                }
            }
        }

        class ClearHighlightsAction
        extends AbstractAction {
            public ClearHighlightsAction() {
                this.putValue("Name", "Erase Highlights");
                this.putValue("MnemonicKey", 72);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Erase highlights.");
            }

            public void actionPerformed(ActionEvent e) {
                Application.this.adjustHighlights(true);
            }
        }

        class ClearAllBreakpointsAction
        extends AbstractAction {
            public ClearAllBreakpointsAction() {
                this.putValue("Name", "Clear Breaks");
                this.putValue("MnemonicKey", 76);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UI.this.platformAgnosticMetaMask | 1));
                this.putValue("ShortDescription", "Clear all breakpoints.");
            }

            public void actionPerformed(ActionEvent e) {
                UI.this.machine.clearAllDebugPoints(Machine.DebugType.BREAK);
                Application.this.statusBar.showMessage("All breakpoints cleared.");
            }
        }

        class ClearBreakpointAction
        extends AbstractAction {
            public ClearBreakpointAction() {
                this.putValue("Name", "Clear Breakpoint");
                this.putValue("MnemonicKey", 67);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Clear breakpoint.");
            }

            public void actionPerformed(ActionEvent e) {
            }
        }

        class SetBreakpointAction
        extends AbstractAction {
            public SetBreakpointAction() {
                this.putValue("Name", "Set Breakpoint");
                this.putValue("MnemonicKey", 66);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Set breakpoint.");
            }

            public void actionPerformed(ActionEvent e) {
            }
        }

        class GotoAction
        extends AbstractAction
        implements IsRunningListener {
            public GotoAction() {
                this.putValue("Name", "Goto");
                this.putValue("MnemonicKey", 71);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Set PC to specified address.");
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning);
            }
        }

        class StepAction
        extends AbstractAction
        implements Memory.StateChangedListener,
        IsRunningListener {
            public StepAction() {
                this.putValue("Name", "Step");
                this.putValue("MnemonicKey", 83);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Execute one instruction and stop.");
                this.setEnabled(false);
                ((UI)UI.this).machine.memory.addStateChangedListener(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                Application.this.statusBar.showMessage("");
                Application.this.setRunning(true);
                Application.this.animator.resume();
                Application.this.statusBar.showMessage(UI.this.machine.run(true, 0));
                Application.this.animator.clear();
                Application.this.setRunning(false);
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }

            public void memoryStateChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }
        }

        class HaltAction
        extends AbstractAction
        implements IsRunningListener {
            public HaltAction() {
                this.putValue("Name", "Halt");
                this.putValue("MnemonicKey", 72);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(46, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Halt CPU execution.");
                this.setEnabled(false);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                UI.this.machine.stop();
                Application.this.animator.stop();
            }

            public void isRunningChanged() {
                this.setEnabled(Application.this.isRunning);
            }
        }

        class AnimationPauseAction
        extends AbstractAction
        implements IsRunningListener,
        PropertyChangeListener {
            static final String PAUSE_NAME = "Pause";
            static final String RESUME_NAME = "Resume";
            static final int PAUSE_MNEMONIC = 80;
            static final int RESUME_MNEMONIC = 82;
            static final String PAUSE_DESCRIPTION = "Pause instruction animation.";
            static final String RESUME_DESCRIPTION = "Resume instruction animation.";

            public AnimationPauseAction() {
                this.putValue("Name", PAUSE_NAME);
                this.putValue("MnemonicKey", 80);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", PAUSE_DESCRIPTION);
                this.setEnabled(false);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                if (Application.this.animator.isPaused()) {
                    Application.this.animator.resume();
                    Application.this.statusBar.showMessage(String.format("Running with %3.1fs long animation ...", (double)Application.this.animator.getDuration() / 1000.0));
                } else {
                    Application.this.animator.pause();
                    Application.this.statusBar.showMessage("Animation paused.");
                }
                this.computeState();
            }

            public void computeState() {
                this.setEnabled(Application.this.animator.isEnabled() && Application.this.isRunning);
                if (Application.this.animator.isEnabled() && Application.this.isRunning && Application.this.animator.isPaused()) {
                    this.putValue("Name", RESUME_NAME);
                    this.putValue("MnemonicKey", 82);
                    this.putValue("ShortDescription", RESUME_DESCRIPTION);
                } else {
                    this.putValue("Name", PAUSE_NAME);
                    this.putValue("MnemonicKey", 80);
                    this.putValue("ShortDescription", PAUSE_DESCRIPTION);
                }
            }

            public void isRunningChanged() {
                this.computeState();
            }

            public void propertyChange(PropertyChangeEvent e) {
                this.computeState();
            }
        }

        class AnimationOnAction
        extends AbstractAction
        implements Memory.StateChangedListener,
        PropertyChangeListener {
            static final String ON_NAME = "Show Animation";
            static final String OFF_NAME = "Hide Animation";
            static final int ON_MNEMONIC = 65;
            static final int OFF_MNEMONIC = 72;
            static final String ON_DESCRIPTION = "Turn instruction animation on.";
            static final String OFF_DESCRIPTION = "Turn instruction animation off.";

            public AnimationOnAction() {
                this.putValue("Name", ON_NAME);
                this.putValue("MnemonicKey", 65);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", ON_DESCRIPTION);
                this.setEnabled(false);
                ((UI)UI.this).machine.memory.addStateChangedListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                if (Application.this.animator.isEnabled()) {
                    Application.this.animator.setEnabled(false);
                    UI.this.machine.setPauseMilliseconds(Application.this.animator.getDuration());
                    if (Application.this.isRunning) {
                        Application.this.statusBar.showMessage(String.format("Running with %3.1fs duration.", (double)UI.this.machine.getPauseMilliseconds() / 1000.0));
                    } else {
                        Application.this.statusBar.showMessage(String.format("Animation disabled.", new Object[0]));
                    }
                } else {
                    Application.this.animator.setDuration(UI.this.machine.getPauseMilliseconds());
                    if (Application.this.animator.getDuration() < 200) {
                        Application.this.animator.setDuration(1400);
                    }
                    Application.this.animator.setEnabled(true);
                    UI.this.machine.setPauseMilliseconds(0);
                    if (Application.this.isRunning) {
                        Application.this.statusBar.showMessage(String.format("Running with %3.1fs long animation ...", (double)Application.this.animator.getDuration() / 1000.0));
                    } else {
                        Application.this.statusBar.showMessage(String.format("Animation enabled with %3.1fs duration ...", (double)Application.this.animator.getDuration() / 1000.0));
                    }
                }
                this.computeState();
            }

            public void computeState() {
                this.setEnabled(((UI)UI.this).machine.memory.hasLoadedFile());
                if (Application.this.animator.isEnabled()) {
                    this.putValue("Name", OFF_NAME);
                    this.putValue("MnemonicKey", 72);
                    this.putValue("ShortDescription", OFF_DESCRIPTION);
                } else {
                    this.putValue("Name", ON_NAME);
                    this.putValue("MnemonicKey", 65);
                    this.putValue("ShortDescription", ON_DESCRIPTION);
                }
            }

            public void memoryStateChanged() {
                this.computeState();
            }

            public void propertyChange(PropertyChangeEvent e) {
                this.computeState();
            }
        }

        class RunSlowerAction
        extends AbstractAction
        implements IsRunningListener,
        PropertyChangeListener {
            public RunSlowerAction() {
                this.putValue("Name", "Slower");
                this.putValue("MnemonicKey", 83);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(93, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Run slower.");
                this.setEnabled(false);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                if (Application.this.animator.isEnabled()) {
                    Application.this.animator.setDuration(Math.max(200, Application.this.animator.getDuration() + 200));
                    if (Application.this.isRunning) {
                        Application.this.statusBar.showMessage(String.format("Running with %3.1fs long animation ...", (double)Application.this.animator.getDuration() / 1000.0));
                    } else {
                        Application.this.statusBar.showMessage(String.format("Animation is %3.1fs.", (double)Application.this.animator.getDuration() / 1000.0));
                    }
                } else {
                    UI.this.machine.setPauseMilliseconds(Math.max(0, UI.this.machine.getPauseMilliseconds() + 200));
                    Application.this.statusBar.showMessage(String.format("Running with %3.1fs pause ...", (double)UI.this.machine.getPauseMilliseconds() / 1000.0));
                }
                Application.this.fireIsRunningChanged();
            }

            public void computeEnabled() {
                boolean isEnabled = Application.this.animator.isEnabled() ? Application.this.animator.getDuration() < 5000 : Application.this.isRunning && UI.this.machine.getPauseMilliseconds() < 5000;
                this.setEnabled(isEnabled);
            }

            public void isRunningChanged() {
                this.computeEnabled();
            }

            public void propertyChange(PropertyChangeEvent e) {
                this.computeEnabled();
            }
        }

        class RunFasterAction
        extends AbstractAction
        implements IsRunningListener,
        PropertyChangeListener {
            public RunFasterAction() {
                this.putValue("Name", "Faster");
                this.putValue("MnemonicKey", 70);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(91, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Run faster.");
                this.setEnabled(false);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                if (Application.this.animator.isEnabled()) {
                    Application.this.animator.setDuration(Math.max(200, Application.this.animator.getDuration() - 200));
                    if (Application.this.isRunning) {
                        Application.this.statusBar.showMessage(String.format("Running with %3.1fs long animation ...", (double)Application.this.animator.getDuration() / 1000.0));
                    } else {
                        Application.this.statusBar.showMessage(String.format("Animation is %3.1fs.", (double)Application.this.animator.getDuration() / 1000.0));
                    }
                } else {
                    UI.this.machine.setPauseMilliseconds(Math.max(0, UI.this.machine.getPauseMilliseconds() - 200));
                    Application.this.statusBar.showMessage(String.format("Running with %3.1fs pause ...", (double)UI.this.machine.getPauseMilliseconds() / 1000.0));
                }
                Application.this.fireIsRunningChanged();
            }

            public void computeEnabled() {
                boolean isEnabled = Application.this.animator.isEnabled() ? Application.this.animator.getDuration() > 200 : Application.this.isRunning && UI.this.machine.getPauseMilliseconds() > 0;
                this.setEnabled(isEnabled);
            }

            public void isRunningChanged() {
                this.computeEnabled();
            }

            public void propertyChange(PropertyChangeEvent e) {
                this.computeEnabled();
            }
        }

        class RunSlowlyAction
        extends AbstractAction
        implements Memory.StateChangedListener,
        IsRunningListener {
            public RunSlowlyAction() {
                this.putValue("Name", "Run Slowly");
                this.putValue("MnemonicKey", 85);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UI.this.platformAgnosticMetaMask | 1));
                this.putValue("ShortDescription", "Animate running the CPU from current PC.");
                this.setEnabled(false);
                ((UI)UI.this).machine.memory.addStateChangedListener(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        if (Application.this.animator.isEnabled()) {
                            Application.this.animator.resume();
                            UI.this.machine.setPauseMilliseconds(0);
                        } else if (UI.this.machine.getPauseMilliseconds() < 200) {
                            UI.this.machine.setPauseMilliseconds(1400);
                        }
                        Application.this.statusBar.showMessage(String.format("Running with %s ...", Application.this.animator.isEnabled() ? String.format("%3.1fs long animation", (double)Application.this.animator.getDuration() / 1000.0) : String.format("%3.1fs pause", (double)UI.this.machine.getPauseMilliseconds() / 1000.0)));
                        Application.this.setRunning(true);
                        Application.this.statusBar.showMessage(UI.this.machine.run(false, UI.this.machine.getPauseMilliseconds()));
                        Application.this.animator.clear();
                        Application.this.setRunning(false);
                    }
                }.start();
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }

            public void memoryStateChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }
        }

        class RunAction
        extends AbstractAction
        implements Memory.StateChangedListener,
        IsRunningListener {
            public RunAction() {
                this.putValue("Name", "Run");
                this.putValue("MnemonicKey", 82);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Start the CPU running from current PC.");
                this.setEnabled(false);
                ((UI)UI.this).machine.memory.addStateChangedListener(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        Application.this.statusBar.showMessage("Running ...");
                        boolean wasAnimating = Application.this.animator.isEnabled();
                        Application.this.animator.setEnabled(false);
                        Application.this.setRunning(true);
                        Application.this.statusBar.showMessage(UI.this.machine.run(false, 0));
                        Application.this.setRunning(false);
                        Application.this.animator.setEnabled(wasAnimating);
                    }
                }.start();
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }

            public void memoryStateChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }
        }

        class DecreaseFontSizeAction
        extends AbstractAction
        implements IsRunningListener {
            public DecreaseFontSizeAction() {
                this.putValue("Name", "Make Text Smaller");
                this.putValue("MnemonicKey", 83);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Decrease font size of all text.");
                Application.this.isRunningListeners.add(this);
                this.setEnabled(true);
            }

            public void actionPerformed(ActionEvent e) {
                Application.this.mainPane.adjustFontSize(-1);
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning);
            }
        }

        class IncreaseFontSizeAction1
        extends IncreaseFontSizeAction {
            public IncreaseFontSizeAction1() {
                this.putValue("Name", "Make Text Bigger");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, UI.this.platformAgnosticMetaMask | 1));
            }
        }

        class IncreaseFontSizeAction0
        extends IncreaseFontSizeAction {
            public IncreaseFontSizeAction0() {
                this.putValue("Name", "Make Text Bigger");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, UI.this.platformAgnosticMetaMask));
            }
        }

        class IncreaseFontSizeAction
        extends AbstractAction
        implements IsRunningListener {
            public IncreaseFontSizeAction() {
                this.putValue("Name", "Make Text Bigger");
                this.putValue("MnemonicKey", 66);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(521, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Increase font size of all text.");
                Application.this.isRunningListeners.add(this);
                this.setEnabled(true);
            }

            public void actionPerformed(ActionEvent e) {
                Application.this.mainPane.adjustFontSize(1);
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning);
            }
        }

        class RedoAction
        extends AbstractAction
        implements StateChangedListener {
            public RedoAction() {
                this.putValue("Name", "Redo");
                this.putValue("MnemonicKey", 82);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UI.this.platformAgnosticMetaMask | 1));
                this.putValue("ShortDescription", "Redo change.");
                this.setEnabled(Application.this.undoManager.canRedo());
                Application.this.undoManager.addStateChangedListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                Application.this.undoManager.redo();
            }

            public void stateChanged(Object o) {
                assert (o == Application.this.undoManager);
                if (Application.this.undoManager.canRedo()) {
                    this.putValue("Name", Application.this.undoManager.getRedoPresentationName());
                    this.setEnabled(true);
                } else {
                    this.putValue("Name", "Redo");
                    this.setEnabled(false);
                }
            }
        }

        class UndoAction
        extends AbstractAction
        implements StateChangedListener {
            public UndoAction() {
                this.putValue("Name", "Undo");
                this.putValue("MnemonicKey", 85);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Undo last change.");
                this.setEnabled(Application.this.undoManager.canUndo());
                Application.this.undoManager.addStateChangedListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                Application.this.undoManager.undo();
            }

            public void stateChanged(Object o) {
                assert (o == Application.this.undoManager);
                if (Application.this.undoManager.canUndo()) {
                    this.putValue("Name", Application.this.undoManager.getUndoPresentationName());
                    this.setEnabled(true);
                } else {
                    this.putValue("Name", "Undo");
                    this.setEnabled(false);
                }
                this.setEnabled(Application.this.undoManager.canUndo());
            }
        }

        class RestoreDataFromCheckpointAction
        extends AbstractAction
        implements Memory.StateChangedListener,
        IsRunningListener {
            public RestoreDataFromCheckpointAction() {
                this.putValue("Name", "Reset Data");
                this.putValue("MnemonicKey", 82);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Restore all data regions from their most recent checkpoint.");
                Application.this.isRunningListeners.add(this);
                this.setEnabled(false);
                ((UI)UI.this).machine.memory.addStateChangedListener(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                if (Application.this.stopEditing()) {
                    ((UI)UI.this).machine.memory.restoreDataFromCheckpoint();
                    Application.this.statusBar.showMessage("Data restored from most recent checkpoint.");
                }
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }

            public void memoryStateChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }
        }

        class CheckpointDataAction
        extends AbstractAction
        implements Memory.StateChangedListener,
        IsRunningListener {
            public CheckpointDataAction() {
                this.putValue("Name", "Checkpoint Data");
                this.putValue("MnemonicKey", 67);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UI.this.platformAgnosticMetaMask | 1));
                this.putValue("ShortDescription", "Checkpoint data regions.");
                Application.this.isRunningListeners.add(this);
                this.setEnabled(false);
                ((UI)UI.this).machine.memory.addStateChangedListener(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                ((UI)UI.this).machine.memory.checkpointData(true);
                Application.this.statusBar.showMessage("Checkpointed.");
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }

            public void memoryStateChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile());
            }
        }

        class AboutAction
        extends AbstractAction {
            public AboutAction() {
                this.putValue("Name", "About ".concat("Simple Machine"));
                this.putValue("MnemonicKey", 65);
                this.putValue("ShortDescription", "About this application.");
            }

            public void actionPerformed(ActionEvent w) {
                Application.this.showAbout();
            }
        }

        class QuitAction
        extends AbstractAction {
            public QuitAction() {
                this.putValue("Name", IS_MS_WINDOWS ? "Exit" : "Quit");
                this.putValue("MnemonicKey", IS_MS_WINDOWS ? 88 : 81);
                this.putValue("ShortDescription", (IS_MS_WINDOWS ? "Exit" : "Quit").concat(" application."));
                if (!IS_MS_WINDOWS) {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, UI.this.platformAgnosticMetaMask));
                }
            }

            public void actionPerformed(ActionEvent e) {
                if (Application.this.quit()) {
                    System.exit(0);
                }
            }
        }

        class SaveAsAction
        extends AbstractAction
        implements IsRunningListener {
            public SaveAsAction() {
                this.putValue("Name", "Save As...");
                this.putValue("MnemonicKey", 65);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UI.this.platformAgnosticMetaMask | 1));
                this.putValue("ShortDescription", "Save assembly code to specified file.");
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog((Frame)Application.this, "Save As", 1);
                fd.setFilenameFilter(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.matches(".*\\.(s|machine)");
                    }
                });
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    try {
                        ((UI)UI.this).machine.memory.saveToFile(fd.getDirectory().concat(fd.getFile()));
                    }
                    catch (FileNotFoundException fnfe) {
                        Application.this.statusBar.showMessage("File not found.");
                    }
                    Application.this.statusBar.showMessage("Saved to assembly file.");
                }
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning);
            }
        }

        class SaveAction
        extends AbstractAction
        implements Memory.StateChangedListener,
        IsRunningListener {
            public SaveAction() {
                this.putValue("Name", "Save");
                this.putValue("MnemonicKey", 83);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Save assembly code to input file.");
                this.setEnabled(false);
                ((UI)UI.this).machine.memory.addStateChangedListener(this);
                Application.this.isRunningListeners.add(this);
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    ((UI)UI.this).machine.memory.saveToFile(null);
                }
                catch (FileNotFoundException fnfe) {
                    throw new AssertionError();
                }
                Application.this.statusBar.showMessage("Saved to assembly file.");
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile() && ((UI)UI.this).machine.memory.hasUnsavedChanges());
            }

            public void memoryStateChanged() {
                this.setEnabled(!Application.this.isRunning && ((UI)UI.this).machine.memory.hasLoadedFile() && ((UI)UI.this).machine.memory.hasUnsavedChanges());
                Application.this.getRootPane().putClientProperty("Window.documentModified", ((UI)UI.this).machine.memory.hasUnsavedChanges());
            }
        }

        class OpenAction
        extends AbstractAction
        implements IsRunningListener {
            FileDialog aFileDialog;

            public OpenAction() {
                this.putValue("Name", "Open...");
                this.putValue("MnemonicKey", 79);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, UI.this.platformAgnosticMetaMask));
                this.putValue("ShortDescription", "Open an assembly- or machine-lanuage file.");
                Application.this.isRunningListeners.add(this);
                this.aFileDialog = new FileDialog((Frame)Application.this, "Open", 0);
                if (IS_MS_WINDOWS) {
                    this.aFileDialog.setFile("*.s; *.machine");
                }
                this.aFileDialog.setFilenameFilter(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.matches(".*\\.(s|machine)");
                    }
                });
            }

            public void actionPerformed(ActionEvent e) {
                if (Application.this.quit()) {
                    this.aFileDialog.setVisible(true);
                    if (this.aFileDialog.getFile() != null) {
                        String pathname = this.aFileDialog.getDirectory().concat(this.aFileDialog.getFile());
                        Application.this.loadFile(pathname);
                    }
                }
            }

            public void isRunningChanged() {
                this.setEnabled(!Application.this.isRunning);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MasterSelectionListner
        extends Vector<View.SelectionListener>
        implements View.SelectionListener {
            MasterSelectionListner() {
            }

            @Override
            public void selectionMayHaveChanged(boolean isKnownToBeSelected) {
                for (View.SelectionListener l : this) {
                    l.selectionMayHaveChanged(isKnownToBeSelected);
                }
            }
        }

        class StatusBar
        extends JPanel
        implements MessageBoard {
            JLabel label;

            StatusBar() {
                super(new GridLayout(1, 1));
                this.setBorder(new CompoundBorder(new MatteBorder(1, 0, 0, 0, UI.this.statusBarBorder), new EmptyBorder(2, 4, 2, 4)));
                this.setBackground(BACKGROUND_COLOR);
                this.label = new JLabel();
                this.label.setFont(UI.this.statusMessageFont);
                this.label.setHorizontalAlignment(2);
                this.label.setText(" ");
                this.add(this.label);
            }

            public void showMessage(String message) {
                this.label.setText(message != null && !message.trim().equals("") ? message : " ");
            }
        }

        class ToolBar
        extends JToolBar {
            ToolBar() {
                this.setBackground(UI.this.toolBarColor);
                this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, UI.this.toolBarBorder), this.getBorder()));
                this.add(new OpenAction());
                this.add(new SaveAction());
                this.add(new SaveAsAction());
                this.add(new RestoreDataFromCheckpointAction());
                this.add(new CheckpointDataAction());
                this.addSeparator();
                this.add(Application.this.run);
                this.add(new StepAction());
                this.add(new RunSlowlyAction());
                this.addSeparator();
                this.add(new HaltAction());
                if (UI.this.isAnimationAvailable) {
                    this.addSeparator();
                    this.add(Application.this.animationOn);
                    this.add(Application.this.animationPause);
                }
                this.addSeparator();
                this.add(Application.this.runSlower);
                this.add(Application.this.runFaster);
            }
        }

        class MenuBar
        extends JMenuBar {
            MenuBar() {
                JMenu menu = new JMenu("File");
                this.add(menu);
                menu.add(new JMenuItem(new OpenAction()));
                menu.addSeparator();
                menu.add(new JMenuItem(new SaveAction()));
                menu.add(new JMenuItem(new SaveAsAction()));
                menu.addSeparator();
                menu.add(new JMenuItem(new RestoreDataFromCheckpointAction()));
                menu.add(new JMenuItem(new CheckpointDataAction()));
                if (!IS_MAC_OS_X) {
                    menu.addSeparator();
                    menu.add(new JMenuItem(new QuitAction()));
                }
                menu = new JMenu("Edit");
                this.add(menu);
                menu.add(new JMenuItem(new UndoAction()));
                menu.add(new JMenuItem(new RedoAction()));
                menu.addSeparator();
                menu.add(new JMenuItem(new InsertAboveAction()));
                menu.add(new JMenuItem(new InsertBelowAction()));
                menu.add(new JMenuItem(new DeleteAction()));
                menu = new JMenu("View");
                this.add(menu);
                menu.add(new JMenuItem(new IncreaseFontSizeAction()));
                JMenuItem x = new JMenuItem(new IncreaseFontSizeAction0());
                JMenuItem y = new JMenuItem(new IncreaseFontSizeAction1());
                x.setVisible(true);
                y.setVisible(true);
                menu.add(x);
                menu.add(y);
                menu.add(new JMenuItem(new DecreaseFontSizeAction()));
                menu = new JMenu("Run");
                this.add(menu);
                menu.add(new JMenuItem(Application.this.run));
                menu.add(new JMenuItem(new StepAction()));
                menu.add(new JMenuItem(new RunSlowlyAction()));
                menu.addSeparator();
                menu.add(new JMenuItem(new HaltAction()));
                if (UI.this.isAnimationAvailable) {
                    menu.addSeparator();
                    menu.add(new JMenuItem(Application.this.animationOn));
                    menu.add(new JMenuItem(Application.this.animationPause));
                }
                menu.addSeparator();
                menu.add(new JMenuItem(Application.this.runSlower));
                menu.add(new JMenuItem(Application.this.runFaster));
                menu.addSeparator();
                menu.add(new JMenuItem(new ClearHighlightsAction()));
                menu = new JMenu("Debug");
                menu.add(new JMenuItem(new ClearAllBreakpointsAction()));
                this.add(menu);
                if (!IS_MAC_OS_X) {
                    menu = new JMenu("Help");
                    menu.add(new JMenuItem(new AboutAction()));
                    this.add(menu);
                }
            }
        }

        class AboutBox
        extends JDialog {
            final ImageIcon scaledIcon;
            final JLabel image;
            final JLabel title;
            final JLabel version;
            final JLabel jdk;
            final JLabel[] copyright;

            AboutBox() {
                super((Frame)Application.this, "About ".concat("Simple Machine"));
                this.scaledIcon = Application.this.icon != null ? new ImageIcon(Application.this.icon.getImage().getScaledInstance(64, -1, 0)) : null;
                this.image = Application.this.icon != null ? new JLabel(this.scaledIcon) : null;
                this.title = new JLabel("Simple Machine");
                this.version = new JLabel(APPLICATION_VERSION);
                this.jdk = new JLabel("JDK " + System.getProperty("java.version"));
                this.copyright = new JLabel[APPLICATION_COPYRIGHT.length];
                if (this.image != null) {
                    this.image.setAlignmentX(0.5f);
                }
                this.title.setAlignmentX(0.5f);
                this.version.setAlignmentX(0.5f);
                this.jdk.setAlignmentX(0.5f);
                Font font = this.title.getFont().deriveFont(10.0f);
                this.title.setFont(font.deriveFont(14.0f).deriveFont(1));
                this.version.setFont(font);
                this.jdk.setFont(font);
                for (int i = 0; i < APPLICATION_COPYRIGHT.length; ++i) {
                    this.copyright[i] = new JLabel(APPLICATION_COPYRIGHT[i]);
                    this.copyright[i].setFont(font);
                    this.copyright[i].setAlignmentX(0.5f);
                }
                this.setLayout(new BoxLayout(this.getContentPane(), 3));
                if (this.image != null) {
                    this.add(this.image);
                }
                this.add(this.title);
                this.add(Box.createRigidArea(new Dimension(0, 10)));
                this.add(this.version);
                this.add(Box.createRigidArea(new Dimension(0, 10)));
                this.add(this.jdk);
                this.add(Box.createRigidArea(new Dimension(0, 10)));
                for (JLabel cp : this.copyright) {
                    this.add(cp);
                }
                this.add(Box.createRigidArea(new Dimension(0, 12)));
                this.pack();
                this.setSize(new Dimension(282, this.getSize().height));
                this.setResizable(false);
            }
        }
    }

    static interface IsRunningListener {
        public void isRunningChanged();
    }

    static interface StateChangedListener {
        public void stateChanged(Object var1);
    }
}

