/*
 * Decompiled with CFR 0.152.
 */
package ui.cli;

import grammar.CliLexer;
import grammar.CliParser;
import isa.AbstractAssembler;
import isa.Memory;
import isa.MemoryCell;
import isa.Region;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import machine.AbstractMainMemory;
import machine.Register;
import machine.RegisterSet;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import ui.AbstractUI;
import ui.Machine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UI
extends AbstractUI
implements Observer {
    static final String CLI_USAGE = "\t[-t <test-filename>] [-ba <benchmark-arch> -bv <benchmark-variant>] \n\t[-r <reg>[:<count>]]* [-m <addr>[:<count>]]* [-c <state>|all] [-p <start-pc>] [<file>]";
    private static AbstractUI.Env<CliEnv> env = new AbstractUI.Env<CliEnv>(CliEnv.class);
    boolean isTraceProgram;
    CommandHandler cmd;
    final String argBnchArch;
    final String argBnchVariant;
    final Integer argStartPC;
    final String argShowCpuState;
    final List<String> argTestFilenameList;
    final List<String> argLoadFilenameList;
    final List<Integer> argShowRegisterNumberList;
    final List<Integer> argShowRegisterCountList;
    final List<Integer> argShowMemoryAddressList;
    final List<Integer> argShowMemoryCountList;

    public UI(ArrayList<String> args) throws AbstractUI.ArgException {
        super(args);
        String adrCnt;
        String regCnt;
        usageList.add(CLI_USAGE);
        envList.add(env);
        this.isTraceProgram = false;
        this.cmd = new CommandHandler();
        this.machine.addObserver(this);
        this.argStartPC = UI.getArgInt(args, "-p", false, true, null);
        this.argBnchArch = UI.getArg(args, "-ba", false, true, env.valueOf(CliEnv.BENCHMARK_ARCHITECTURE));
        this.argBnchVariant = UI.getArg(args, "-bv", false, true, env.valueOf(CliEnv.BENCHMARK_VARIANT, ""));
        this.argTestFilenameList = UI.getArgList(args, "-t", false, true, true, null);
        this.argShowCpuState = UI.getArg(args, "-c", false, true, null);
        ArrayList<Integer> regList = new ArrayList<Integer>();
        ArrayList<Integer> cntList = new ArrayList<Integer>();
        while ((regCnt = UI.getArg(args, "-r", false, true, null)) != null) {
            String[] parts = regCnt.split(":");
            Register reg = this.machine.registerFile.getRegister(parts[0].replaceAll("%", ""));
            if (reg != null) {
                int count;
                if (parts.length == 1) {
                    count = 1;
                } else if (parts.length == 2) {
                    try {
                        count = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new AbstractUI.ArgException("Invalid register count.");
                    }
                } else {
                    throw new AbstractUI.ArgException("Invalid register interval.");
                }
                regList.add(this.machine.registerFile.getAll().indexOf(reg));
                cntList.add(count);
                continue;
            }
            throw new AbstractUI.ArgException("Invalid register name.");
        }
        this.argShowRegisterNumberList = regList;
        this.argShowRegisterCountList = cntList;
        ArrayList<Integer> addrList = new ArrayList<Integer>();
        ArrayList<Integer> countList = new ArrayList<Integer>();
        while ((adrCnt = UI.getArg(args, "-m", false, true, null)) != null) {
            String[] parts = adrCnt.split(":");
            try {
                int count;
                int radix;
                if (parts[0].substring(0, 2).toLowerCase().equals("0x")) {
                    parts[0] = parts[0].substring(2, parts[0].length());
                    radix = 16;
                } else {
                    radix = 10;
                }
                int addr = Integer.parseInt(parts[0], radix);
                if (parts.length == 1) {
                    count = 1;
                } else if (parts.length == 2) {
                    count = Integer.parseInt(parts[1]);
                } else {
                    throw new NumberFormatException();
                }
                addrList.add(new Integer(addr));
                countList.add(new Integer(count));
            }
            catch (NumberFormatException e) {
                throw new AbstractUI.ArgException("Invalid memory interval.");
            }
        }
        this.argShowMemoryAddressList = addrList;
        this.argShowMemoryCountList = countList;
        this.argLoadFilenameList = new ArrayList<String>();
        while (!args.isEmpty() && !args.get(0).substring(0, 1).equals("-")) {
            this.argLoadFilenameList.add(args.remove(0));
        }
        if (this.argLoadFilenameList.size() > 0 && this.argTestFilenameList.size() > 0) {
            throw new AbstractUI.ArgException("Invalid combination of command-line arguments.");
        }
        if (args.size() != 0) {
            throw new AbstractUI.ArgException("Invalid command-line syntax.");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        System.out.printf("%s\n", this.applicationFullName);
        if (this.argLoadFilenameList.size() > 0) {
            this.runFile();
            return;
        }
        if (this.argTestFilenameList.size() > 0) {
            Iterator<String> i$ = this.argTestFilenameList.iterator();
            while (i$.hasNext()) {
                String file = i$.next();
                this.cmd.test(file, null, null);
            }
            return;
        }
        ConsoleReader in = new ConsoleReader("(sm) ");
        while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = in.readLine()) == null) {
                        System.out.print("\n");
                        return;
                    }
                    StringReader sr = new StringReader(line);
                    ANTLRReaderStream rs = new ANTLRReaderStream(sr);
                    CliLexer lx = new CliLexer(rs);
                    CommonTokenStream tk = new CommonTokenStream(lx);
                    CliParser ps = new CliParser(tk);
                    ps.setCommandHandler(this.cmd);
                    ps.command();
                }
            }
            catch (CliLexer.SyntaxErrorException e) {
                System.out.print("Undefined or malformed command. Try \"help\".\n");
                continue;
            }
            catch (CliParser.SyntaxErrorException e) {
                System.out.print("Undefined or malformed command. Try \"help\".\n");
                continue;
            }
            catch (CommandException e) {
                continue;
            }
            catch (CliParser.QuitException e) {
                return;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            break;
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void runFile() {
        for (String filename : this.argLoadFilenameList) {
            int i;
            this.cmd.load(filename);
            System.out.printf("Running %s, starting at PC 0x%x.\n", filename, (Integer)this.machine.pc.getValueAt(0, 1));
            this.cmd.run();
            for (i = 0; i < this.argShowRegisterNumberList.size(); ++i) {
                for (String dsc : this.regDsc(this.argShowRegisterNumberList.get(i), this.argShowRegisterCountList.get(i))) {
                    System.out.print(dsc);
                }
            }
            for (i = 0; i < this.argShowMemoryAddressList.size(); ++i) {
                for (String dsc : this.memDsc(this.argShowMemoryAddressList.get(i), CliParser.CommandHandler.MemFormat.HEX, EnumSet.allOf(Region.Type.class), this.argShowMemoryCountList.get(i))) {
                    System.out.print(dsc);
                }
            }
            if (this.argShowCpuState == null) continue;
            this.cmd.examineProc(this.argShowCpuState.equalsIgnoreCase("all") ? null : this.argShowCpuState);
        }
    }

    ArrayList<String> memDsc(int addr, CliParser.CommandHandler.MemFormat format, EnumSet<Region.Type> regionSet, int count) {
        ArrayList<String> dsc = new ArrayList<String>();
        int curAddr = addr;
        List<Region> regions = this.machine.memory.getRegions();
        while (curAddr <= addr + (count > 0 ? count : 1) - 1 || count == -1) {
            Region closestRegion = null;
            boolean foundMatch = false;
            for (Region region : regions) {
                if (curAddr >= region.getAddress() && curAddr <= region.getAddress() + region.byteLength() - 1 && regionSet.contains((Object)region.getType())) {
                    MemoryCell cell = region.getCellContainingAddress(curAddr);
                    assert (cell != null);
                    switch (format) {
                        case ASM: {
                            String label = cell.getLabel();
                            String comment = cell.getComment();
                            dsc.add(String.format("%08x:  %-16s %-24s %s\n", cell.getAddress(), label != null && !label.equals("") ? label.concat(":") : "", cell.toAsm(), comment != null && !comment.equals("") ? "# ".concat(comment) : ""));
                            break;
                        }
                        case HEX: {
                            dsc.add(String.format("%08x: %s\n", cell.getAddress(), cell.toMac()));
                        }
                    }
                    curAddr = cell.getAddress() + cell.length();
                    foundMatch = true;
                    break;
                }
                if (curAddr >= region.getAddress() || closestRegion != null && region.getAddress() >= closestRegion.getAddress()) continue;
                closestRegion = region;
            }
            if (foundMatch) continue;
            if (closestRegion == null) break;
            curAddr = closestRegion.getAddress();
        }
        if (dsc.size() == 0) {
            dsc.add("Address out of bounds.\n");
        }
        return dsc;
    }

    ArrayList<String> regDsc(int regNum, int count) {
        List<Register> regs = this.machine.registerFile.getAll();
        ArrayList<String> dsc = new ArrayList<String>();
        if (count == 0) {
            count = 1;
        } else if (count == -1) {
            count = regs.size();
        }
        for (int r = regNum; r < Math.min(regNum + count, regs.size()); ++r) {
            Register reg = regs.get(r);
            dsc.add(String.format("%%%s:  0x%-8x  %d\n", reg.getName(), reg.get(), reg.get()));
        }
        if (dsc.size() == 0) {
            dsc.add("No registers selected.\n");
        }
        return dsc;
    }

    void showStatus(String msg) {
        if (!msg.isEmpty()) {
            System.out.printf("%s\n", msg);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Machine) {
            Machine.Event e = (Machine.Event)arg;
            block0 : switch (e.type) {
                case INSTRUCTION_PROLOG: {
                    if (!this.isTraceProgram) break;
                    this.cmd.showWhere();
                    break;
                }
                case TRACE_POINT: {
                    String pointDsc;
                    Machine.DebugEvent de = (Machine.DebugEvent)e;
                    String pointNam = "?";
                    String pointVal = "?";
                    switch (de.point) {
                        case MEMORY_READ: 
                        case MEMORY_WRITE: {
                            pointNam = String.format("0x%x", de.value);
                            Region region = this.machine.memory.regionForAddress(de.value);
                            if (region == null) break;
                            MemoryCell cell = region.getCellContainingAddress(de.value);
                            assert (cell != null);
                            pointVal = String.format("%s=%s", cell.toAsm(), cell.toMac());
                            break;
                        }
                        case REGISTER_READ: 
                        case REGISTER_WRITE: {
                            Register reg = this.machine.registerFile.getAll().get(de.value);
                            pointNam = "%".concat(reg.getName());
                            pointVal = String.format("0x%x=%d", reg.get(), reg.get());
                        }
                    }
                    switch (de.point) {
                        case INSTRUCTION: {
                            pointDsc = String.format("ins 0x%x", de.value);
                            break;
                        }
                        case MEMORY_READ: {
                            pointDsc = String.format("rd mem[%s]=%s", pointNam, pointVal);
                            break;
                        }
                        case MEMORY_WRITE: {
                            pointDsc = String.format("wr mem[%s]=%s", pointNam, pointVal);
                            break;
                        }
                        case REGISTER_READ: {
                            pointDsc = String.format("rd %s=%s", pointNam, pointVal);
                            break;
                        }
                        case REGISTER_WRITE: {
                            pointDsc = String.format("wr %s=%s", pointNam, pointVal);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    switch (de.debugType) {
                        case BREAK: {
                            System.out.printf("Break %-20s:  ", pointDsc);
                            this.cmd.showWhere();
                            break block0;
                        }
                        case TRACE: {
                            System.out.printf("Trace %-20s:  ", pointDsc);
                            this.cmd.showWhere();
                        }
                    }
                }
            }
        }
    }

    private class CommandHandler
    implements CliParser.CommandHandler {
        private CommandHandler() {
        }

        public void load(String filename) {
            try {
                Integer startPC;
                ((UI)UI.this).machine.memory.loadFile(filename);
                Integer n = startPC = UI.this.argStartPC != null ? UI.this.argStartPC : UI.this.machine.getFirstInstructionAddress();
                if (startPC != null) {
                    UI.this.machine.gotoPC(startPC);
                } else {
                    System.out.print("File has no instructions\n");
                }
            }
            catch (FileNotFoundException e) {
                System.out.print("File not found.\n");
            }
            catch (Memory.FileTypeException fte) {
                System.out.print("Invalid file type.\n");
            }
            catch (Memory.InputFileSyntaxException ifse) {
                System.out.printf("%s\n", ifse.toString());
            }
            catch (Exception ex) {
                throw new AssertionError((Object)ex);
            }
        }

        public void test(String filename, String bnchArch, String bnchVariant) {
            if (bnchArch == null) {
                bnchArch = UI.this.argBnchArch;
            }
            if (bnchVariant == null) {
                bnchVariant = UI.this.argBnchVariant != null ? UI.this.argBnchVariant : "";
            }
            List<String> checkedState = Arrays.asList("cc");
            boolean isSuccessful = false;
            try {
                Integer startPC;
                Machine testMachine = Machine.newInstance(UI.this.machine);
                testMachine.memory.loadFile(filename);
                Integer n = startPC = UI.this.argStartPC != null ? UI.this.argStartPC : testMachine.getFirstInstructionAddress();
                if (startPC == null) {
                    System.out.printf("File has no instructions\n", new Object[0]);
                    throw new CommandException();
                }
                testMachine.gotoPC(startPC);
                Machine bnchMachine = AbstractUI.Config.newMachine(bnchArch, bnchVariant);
                assert (bnchMachine != null);
                bnchMachine.memory.loadFile(filename);
                bnchMachine.gotoPC(startPC);
                System.out.printf("Testing %s against %s.\n", filename, bnchMachine.getName());
                testMachine.run(false, 0);
                bnchMachine.run(false, 0);
                if (testMachine.getStatus() != bnchMachine.getStatus()) {
                    System.out.printf("ISA Status (%s) != Machine Status (%s).", bnchMachine.getStatus().toString(), testMachine.getStatus().toString());
                    return;
                }
                EnumSet<Machine.ComparisonFailure> cmps = testMachine.compareTo(bnchMachine, checkedState);
                if (cmps.isEmpty()) {
                    isSuccessful = true;
                } else {
                    block19: for (Machine.ComparisonFailure cmp : cmps) {
                        switch (cmp) {
                            case REGISTER_FILE_MISMATCH: {
                                System.out.print("ISA Register File != Machine Register File.\n");
                                continue block19;
                            }
                            case PROCESSOR_STATE_MISMATCH: {
                                System.out.print("ISA Processor State != Machine Processor State.\n");
                                continue block19;
                            }
                            case MAIN_MEMORY_MISMATCH: {
                                System.out.print("ISA Memory != Machine Memory.\n");
                                continue block19;
                            }
                        }
                        throw new AssertionError();
                    }
                }
            }
            catch (FileNotFoundException e) {
                System.out.print("File not found.\n");
            }
            catch (Memory.FileTypeException fte) {
                System.out.print("Invalid file type.\n");
            }
            catch (Memory.InputFileSyntaxException ifse) {
                System.out.printf("%s\n", ifse.toString());
            }
            catch (AbstractUI.ArgException e) {
                System.out.printf("Benchmark implementation not found.\n", new Object[0]);
            }
            catch (Throwable ex) {
                throw new AssertionError((Object)ex);
            }
            finally {
                if (isSuccessful) {
                    System.out.printf("ISA Check Succeeds.\n", new Object[0]);
                } else {
                    System.out.printf("ISA Check Fails.\n", new Object[0]);
                }
            }
        }

        public void run() {
            UI.this.showStatus(UI.this.machine.run(false, 0));
        }

        public void step() {
            UI.this.showStatus(UI.this.machine.run(true, 0));
            this.showWhere();
        }

        public void showWhere() {
            System.out.print(UI.this.memDsc((Integer)((UI)UI.this).machine.pc.getValueAt(0, 1), CliParser.CommandHandler.MemFormat.ASM, EnumSet.of(Region.Type.INSTRUCTIONS), 1).get(0));
        }

        public void gotoPC(int pc) {
            UI.this.machine.gotoPC(pc);
        }

        public void examineMem(int count, CliParser.CommandHandler.MemFormat format, int addr) {
            for (String dsc : UI.this.memDsc(addr, format, EnumSet.allOf(Region.Type.class), count)) {
                System.out.print(dsc);
            }
        }

        public void examineMemAll(CliParser.CommandHandler.MemFormat format, CliParser.CommandHandler.MemRegion region) {
            EnumSet<Region.Type> regionSet;
            switch (region) {
                case INS: {
                    regionSet = EnumSet.of(Region.Type.INSTRUCTIONS);
                    break;
                }
                case DAT: {
                    regionSet = EnumSet.of(Region.Type.DATA);
                    break;
                }
                case ALL: {
                    regionSet = EnumSet.allOf(Region.Type.class);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            for (String dsc : UI.this.memDsc(0, format, regionSet, -1)) {
                System.out.print(dsc);
            }
        }

        public void examineReg(int count, int reg) {
            for (String dsc : UI.this.regDsc(reg, count)) {
                System.out.print(dsc);
            }
        }

        public void examineRegAll() {
            for (String dsc : UI.this.regDsc(0, -1)) {
                System.out.print(dsc);
            }
        }

        public void examineProc(String state) {
            for (RegisterSet rs : ((UI)UI.this).machine.processorState) {
                if (state != null && !rs.getName().equalsIgnoreCase(state)) continue;
                if (state == null) {
                    System.out.printf("[%s] CPU State:\n", rs.getName());
                }
                for (Register reg : rs.getAll()) {
                    System.out.printf("%-4s:  0x%-8x  %d\n", reg.getName(), reg.get(), reg.get());
                }
            }
        }

        public void setReg(int regNum, int value) {
            Register reg = ((UI)UI.this).machine.registerFile.getAll().get(regNum);
            reg.set(value);
            reg.tickClock(Register.ClockTransition.NORMAL);
        }

        public void setMem(int addr, int value) {
            if (((UI)UI.this).machine.memory.regionForAddress(addr) != null) {
                try {
                    ((UI)UI.this).machine.mainMemory.writeInteger(addr, value);
                }
                catch (AbstractMainMemory.InvalidAddressException e) {
                    throw new AssertionError();
                }
            } else {
                System.out.printf("Address out of bounds.\n", new Object[0]);
                throw new CommandException();
            }
        }

        public void setIns(int addr, CliParser.CommandHandler.InsOper oper, String value) {
            Region region = ((UI)UI.this).machine.memory.regionForAddress(addr);
            if (region == null) {
                System.out.printf("Address out of bounds.\n", new Object[0]);
                throw new CommandException();
            }
            if (region.getType() != Region.Type.INSTRUCTIONS) {
                System.out.printf("Address is not in code section of memory.\n", new Object[0]);
                throw new CommandException();
            }
            int row = region.getRowIndexForAddress(addr);
            int col = region.getAsmColumn();
            try {
                switch (oper) {
                    case INSERT: {
                        region.insertRow(row);
                        break;
                    }
                    case DELETE: {
                        region.deleteRow(row);
                        break;
                    }
                }
                switch (oper) {
                    case INSERT: 
                    case REPLACE: {
                        Region.AssemblyString as = (Region.AssemblyString)region.getValueAt(row, col);
                        as.setValue(value);
                        region.setValueAt(as, row, col);
                        break;
                    }
                }
            }
            catch (AbstractAssembler.AssemblyException e) {
                switch (oper) {
                    case INSERT: {
                        region.deleteRow(row);
                        break;
                    }
                }
                System.out.printf("%s\n", e.toString());
                throw new CommandException();
            }
        }

        public void debugPoint(CliParser.CommandHandler.DebugType cmdType, CliParser.CommandHandler.DebugPoint cmdPoint, boolean isEnabled, int value) {
            switch (cmdPoint) {
                case MEMORY_ACCESS: {
                    this.debugPoint(cmdType, CliParser.CommandHandler.DebugPoint.MEMORY_READ, isEnabled, value);
                    this.debugPoint(cmdType, CliParser.CommandHandler.DebugPoint.MEMORY_WRITE, isEnabled, value);
                    break;
                }
                case REGISTER_ACCESS: {
                    this.debugPoint(cmdType, CliParser.CommandHandler.DebugPoint.REGISTER_READ, isEnabled, value);
                    this.debugPoint(cmdType, CliParser.CommandHandler.DebugPoint.REGISTER_WRITE, isEnabled, value);
                    break;
                }
                case INSTRUCTION: 
                case MEMORY_READ: 
                case MEMORY_WRITE: 
                case REGISTER_READ: 
                case REGISTER_WRITE: {
                    Machine.DebugType type;
                    switch (cmdType) {
                        case BREAK: {
                            type = Machine.DebugType.BREAK;
                            break;
                        }
                        case TRACE: {
                            type = Machine.DebugType.TRACE;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    Machine.DebugPoint point = null;
                    switch (cmdPoint) {
                        case INSTRUCTION: {
                            point = Machine.DebugPoint.INSTRUCTION;
                            break;
                        }
                        case MEMORY_READ: {
                            point = Machine.DebugPoint.MEMORY_READ;
                            break;
                        }
                        case MEMORY_WRITE: {
                            point = Machine.DebugPoint.MEMORY_WRITE;
                            break;
                        }
                        case REGISTER_READ: {
                            point = Machine.DebugPoint.REGISTER_READ;
                            break;
                        }
                        case REGISTER_WRITE: {
                            point = Machine.DebugPoint.REGISTER_WRITE;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    switch (point) {
                        case INSTRUCTION: {
                            boolean badAddress = false;
                            Region r = ((UI)UI.this).machine.memory.regionForAddress(value);
                            if (r == null || r.getType() != Region.Type.INSTRUCTIONS) {
                                badAddress = true;
                            } else {
                                MemoryCell c = r.getCellContainingAddress(value);
                                boolean bl = badAddress = c == null || c.getAddress() != value;
                            }
                            if (!badAddress) break;
                            System.out.printf("Invalid memory address for break point.\n", new Object[0]);
                            throw new CommandException();
                        }
                        case MEMORY_READ: 
                        case MEMORY_WRITE: {
                            if (((UI)UI.this).machine.memory.regionForAddress(value) != null) break;
                            System.out.printf("Address out of bounds.\n", new Object[0]);
                            throw new CommandException();
                        }
                    }
                    UI.this.machine.setDebugPoint(type, point, value, isEnabled);
                }
            }
        }

        public void traceProg(boolean isEnabled) {
            UI.this.isTraceProgram = isEnabled;
        }

        public void clearDebugPoints(CliParser.CommandHandler.DebugType cmdType) {
            Machine.DebugType type;
            switch (cmdType) {
                case BREAK: {
                    type = Machine.DebugType.BREAK;
                    break;
                }
                case TRACE: {
                    type = Machine.DebugType.TRACE;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            UI.this.machine.clearAllDebugPoints(type);
        }

        public void showDebugPoints(CliParser.CommandHandler.DebugType cmdType) {
            Machine.DebugType type;
            switch (cmdType) {
                case BREAK: {
                    type = Machine.DebugType.BREAK;
                    break;
                }
                case TRACE: {
                    type = Machine.DebugType.TRACE;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            boolean typeShown = false;
            for (Machine.DebugPoint point : EnumSet.allOf(Machine.DebugPoint.class)) {
                boolean pointShown = false;
                for (Integer value : UI.this.machine.getDebugPoints(type, point)) {
                    String valueString = "";
                    switch (point) {
                        case MEMORY_READ: 
                        case MEMORY_WRITE: 
                        case INSTRUCTION: {
                            valueString = String.format("0x%x", value);
                            break;
                        }
                        case REGISTER_READ: 
                        case REGISTER_WRITE: {
                            valueString = "%".concat(((UI)UI.this).machine.registerFile.getAll().get(value).getName());
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    System.out.printf("%-5s %-14s %s\n", !typeShown ? type.toString() : "", !pointShown ? point.toString() : "", valueString);
                    typeShown = true;
                    pointShown = true;
                }
            }
        }

        public void help() {
            System.out.print("  l|load <file>|\"<file>\"\n");
            System.out.print("  test <file> [<against-arch> [<against-variant>]]\n");
            System.out.print("  r|run\n");
            System.out.print("  s|step\n");
            System.out.print("  w|where\n");
            System.out.print("  g|goto <pc>\n");
            System.out.print("  e|examine[/x] <mem-address> [: <count>]\n");
            System.out.print("  e|examine     <register> [: <count>]\n");
            System.out.print("  i|info[/x] mem|ins|dat\n");
            System.out.print("  i|info reg\n");
            System.out.print("  i|info cpu [state]\n");
            System.out.print("  <regiser> = <new-value>\n");
            System.out.print("  m <mem-address> = <new-numeric-value>\n");
            System.out.print("  i <mem-address> = <replacement-instruction>\n");
            System.out.print("  i <mem-address> + <insertion-instruction>\n");
            System.out.print("  i <mem-address> -\n");
            System.out.print("  [no]break|trace x <instruction-address>\n");
            System.out.print("  [no]break|trace r|w|a <memory-address>|<register>\n");
            System.out.print("  [no]trace prog\n");
            System.out.print("  clear break|trace\n");
            System.out.print("  i|info break|trace\n");
            System.out.print("  quit\n");
        }

        public int getRegisterNumber(String registerName) {
            Register reg = ((UI)UI.this).machine.registerFile.getRegister(registerName);
            if (reg != null) {
                return ((UI)UI.this).machine.registerFile.getAll().indexOf(reg);
            }
            System.out.printf("Invalid register name.\n", new Object[0]);
            throw new CommandException();
        }

        public int getLabelValue(String label) {
            Integer value = ((UI)UI.this).machine.memory.getLabelMap().getAddress(label);
            if (value != null) {
                return value;
            }
            System.out.printf("Undefined label.\n", new Object[0]);
            throw new CommandException();
        }
    }

    class CommandException
    extends RuntimeException {
        CommandException() {
        }
    }

    class ConsoleReader {
        String prompt;
        boolean isUsingJline = false;
        Object jlineConsoleReader;
        Method jlineConsoleReaderReadLine;
        BufferedReader bufferedReader;

        ConsoleReader(String aPrompt) {
            this.prompt = aPrompt;
            try {
                Class<?> jlineConsoleReaderClass = Class.forName("jline.ConsoleReader");
                this.jlineConsoleReader = jlineConsoleReaderClass.newInstance();
                this.jlineConsoleReaderReadLine = jlineConsoleReaderClass.getMethod("readLine", String.class);
                this.isUsingJline = true;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (!this.isUsingJline) {
                InputStreamReader ins = new InputStreamReader(System.in);
                this.bufferedReader = new BufferedReader(ins);
            }
        }

        String readLine() throws IOException {
            if (this.isUsingJline) {
                try {
                    return (String)this.jlineConsoleReaderReadLine.invoke(this.jlineConsoleReader, this.prompt);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError();
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (te instanceof IOException) {
                        throw (IOException)te;
                    }
                    throw new AssertionError((Object)e);
                }
            }
            System.out.printf(this.prompt, new Object[0]);
            return this.bufferedReader.readLine();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CliEnv {
        BENCHMARK_ARCHITECTURE,
        BENCHMARK_VARIANT;

    }
}

