/*
 * Decompiled with CFR 0.152.
 */
package isa;

import isa.AbstractAssembler;
import isa.Datum;
import isa.Instruction;
import isa.Memory;
import isa.MemoryCell;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import util.AbstractDataModel;
import util.BitString;
import util.DataModelEvent;
import util.TableCellIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Region
extends AbstractDataModel {
    private Type type;
    Memory memory;
    Vector<MemoryCell> rows;
    SortedMap<Integer, MemoryCell> map;
    private Vector<ByteLengthChangedListener> byteLengthChangedListeners = new Vector();

    Region(Memory aMemory, Type aType) {
        this.memory = aMemory;
        this.type = aType;
        this.rows = new Vector();
        this.map = new TreeMap<Integer, MemoryCell>();
    }

    public boolean valueEquals(Region aRegion) {
        boolean equalSoFar = this.rows.size() == aRegion.rows.size();
        for (int i = 0; equalSoFar && i < this.rows.size(); equalSoFar &= this.rows.get(0).valueEquals(aRegion.rows.get(0)), ++i) {
        }
        return equalSoFar;
    }

    public Vector<MemoryCell> getSavableRows() {
        return this.rows;
    }

    public Type getType() {
        return this.type;
    }

    public int length() {
        return this.rows.size();
    }

    public int getAddress() {
        return this.map.size() > 0 ? ((MemoryCell)this.map.get(this.map.firstKey())).getAddress() : 0;
    }

    public int byteLength() {
        if (this.map.size() > 0) {
            MemoryCell lastCell = (MemoryCell)this.map.get(this.map.lastKey());
            return lastCell.getAddress() + lastCell.length() - this.getAddress();
        }
        return 0;
    }

    public MemoryCell getCellForRowIndex(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public int getRowIndexForAddress(int address) {
        return this.rows.indexOf(this.map.get(address));
    }

    public MemoryCell getCellContainingAddress(int address) {
        MemoryCell cell = (MemoryCell)this.map.get(address);
        if (cell != null) {
            return cell;
        }
        for (MemoryCell c : this.rows) {
            if (address < c.getAddress() || address > c.getAddress() + c.length() - 1) continue;
            return c;
        }
        return null;
    }

    private void changeCellAddresses(int startingRow, int addressDelta) {
        MemoryCell cell;
        int r;
        assert (startingRow >= 0 && startingRow < this.rows.size());
        for (r = startingRow; r < this.rows.size(); ++r) {
            cell = this.rows.get(r);
            int adr = cell.getAddress();
            this.map.remove(adr);
            cell.setAddress(adr + addressDelta);
        }
        for (r = startingRow; r < this.rows.size(); ++r) {
            cell = this.rows.get(r);
            this.map.put(cell.getAddress(), cell);
            cell.syncToMemory();
            this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, r, 0));
        }
        Vector<MemoryCell> cells = new Vector<MemoryCell>();
        for (int r2 = startingRow; r2 < this.rows.size(); ++r2) {
            cells.add(this.rows.get(r2));
        }
        this.memory.getLabelMap().changeAddresses(cells);
        if (addressDelta > 0) {
            this.memory.fireInserted(this.rows.get(startingRow).getAddress() - addressDelta, addressDelta, this.getAddress() + this.byteLength() - 1);
        } else {
            this.memory.fireDeleted(this.rows.get(startingRow).getAddress(), -addressDelta, this.getAddress() + this.byteLength() - 1 - addressDelta);
        }
    }

    @Override
    public boolean insertRow(int row) {
        assert (row >= 0 && row <= this.rows.size());
        int adr = row < this.rows.size() ? this.rows.get(row).getAddress() : this.rows.get(row - 1).getAddress() + this.rows.get(row - 1).length();
        MemoryCell cell = this.newPlaceholderCell(adr);
        this.memory.addUndo(new UndoInsert(row, cell));
        this.insertCell(row, cell);
        this.memory.setChanged(true);
        return true;
    }

    private void insertCell(int row, MemoryCell cell) {
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.CHANGING, this.getAllCellsInRow(row)));
        this.rows.insertElementAt(cell, row);
        if (row + 1 < this.rows.size()) {
            this.changeCellAddresses(row + 1, cell.length());
        }
        this.map.put(cell.getAddress(), cell);
        this.memory.getLabelMap().add(cell);
        this.fireByteLengthChanged();
        cell.syncToMemory();
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.ROWS_INSERTED, row, row));
    }

    @Override
    public boolean canInsertRow(int row) {
        return true;
    }

    @Override
    public boolean deleteRow(int row) {
        assert (row >= 0 && row < this.rows.size());
        if (this.canDeleteRow(row)) {
            MemoryCell cell = this.rows.get(row);
            this.memory.addUndo(new UndoDelete(row, cell));
            this.deleteCell(row);
            this.memory.setChanged(true);
            return true;
        }
        return false;
    }

    private void deleteCell(int row) {
        assert (this.canDeleteRow(row));
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.CHANGING, this.getAllCellsInRow(row)));
        MemoryCell cell = this.rows.get(row);
        this.map.remove(cell.getAddress());
        this.rows.removeElementAt(row);
        if (row < this.rows.size()) {
            this.changeCellAddresses(row, -cell.length());
        }
        this.memory.getLabelMap().remove(cell);
        this.fireByteLengthChanged();
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.ROWS_DELETED, row, row));
    }

    @Override
    public boolean canDeleteRow(int row) {
        return this.rows.size() > 1;
    }

    protected void add(MemoryCell cell) {
        assert (this.type == Type.INSTRUCTIONS && cell instanceof Instruction || this.type == Type.DATA && cell instanceof Datum);
        Integer cellAddress = cell.getAddress();
        MemoryCell existingCell = (MemoryCell)this.map.get(cellAddress);
        if (existingCell == null || !existingCell.equals(cell)) {
            int oldRegionLength = this.byteLength();
            if (existingCell != null) {
                int oldLength = existingCell.length();
                existingCell.copyFrom(cell);
                cell = existingCell;
                int row = this.rows.indexOf(cell);
                if (row != this.rows.size() - 1 && oldLength != cell.length()) {
                    this.changeCellAddresses(row + 1, cell.length() - oldLength);
                }
                cell.syncToMemory();
                this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, this.getAllCellsInRow(this.map.size())));
            } else {
                this.map.put(cellAddress, cell);
                if (this.map.lastKey() == cellAddress) {
                    this.rows.add(cell);
                    this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, this.getAllCellsInRow(this.map.size())));
                } else {
                    this.rebuildRows();
                }
            }
            cell.syncToMemory();
            this.memory.getLabelMap().add(cell);
            if (this.byteLength() != oldRegionLength) {
                this.fireByteLengthChanged();
            }
        }
    }

    protected void replace(Vector<MemoryCell> removeCells, Vector<MemoryCell> addCells) {
        if (removeCells != null) {
            for (MemoryCell cell : removeCells) {
                this.map.remove(cell.getAddress());
                this.memory.getLabelMap().remove(cell);
            }
        }
        if (addCells != null) {
            for (MemoryCell cell : addCells) {
                this.map.put(cell.getAddress(), cell);
                this.memory.getLabelMap().add(cell);
            }
        }
        this.rebuildRows();
    }

    DataModelEvent update(DataModelEvent event) {
        boolean changed = false;
        HashSet<MemoryCell> affectedCells = new HashSet<MemoryCell>();
        Vector<TableCellIndex> mc = new Vector<TableCellIndex>();
        for (TableCellIndex tableCell : event.getCells()) {
            MemoryCell memoryCell;
            int address = tableCell.rowIndex;
            if (this.type == Type.DATA) {
                address = address >>> 2 << 2;
            }
            if (address < this.getAddress() || address > this.getAddress() + this.byteLength() - 1 || (memoryCell = this.getCellContainingAddress(address)) == null) continue;
            affectedCells.add(memoryCell);
            if (this.isMemoryValueColumn(tableCell.columnIndex)) continue;
            this.memory.setChanged(true);
        }
        for (MemoryCell cell : affectedCells) {
            if (event.getType() == DataModelEvent.Type.WRITE || event.getType() == DataModelEvent.Type.WRITE_BY_USER) {
                int len = cell.length();
                if (cell.syncFromMemory()) {
                    changed = true;
                    if (cell.length() != len) {
                        this.memorySyncChangedCellLength(cell, len);
                    }
                    if (this.type == Type.INSTRUCTIONS) {
                        this.memory.setChanged(true);
                    }
                }
            }
            this.tellObservers(new DataModelEvent(event.getType(), this.getAllCellsInRow(this.rows.indexOf(cell))));
            for (int i = 0; i < cell.length(); ++i) {
                mc.add(new TableCellIndex(cell.getAddress() + i, 1));
            }
        }
        return new DataModelEvent(event.getType(), mc);
    }

    abstract boolean isMemoryValueColumn(int var1);

    abstract void memorySyncChangedCellLength(MemoryCell var1, int var2);

    void rebuildRows() {
        Vector<MemoryCell> oldRows = this.rows;
        this.rows = new Vector<MemoryCell>(this.map.values());
        for (MemoryCell cell : this.rows) {
            int newIndex = this.rows.indexOf(cell);
            if (newIndex < oldRows.size() && cell.equals(oldRows.get(newIndex))) continue;
            this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, this.getAllCellsInRow(newIndex)));
        }
    }

    void syncMemoryFromAsm() {
        for (MemoryCell cell : this.rows) {
            if (!cell.memoryResyncedFromAsm() || this.getAsmColumn() < 0) continue;
            this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, this.rows.indexOf(cell), this.getAsmColumn()));
        }
    }

    void syncAsmFromMemory() {
        for (MemoryCell cell : this.rows) {
            if (!cell.asmResyncedFromMemory() || this.getAsmColumn() < 0) continue;
            this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, this.rows.indexOf(cell), this.getAsmColumn()));
        }
    }

    List<TableCellIndex> getAllCellsInRow(int row) {
        Vector<TableCellIndex> cells = new Vector<TableCellIndex>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            cells.add(new TableCellIndex(row, i));
        }
        return cells;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public void addByteLengthChangedListener(ByteLengthChangedListener l) {
        this.byteLengthChangedListeners.add(l);
    }

    protected void fireByteLengthChanged() {
        for (ByteLengthChangedListener l : this.byteLengthChangedListeners) {
            l.byteLengthChanged();
        }
    }

    abstract MemoryCell newPlaceholderCell(int var1);

    public abstract int getAsmColumn();

    class UndoDelete
    extends Memory.Undo {
        int row;
        MemoryCell cell;

        public UndoDelete(int aRow, MemoryCell aCell) {
            super(String.format("Delete Row %d", aRow), true);
            this.row = aRow;
            this.cell = aCell;
        }

        public void undo() {
            super.undo();
            Region.this.insertCell(this.row, this.cell);
        }

        public void redo() {
            super.redo();
            Region.this.deleteCell(this.row);
            Region.this.memory.setChanged(true);
        }
    }

    class UndoInsert
    extends Memory.Undo {
        int row;
        MemoryCell cell;

        public UndoInsert(int aRow, MemoryCell aCell) {
            super(String.format("Insert Row %d", aRow), true);
            this.row = aRow;
            this.cell = aCell;
        }

        public void undo() {
            super.undo();
            Region.this.deleteCell(this.row);
        }

        public void redo() {
            super.redo();
            Region.this.insertCell(this.row, this.cell);
            Region.this.memory.setChanged(true);
        }
    }

    class UndoChange
    extends Memory.Undo {
        int row;
        int column;
        UndoChangeType type;
        Object value;

        public UndoChange(String aName, int aRow, int aColumn, UndoChangeType aType, Object aValue) {
            super(aName, true);
            this.type = aType;
            this.row = aRow;
            this.column = aColumn;
            this.value = aValue;
        }

        public UndoChange(String aName, int aRow, int aColumn, UndoChangeType aType) {
            super(aName, true);
            this.type = aType;
            this.row = aRow;
            this.column = aColumn;
            this.value = this.getCellValue();
        }

        private Object getCellValue() {
            MemoryCell cell = Region.this.rows.get(this.row);
            if (this.type == UndoChangeType.LABEL) {
                return cell.getLabel();
            }
            if (this.type == UndoChangeType.VALUE) {
                return cell.getValue();
            }
            if (this.type == UndoChangeType.COMMENT) {
                return cell.getComment();
            }
            throw new AssertionError((Object)this.type);
        }

        private void setCellValue() {
            MemoryCell cell = Region.this.rows.get(this.row);
            Region.this.tellObservers(new DataModelEvent(DataModelEvent.Type.CHANGING, this.row, this.column));
            Object v = this.getCellValue();
            if (this.type == UndoChangeType.LABEL) {
                cell.setLabel((String)this.value);
            } else if (this.type == UndoChangeType.VALUE) {
                cell.setValue((BitString)this.value);
                cell.syncToMemory();
            } else if (this.type == UndoChangeType.COMMENT) {
                cell.setComment((String)this.value);
            } else {
                throw new AssertionError((Object)this.type);
            }
            this.value = v;
            Region.this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, this.row, this.column));
        }

        public void undo() {
            super.undo();
            this.setCellValue();
        }

        public void redo() {
            super.redo();
            this.setCellValue();
            Region.this.memory.setChanged(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UndoChangeType {
        LABEL,
        VALUE,
        COMMENT;

    }

    public static interface ByteLengthChangedListener {
        public void byteLengthChanged();
    }

    public class LabelString {
        int address;
        String value;

        public LabelString(int anAddress, String aValue) {
            this.address = anAddress;
            this.value = aValue;
        }

        public String toString() {
            return this.value;
        }

        public void setValue(String text) throws AbstractAssembler.AssemblyException {
            if (!text.trim().equals(this.value)) {
                Integer curAddress = Region.this.memory.getLabelMap().getAddress(text);
                if (curAddress != null && curAddress != this.address) {
                    throw new AbstractAssembler.AssemblyException("Duplicate label.");
                }
                Region.this.memory.checkAssemblyLabelSyntax(text);
                this.value = text;
            }
        }
    }

    public class AssemblyString {
        int address;
        boolean changed = false;
        String label;
        String value;
        String comment;

        public AssemblyString(int anAddress, String aLabel, String aValue, String aComment) {
            this.address = anAddress;
            this.label = aLabel;
            this.value = aValue;
            this.comment = aComment;
        }

        private String selectedValue() {
            return this.value.trim().equals("nop") ? "" : this.value.trim();
        }

        public String toString() {
            return this.value;
        }

        public String toSelectedString() {
            return this.selectedValue();
        }

        public void setValue(String text) throws AbstractAssembler.AssemblyException {
            if (!text.trim().equals(this.value.trim()) && !text.trim().equals(this.selectedValue())) {
                Region.this.memory.checkAssemblyLineSyntax(this.address, this.label, text, this.comment);
                this.value = text;
                this.changed = true;
            }
        }

        public boolean hasChanged() {
            return this.changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INSTRUCTIONS,
        DATA;

    }
}

