/*
 * Decompiled with CFR 0.152.
 */
package isa;

import isa.Memory;
import util.BitStream;
import util.BitString;

public abstract class MemoryCell {
    protected Memory memory;
    protected int address;
    protected BitString value;
    protected String label;
    protected String comment;
    protected BitString checkpointValue;

    public MemoryCell(Memory aMemory, int anAddress, BitString aValue, String aLabel, String aComment) {
        this.memory = aMemory;
        this.address = anAddress;
        this.value = aValue;
        this.label = aLabel;
        this.comment = aComment;
        this.checkpointValue = null;
    }

    public boolean valueEquals(MemoryCell aMemoryCell) {
        return this.value.equals(aMemoryCell.value);
    }

    public void copyFrom(MemoryCell aCell) {
        this.memory = aCell.memory;
        this.address = aCell.address;
        this.value = aCell.value;
        this.label = aCell.label;
        this.comment = aCell.comment;
        this.checkpointValue = aCell.checkpointValue;
    }

    public void checkpointValue() {
        this.checkpointValue = this.value;
    }

    public void restoreValueFromCheckpoint() {
        if (this.checkpointValue != null && !this.checkpointValue.equals(this.value)) {
            this.checkpointValue.writeToByUser(this.memory, this.address);
        }
    }

    public int getAddress() {
        return this.address;
    }

    BitString getValue() {
        return this.value;
    }

    BitString getSavableValue() {
        return this.checkpointValue != null ? this.checkpointValue : this.value;
    }

    public int length() {
        return this.value.byteLength();
    }

    public String getLabel() {
        return this.label;
    }

    public String getComment() {
        return this.comment;
    }

    void setAddress(int anAddress) {
        this.address = anAddress;
    }

    void setLabel(String aLabel) {
        this.label = aLabel;
        this.memory.getLabelMap().add(this);
    }

    void setValue(BitString aValue) {
        this.value = aValue;
    }

    void setComment(String aComment) {
        this.comment = aComment;
    }

    void syncToMemory() {
        BitString memValue = new BitStream(this.memory, this.address).getValue(this.value.length());
        if (!this.value.equals(memValue)) {
            this.value.writeToByUser(this.memory, this.address);
        }
    }

    boolean syncFromMemory() {
        BitString memValue = new BitStream(this.memory, this.address).getValue(this.value.length());
        if (!memValue.equals(this.value)) {
            this.value = memValue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof MemoryCell) {
            MemoryCell cell = (MemoryCell)o;
            return this.getAddress() == cell.getAddress() && this.getValue().equals(cell.getValue()) && this.getLabel().equals(cell.getLabel()) && this.getComment().equals(cell.getComment());
        }
        return false;
    }

    public int hashCode() {
        return this.getAddress() + this.getValue().hashCode() + this.getLabel().hashCode() + this.getComment().hashCode();
    }

    public abstract String toAsm();

    abstract String toSavableAsm();

    public abstract String toMac();

    abstract boolean memoryResyncedFromAsm();

    abstract boolean asmResyncedFromMemory();
}

