/*
 * Decompiled with CFR 0.152.
 */
package isa;

import isa.AbstractAssembler;
import isa.AbstractISA;
import isa.Memory;
import isa.MemoryCell;
import util.BitStream;
import util.BitString;
import util.IntStream;

public class Instruction
extends MemoryCell {
    private AbstractISA.InstructionDef def;
    private String lastRequestedAsm;

    Instruction(Memory aMemory, Integer anAddress, AbstractISA.InstructionDef aDef, BitString aValue, String aLabel, String aComment) {
        super(aMemory, anAddress, aValue, aLabel, aComment);
        assert (aValue != null);
        this.def = aDef;
        this.lastRequestedAsm = null;
        this.toAsm();
    }

    public static Instruction valueOfMemory(Memory memory, int address, String label, String comment) {
        AbstractISA.InstructionDef def = memory.getInstructionDefForValue(address);
        if (def != null) {
            BitString value = new BitStream(memory, address).getValue(def.getLayout().length());
            return new Instruction(memory, address, def, value, label, comment);
        }
        return null;
    }

    public void copyFrom(MemoryCell aCell) {
        super.copyFrom(aCell);
        Instruction ins = (Instruction)aCell;
        this.def = ins.def;
        this.lastRequestedAsm = ins.lastRequestedAsm;
    }

    public static Instruction valueOfPlaceholder(Memory memory, int address, String label, String comment) {
        return new Instruction(memory, address, memory.getPlaceholderInstructionDef(), memory.getPlaceholderInstructionValue(), label, comment);
    }

    public static Instruction valueOf(Memory memory, int address, int opCode, int[] operands, String label, String comment) {
        AbstractISA.InstructionDef def = memory.getInstructionDefForOpCode(opCode);
        if (def != null) {
            return new Instruction(memory, address, def, def.getValue(new IntStream(operands), address), label, comment);
        }
        return null;
    }

    boolean syncFromMemory() {
        boolean hasChanged = super.syncFromMemory();
        if (hasChanged) {
            this.def = this.memory.getInstructionDefForValue(this.address);
            if (this.def != null) {
                this.value = new BitStream(this.memory, this.address).getValue(this.def.getLayout().length());
            }
        }
        return hasChanged;
    }

    private void syncAsmToMemory(String asm) {
        try {
            this.memory.loadAssemblyLine(this.address, this.label, asm, this.comment);
            this.lastRequestedAsm = asm;
        }
        catch (AbstractAssembler.AssemblyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toAsm() {
        this.lastRequestedAsm = this.def != null ? this.def.getLayout().toAsm(this.value, 0, this.address) : "";
        return this.lastRequestedAsm;
    }

    String toSavableAsm() {
        this.lastRequestedAsm = this.def != null ? this.def.getLayout().toAsm(this.getSavableValue(), 0, this.address) : "";
        return this.lastRequestedAsm;
    }

    String toDsc() {
        return this.def != null ? this.def.getLayout().toDsc(this.value, 0, this.address) : "";
    }

    public String toMac() {
        return this.def != null ? this.def.getLayout().toMac(this.value, 0, this.address) : "?";
    }

    boolean memoryResyncedFromAsm() {
        String asmTruth = this.lastRequestedAsm;
        if (this.lastRequestedAsm != null && !this.lastRequestedAsm.equals(this.toAsm())) {
            this.syncAsmToMemory(asmTruth);
            return true;
        }
        return false;
    }

    boolean asmResyncedFromMemory() {
        return this.lastRequestedAsm != null && !this.lastRequestedAsm.equals(this.toAsm());
    }
}

