/*
 * Decompiled with CFR 0.152.
 */
package isa;

import isa.AbstractAssembler;
import isa.Memory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import util.BitStream;
import util.BitString;
import util.IntStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractISA {
    private String name;
    private Endianness endianness;
    private AbstractAssembler assembler;
    private Map<Integer, InstructionDef> isaDef;
    private Map<Integer, String> addressToLabelMap;
    private InstructionDef placeholderInstructionDef = null;
    private BitString placeholderInstructionValue = null;

    public AbstractISA(String aName, Endianness anEndianness, AbstractAssembler anAssembler) {
        this.name = aName;
        this.assembler = anAssembler;
        this.endianness = anEndianness;
        this.isaDef = new HashMap<Integer, InstructionDef>();
        this.addressToLabelMap = null;
    }

    void setAddressToLabelMap(Map<Integer, String> aMap) {
        this.addressToLabelMap = aMap;
    }

    public String getName() {
        return this.name;
    }

    protected void define(int opCode, InsLayout layout) {
        this.isaDef.put(new Integer(opCode), new InstructionDef(opCode, layout));
    }

    protected void setPlaceholderInstruction(int opCode) {
        this.placeholderInstructionDef = this.isaDef.get(opCode);
        assert (this.placeholderInstructionDef != null);
        this.placeholderInstructionValue = this.placeholderInstructionDef.getValue(new IntStream(0), 0);
    }

    public InstructionDef getPlaceholderInstructionDef() {
        assert (this.placeholderInstructionDef != null);
        return this.placeholderInstructionDef;
    }

    public BitString getPlaceholderInstructionValue() {
        assert (this.placeholderInstructionValue != null);
        return this.placeholderInstructionValue;
    }

    int signExtend(int value, int length) {
        return value << 32 - length >> 32 - length;
    }

    InstructionDef getDefForOpCode(int opCode) {
        return this.isaDef.get(opCode);
    }

    InstructionDef getDefForValue(BitStream mem) {
        for (InstructionDef def : this.isaDef.values()) {
            mem.rewind();
            if (def.getValue(mem) == null) continue;
            return def;
        }
        return null;
    }

    public int normalizeEndianness(int num, int byteSize) {
        int normalizedNum = 0;
        switch (this.endianness) {
            case BIG: {
                normalizedNum = num;
                break;
            }
            case LITTLE: {
                for (int b = 0; b < byteSize; ++b) {
                    normalizedNum = normalizedNum << 8 | num >> b * 8 & 0xFF;
                }
                break;
            }
        }
        return normalizedNum;
    }

    void assembleFile(String filename, Memory memory) throws AbstractAssembler.AssemblyException, FileNotFoundException, IOException {
        this.assembler.assembleFile(filename, memory);
    }

    void assembleLine(int address, String label, String statement, String comment, Memory memory) throws AbstractAssembler.AssemblyException {
        this.assembler.assembleLine(address, label, statement, comment, memory);
    }

    void checkAssemblyLineSyntax(int address, String label, String statement, String comment, Memory memory) throws AbstractAssembler.AssemblyException {
        this.assembler.checkLineSyntax(address, label, statement, comment, memory);
    }

    void checkAssemblyLabelSyntax(String label, Memory memory) throws AbstractAssembler.AssemblyException {
        this.assembler.checkLabelSyntax(label, memory);
    }

    class InstructionDef {
        int opCode;
        InsLayout layout;
        OpCodeField opCodeLayout;
        int opCodeOffset;

        InstructionDef(int anOpCode, InsLayout aLayout) {
            this.opCode = anOpCode;
            this.layout = aLayout;
            this.opCodeLayout = (OpCodeField)this.layout.getFirstFieldForClass(OpCodeField.class);
            this.opCodeOffset = this.layout.getOffsetTo(this.opCodeLayout);
        }

        BitString getValue(BitStream bitStream) {
            bitStream.mark();
            bitStream.skip(this.opCodeOffset);
            boolean match = this.opCodeLayout.getValue(bitStream).getValue() == (long)this.opCode;
            bitStream.rewind();
            if (match) {
                return this.layout.getValue(bitStream);
            }
            return null;
        }

        BitString getValue(IntStream operandValues, int pc) {
            return this.layout.getValue(new IntStream(this.opCode).concat(operandValues), pc);
        }

        InsLayout getLayout() {
            return this.layout;
        }
    }

    protected class SimpleField
    implements InsLayout {
        int length;
        String macFormat;
        String asmFormat;
        String dscFormat;

        public SimpleField(int aLength, String aMacFormat, String anAsmFormat, String aDscFormat) {
            this.length = aLength;
            this.macFormat = aMacFormat;
            this.asmFormat = anAsmFormat;
            this.dscFormat = aDscFormat;
        }

        int scaleValue(int value, int pc) {
            return value;
        }

        int unscaleValue(int value, int pc) {
            return value;
        }

        public String toMac(BitString insValue, int offset, int pc) {
            return String.format(this.macFormat, insValue.getValueAt(offset, this.length), pc);
        }

        public String toAsm(BitString insValue, int offset, int pc) {
            return String.format(this.asmFormat, this.unscaleValue(insValue.getValueAt(offset, this.length), pc));
        }

        public String toDsc(BitString insValue, int offset, int pc) {
            return String.format(this.dscFormat, this.unscaleValue(insValue.getValueAt(offset, this.length), pc));
        }

        public BitString getValue(IntStream fields, int pc) {
            return new BitString(this.length, this.scaleValue(fields.getValue(), pc));
        }

        public BitString getValue(BitStream bitStream) {
            return bitStream.getValue(this.length);
        }

        public int length() {
            return this.length;
        }

        public int byteLength() {
            return this.length() / 8;
        }

        public int getOffsetTo(InsLayout aField) {
            assert (aField == this);
            return 0;
        }

        public InsLayout getFirstFieldForClass(Class aClass) {
            return aClass.isInstance(this) ? this : null;
        }
    }

    protected class LabelableField
    extends SimpleField {
        String labelAsmFormat;
        String labelDscFormat;

        public LabelableField(int aLength, String aMacFormat, String aNoLabelAsmFormat, String aLabelAsmFormat, String aDscFormat, String aLabelDscFormat) {
            super(aLength, aMacFormat, aNoLabelAsmFormat, aDscFormat);
            this.labelAsmFormat = aLabelAsmFormat;
            this.labelDscFormat = aLabelDscFormat;
        }

        int scaleValue(int value, int pc) {
            return AbstractISA.this.normalizeEndianness(value, this.length);
        }

        int unscaleValue(int value, int pc) {
            return AbstractISA.this.normalizeEndianness(value, this.length);
        }

        public String toAsm(BitString insValue, int offset, int pc) {
            String label;
            int value = this.unscaleValue(insValue.getValueAt(offset, this.length), pc);
            String string = label = AbstractISA.this.addressToLabelMap != null ? (String)AbstractISA.this.addressToLabelMap.get(value) : null;
            if (label != null) {
                return String.format(this.labelAsmFormat, label);
            }
            return String.format(this.asmFormat, value);
        }

        public String toDsc(BitString insValue, int offset, int pc) {
            String label;
            int value = this.unscaleValue(insValue.getValueAt(offset, this.length), pc);
            String string = label = AbstractISA.this.addressToLabelMap != null ? (String)AbstractISA.this.addressToLabelMap.get(value) : null;
            if (label != null) {
                return String.format(this.labelDscFormat, label);
            }
            return String.format(this.dscFormat, value);
        }
    }

    protected class OpCodeField
    extends SimpleField {
        public OpCodeField(int aLength, String aMacFormat, String anAsmFormat, String aDscFormat) {
            super(aLength, aMacFormat, anAsmFormat, aDscFormat);
        }
    }

    protected class ScaledField
    extends SimpleField {
        int scale;

        public ScaledField(int aLength, String aMacFormat, String anAsmFormat, String aDscFormat, int aScale) {
            super(aLength, aMacFormat, anAsmFormat, aDscFormat);
            this.scale = aScale;
        }

        int scaleValue(int value, int pc) {
            return value / this.scale;
        }

        int unscaleValue(int value, int pc) {
            return value * this.scale;
        }
    }

    protected class ConstantField
    extends SimpleField {
        int value;

        public ConstantField(int aLength, String aMacFormat, String anAsmFormat, String aDscFormat, int aValue) {
            super(aLength, aMacFormat, anAsmFormat, aDscFormat);
            this.value = aValue;
        }

        int scaleValue(int aValue, int pc) {
            return this.value;
        }

        int unscaleValue(int aValue, int pc) {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DictonaryField
    extends SimpleField {
        Map<Integer, String> names;

        public DictonaryField(int aLength, String aMacFormat, String anAsmFormat, String aDscFormat, Map<Integer, String> aNames) {
            super(aLength, aMacFormat, anAsmFormat, aDscFormat);
            this.names = aNames;
        }

        @Override
        public String toAsm(BitString insValue, int offset, int pc) {
            return String.format(this.asmFormat, this.names.get(insValue.getValueAt(offset, this.length)));
        }

        @Override
        public String toDsc(BitString insValue, int offset, int pc) {
            return String.format(this.dscFormat, this.names.get(insValue.getValueAt(offset, this.length)));
        }
    }

    protected class PCRelativeField
    extends LabelableField {
        public PCRelativeField(int aLength, String aMacFormat, String aNoLabelAsmFormat, String aLabelAsmFormat, String aDscFormat, String aLabelDscFormat) {
            super(aLength, aMacFormat, aNoLabelAsmFormat, aLabelAsmFormat, aDscFormat, aLabelDscFormat);
        }

        int scaleValue(int value, int pc) {
            return (value - (pc + 2)) / 2;
        }

        int unscaleValue(int value, int pc) {
            return AbstractISA.this.signExtend(value, this.length) * 2 + (pc + 2);
        }
    }

    protected class CompoundField
    implements InsLayout {
        InsLayout[] fields;
        int[] asmOrder;
        String[] asmFormats;
        int[] dscOrder;
        String[] dscFormats;

        public CompoundField(InsLayout[] aFields, int[] anAsmOrder, String[] anAsmFormats, int[] aDscOrder, String[] aDscFormats) {
            this.fields = aFields;
            this.asmOrder = anAsmOrder;
            this.asmFormats = anAsmFormats;
            this.dscOrder = aDscOrder;
            this.dscFormats = aDscFormats;
        }

        public String toMac(BitString ins, int offset, int pc) {
            String mac = "";
            for (int i = 0; i < this.fields.length; ++i) {
                mac = mac.concat(this.fields[i].toMac(ins, offset, pc));
                offset += this.fields[i].length();
            }
            return mac;
        }

        public String toAsm(BitString ins, int offset, int pc) {
            int i;
            String[] fldAsm = new String[this.fields.length];
            String asm = "";
            for (i = 0; i < this.fields.length; ++i) {
                fldAsm[i] = this.fields[i].toAsm(ins, offset, pc);
                offset += this.fields[i].length();
            }
            for (i = 0; i < this.asmOrder.length; ++i) {
                asm = asm.concat(String.format(this.asmFormats[i], fldAsm[this.asmOrder[i]]));
            }
            return asm;
        }

        public String toDsc(BitString ins, int offset, int pc) {
            int i;
            String[] fldDsc = new String[this.fields.length];
            String dsc = "";
            for (i = 0; i < this.fields.length; ++i) {
                fldDsc[i] = this.fields[i].toDsc(ins, offset, pc);
                offset += this.fields[i].length();
            }
            for (i = 0; i < this.dscOrder.length; ++i) {
                dsc = dsc.concat(String.format(this.dscFormats[i], fldDsc[this.dscOrder[i]]));
            }
            return dsc;
        }

        public BitString getValue(IntStream fieldValues, int pc) {
            BitString value = new BitString();
            for (int i = 0; i < this.fields.length; ++i) {
                value = value.concat(this.fields[i].getValue(fieldValues, pc));
            }
            return value;
        }

        public BitString getValue(BitStream bitStream) {
            BitString value = new BitString();
            for (int i = 0; i < this.fields.length; ++i) {
                value = value.concat(this.fields[i].getValue(bitStream));
            }
            return value;
        }

        public int length() {
            int length = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                length += this.fields[i].length();
            }
            return length;
        }

        public int byteLength() {
            return this.length() / 8;
        }

        public int getOffsetTo(InsLayout aField) {
            int offset = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == aField) {
                    return offset;
                }
                offset += this.fields[i].length();
            }
            throw new RuntimeException();
        }

        public InsLayout getFirstFieldForClass(Class aClass) {
            for (int i = 0; i < this.fields.length; ++i) {
                InsLayout aField = this.fields[i].getFirstFieldForClass(aClass);
                if (aField == null) continue;
                return aField;
            }
            throw new RuntimeException();
        }
    }

    protected class ShiftField
    extends SimpleField {
        public ShiftField(int aLength, String aMacFormat, String anAsmFormat, String aDscFormat) {
            super(aLength, aMacFormat, anAsmFormat, aDscFormat);
        }

        int unscaleValue(int value, int pc) {
            int seValue = AbstractISA.this.signExtend(value, this.length);
            return seValue < 0 ? -seValue : seValue;
        }
    }

    protected class ShiftOpCodeField
    extends OpCodeField {
        String nonNegAsm;
        String negAsm;
        String nonNegDsc;
        String negDsc;
        int shiftOffset;
        int shiftLength;

        public ShiftOpCodeField(int aLength, String aMacFormat, String anAsmFormat, String aNonNegAsm, String aNegAsm, String aDscFormat, String aNonNegDsc, String aNegDsc) {
            super(aLength, aMacFormat, anAsmFormat, aDscFormat);
            this.nonNegAsm = aNonNegAsm;
            this.negAsm = aNegAsm;
            this.nonNegDsc = aNonNegDsc;
            this.negDsc = aNegDsc;
        }

        void setShiftField(int aShiftOffset, int aShiftLength) {
            this.shiftOffset = aShiftOffset;
            this.shiftLength = aShiftLength;
        }

        public String toAsm(BitString ins, int offset, int pc) {
            return String.format(this.asmFormat, AbstractISA.this.signExtend(ins.getValueAt(this.shiftOffset, this.shiftLength), this.shiftLength) >= 0 ? this.nonNegAsm : this.negAsm);
        }

        public String toDsc(BitString ins, int offset, int pc) {
            return String.format(this.dscFormat, AbstractISA.this.signExtend(ins.getValueAt(this.shiftOffset, this.shiftLength), this.shiftLength) >= 0 ? this.nonNegDsc : this.negDsc);
        }
    }

    protected class ShiftInsField
    extends CompoundField {
        public ShiftInsField(InsLayout[] aFields, int[] anAsmOrder, String[] anAsmFormats, int[] aDscOrder, String[] aDscFormats, int opCodeField, int shiftField) {
            super(aFields, anAsmOrder, anAsmFormats, aDscOrder, aDscFormats);
            ((ShiftOpCodeField)this.fields[opCodeField]).setShiftField(this.getOffsetTo(this.fields[shiftField]), this.fields[shiftField].length());
        }
    }

    protected static interface InsLayout {
        public String toMac(BitString var1, int var2, int var3);

        public String toAsm(BitString var1, int var2, int var3);

        public String toDsc(BitString var1, int var2, int var3);

        public BitString getValue(IntStream var1, int var2);

        public BitString getValue(BitStream var1);

        public int length();

        public int byteLength();

        public int getOffsetTo(InsLayout var1);

        public InsLayout getFirstFieldForClass(Class var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Endianness {
        BIG,
        LITTLE;

    }
}

