/*
 * Decompiled with CFR 0.152.
 */
package arch.y86.machine;

import machine.AbstractMainMemory;
import util.UnsignedByte;

public class MainMemory
extends AbstractMainMemory {
    private byte[] mem;

    public MainMemory(int byteCapacity) {
        this.mem = new byte[byteCapacity];
    }

    protected boolean isAccessAligned(int address, int length) {
        return address % length == 0;
    }

    public int bytesToInteger(UnsignedByte byteAtAddrPlus0, UnsignedByte byteAtAddrPlus1, UnsignedByte byteAtAddrPlus2, UnsignedByte byteAtAddrPlus3) {
        return (int)(byteAtAddrPlus3.value() << 24 | byteAtAddrPlus2.value() << 16 | byteAtAddrPlus1.value() << 8 | byteAtAddrPlus0.value());
    }

    public UnsignedByte[] integerToBytes(int i) {
        UnsignedByte[] b = new UnsignedByte[4];
        b[3] = new UnsignedByte(i >>> 24);
        b[2] = new UnsignedByte(i >>> 16);
        b[1] = new UnsignedByte(i >>> 8);
        b[0] = new UnsignedByte(i);
        return b;
    }

    protected UnsignedByte[] get(int address, int length) throws AbstractMainMemory.InvalidAddressException {
        if (address < 0 || address + length - 1 >= this.mem.length) {
            throw new AbstractMainMemory.InvalidAddressException();
        }
        UnsignedByte[] value = new UnsignedByte[length];
        for (int i = 0; i < length; ++i) {
            value[i] = new UnsignedByte((int)this.mem[address + i]);
        }
        return value;
    }

    protected void set(int address, UnsignedByte[] value) throws AbstractMainMemory.InvalidAddressException {
        if (address < 0 || address + value.length - 1 >= this.mem.length) {
            throw new AbstractMainMemory.InvalidAddressException();
        }
        for (int i = 0; i < value.length; ++i) {
            this.mem[address + i] = (byte)value[i].value();
        }
    }

    public int length() {
        return this.mem.length;
    }
}

