/*
 * Decompiled with CFR 0.152.
 */
package arch.y86.machine;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Vector;
import machine.AbstractCPU;
import machine.AbstractMainMemory;
import machine.Register;
import machine.RegisterSet;
import util.HalfByteNumber;

public abstract class AbstractY86CPU
extends AbstractCPU {
    protected static final int R_ESP = 4;
    protected static final int R_EBP = 5;
    protected static final int R_NONE = 15;
    protected static final int I_HALT = 0;
    protected static final int I_NOP = 1;
    protected static final int I_RRMOVL = 2;
    protected static final int I_RRMVXX = 2;
    protected static final int I_IRMOVL = 3;
    protected static final int I_RMMOVL = 4;
    protected static final int I_MRMOVL = 5;
    protected static final int I_OPL = 6;
    protected static final int I_JXX = 7;
    protected static final int I_CALL = 8;
    protected static final int I_RET = 9;
    protected static final int I_PUSHL = 10;
    protected static final int I_POPL = 11;
    protected static final int I_IOPL = 12;
    protected static final int I_LEAVE = 13;
    protected static final int I_JMPI = 14;
    protected static final int I_CALLI = 15;
    protected static final int A_ADDL = 0;
    protected static final int A_SUBL = 1;
    protected static final int A_ANDL = 2;
    protected static final int A_XORL = 3;
    protected static final int A_ADDL_LSHIFT_1 = 4;
    protected static final int A_ADDL_LSHIFT_2 = 5;
    protected static final int X_INDIRECT = 0;
    protected static final int X_DBL_INDIRECT = 1;
    protected static final int C_NC = 0;
    protected static final int C_LE = 1;
    protected static final int C_L = 2;
    protected static final int C_E = 3;
    protected static final int C_NE = 4;
    protected static final int C_GE = 5;
    protected static final int C_G = 6;
    protected static final int S_AOK = 1;
    protected static final int S_ADR = 2;
    protected static final int S_INS = 3;
    protected static final int S_HLT = 4;

    private AbstractY86CPU(String name, AbstractMainMemory memory, boolean anIsPipelined) {
        super(name, memory);
    }

    protected abstract void fetch() throws Register.TimingException;

    protected abstract void decode() throws Register.TimingException;

    protected abstract void execute() throws Register.TimingException;

    protected abstract void memory() throws Register.TimingException;

    protected abstract void writeBack() throws AbstractCPU.MachineHaltException, AbstractCPU.InvalidInstructionException, AbstractMainMemory.InvalidAddressException, Register.TimingException;

    protected void fetch_SelectPC() throws Register.TimingException {
    }

    protected void pipelineHazardControl() throws Register.TimingException {
    }

    public static abstract class Base
    extends AbstractY86CPU {
        private ProcessorState proc;
        protected ProcessorState.InputPorts p;
        protected ProcessorState.OutputPorts P;
        private WriteBackStageState wrBk;
        protected FetchStageState.InputPorts w;
        protected WriteBackStageState.OutputPorts W;
        private MemoryStageState mmry;
        protected WriteBackStageState.InputPorts m;
        protected MemoryStageState.OutputPorts M;
        private ExecuteStageState exec;
        protected MemoryStageState.InputPorts e;
        protected ExecuteStageState.OutputPorts E;
        private DecodeStageState decd;
        protected ExecuteStageState.InputPorts d;
        protected DecodeStageState.OutputPorts D;
        private FetchStageState ftch;
        protected DecodeStageState.InputPorts f;
        protected FetchStageState.OutputPorts F;
        private boolean isPipelined;

        public Base(String name, AbstractMainMemory memory, boolean anIsPipelined) {
            super(name, memory, anIsPipelined);
            this.isPipelined = anIsPipelined;
            this.is.regFile.addSigned("eax", true);
            this.is.regFile.addSigned("ecx", true);
            this.is.regFile.addSigned("edx", true);
            this.is.regFile.addSigned("ebx", true);
            this.is.regFile.addSigned("esp", true);
            this.is.regFile.addSigned("ebp", true);
            this.is.regFile.addSigned("esi", true);
            this.is.regFile.addSigned("edi", true);
            this.proc = this.newProcessorState();
            this.ftch = this.newFetchStageState();
            this.decd = this.newDecodeStageState();
            this.exec = this.newExecuteStageState();
            this.mmry = this.newMemoryStageState();
            this.wrBk = this.newWriteBackStageState();
            this.p = (ProcessorState.InputPorts)this.proc.getInputPorts();
            this.P = (ProcessorState.OutputPorts)this.proc.getOutputPorts();
            this.f = (DecodeStageState.InputPorts)this.decd.getInputPorts();
            this.F = (FetchStageState.OutputPorts)this.ftch.getOutputPorts();
            this.d = (ExecuteStageState.InputPorts)this.exec.getInputPorts();
            this.D = (DecodeStageState.OutputPorts)this.decd.getOutputPorts();
            this.e = (MemoryStageState.InputPorts)this.mmry.getInputPorts();
            this.E = (ExecuteStageState.OutputPorts)this.exec.getOutputPorts();
            this.m = (WriteBackStageState.InputPorts)this.wrBk.getInputPorts();
            this.M = (MemoryStageState.OutputPorts)this.mmry.getOutputPorts();
            this.w = (FetchStageState.InputPorts)this.ftch.getInputPorts();
            this.W = (WriteBackStageState.OutputPorts)this.wrBk.getOutputPorts();
            this.is.processorState.add(this.proc);
            this.is.processorState.add(this.wrBk);
            this.is.processorState.add(this.mmry);
            this.is.processorState.add(this.exec);
            this.is.processorState.add(this.decd);
            this.is.processorState.add(this.ftch);
            if (this.isPipelined) {
                this.ftch.add("CurrentInstructionAddress", Integer.class, true, false, false, -1L);
                this.decd.add("CurrentInstructionAddress", Integer.class, true, false, false, -1L);
                this.exec.add("CurrentInstructionAddress", Integer.class, true, false, false, -1L);
                this.mmry.add("CurrentInstructionAddress", Integer.class, true, false, false, -1L);
                this.wrBk.add("CurrentInstructionAddress", Integer.class, true, false, false, -1L);
            } else {
                this.proc.add("CurrentInstructionAddress", Integer.class, true, false, false, -1L);
            }
        }

        private ProcessorState newProcessorState() {
            return new ProcessorState();
        }

        private FetchStageState newFetchStageState() {
            return new FetchStageState();
        }

        private DecodeStageState newDecodeStageState() {
            return new DecodeStageState();
        }

        private ExecuteStageState newExecuteStageState() {
            return new ExecuteStageState();
        }

        private MemoryStageState newMemoryStageState() {
            return new MemoryStageState();
        }

        private WriteBackStageState newWriteBackStageState() {
            return new WriteBackStageState();
        }

        public void setPC(int aPC) {
            this.proc.tickClock(Register.ClockTransition.BUBBLE);
            if (this.isPipelined) {
                this.ftch.setValue("CurrentInstructionAddress", aPC);
            }
            this.ftch.setValue("prPC", aPC);
            this.ftch.setValue("pc", aPC);
            this.ftch.tickClock(Register.ClockTransition.NORMAL);
            this.decd.tickClock(Register.ClockTransition.BUBBLE);
            this.exec.tickClock(Register.ClockTransition.BUBBLE);
            this.mmry.tickClock(Register.ClockTransition.BUBBLE);
            this.wrBk.tickClock(Register.ClockTransition.BUBBLE);
            super.setPC(aPC);
        }

        protected void cycleSeq() throws AbstractCPU.InvalidInstructionException, AbstractMainMemory.InvalidAddressException, AbstractCPU.MachineHaltException, Register.TimingException, AbstractCPU.ImplementationException {
            this.proc.cCnt.set(this.proc.cCnt.get() + 1);
            this.proc.iCnt.set(this.proc.iCnt.get() + 1);
            this.proc.setValue("CurrentInstructionAddress", this.ftch.pc.get());
            try {
                this.fetch();
                this.decd.tickClock(Register.ClockTransition.NORMAL);
                this.ftch.tickClock(Register.ClockTransition.NORMAL);
                this.decode();
                this.exec.tickClock(Register.ClockTransition.NORMAL);
                this.execute();
                this.mmry.tickClock(Register.ClockTransition.NORMAL);
                this.memory();
                this.wrBk.tickClock(Register.ClockTransition.NORMAL);
                this.writeBack();
                this.ftch.tickClock(Register.ClockTransition.NORMAL);
                this.proc.setValue("PC", this.F.pc.get());
                this.proc.tickClock(Register.ClockTransition.NORMAL);
                this.is.regFile.tickClock(Register.ClockTransition.NORMAL);
            }
            catch (Exception e) {
                int pc = this.F.pc.get();
                if (e instanceof RegisterSet.InvalidRegisterNumberException) {
                    throw new AbstractCPU.InvalidInstructionException(this, e, pc);
                }
                if (e instanceof AbstractCPU.InvalidInstructionException) {
                    throw new AbstractCPU.InvalidInstructionException((AbstractCPU)this, pc);
                }
                if (e instanceof AbstractMainMemory.InvalidAddressException) {
                    throw new AbstractMainMemory.InvalidAddressException(pc);
                }
                if (e instanceof AbstractCPU.MachineHaltException) {
                    throw new AbstractCPU.MachineHaltException(this, pc);
                }
                if (e instanceof Register.TimingException) {
                    Register.TimingException rte = (Register.TimingException)e;
                    rte.setPC(pc);
                    throw rte;
                }
                if (e instanceof RuntimeException) {
                    throw new AbstractCPU.ImplementationException(this, (RuntimeException)e, pc);
                }
                throw new AssertionError((Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cyclePipe() throws AbstractCPU.InvalidInstructionException, AbstractMainMemory.InvalidAddressException, AbstractCPU.MachineHaltException, Register.TimingException, AbstractCPU.ImplementationException {
            this.F.stall = false;
            this.F.bubble = false;
            this.D.stall = false;
            this.D.bubble = false;
            this.E.stall = false;
            this.E.bubble = false;
            this.M.stall = false;
            this.M.bubble = false;
            this.W.stall = false;
            this.W.bubble = false;
            try {
                Vector<StageThread> threads = new Vector<StageThread>();
                StageThread fetchThread = new StageThread(){

                    public void run() {
                        try {
                            Base.this.fetch();
                        }
                        catch (Exception ex) {
                            this.exceptionPC = Base.this.ftch.getValue("CurrentInstructionAddress");
                            this.exception = ex;
                        }
                    }
                };
                threads.add(fetchThread);
                threads.add(new StageThread(){

                    public void run() {
                        try {
                            Base.this.decode();
                        }
                        catch (Exception ex) {
                            this.exceptionPC = Base.this.decd.getValue("CurrentInstructionAddress");
                            this.exception = ex;
                        }
                    }
                });
                threads.add(new StageThread(){

                    public void run() {
                        try {
                            Base.this.execute();
                        }
                        catch (Exception ex) {
                            this.exceptionPC = Base.this.exec.getValue("CurrentInstructionAddress");
                            this.exception = ex;
                        }
                    }
                });
                threads.add(new StageThread(){

                    public void run() {
                        try {
                            Base.this.memory();
                        }
                        catch (Exception ex) {
                            this.exceptionPC = Base.this.mmry.getValue("CurrentInstructionAddress");
                            this.exception = ex;
                        }
                    }
                });
                threads.add(new StageThread(){

                    public void run() {
                        try {
                            Base.this.writeBack();
                        }
                        catch (Exception ex) {
                            this.exceptionPC = Base.this.wrBk.getValue("CurrentInstructionAddress");
                            this.exception = ex;
                        }
                    }
                });
                threads.add(new StageThread(){

                    public void run() {
                        try {
                            Base.this.pipelineHazardControl();
                            if (Base.this.F.stall && Base.this.F.bubble) {
                                throw new RuntimeException("F stage set to both stall and bubble");
                            }
                            if (Base.this.D.stall && Base.this.D.bubble) {
                                throw new RuntimeException("D stage set to both stall and bubble");
                            }
                            if (Base.this.E.stall && Base.this.E.bubble) {
                                throw new RuntimeException("E stage set to both stall and bubble");
                            }
                            if (Base.this.M.stall && Base.this.M.bubble) {
                                throw new RuntimeException("M stage set to both stall and bubble");
                            }
                            if (Base.this.W.stall && Base.this.W.bubble) {
                                throw new RuntimeException("W stage set to both stall and bubble");
                            }
                        }
                        catch (Exception ex) {
                            this.exceptionPC = -1;
                            this.exception = ex;
                        }
                    }
                });
                for (StageThread t : threads) {
                    t.start();
                }
                for (StageThread t : threads) {
                    try {
                        t.join();
                    }
                    catch (InterruptedException ie) {}
                }
                if (this.wrBk.iCd.get() != 1 && !this.W.stall && !this.W.bubble) {
                    this.proc.iCnt.set(this.proc.iCnt.get() + 1);
                }
                this.proc.cCnt.set(this.P.cCnt.get() + 1);
                for (StageThread t : threads) {
                    if (t.exception == null) continue;
                    if (t.exception instanceof RegisterSet.InvalidRegisterNumberException) {
                        throw new AbstractCPU.InvalidInstructionException(this, t.exception, t.exceptionPC);
                    }
                    if (t.exception instanceof AbstractCPU.InvalidInstructionException) {
                        throw new AbstractCPU.InvalidInstructionException((AbstractCPU)this, t.exceptionPC);
                    }
                    if (t.exception instanceof AbstractMainMemory.InvalidAddressException) {
                        throw new AbstractMainMemory.InvalidAddressException(t.exceptionPC);
                    }
                    if (t.exception instanceof AbstractCPU.MachineHaltException) {
                        throw new AbstractCPU.MachineHaltException(this, t.exceptionPC);
                    }
                    if (t.exception instanceof Register.TimingException) {
                        Register.TimingException rte = (Register.TimingException)t.exception;
                        rte.setPC(t.exceptionPC);
                        throw rte;
                    }
                    if (t.exception instanceof RuntimeException) {
                        throw new AbstractCPU.ImplementationException(this, (RuntimeException)t.exception, t.exceptionPC);
                    }
                    throw new AssertionError((Object)t.exception);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.decd.setValue("CurrentInstructionAddress", this.decd.pc.getInput());
                this.exec.setValue("CurrentInstructionAddress", this.decd.getValue("CurrentInstructionAddress"));
                this.mmry.setValue("CurrentInstructionAddress", this.exec.getValue("CurrentInstructionAddress"));
                this.wrBk.setValue("CurrentInstructionAddress", this.mmry.getValue("CurrentInstructionAddress"));
                this.is.regFile.tickClock(Register.ClockTransition.NORMAL);
                this.decd.tickClock(this.D.stall ? Register.ClockTransition.STALL : (this.D.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
                this.ftch.prPC.set(this.decd.prPC.get());
                this.ftch.tickClock(this.F.stall ? Register.ClockTransition.STALL : (this.F.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
                this.exec.tickClock(this.E.stall ? Register.ClockTransition.STALL : (this.E.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
                this.mmry.tickClock(this.M.stall ? Register.ClockTransition.STALL : (this.M.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
                this.wrBk.tickClock(this.W.stall ? Register.ClockTransition.STALL : (this.W.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
                throw throwable;
            }
            this.decd.setValue("CurrentInstructionAddress", this.decd.pc.getInput());
            this.exec.setValue("CurrentInstructionAddress", this.decd.getValue("CurrentInstructionAddress"));
            this.mmry.setValue("CurrentInstructionAddress", this.exec.getValue("CurrentInstructionAddress"));
            this.wrBk.setValue("CurrentInstructionAddress", this.mmry.getValue("CurrentInstructionAddress"));
            this.is.regFile.tickClock(Register.ClockTransition.NORMAL);
            this.decd.tickClock(this.D.stall ? Register.ClockTransition.STALL : (this.D.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
            this.ftch.prPC.set(this.decd.prPC.get());
            this.ftch.tickClock(this.F.stall ? Register.ClockTransition.STALL : (this.F.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
            this.exec.tickClock(this.E.stall ? Register.ClockTransition.STALL : (this.E.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
            this.mmry.tickClock(this.M.stall ? Register.ClockTransition.STALL : (this.M.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
            this.wrBk.tickClock(this.W.stall ? Register.ClockTransition.STALL : (this.W.bubble ? Register.ClockTransition.BUBBLE : Register.ClockTransition.NORMAL));
            this.fetch_SelectPC();
            this.ftch.pc.set(this.decd.pc.getInput());
            this.ftch.setValue("CurrentInstructionAddress", this.ftch.pc.getInput());
            this.proc.setValue("PC", this.ftch.pc.getInput());
            this.proc.tickClock(Register.ClockTransition.NORMAL);
        }

        private class StageThread
        extends Thread {
            int exceptionPC = -1;
            Exception exception = null;

            private StageThread() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class WriteBackStageState
        extends StageState<InputPorts, OutputPorts> {
            public Register stat;
            public Register iCd;
            public Register iFn;
            public Register cnd;
            public Register valE;
            public Register valM;
            public Register dstE;
            public Register dstM;

            public WriteBackStageState() {
                super("W");
                this.stat = this.add("stat", HalfByteNumber.class, true, false, true, 1L);
                this.iCd = this.add("iCd", HalfByteNumber.class, true, false, true, 1L);
                this.iFn = this.addUnsigned("iFn", HalfByteNumber.class);
                this.cnd = this.addUnsigned("cnd", HalfByteNumber.class);
                this.valE = this.addSigned("valE", Integer.class);
                this.valM = this.addSigned("valM", Integer.class);
                this.dstE = this.addUnsigned("dstE", HalfByteNumber.class, 15L);
                this.dstM = this.addUnsigned("dstM", HalfByteNumber.class, 15L);
            }

            public class OutputPorts {
                public Register.OutputPort stat;
                public Register.OutputPort iCd;
                public Register.OutputPort iFn;
                public Register.OutputPort cnd;
                public Register.OutputPort valE;
                public Register.OutputPort valM;
                public Register.OutputPort dstE;
                public Register.OutputPort dstM;
                public boolean stall;
                public boolean bubble;

                public OutputPorts() {
                    WriteBackStageState.this.mapOutputs(0, 1, 2, 3, 4, 5, 6, 7);
                }
            }

            public class InputPorts {
                public Register.InputPort stat;
                public Register.InputPort iCd;
                public Register.InputPort iFn;
                public Register.InputPort cnd;
                public Register.InputPort valE;
                public Register.InputPort valM;
                public Register.InputPort dstE;
                public Register.InputPort dstM;

                public InputPorts() {
                    WriteBackStageState.this.mapInputs(0, 1, 2, 3, 4, 5, 6, 7);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class MemoryStageState
        extends StageState<InputPorts, OutputPorts> {
            public Register stat;
            public Register iCd;
            public Register iFn;
            public Register cnd;
            public Register valE;
            public Register valC;
            public Register valA;
            public Register dstE;
            public Register dstM;
            public Register valP;

            public MemoryStageState() {
                super("M");
                this.stat = this.add("stat", HalfByteNumber.class, true, false, true, 1L);
                this.iCd = this.add("iCd", HalfByteNumber.class, true, false, true, 1L);
                this.iFn = this.addUnsigned("iFn", HalfByteNumber.class);
                this.cnd = this.addUnsigned("cnd", HalfByteNumber.class);
                this.valE = this.addSigned("valE", Integer.class);
                this.valC = this.addSigned("valC", Integer.class);
                this.valA = this.addSigned("valA", Integer.class);
                this.dstE = this.addUnsigned("dstE", HalfByteNumber.class, 15L);
                this.dstM = this.addUnsigned("dstM", HalfByteNumber.class, 15L);
                this.valP = this.addUnsigned("valP", Integer.class);
            }

            public class OutputPorts {
                public Register.OutputPort stat;
                public Register.OutputPort iCd;
                public Register.OutputPort iFn;
                public Register.OutputPort cnd;
                public Register.OutputPort valE;
                public Register.OutputPort valC;
                public Register.OutputPort valA;
                public Register.OutputPort dstE;
                public Register.OutputPort dstM;
                public Register.OutputPort valP;
                public boolean stall;
                public boolean bubble;

                public OutputPorts() {
                    MemoryStageState.this.mapOutputs(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
                }
            }

            public class InputPorts {
                public Register.InputPort stat;
                public Register.InputPort iCd;
                public Register.InputPort iFn;
                public Register.InputPort cnd;
                public Register.InputPort valE;
                public Register.InputPort valC;
                public Register.InputPort valA;
                public Register.InputPort dstE;
                public Register.InputPort dstM;
                public Register.InputPort valP;

                public InputPorts() {
                    MemoryStageState.this.mapInputs(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ExecuteStageState
        extends StageState<InputPorts, OutputPorts> {
            public Register stat;
            public Register iCd;
            public Register iFn;
            public Register valC;
            public Register valA;
            public Register valB;
            public Register dstE;
            public Register dstM;
            public Register srcA;
            public Register srcB;
            public Register valP;

            public ExecuteStageState() {
                super("E");
                this.stat = this.add("stat", HalfByteNumber.class, true, false, true, 1L);
                this.iCd = this.add("iCd", HalfByteNumber.class, true, false, true, 1L);
                this.iFn = this.addUnsigned("iFn", HalfByteNumber.class);
                this.valC = this.addSigned("valC", Integer.class);
                this.valA = this.addSigned("valA", Integer.class);
                this.valB = this.addSigned("valB", Integer.class);
                this.dstE = this.addUnsigned("dstE", HalfByteNumber.class, 15L);
                this.dstM = this.addUnsigned("dstM", HalfByteNumber.class, 15L);
                this.srcA = this.addUnsigned("srcA", HalfByteNumber.class, 15L);
                this.srcB = this.addUnsigned("srcB", HalfByteNumber.class, 15L);
                this.valP = this.addUnsigned("valP", Integer.class);
            }

            public class OutputPorts {
                public Register.OutputPort stat;
                public Register.OutputPort iCd;
                public Register.OutputPort iFn;
                public Register.OutputPort valC;
                public Register.OutputPort valA;
                public Register.OutputPort valB;
                public Register.OutputPort dstE;
                public Register.OutputPort dstM;
                public Register.OutputPort srcA;
                public Register.OutputPort srcB;
                public Register.OutputPort valP;
                public boolean stall;
                public boolean bubble;

                public OutputPorts() {
                    ExecuteStageState.this.mapOutputs(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
                }
            }

            public class InputPorts {
                public Register.InputPort stat;
                public Register.InputPort iCd;
                public Register.InputPort iFn;
                public Register.InputPort valC;
                public Register.InputPort valA;
                public Register.InputPort valB;
                public Register.InputPort dstE;
                public Register.InputPort dstM;
                public Register.InputPort srcA;
                public Register.InputPort srcB;
                public Register.InputPort valP;

                public InputPorts() {
                    ExecuteStageState.this.mapInputs(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class DecodeStageState
        extends StageState<InputPorts, OutputPorts> {
            public Register pc;
            public Register prPC;
            public Register stat;
            public Register iCd;
            public Register iFn;
            public Register rA;
            public Register rB;
            public Register valC;
            public Register valP;

            public DecodeStageState() {
                super("D");
                this.pc = this.add("pc", Integer.class, true, false, false, -1L);
                this.prPC = this.add("prPC", Integer.class, true, false, false, -1L);
                this.stat = this.add("stat", HalfByteNumber.class, true, false, true, 1L);
                this.iCd = this.add("iCd", HalfByteNumber.class, true, false, true, 1L);
                this.iFn = this.addUnsigned("iFn", HalfByteNumber.class);
                this.rA = this.addUnsigned("rA", HalfByteNumber.class);
                this.rB = this.addUnsigned("rB", HalfByteNumber.class);
                this.valC = this.addSigned("valC", Integer.class);
                this.valP = this.addUnsigned("valP", Integer.class);
            }

            public class OutputPorts {
                public Register.OutputPort stat;
                public Register.OutputPort iCd;
                public Register.OutputPort iFn;
                public Register.OutputPort rA;
                public Register.OutputPort rB;
                public Register.OutputPort valC;
                public Register.OutputPort valP;
                public boolean stall;
                public boolean bubble;

                public OutputPorts() {
                    DecodeStageState.this.mapOutputs(2, 3, 4, 5, 6, 7, 8);
                }
            }

            public class InputPorts {
                public Register.InputPort pc;
                public Register.InputPort prPC;
                public Register.InputPort stat;
                public Register.InputPort iCd;
                public Register.InputPort iFn;
                public Register.InputPort rA;
                public Register.InputPort rB;
                public Register.InputPort valC;
                public Register.InputPort valP;

                public InputPorts() {
                    DecodeStageState.this.mapInputs(0, 1, 2, 3, 4, 5, 6, 7, 8);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class FetchStageState
        extends StageState<InputPorts, OutputPorts> {
            public Register prPC;
            public Register pc;
            public Register stat;

            public FetchStageState() {
                super("F");
                this.prPC = this.add("prPC", Integer.class, true, false, Base.this.isPipelined, -1L);
                this.pc = this.add("pc", Integer.class, true, false, true, -1L);
                this.stat = this.add("stat", Integer.class, true, false, false, 1L);
            }

            public class OutputPorts {
                public Register.OutputPort prPC;
                public Register.OutputPort pc;
                public boolean stall;
                public boolean bubble;

                public OutputPorts() {
                    FetchStageState.this.mapOutputs(0, 1);
                }
            }

            public class InputPorts {
                public Register.InputPort prPC;
                public Register.InputPort pc;
                public Register.InputPort stat;

                public InputPorts() {
                    FetchStageState.this.mapInputs(0, 1, 2);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class StageState<InputPorts, OutputPorts>
        extends MultiPortRegisterSet<InputPorts, OutputPorts> {
            public StageState(String name) {
                super(name);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ProcessorState
        extends MultiPortRegisterSet<InputPorts, OutputPorts> {
            public Register pc;
            public Register cCnt;
            public Register iCnt;
            public Register cc;

            public ProcessorState() {
                super("P");
                this.pc = this.add("PC", Integer.class, true, false, false, -1L);
                this.cCnt = this.addUnsigned("cCnt", Long.class, true);
                this.iCnt = this.addUnsigned("iCnt", Long.class, true);
                this.cc = this.addUnsigned("cc", Short.class);
            }

            public class OutputPorts {
                public Register.OutputPort pc;
                public Register.OutputPort cCnt;
                public Register.OutputPort iCnt;
                public Register.OutputPort cc;

                public OutputPorts() {
                    ProcessorState.this.mapOutputs(0, 1, 2, 3);
                }
            }

            public class InputPorts {
                public Register.InputPort pc;
                public Register.InputPort cCnt;
                public Register.InputPort iCnt;
                public Register.InputPort cc;

                public InputPorts() {
                    ProcessorState.this.mapInputs(0, 1, 2, 3);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MultiPortRegisterSet<InputPorts, OutputPorts>
        extends RegisterSet {
            static final int INPUT_PORTS_TYPE_ARGUMENT_NUMBER = 0;
            static final int OUTPUT_PORTS_TYPE_ARGUMENT_NUMBER = 1;
            Field[] flds;
            int[] inputMap;
            int[] outputMap;

            Class<InputPorts> getInputPortsClass() {
                Type type = this.getClass().getGenericSuperclass();
                ParameterizedType paramType = (ParameterizedType)type;
                return (Class)paramType.getActualTypeArguments()[0];
            }

            Class<OutputPorts> getOutputPortsClass() {
                Type type = this.getClass().getGenericSuperclass();
                ParameterizedType paramType = (ParameterizedType)type;
                return (Class)paramType.getActualTypeArguments()[1];
            }

            protected InputPorts getInputPorts() {
                try {
                    Class<InputPorts> ipc = this.getInputPortsClass();
                    Constructor<InputPorts> con = ipc.getConstructor(this.getClass());
                    InputPorts ip = con.newInstance(this);
                    Field[] prts = ipc.getDeclaredFields();
                    for (int i = 0; i < Math.min(prts.length, this.inputMap.length); ++i) {
                        Register reg = (Register)this.flds[this.inputMap[i]].get(this);
                        prts[i].set(ip, reg.getInputPort());
                    }
                    return ip;
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new AssertionError((Object)t);
                }
            }

            protected OutputPorts getOutputPorts() {
                try {
                    Class<OutputPorts> opc = this.getOutputPortsClass();
                    Constructor<OutputPorts> con = opc.getConstructor(this.getClass());
                    OutputPorts op = con.newInstance(this);
                    Field[] prts = opc.getDeclaredFields();
                    for (int i = 0; i < Math.min(prts.length, this.outputMap.length); ++i) {
                        Register reg = (Register)this.flds[this.outputMap[i]].get(this);
                        prts[i].set(op, reg.getOutputPort());
                    }
                    return op;
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new AssertionError((Object)t);
                }
            }

            protected void mapInputs(int ... fieldMap) {
                this.inputMap = fieldMap;
            }

            protected void mapOutputs(int ... fieldMap) {
                this.outputMap = fieldMap;
            }

            protected MultiPortRegisterSet(String aName) {
                super(aName);
                this.flds = this.getClass().getDeclaredFields();
            }
        }
    }

    public static abstract class Pipelined
    extends Base {
        public Pipelined(String name, AbstractMainMemory memory) {
            super(name, memory, true);
        }
    }

    public static abstract class Sequential
    extends Base {
        public Sequential(String name, AbstractMainMemory memory) {
            super(name, memory, false);
        }
    }
}

