// $ANTLR 3.3 Nov 30, 2010 12:45:30 /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g 2011-10-12 23:29:46

package grammar;

import isa.Memory;
import isa.MemoryCell;
import isa.Instruction;
import isa.Datum;
import arch.sm213.isa.Assembler;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class AsmSM213Parser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "NewLine", "Comment", "Identifier", "Register", "Hex", "Decimal", "RegisterNumber", "Character", "Digit", "HexDigit", "WS", "':'", "'ld'", "'st'", "'not'", "'inc'", "'inca'", "'dec'", "'deca'", "'gpc'", "'mov'", "'add'", "'and'", "'shl'", "'shr'", "'br'", "'beq'", "'bgt'", "'j'", "'halt'", "'nop'", "','", "'*'", "'$'", "'('", "')'", "'.address'", "'.pos'", "'.long'", "'.data'"
    };
    public static final int EOF=-1;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__19=19;
    public static final int T__20=20;
    public static final int T__21=21;
    public static final int T__22=22;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int T__25=25;
    public static final int T__26=26;
    public static final int T__27=27;
    public static final int T__28=28;
    public static final int T__29=29;
    public static final int T__30=30;
    public static final int T__31=31;
    public static final int T__32=32;
    public static final int T__33=33;
    public static final int T__34=34;
    public static final int T__35=35;
    public static final int T__36=36;
    public static final int T__37=37;
    public static final int T__38=38;
    public static final int T__39=39;
    public static final int T__40=40;
    public static final int T__41=41;
    public static final int T__42=42;
    public static final int T__43=43;
    public static final int NewLine=4;
    public static final int Comment=5;
    public static final int Identifier=6;
    public static final int Register=7;
    public static final int Hex=8;
    public static final int Decimal=9;
    public static final int RegisterNumber=10;
    public static final int Character=11;
    public static final int Digit=12;
    public static final int HexDigit=13;
    public static final int WS=14;

    // delegates
    // delegators


        public AsmSM213Parser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public AsmSM213Parser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return AsmSM213Parser.tokenNames; }
    public String getGrammarFileName() { return "/Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g"; }


    public enum LineType { INSTRUCTION, DATA, NULL };
    Memory memory;
    LineType lineType;
    int pc;
    int opCode;
    int[] op = new int[4];
    int opLength;
    String label;
    String comment;
    int dataValue;
    int dataCount;
    int pass;

    void init (Memory aMemory, int startingAddress) {
      memory      = aMemory;
      pc          = startingAddress;
      lineType    = LineType.NULL;
      comment     = "";
      label       = "";
    }

    public void checkSyntax (Memory aMemory, int startingAddress) throws Assembler.AssemblyException {
      init (aMemory, startingAddress);
      pass = 0;
      try {
        program ();
      } catch (RecognitionException e) {
        throw new Assembler.AssemblyException ("");
      }
    }

    public void passOne (Memory aMemory, int startingAddress) throws Assembler.AssemblyException {
      init (aMemory, startingAddress);
      pass = 1;
      try {
        program ();
      } catch (RecognitionException e) {
        throw new Assembler.AssemblyException ("");
      }
    }

    public void passTwo (Memory aMemory, int startingAddress) throws Assembler.AssemblyException {
      init (aMemory, startingAddress);
      pass = 2;
      try {
        program ();
      } catch (RecognitionException e) {
        throw new Assembler.AssemblyException ("");
      }
    }

    @Override
    public void emitErrorMessage(String msg) {
      throw new Assembler.AssemblyException (msg);
    }

    int getLabelValue (String label) {
      Integer value = memory.getLabelMap ().getAddress (label);
      if (value==null) {
        if (pass==1)
          value = pc;
        else
          emitErrorMessage (java.lang.String.format ("Label not found: %s at address %d", label, pc));
      }
      return value.intValue ();
    }

    void writeLine () throws RecognitionException {
      MemoryCell cell = null;
      switch (lineType) {
        case INSTRUCTION:
          try {
            cell = Instruction.valueOf (memory, pc, opCode, op, label, comment);
            if (cell==null)
              throw new RecognitionException ();
            if (pass==1 && !label.trim ().equals ("")) 
              memory.addLabelOnly (cell);
            else if (pass==2)
              memory.add (cell);
            label = "";
            comment = "";
            pc += cell.length ();
          } catch (IndexOutOfBoundsException e) {
            throw new RecognitionException ();
          }
          break;
        case DATA:
          for (int i=0; i<dataCount; i++) {
            cell = Datum.valueOf (memory, pc, dataValue, label, comment);
            if (cell==null)
              throw new RecognitionException ();
            if (pass==1 && !label.trim ().equals (""))
              memory.addLabelOnly (cell);
            else if (pass==2)
              memory.add (cell);
            label = "";
            comment = "";
            pc += 4;
          }
          label = "";
          comment = "";
          break;
        default:
      }
      lineType = LineType.NULL;
      op[0]=0;
      op[1]=0;
      op[2]=0;
      op[3]=0;
    }



    // $ANTLR start "program"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:142:1: program : ( line )* EOF ;
    public final void program() throws RecognitionException {
        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:142:9: ( ( line )* EOF )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:142:11: ( line )* EOF
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:142:11: ( line )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( ((LA1_0>=NewLine && LA1_0<=Identifier)||(LA1_0>=16 && LA1_0<=34)||(LA1_0>=40 && LA1_0<=43)) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:142:11: line
            	    {
            	    pushFollow(FOLLOW_line_in_program46);
            	    line();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            match(input,EOF,FOLLOW_EOF_in_program49); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "program"


    // $ANTLR start "line"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:1: line : ( labelDeclaration )? ( instruction | directive )? ( NewLine | ( Comment ) ) ;
    public final void line() throws RecognitionException {
        Token Comment1=null;

        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:6: ( ( labelDeclaration )? ( instruction | directive )? ( NewLine | ( Comment ) ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:8: ( labelDeclaration )? ( instruction | directive )? ( NewLine | ( Comment ) )
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:8: ( labelDeclaration )?
            int alt2=2;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:9: labelDeclaration
                    {
                    pushFollow(FOLLOW_labelDeclaration_in_line58);
                    labelDeclaration();

                    state._fsp--;


                    }
                    break;

            }

            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:28: ( instruction | directive )?
            int alt3=3;
            int LA3_0 = input.LA(1);

            if ( ((LA3_0>=16 && LA3_0<=34)) ) {
                alt3=1;
            }
            else if ( ((LA3_0>=40 && LA3_0<=43)) ) {
                alt3=2;
            }
            switch (alt3) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:30: instruction
                    {
                    pushFollow(FOLLOW_instruction_in_line64);
                    instruction();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:44: directive
                    {
                    pushFollow(FOLLOW_directive_in_line68);
                    directive();

                    state._fsp--;


                    }
                    break;

            }

            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:57: ( NewLine | ( Comment ) )
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==NewLine) ) {
                alt4=1;
            }
            else if ( (LA4_0==Comment) ) {
                alt4=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }
            switch (alt4) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:59: NewLine
                    {
                    match(input,NewLine,FOLLOW_NewLine_in_line75); 

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:69: ( Comment )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:69: ( Comment )
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:144:70: Comment
                    {
                    Comment1=(Token)match(input,Comment,FOLLOW_Comment_in_line80); 
                     comment = (Comment1!=null?Comment1.getText():null).substring(1).trim(); 

                    }


                    }
                    break;

            }

             writeLine (); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "line"

    public static class labelDeclaration_return extends ParserRuleReturnScope {
    };

    // $ANTLR start "labelDeclaration"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:146:1: labelDeclaration : ( Identifier | operand ) ':' ;
    public final AsmSM213Parser.labelDeclaration_return labelDeclaration() throws RecognitionException {
        AsmSM213Parser.labelDeclaration_return retval = new AsmSM213Parser.labelDeclaration_return();
        retval.start = input.LT(1);

        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:147:2: ( ( Identifier | operand ) ':' )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:147:4: ( Identifier | operand ) ':'
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:147:4: ( Identifier | operand )
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==Identifier) ) {
                alt5=1;
            }
            else if ( ((LA5_0>=16 && LA5_0<=34)) ) {
                alt5=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;
            }
            switch (alt5) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:147:5: Identifier
                    {
                    match(input,Identifier,FOLLOW_Identifier_in_labelDeclaration97); 

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:147:18: operand
                    {
                    pushFollow(FOLLOW_operand_in_labelDeclaration101);
                    operand();

                    state._fsp--;


                    }
                    break;

            }

            match(input,15,FOLLOW_15_in_labelDeclaration104); 
             label = input.toString(retval.start,input.LT(-1)).substring (0, input.toString(retval.start,input.LT(-1)).length ()-1); 

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "labelDeclaration"

    public static class label_return extends ParserRuleReturnScope {
        public int value;
    };

    // $ANTLR start "label"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:148:1: label returns [int value] : ( Identifier | operand ) ;
    public final AsmSM213Parser.label_return label() throws RecognitionException {
        AsmSM213Parser.label_return retval = new AsmSM213Parser.label_return();
        retval.start = input.LT(1);

        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:149:2: ( ( Identifier | operand ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:149:4: ( Identifier | operand )
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:149:4: ( Identifier | operand )
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==Identifier) ) {
                alt6=1;
            }
            else if ( ((LA6_0>=16 && LA6_0<=34)) ) {
                alt6=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }
            switch (alt6) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:149:5: Identifier
                    {
                    match(input,Identifier,FOLLOW_Identifier_in_label119); 

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:149:18: operand
                    {
                    pushFollow(FOLLOW_operand_in_label123);
                    operand();

                    state._fsp--;


                    }
                    break;

            }

             retval.value = getLabelValue (input.toString(retval.start,input.LT(-1))); 

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "label"


    // $ANTLR start "instruction"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:152:1: instruction : ( load | store | aluOne | aluTwo | gpc | shift | branch | jump | halt | nop ) ;
    public final void instruction() throws RecognitionException {
        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:2: ( ( load | store | aluOne | aluTwo | gpc | shift | branch | jump | halt | nop ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:4: ( load | store | aluOne | aluTwo | gpc | shift | branch | jump | halt | nop )
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:4: ( load | store | aluOne | aluTwo | gpc | shift | branch | jump | halt | nop )
            int alt7=10;
            switch ( input.LA(1) ) {
            case 16:
                {
                alt7=1;
                }
                break;
            case 17:
                {
                alt7=2;
                }
                break;
            case 18:
            case 19:
            case 20:
            case 21:
            case 22:
                {
                alt7=3;
                }
                break;
            case 24:
            case 25:
            case 26:
                {
                alt7=4;
                }
                break;
            case 23:
                {
                alt7=5;
                }
                break;
            case 27:
            case 28:
                {
                alt7=6;
                }
                break;
            case 29:
            case 30:
            case 31:
                {
                alt7=7;
                }
                break;
            case 32:
                {
                alt7=8;
                }
                break;
            case 33:
                {
                alt7=9;
                }
                break;
            case 34:
                {
                alt7=10;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:5: load
                    {
                    pushFollow(FOLLOW_load_in_instruction138);
                    load();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:12: store
                    {
                    pushFollow(FOLLOW_store_in_instruction142);
                    store();

                    state._fsp--;


                    }
                    break;
                case 3 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:20: aluOne
                    {
                    pushFollow(FOLLOW_aluOne_in_instruction146);
                    aluOne();

                    state._fsp--;


                    }
                    break;
                case 4 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:29: aluTwo
                    {
                    pushFollow(FOLLOW_aluTwo_in_instruction150);
                    aluTwo();

                    state._fsp--;


                    }
                    break;
                case 5 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:38: gpc
                    {
                    pushFollow(FOLLOW_gpc_in_instruction154);
                    gpc();

                    state._fsp--;


                    }
                    break;
                case 6 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:44: shift
                    {
                    pushFollow(FOLLOW_shift_in_instruction158);
                    shift();

                    state._fsp--;


                    }
                    break;
                case 7 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:52: branch
                    {
                    pushFollow(FOLLOW_branch_in_instruction162);
                    branch();

                    state._fsp--;


                    }
                    break;
                case 8 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:61: jump
                    {
                    pushFollow(FOLLOW_jump_in_instruction166);
                    jump();

                    state._fsp--;


                    }
                    break;
                case 9 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:68: halt
                    {
                    pushFollow(FOLLOW_halt_in_instruction170);
                    halt();

                    state._fsp--;


                    }
                    break;
                case 10 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:153:75: nop
                    {
                    pushFollow(FOLLOW_nop_in_instruction174);
                    nop();

                    state._fsp--;


                    }
                    break;

            }

            lineType = LineType.INSTRUCTION;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "instruction"


    // $ANTLR start "operand"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:154:1: operand : ( 'ld' | 'st' | 'not' | 'inc' | 'inca' | 'dec' | 'deca' | 'gpc' | 'mov' | 'add' | 'and' | 'shl' | 'shr' | 'br' | 'beq' | 'bgt' | 'j' | 'halt' | 'nop' ) ;
    public final void operand() throws RecognitionException {
        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:154:9: ( ( 'ld' | 'st' | 'not' | 'inc' | 'inca' | 'dec' | 'deca' | 'gpc' | 'mov' | 'add' | 'and' | 'shl' | 'shr' | 'br' | 'beq' | 'bgt' | 'j' | 'halt' | 'nop' ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:154:11: ( 'ld' | 'st' | 'not' | 'inc' | 'inca' | 'dec' | 'deca' | 'gpc' | 'mov' | 'add' | 'and' | 'shl' | 'shr' | 'br' | 'beq' | 'bgt' | 'j' | 'halt' | 'nop' )
            {
            if ( (input.LA(1)>=16 && input.LA(1)<=34) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "operand"


    // $ANTLR start "load"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:156:1: load : 'ld' ( ( literal ',' ld= register ) | ( baseOffset4 | index ) ',' d= register ) ;
    public final void load() throws RecognitionException {
        int ld = 0;

        int d = 0;

        int literal2 = 0;

        AsmSM213Parser.baseOffset4_return baseOffset43 = null;

        AsmSM213Parser.index_return index4 = null;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:156:7: ( 'ld' ( ( literal ',' ld= register ) | ( baseOffset4 | index ) ',' d= register ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:156:9: 'ld' ( ( literal ',' ld= register ) | ( baseOffset4 | index ) ',' d= register )
            {
            match(input,16,FOLLOW_16_in_load231); 
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:156:14: ( ( literal ',' ld= register ) | ( baseOffset4 | index ) ',' d= register )
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==37) ) {
                alt9=1;
            }
            else if ( ((LA9_0>=Hex && LA9_0<=Decimal)||LA9_0==38) ) {
                alt9=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }
            switch (alt9) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:156:16: ( literal ',' ld= register )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:156:16: ( literal ',' ld= register )
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:156:17: literal ',' ld= register
                    {
                    pushFollow(FOLLOW_literal_in_load236);
                    literal2=literal();

                    state._fsp--;

                     opCode=0; op[2]=literal2; 
                    match(input,35,FOLLOW_35_in_load240); 
                    pushFollow(FOLLOW_register_in_load244);
                    ld=register();

                    state._fsp--;

                     op[0]=ld; 

                    }


                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:157:10: ( baseOffset4 | index ) ',' d= register
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:157:10: ( baseOffset4 | index )
                    int alt8=2;
                    int LA8_0 = input.LA(1);

                    if ( ((LA8_0>=Hex && LA8_0<=Decimal)) ) {
                        alt8=1;
                    }
                    else if ( (LA8_0==38) ) {
                        int LA8_2 = input.LA(2);

                        if ( (LA8_2==Register) ) {
                            int LA8_3 = input.LA(3);

                            if ( (LA8_3==39) ) {
                                alt8=1;
                            }
                            else if ( (LA8_3==35) ) {
                                alt8=2;
                            }
                            else {
                                NoViableAltException nvae =
                                    new NoViableAltException("", 8, 3, input);

                                throw nvae;
                            }
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 8, 2, input);

                            throw nvae;
                        }
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 8, 0, input);

                        throw nvae;
                    }
                    switch (alt8) {
                        case 1 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:157:11: baseOffset4
                            {
                            pushFollow(FOLLOW_baseOffset4_in_load262);
                            baseOffset43=baseOffset4();

                            state._fsp--;

                             opCode=1; op[0]=(baseOffset43!=null?baseOffset43.offset:0); op[1]=(baseOffset43!=null?baseOffset43.base:0); 

                            }
                            break;
                        case 2 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:158:10: index
                            {
                            pushFollow(FOLLOW_index_in_load278);
                            index4=index();

                            state._fsp--;

                             opCode=2; op[0]=(index4!=null?index4.base:0); op[1]=(index4!=null?index4.index:0); 

                            }
                            break;

                    }

                    match(input,35,FOLLOW_35_in_load292); 
                    pushFollow(FOLLOW_register_in_load296);
                    d=register();

                    state._fsp--;

                     op[2] = d; 

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "load"


    // $ANTLR start "store"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:160:1: store : 'st' s= register ',' ( baseOffset4 | index ) ;
    public final void store() throws RecognitionException {
        int s = 0;

        AsmSM213Parser.baseOffset4_return baseOffset45 = null;

        AsmSM213Parser.index_return index6 = null;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:160:7: ( 'st' s= register ',' ( baseOffset4 | index ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:160:9: 'st' s= register ',' ( baseOffset4 | index )
            {
            match(input,17,FOLLOW_17_in_store306); 
            pushFollow(FOLLOW_register_in_store310);
            s=register();

            state._fsp--;

             op[0]=s; 
            match(input,35,FOLLOW_35_in_store314); 
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:161:4: ( baseOffset4 | index )
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( ((LA10_0>=Hex && LA10_0<=Decimal)) ) {
                alt10=1;
            }
            else if ( (LA10_0==38) ) {
                int LA10_2 = input.LA(2);

                if ( (LA10_2==Register) ) {
                    int LA10_3 = input.LA(3);

                    if ( (LA10_3==39) ) {
                        alt10=1;
                    }
                    else if ( (LA10_3==35) ) {
                        alt10=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 3, input);

                        throw nvae;
                    }
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 10, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }
            switch (alt10) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:161:6: baseOffset4
                    {
                    pushFollow(FOLLOW_baseOffset4_in_store322);
                    baseOffset45=baseOffset4();

                    state._fsp--;

                     opCode=3; op[1]=(baseOffset45!=null?baseOffset45.offset:0); op[2]=(baseOffset45!=null?baseOffset45.base:0); 

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:162:4: index
                    {
                    pushFollow(FOLLOW_index_in_store332);
                    index6=index();

                    state._fsp--;

                     opCode=4; op[1]=(index6!=null?index6.base:0); op[2]=(index6!=null?index6.index:0); 

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "store"


    // $ANTLR start "aluOne"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:1: aluOne : ( 'not' | 'inc' | 'inca' | 'dec' | 'deca' ) register ;
    public final void aluOne() throws RecognitionException {
        int register7 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:8: ( ( 'not' | 'inc' | 'inca' | 'dec' | 'deca' ) register )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:10: ( 'not' | 'inc' | 'inca' | 'dec' | 'deca' ) register
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:10: ( 'not' | 'inc' | 'inca' | 'dec' | 'deca' )
            int alt11=5;
            switch ( input.LA(1) ) {
            case 18:
                {
                alt11=1;
                }
                break;
            case 19:
                {
                alt11=2;
                }
                break;
            case 20:
                {
                alt11=3;
                }
                break;
            case 21:
                {
                alt11=4;
                }
                break;
            case 22:
                {
                alt11=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;
            }

            switch (alt11) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:12: 'not'
                    {
                    match(input,18,FOLLOW_18_in_aluOne345); 
                    opCode=0x67;

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:35: 'inc'
                    {
                    match(input,19,FOLLOW_19_in_aluOne351); 
                    opCode=0x63;

                    }
                    break;
                case 3 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:58: 'inca'
                    {
                    match(input,20,FOLLOW_20_in_aluOne357); 
                    opCode=0x64;

                    }
                    break;
                case 4 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:82: 'dec'
                    {
                    match(input,21,FOLLOW_21_in_aluOne363); 
                    opCode=0x65;

                    }
                    break;
                case 5 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:163:105: 'deca'
                    {
                    match(input,22,FOLLOW_22_in_aluOne369); 
                    opCode=0x66;

                    }
                    break;

            }

            pushFollow(FOLLOW_register_in_aluOne374);
            register7=register();

            state._fsp--;

            op[1] = register7;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "aluOne"


    // $ANTLR start "aluTwo"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:164:1: aluTwo : ( 'mov' | 'add' | 'and' ) s= register ',' d= register ;
    public final void aluTwo() throws RecognitionException {
        int s = 0;

        int d = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:164:8: ( ( 'mov' | 'add' | 'and' ) s= register ',' d= register )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:164:10: ( 'mov' | 'add' | 'and' ) s= register ',' d= register
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:164:10: ( 'mov' | 'add' | 'and' )
            int alt12=3;
            switch ( input.LA(1) ) {
            case 24:
                {
                alt12=1;
                }
                break;
            case 25:
                {
                alt12=2;
                }
                break;
            case 26:
                {
                alt12=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:164:12: 'mov'
                    {
                    match(input,24,FOLLOW_24_in_aluTwo385); 
                    opCode=0x60;

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:164:35: 'add'
                    {
                    match(input,25,FOLLOW_25_in_aluTwo391); 
                    opCode=0x61;

                    }
                    break;
                case 3 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:164:58: 'and'
                    {
                    match(input,26,FOLLOW_26_in_aluTwo397); 
                    opCode=0x62;

                    }
                    break;

            }

            pushFollow(FOLLOW_register_in_aluTwo405);
            s=register();

            state._fsp--;

            op[0]=s;
            match(input,35,FOLLOW_35_in_aluTwo409); 
            pushFollow(FOLLOW_register_in_aluTwo413);
            d=register();

            state._fsp--;

            op[1]=d;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "aluTwo"


    // $ANTLR start "gpc"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:165:1: gpc : 'gpc' literal ',' register ;
    public final void gpc() throws RecognitionException {
        int literal8 = 0;

        int register9 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:165:9: ( 'gpc' literal ',' register )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:165:11: 'gpc' literal ',' register
            {
            match(input,23,FOLLOW_23_in_gpc426); 
            pushFollow(FOLLOW_literal_in_gpc428);
            literal8=literal();

            state._fsp--;

            match(input,35,FOLLOW_35_in_gpc430); 
            pushFollow(FOLLOW_register_in_gpc432);
            register9=register();

            state._fsp--;

            opCode=0x6f; op[0]=literal8; op[1]=register9;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "gpc"


    // $ANTLR start "shift"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:1: shift : ( ( 'shl' | 'shr' ) literal ',' register ) ;
    public final void shift() throws RecognitionException {
        int register10 = 0;

        int literal11 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:7: ( ( ( 'shl' | 'shr' ) literal ',' register ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:9: ( ( 'shl' | 'shr' ) literal ',' register )
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:9: ( ( 'shl' | 'shr' ) literal ',' register )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:11: ( 'shl' | 'shr' ) literal ',' register
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:11: ( 'shl' | 'shr' )
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==27) ) {
                alt13=1;
            }
            else if ( (LA13_0==28) ) {
                alt13=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }
            switch (alt13) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:13: 'shl'
                    {
                    match(input,27,FOLLOW_27_in_shift445); 
                    op[1]=1;

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:166:32: 'shr'
                    {
                    match(input,28,FOLLOW_28_in_shift451); 
                    op[1]=-1;

                    }
                    break;

            }

            pushFollow(FOLLOW_literal_in_shift457);
            literal11=literal();

            state._fsp--;

            match(input,35,FOLLOW_35_in_shift459); 
            pushFollow(FOLLOW_register_in_shift461);
            register10=register();

            state._fsp--;


            }

            opCode=0x7; op[0]=register10; op[1]*=literal11;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "shift"


    // $ANTLR start "branch"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:1: branch : ( ( 'br' ( label | number ) ) | ( ( 'beq' | 'bgt' ) register ',' ( label | number ) ) );
    public final void branch() throws RecognitionException {
        AsmSM213Parser.label_return label12 = null;

        int number13 = 0;

        AsmSM213Parser.label_return label14 = null;

        int number15 = 0;

        int register16 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:9: ( ( 'br' ( label | number ) ) | ( ( 'beq' | 'bgt' ) register ',' ( label | number ) ) )
            int alt17=2;
            int LA17_0 = input.LA(1);

            if ( (LA17_0==29) ) {
                alt17=1;
            }
            else if ( ((LA17_0>=30 && LA17_0<=31)) ) {
                alt17=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;
            }
            switch (alt17) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:11: ( 'br' ( label | number ) )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:11: ( 'br' ( label | number ) )
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:13: 'br' ( label | number )
                    {
                    match(input,29,FOLLOW_29_in_branch475); 
                    opCode=0x8;
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:32: ( label | number )
                    int alt14=2;
                    int LA14_0 = input.LA(1);

                    if ( (LA14_0==Identifier||(LA14_0>=16 && LA14_0<=34)) ) {
                        alt14=1;
                    }
                    else if ( ((LA14_0>=Hex && LA14_0<=Decimal)) ) {
                        alt14=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 14, 0, input);

                        throw nvae;
                    }
                    switch (alt14) {
                        case 1 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:33: label
                            {
                            pushFollow(FOLLOW_label_in_branch480);
                            label12=label();

                            state._fsp--;

                            op[1]=(label12!=null?label12.value:0);

                            }
                            break;
                        case 2 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:63: number
                            {
                            pushFollow(FOLLOW_number_in_branch486);
                            number13=number();

                            state._fsp--;

                            op[1]=number13;

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:97: ( ( 'beq' | 'bgt' ) register ',' ( label | number ) )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:97: ( ( 'beq' | 'bgt' ) register ',' ( label | number ) )
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:99: ( 'beq' | 'bgt' ) register ',' ( label | number )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:99: ( 'beq' | 'bgt' )
                    int alt15=2;
                    int LA15_0 = input.LA(1);

                    if ( (LA15_0==30) ) {
                        alt15=1;
                    }
                    else if ( (LA15_0==31) ) {
                        alt15=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 15, 0, input);

                        throw nvae;
                    }
                    switch (alt15) {
                        case 1 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:101: 'beq'
                            {
                            match(input,30,FOLLOW_30_in_branch498); 
                            opCode=0x9;

                            }
                            break;
                        case 2 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:122: 'bgt'
                            {
                            match(input,31,FOLLOW_31_in_branch503); 
                            opCode=0xa;

                            }
                            break;

                    }

                    pushFollow(FOLLOW_register_in_branch508);
                    register16=register();

                    state._fsp--;

                    match(input,35,FOLLOW_35_in_branch510); 
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:156: ( label | number )
                    int alt16=2;
                    int LA16_0 = input.LA(1);

                    if ( (LA16_0==Identifier||(LA16_0>=16 && LA16_0<=34)) ) {
                        alt16=1;
                    }
                    else if ( ((LA16_0>=Hex && LA16_0<=Decimal)) ) {
                        alt16=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 16, 0, input);

                        throw nvae;
                    }
                    switch (alt16) {
                        case 1 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:157: label
                            {
                            pushFollow(FOLLOW_label_in_branch513);
                            label14=label();

                            state._fsp--;

                            op[1]=(label14!=null?label14.value:0);

                            }
                            break;
                        case 2 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:167:187: number
                            {
                            pushFollow(FOLLOW_number_in_branch519);
                            number15=number();

                            state._fsp--;

                            op[1]=number15;

                            }
                            break;

                    }

                    op[0]=register16;

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "branch"


    // $ANTLR start "jump"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:1: jump : 'j' ( ( label | number ) | b1= baseOffset2 | ( '*' b2= baseOffset4 ) | ( '*' index ) ) ;
    public final void jump() throws RecognitionException {
        AsmSM213Parser.baseOffset2_return b1 = null;

        AsmSM213Parser.baseOffset4_return b2 = null;

        AsmSM213Parser.label_return label17 = null;

        int number18 = 0;

        AsmSM213Parser.index_return index19 = null;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:6: ( 'j' ( ( label | number ) | b1= baseOffset2 | ( '*' b2= baseOffset4 ) | ( '*' index ) ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:8: 'j' ( ( label | number ) | b1= baseOffset2 | ( '*' b2= baseOffset4 ) | ( '*' index ) )
            {
            match(input,32,FOLLOW_32_in_jump532); 
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:12: ( ( label | number ) | b1= baseOffset2 | ( '*' b2= baseOffset4 ) | ( '*' index ) )
            int alt19=4;
            alt19 = dfa19.predict(input);
            switch (alt19) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:14: ( label | number )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:14: ( label | number )
                    int alt18=2;
                    int LA18_0 = input.LA(1);

                    if ( (LA18_0==Identifier||(LA18_0>=16 && LA18_0<=34)) ) {
                        alt18=1;
                    }
                    else if ( ((LA18_0>=Hex && LA18_0<=Decimal)) ) {
                        alt18=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 18, 0, input);

                        throw nvae;
                    }
                    switch (alt18) {
                        case 1 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:15: label
                            {
                            pushFollow(FOLLOW_label_in_jump537);
                            label17=label();

                            state._fsp--;

                            opCode=0xb; op[1]=(label17!=null?label17.value:0);

                            }
                            break;
                        case 2 :
                            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:168:57: number
                            {
                            pushFollow(FOLLOW_number_in_jump543);
                            number18=number();

                            state._fsp--;

                            opCode=0xb; op[1]=number18;

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:169:9: b1= baseOffset2
                    {
                    pushFollow(FOLLOW_baseOffset2_in_jump562);
                    b1=baseOffset2();

                    state._fsp--;

                    opCode=0xc; op[0]=(b1!=null?b1.base:0); op[1]=(b1!=null?b1.offset:0);

                    }
                    break;
                case 3 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:170:9: ( '*' b2= baseOffset4 )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:170:9: ( '*' b2= baseOffset4 )
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:170:11: '*' b2= baseOffset4
                    {
                    match(input,36,FOLLOW_36_in_jump579); 
                    pushFollow(FOLLOW_baseOffset4_in_jump583);
                    b2=baseOffset4();

                    state._fsp--;

                    opCode=0xd; op[0]=(b2!=null?b2.base:0); op[1]=(b2!=null?b2.offset:0);

                    }


                    }
                    break;
                case 4 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:170:81: ( '*' index )
                    {
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:170:81: ( '*' index )
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:170:82: '*' index
                    {
                    match(input,36,FOLLOW_36_in_jump591); 
                    pushFollow(FOLLOW_index_in_jump593);
                    index19=index();

                    state._fsp--;

                    opCode=0xe; op[0]=(index19!=null?index19.base:0); op[1]=(index19!=null?index19.index:0);

                    }


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "jump"


    // $ANTLR start "halt"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:171:1: halt : 'halt' ;
    public final void halt() throws RecognitionException {
        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:171:6: ( 'halt' )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:171:8: 'halt'
            {
            match(input,33,FOLLOW_33_in_halt604); 
            opCode=0xf0;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "halt"


    // $ANTLR start "nop"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:172:1: nop : 'nop' ;
    public final void nop() throws RecognitionException {
        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:172:5: ( 'nop' )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:172:7: 'nop'
            {
            match(input,34,FOLLOW_34_in_nop613); 
            opCode=0xff;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "nop"


    // $ANTLR start "literal"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:175:1: literal returns [int value] : '$' ( number | label ) ;
    public final int literal() throws RecognitionException {
        int value = 0;

        int number20 = 0;

        AsmSM213Parser.label_return label21 = null;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:176:2: ( '$' ( number | label ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:176:4: '$' ( number | label )
            {
            match(input,37,FOLLOW_37_in_literal629); 
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:176:8: ( number | label )
            int alt20=2;
            int LA20_0 = input.LA(1);

            if ( ((LA20_0>=Hex && LA20_0<=Decimal)) ) {
                alt20=1;
            }
            else if ( (LA20_0==Identifier||(LA20_0>=16 && LA20_0<=34)) ) {
                alt20=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;
            }
            switch (alt20) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:176:9: number
                    {
                    pushFollow(FOLLOW_number_in_literal632);
                    number20=number();

                    state._fsp--;

                     value = number20; 

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:176:46: label
                    {
                    pushFollow(FOLLOW_label_in_literal638);
                    label21=label();

                    state._fsp--;

                     value = (label21!=null?label21.value:0); 

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "literal"

    public static class baseOffset2_return extends ParserRuleReturnScope {
        public int offset;
        public int base;
    };

    // $ANTLR start "baseOffset2"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:177:1: baseOffset2 returns [int offset, int base] : ( number )? '(' register ')' ;
    public final AsmSM213Parser.baseOffset2_return baseOffset2() throws RecognitionException {
        AsmSM213Parser.baseOffset2_return retval = new AsmSM213Parser.baseOffset2_return();
        retval.start = input.LT(1);

        int number22 = 0;

        int register23 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:178:2: ( ( number )? '(' register ')' )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:178:4: ( number )? '(' register ')'
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:178:4: ( number )?
            int alt21=2;
            int LA21_0 = input.LA(1);

            if ( ((LA21_0>=Hex && LA21_0<=Decimal)) ) {
                alt21=1;
            }
            switch (alt21) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:178:4: number
                    {
                    pushFollow(FOLLOW_number_in_baseOffset2653);
                    number22=number();

                    state._fsp--;


                    }
                    break;

            }

            match(input,38,FOLLOW_38_in_baseOffset2656); 
            pushFollow(FOLLOW_register_in_baseOffset2658);
            register23=register();

            state._fsp--;

            match(input,39,FOLLOW_39_in_baseOffset2660); 
             retval.offset =number22; retval.base =register23; if ((retval.offset%2)!=0) emitErrorMessage ("Offset must be a multiple of 2");

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "baseOffset2"

    public static class baseOffset4_return extends ParserRuleReturnScope {
        public int offset;
        public int base;
    };

    // $ANTLR start "baseOffset4"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:179:1: baseOffset4 returns [int offset, int base] : ( number )? '(' register ')' ;
    public final AsmSM213Parser.baseOffset4_return baseOffset4() throws RecognitionException {
        AsmSM213Parser.baseOffset4_return retval = new AsmSM213Parser.baseOffset4_return();
        retval.start = input.LT(1);

        int number24 = 0;

        int register25 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:180:2: ( ( number )? '(' register ')' )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:180:4: ( number )? '(' register ')'
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:180:4: ( number )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( ((LA22_0>=Hex && LA22_0<=Decimal)) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:180:4: number
                    {
                    pushFollow(FOLLOW_number_in_baseOffset4674);
                    number24=number();

                    state._fsp--;


                    }
                    break;

            }

            match(input,38,FOLLOW_38_in_baseOffset4677); 
            pushFollow(FOLLOW_register_in_baseOffset4679);
            register25=register();

            state._fsp--;

            match(input,39,FOLLOW_39_in_baseOffset4681); 
             retval.offset =number24; retval.base =register25; if ((retval.offset%4)!=0) emitErrorMessage ("Offset must be a multiple of 4");

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "baseOffset4"

    public static class index_return extends ParserRuleReturnScope {
        public int base;
        public int index;
    };

    // $ANTLR start "index"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:181:1: index returns [int base, int index] : '(' b= register ',' i= register ',' decimal ')' ;
    public final AsmSM213Parser.index_return index() throws RecognitionException {
        AsmSM213Parser.index_return retval = new AsmSM213Parser.index_return();
        retval.start = input.LT(1);

        int b = 0;

        int i = 0;

        int decimal26 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:182:2: ( '(' b= register ',' i= register ',' decimal ')' )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:182:4: '(' b= register ',' i= register ',' decimal ')'
            {
            match(input,38,FOLLOW_38_in_index695); 
            pushFollow(FOLLOW_register_in_index699);
            b=register();

            state._fsp--;

            match(input,35,FOLLOW_35_in_index701); 
            pushFollow(FOLLOW_register_in_index705);
            i=register();

            state._fsp--;

            match(input,35,FOLLOW_35_in_index707); 
            pushFollow(FOLLOW_decimal_in_index709);
            decimal26=decimal();

            state._fsp--;

            match(input,39,FOLLOW_39_in_index711); 
             retval.base = b; retval.index = i; if (decimal26!=4) emitErrorMessage ("In index, scale must be 4"); 

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "index"


    // $ANTLR start "register"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:183:1: register returns [int value] : Register ;
    public final int register() throws RecognitionException {
        int value = 0;

        Token Register27=null;

        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:184:2: ( Register )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:184:4: Register
            {
            Register27=(Token)match(input,Register,FOLLOW_Register_in_register725); 
             value = Integer.parseInt ((Register27!=null?Register27.getText():null).substring(1)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "register"


    // $ANTLR start "number"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:185:1: number returns [int value] : ( decimal | hex );
    public final int number() throws RecognitionException {
        int value = 0;

        int decimal28 = 0;

        int hex29 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:186:3: ( decimal | hex )
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==Decimal) ) {
                alt23=1;
            }
            else if ( (LA23_0==Hex) ) {
                alt23=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 23, 0, input);

                throw nvae;
            }
            switch (alt23) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:186:5: decimal
                    {
                    pushFollow(FOLLOW_decimal_in_number740);
                    decimal28=decimal();

                    state._fsp--;

                     value =decimal28; 

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:186:42: hex
                    {
                    pushFollow(FOLLOW_hex_in_number746);
                    hex29=hex();

                    state._fsp--;

                     value =hex29; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "number"


    // $ANTLR start "hex"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:187:1: hex returns [int value] : Hex ;
    public final int hex() throws RecognitionException {
        int value = 0;

        Token Hex30=null;

        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:188:2: ( Hex )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:188:4: Hex
            {
            Hex30=(Token)match(input,Hex,FOLLOW_Hex_in_hex761); 
             value =(int)(Long.parseLong((Hex30!=null?Hex30.getText():null).substring(2),16)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "hex"


    // $ANTLR start "decimal"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:190:1: decimal returns [int value] : Decimal ;
    public final int decimal() throws RecognitionException {
        int value = 0;

        Token Decimal31=null;

        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:191:3: ( Decimal )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:191:5: Decimal
            {
            Decimal31=(Token)match(input,Decimal,FOLLOW_Decimal_in_decimal780); 
             value =(int)(Long.parseLong((Decimal31!=null?Decimal31.getText():null))); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "decimal"


    // $ANTLR start "directive"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:193:1: directive : ( address | data );
    public final void directive() throws RecognitionException {
        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:194:2: ( address | data )
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( ((LA24_0>=40 && LA24_0<=41)) ) {
                alt24=1;
            }
            else if ( ((LA24_0>=42 && LA24_0<=43)) ) {
                alt24=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;
            }
            switch (alt24) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:194:4: address
                    {
                    pushFollow(FOLLOW_address_in_directive797);
                    address();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:194:14: data
                    {
                    pushFollow(FOLLOW_data_in_directive801);
                    data();

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "directive"


    // $ANTLR start "address"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:195:1: address : ( ( '.address' | '.pos' ) hex ) ;
    public final void address() throws RecognitionException {
        int hex32 = 0;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:195:9: ( ( ( '.address' | '.pos' ) hex ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:195:11: ( ( '.address' | '.pos' ) hex )
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:195:11: ( ( '.address' | '.pos' ) hex )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:195:12: ( '.address' | '.pos' ) hex
            {
            if ( (input.LA(1)>=40 && input.LA(1)<=41) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            pushFollow(FOLLOW_hex_in_address817);
            hex32=hex();

            state._fsp--;

             pc = hex32; 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "address"


    // $ANTLR start "data"
    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:1: data : ( ( '.long' | '.data' ) (value= number | label ) ( ',' count= number )? ) ;
    public final void data() throws RecognitionException {
        int value = 0;

        int count = 0;

        AsmSM213Parser.label_return label33 = null;


        try {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:6: ( ( ( '.long' | '.data' ) (value= number | label ) ( ',' count= number )? ) )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:8: ( ( '.long' | '.data' ) (value= number | label ) ( ',' count= number )? )
            {
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:8: ( ( '.long' | '.data' ) (value= number | label ) ( ',' count= number )? )
            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:9: ( '.long' | '.data' ) (value= number | label ) ( ',' count= number )?
            {
            if ( (input.LA(1)>=42 && input.LA(1)<=43) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:29: (value= number | label )
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( ((LA25_0>=Hex && LA25_0<=Decimal)) ) {
                alt25=1;
            }
            else if ( (LA25_0==Identifier||(LA25_0>=16 && LA25_0<=34)) ) {
                alt25=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 25, 0, input);

                throw nvae;
            }
            switch (alt25) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:30: value= number
                    {
                    pushFollow(FOLLOW_number_in_data839);
                    value=number();

                    state._fsp--;

                    dataValue=value;

                    }
                    break;
                case 2 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:71: label
                    {
                    pushFollow(FOLLOW_label_in_data845);
                    label33=label();

                    state._fsp--;

                    dataValue=(label33!=null?label33.value:0);

                    }
                    break;

            }

            // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:104: ( ',' count= number )?
            int alt26=2;
            int LA26_0 = input.LA(1);

            if ( (LA26_0==35) ) {
                alt26=1;
            }
            switch (alt26) {
                case 1 :
                    // /Users/feeley/Documents/Work/Courses/SimpleMachine/Grammar/Source/AsmSM213.g:196:105: ',' count= number
                    {
                    match(input,35,FOLLOW_35_in_data851); 
                    pushFollow(FOLLOW_number_in_data855);
                    count=number();

                    state._fsp--;


                    }
                    break;

            }


            }

             lineType = LineType.DATA; dataCount= count>0? count : 1; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "data"

    // Delegated rules


    protected DFA2 dfa2 = new DFA2(this);
    protected DFA19 dfa19 = new DFA19(this);
    static final String DFA2_eotS =
        "\26\uffff";
    static final String DFA2_eofS =
        "\26\uffff";
    static final String DFA2_minS =
        "\1\4\1\uffff\1\10\11\7\3\17\1\6\2\7\1\6\2\4\1\uffff";
    static final String DFA2_maxS =
        "\1\53\1\uffff\1\46\11\17\3\45\1\42\2\17\1\46\2\17\1\uffff";
    static final String DFA2_acceptS =
        "\1\uffff\1\1\23\uffff\1\2";
    static final String DFA2_specialS =
        "\26\uffff}>";
    static final String[] DFA2_transitionS = {
            "\2\25\1\1\11\uffff\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\14\1\11\1"+
            "\12\1\13\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24\5\uffff\4\25",
            "",
            "\2\25\5\uffff\1\1\25\uffff\2\25",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\1\25\uffff\1\25",
            "\1\1\25\uffff\1\25",
            "\1\1\25\uffff\1\25",
            "\1\25\1\uffff\2\25\5\uffff\1\1\23\25",
            "\1\25\7\uffff\1\1",
            "\1\25\7\uffff\1\1",
            "\1\25\1\uffff\2\25\5\uffff\1\1\23\25\1\uffff\1\25\1\uffff\1"+
            "\25",
            "\2\25\11\uffff\1\1",
            "\2\25\11\uffff\1\1",
            ""
    };

    static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
    static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
    static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
    static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
    static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
    static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
    static final short[][] DFA2_transition;

    static {
        int numStates = DFA2_transitionS.length;
        DFA2_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
        }
    }

    class DFA2 extends DFA {

        public DFA2(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 2;
            this.eot = DFA2_eot;
            this.eof = DFA2_eof;
            this.min = DFA2_min;
            this.max = DFA2_max;
            this.accept = DFA2_accept;
            this.special = DFA2_special;
            this.transition = DFA2_transition;
        }
        public String getDescription() {
            return "144:8: ( labelDeclaration )?";
        }
    }
    static final String DFA19_eotS =
        "\12\uffff";
    static final String DFA19_eofS =
        "\12\uffff";
    static final String DFA19_minS =
        "\1\6\1\uffff\2\4\1\uffff\1\10\1\uffff\1\7\1\43\1\uffff";
    static final String DFA19_maxS =
        "\1\46\1\uffff\2\46\1\uffff\1\46\1\uffff\1\7\1\47\1\uffff";
    static final String DFA19_acceptS =
        "\1\uffff\1\1\2\uffff\1\2\1\uffff\1\3\2\uffff\1\4";
    static final String DFA19_specialS =
        "\12\uffff}>";
    static final String[] DFA19_transitionS = {
            "\1\1\1\uffff\1\3\1\2\6\uffff\23\1\1\uffff\1\5\1\uffff\1\4",
            "",
            "\2\1\40\uffff\1\4",
            "\2\1\40\uffff\1\4",
            "",
            "\2\6\34\uffff\1\7",
            "",
            "\1\10",
            "\1\11\3\uffff\1\6",
            ""
    };

    static final short[] DFA19_eot = DFA.unpackEncodedString(DFA19_eotS);
    static final short[] DFA19_eof = DFA.unpackEncodedString(DFA19_eofS);
    static final char[] DFA19_min = DFA.unpackEncodedStringToUnsignedChars(DFA19_minS);
    static final char[] DFA19_max = DFA.unpackEncodedStringToUnsignedChars(DFA19_maxS);
    static final short[] DFA19_accept = DFA.unpackEncodedString(DFA19_acceptS);
    static final short[] DFA19_special = DFA.unpackEncodedString(DFA19_specialS);
    static final short[][] DFA19_transition;

    static {
        int numStates = DFA19_transitionS.length;
        DFA19_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA19_transition[i] = DFA.unpackEncodedString(DFA19_transitionS[i]);
        }
    }

    class DFA19 extends DFA {

        public DFA19(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 19;
            this.eot = DFA19_eot;
            this.eof = DFA19_eof;
            this.min = DFA19_min;
            this.max = DFA19_max;
            this.accept = DFA19_accept;
            this.special = DFA19_special;
            this.transition = DFA19_transition;
        }
        public String getDescription() {
            return "168:12: ( ( label | number ) | b1= baseOffset2 | ( '*' b2= baseOffset4 ) | ( '*' index ) )";
        }
    }
 

    public static final BitSet FOLLOW_line_in_program46 = new BitSet(new long[]{0x00000F07FFFF0070L});
    public static final BitSet FOLLOW_EOF_in_program49 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_labelDeclaration_in_line58 = new BitSet(new long[]{0x00000F07FFFF0030L});
    public static final BitSet FOLLOW_instruction_in_line64 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_directive_in_line68 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_NewLine_in_line75 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_Comment_in_line80 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_Identifier_in_labelDeclaration97 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_operand_in_labelDeclaration101 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_15_in_labelDeclaration104 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_Identifier_in_label119 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_operand_in_label123 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_load_in_instruction138 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_store_in_instruction142 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_aluOne_in_instruction146 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_aluTwo_in_instruction150 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_gpc_in_instruction154 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_shift_in_instruction158 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_branch_in_instruction162 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jump_in_instruction166 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_halt_in_instruction170 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_nop_in_instruction174 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_operand184 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_16_in_load231 = new BitSet(new long[]{0x0000006000000300L});
    public static final BitSet FOLLOW_literal_in_load236 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_load240 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_load244 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_baseOffset4_in_load262 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_index_in_load278 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_load292 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_load296 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_17_in_store306 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_store310 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_store314 = new BitSet(new long[]{0x0000006000000300L});
    public static final BitSet FOLLOW_baseOffset4_in_store322 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_index_in_store332 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_18_in_aluOne345 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_19_in_aluOne351 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_20_in_aluOne357 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_21_in_aluOne363 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_22_in_aluOne369 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_aluOne374 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_24_in_aluTwo385 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_25_in_aluTwo391 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_26_in_aluTwo397 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_aluTwo405 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_aluTwo409 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_aluTwo413 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_23_in_gpc426 = new BitSet(new long[]{0x0000002000000000L});
    public static final BitSet FOLLOW_literal_in_gpc428 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_gpc430 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_gpc432 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_27_in_shift445 = new BitSet(new long[]{0x0000002000000000L});
    public static final BitSet FOLLOW_28_in_shift451 = new BitSet(new long[]{0x0000002000000000L});
    public static final BitSet FOLLOW_literal_in_shift457 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_shift459 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_shift461 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_29_in_branch475 = new BitSet(new long[]{0x00000007FFFF0340L});
    public static final BitSet FOLLOW_label_in_branch480 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_number_in_branch486 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_30_in_branch498 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_31_in_branch503 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_branch508 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_branch510 = new BitSet(new long[]{0x00000007FFFF0340L});
    public static final BitSet FOLLOW_label_in_branch513 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_number_in_branch519 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_32_in_jump532 = new BitSet(new long[]{0x00000057FFFF0340L});
    public static final BitSet FOLLOW_label_in_jump537 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_number_in_jump543 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_baseOffset2_in_jump562 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_36_in_jump579 = new BitSet(new long[]{0x0000004000000300L});
    public static final BitSet FOLLOW_baseOffset4_in_jump583 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_36_in_jump591 = new BitSet(new long[]{0x0000006000000300L});
    public static final BitSet FOLLOW_index_in_jump593 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_33_in_halt604 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_34_in_nop613 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_37_in_literal629 = new BitSet(new long[]{0x00000007FFFF0340L});
    public static final BitSet FOLLOW_number_in_literal632 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_label_in_literal638 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_number_in_baseOffset2653 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_38_in_baseOffset2656 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_baseOffset2658 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_39_in_baseOffset2660 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_number_in_baseOffset4674 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_38_in_baseOffset4677 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_baseOffset4679 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_39_in_baseOffset4681 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_38_in_index695 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_index699 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_index701 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_register_in_index705 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_35_in_index707 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_decimal_in_index709 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_39_in_index711 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_Register_in_register725 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_decimal_in_number740 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_hex_in_number746 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_Hex_in_hex761 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_Decimal_in_decimal780 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_address_in_directive797 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_data_in_directive801 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_address809 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_hex_in_address817 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_data828 = new BitSet(new long[]{0x00000007FFFF0340L});
    public static final BitSet FOLLOW_number_in_data839 = new BitSet(new long[]{0x0000000800000002L});
    public static final BitSet FOLLOW_label_in_data845 = new BitSet(new long[]{0x0000000800000002L});
    public static final BitSet FOLLOW_35_in_data851 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_number_in_data855 = new BitSet(new long[]{0x0000000000000002L});

}