/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoableEdit;
import ui.gui.MessageBoard;
import ui.gui.UI;
import ui.gui.ViewFormat;
import ui.gui.ViewModel;
import util.DataModelEvent;
import util.TableCellIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class View
extends JTable
implements ViewModel.Listener,
UndoableEditListener {
    private MessageBoard messageBoard;
    private List<ViewFormat> columnFormats;
    private Map<TableCellIndex, ViewFormat.HighlightCell> highlights;
    private ArrayList<AccessListener> accessListeners = new ArrayList();
    Vector<SizeChangedListener> sizeChangedListeners = new Vector();
    private Vector<SelectionListener> selectionListeners = new Vector();
    Vector<UndoableEditListener> undoableEditListeners = new Vector();

    View(ViewModel aModel, MessageBoard aMessageBoard, List<ViewFormat> aColumnFormats) {
        super(aModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.messageBoard = aMessageBoard;
        this.columnFormats = aColumnFormats;
        this.highlights = new HashMap<TableCellIndex, ViewFormat.HighlightCell>();
        this.setupColumns();
        ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        aModel.addListener(this);
        this.setColumnSelectionAllowed(true);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean okayToClear;
                if (!View.contains(View.this.getComponents(), e.getOppositeComponent()) && (okayToClear = View.this.getCellEditor() != null ? View.this.getCellEditor().stopCellEditing() : true)) {
                    View.this.clearSelection();
                }
            }
        });
    }

    private static boolean contains(Component[] c, Component t) {
        for (int i = 0; i < c.length; ++i) {
            if (c[i].equals(t)) {
                return true;
            }
            if (!(c[i] instanceof Container) || !View.contains(((Container)c[i]).getComponents(), t)) continue;
            return true;
        }
        return false;
    }

    private void setupColumns() {
        TableModel model = this.getModel();
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            ViewFormat columnFormat = this.columnFormats.get(i);
            column.setPreferredWidth(columnFormat.getWidth());
            if (!columnFormat.isWidthVariable()) {
                column.setMinWidth(columnFormat.getWidth());
                column.setMaxWidth(columnFormat.getWidth());
            }
            column.setCellRenderer(new CellRenderer());
            if (!columnFormat.isEditable()) continue;
            JComponent prototype = columnFormat.getEditorPrototype();
            if (prototype instanceof JTextField) {
                JTextField prototypeTF = (JTextField)prototype;
                column.setCellEditor(new CellEditor(prototypeTF, columnFormat));
                prototypeTF.getDocument().addUndoableEditListener(this);
                continue;
            }
            column.setCellEditor(new CellEditor((JCheckBox)prototype, columnFormat));
        }
    }

    private void syncColumnWidths() {
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            ViewFormat columnFormat = this.columnFormats.get(i);
            if (!columnFormat.isWidthVariable()) {
                column.setMinWidth(columnFormat.getWidth());
                column.setMaxWidth(columnFormat.getWidth());
            }
            column.setPreferredWidth(columnFormat.getWidth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelTouched(DataModelEvent event) {
        ViewModel model = (ViewModel)this.getModel();
        List<TableCellIndex> cells = event.getCells();
        Map<TableCellIndex, ViewFormat.HighlightCell> map = this.highlights;
        synchronized (map) {
            for (TableCellIndex cell : cells) {
                boolean isEnd;
                boolean isStart = !cells.contains(model.prevDataCell(cell));
                boolean bl = isEnd = !cells.contains(model.nextDataCell(cell));
                DataModelEvent.Type type = event.getType();
                if (!ViewFormat.HighlightControl.isHighlightType(type) || type == DataModelEvent.Type.CURSOR_CLEAR && this.highlights.get(cell) != null && this.highlights.get((Object)cell).type != DataModelEvent.Type.CURSOR_SET) continue;
                this.highlights.put(cell, new ViewFormat.HighlightCell(event.getType(), isStart, isEnd));
            }
        }
        int columnCount = 0;
        for (int i = 0; i < cells.size(); ++i) {
            TableCellIndex nextCell;
            TableCellIndex cell;
            cell = cells.get(i);
            TableCellIndex tableCellIndex = nextCell = i + 1 < cells.size() ? cells.get(i + 1) : null;
            if (nextCell != null && cell.rowIndex == nextCell.rowIndex && cell.columnIndex == nextCell.columnIndex - 1) {
                ++columnCount;
                continue;
            }
            this.fireAccess(event.getType(), cell.rowIndex, cell.columnIndex - columnCount, columnCount + 1);
            columnCount = 0;
        }
    }

    public void addAccessListener(AccessListener l) {
        this.accessListeners.add(l);
    }

    private void fireAccess(DataModelEvent.Type type, int rowIndex, int columnIndex, int count) {
        for (AccessListener l : this.accessListeners) {
            if (AccessListener.Type.valueOf(type) == null) continue;
            l.access(AccessListener.Type.valueOf(type), rowIndex, columnIndex, count);
        }
    }

    @Override
    public void changingModel(boolean cancelEditing, List<TableCellIndex> cells) {
        TableCellEditor cellEditor;
        if (cancelEditing && (cellEditor = this.getCellEditor()) != null) {
            cellEditor.cancelCellEditing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustHighlights(boolean clear) {
        Vector<TableCellIndex> changesToFire = new Vector<TableCellIndex>();
        Vector<TableCellIndex> cellsToRemove = new Vector<TableCellIndex>();
        Map<TableCellIndex, ViewFormat.HighlightCell> map = this.highlights;
        synchronized (map) {
            for (Map.Entry<TableCellIndex, ViewFormat.HighlightCell> mapEntry : this.highlights.entrySet()) {
                changesToFire.add(mapEntry.getKey());
                if (clear || !mapEntry.getValue().fade()) continue;
                cellsToRemove.add(mapEntry.getKey());
            }
            if (clear) {
                this.highlights.clear();
            } else {
                for (TableCellIndex cell : cellsToRemove) {
                    this.highlights.remove(cell);
                }
            }
        }
        for (TableCellIndex cell : changesToFire) {
            ((AbstractTableModel)this.getModel()).fireTableCellUpdated(cell.rowIndex, cell.columnIndex);
        }
    }

    public void adjustFontSize(int increment) {
        for (ViewFormat columnFormat : this.columnFormats) {
            columnFormat.adjustFontSize(increment);
        }
        this.syncColumnWidths();
        this.setRowHeight(this.getRowHeight() + increment);
        this.tableChanged(new TableModelEvent(this.getModel()));
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.columnFormats.get(columnIndex).setWidth(width);
        this.syncColumnWidths();
        this.tableChanged(new TableModelEvent(this.getModel()));
        TableColumnModel columnModel = this.getColumnModel();
    }

    public ViewFormat getColumnFormat(int columnIndex) {
        return this.columnFormats.get(columnIndex);
    }

    public boolean insertAboveSelection() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = this.getEditingRow();
            col = this.getEditingColumn();
        }
        if (row < 0 || col < 0) {
            return false;
        }
        boolean inserted = ((ViewModel)this.getModel()).insertRow(row);
        return inserted;
    }

    public boolean insertBelowSelection() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = this.getEditingRow();
            col = this.getEditingColumn();
        }
        if (row < 0 || col < 0) {
            return false;
        }
        boolean inserted = ((ViewModel)this.getModel()).insertRow(row + 1);
        this.changeSelection(row + 1, col, false, false);
        return inserted;
    }

    public boolean deleteSelection() {
        boolean deleted;
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = this.getEditingRow();
            col = this.getEditingColumn();
        }
        if (row < 0 || col < 0) {
            return false;
        }
        ViewModel model = (ViewModel)this.getModel();
        if (model.getRowCount() > 1) {
            deleted = model.deleteRow(row);
            if (row == model.getRowCount()) {
                --row;
            }
            this.changeSelection(row, col, false, false);
        } else {
            deleted = false;
        }
        return deleted;
    }

    private void setBorderSelected(JComponent component) {
        Insets insets = component.getBorder().getBorderInsets(component);
        int insetTop = insets.top - 2;
        int insetBottom = insets.bottom - 2;
        if (insetTop >= 0 && insetBottom >= 0) {
            component.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(UI.SELECTION_COLOR, 1), new LineBorder(UI.SELECTION_COLOR.brighter(), 1)), new EmptyBorder(insetTop, 1, insetBottom, 1)));
        } else {
            component.setBorder(new CompoundBorder(new LineBorder(UI.SELECTION_COLOR, 1), new EmptyBorder(insetTop + 1, 2, insetBottom + 1, 2)));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getType() == 1 || e.getType() == -1) {
            this.fireSizeChanged();
            this.changeSelection(this.getSelectedRow(), this.getSelectedColumn(), false, false);
        }
    }

    public void addSizeChangedListener(SizeChangedListener l) {
        this.sizeChangedListeners.add(l);
    }

    private void fireSizeChanged() {
        for (SizeChangedListener l : this.sizeChangedListeners) {
            l.sizeChanged();
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    private void fireSelectionMayHaveChanged(boolean isKnownToBeSelected) {
        for (SelectionListener l : this.selectionListeners) {
            l.selectionMayHaveChanged(isKnownToBeSelected);
        }
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoableEditListeners.add(l);
    }

    public void removeUndoableEditListeners(UndoableEditListener l) {
        this.undoableEditListeners.remove(l);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        ViewEdit ve = new ViewEdit(e.getEdit());
        if (ve.canUndo()) {
            for (UndoableEditListener l : this.undoableEditListeners) {
                l.undoableEditHappened(new UndoableEditEvent(e.getSource(), ve));
            }
        }
    }

    class ViewEdit
    implements UndoableEdit {
        UndoableEdit baseEdit;
        int rowIndex;
        int columnIndex;

        ViewEdit(UndoableEdit anEdit) {
            this.baseEdit = anEdit;
            this.rowIndex = View.this.getEditingRow();
            this.columnIndex = View.this.getEditingColumn();
        }

        public boolean addEdit(UndoableEdit anEdit) {
            return this.baseEdit.addEdit(anEdit);
        }

        public boolean canRedo() {
            return this.rowIndex >= 0 && this.columnIndex >= 0 && this.baseEdit.canRedo();
        }

        public boolean canUndo() {
            return this.rowIndex >= 0 && this.columnIndex >= 0 && this.baseEdit.canUndo();
        }

        public void die() {
            this.baseEdit.die();
        }

        public String getPresentationName() {
            return this.baseEdit.getPresentationName();
        }

        public String getRedoPresentationName() {
            return this.baseEdit.getRedoPresentationName();
        }

        public String getUndoPresentationName() {
            return this.baseEdit.getUndoPresentationName();
        }

        public boolean isSignificant() {
            return this.baseEdit.isSignificant();
        }

        public void redo() {
            boolean proceed = this.rowIndex == View.this.getEditingRow() && this.columnIndex == View.this.getEditingColumn() ? true : View.this.editCellAt(this.rowIndex, this.columnIndex);
            if (proceed) {
                this.baseEdit.redo();
            }
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            return this.baseEdit.replaceEdit(anEdit);
        }

        public void undo() {
            boolean proceed = this.rowIndex == View.this.getEditingRow() && this.columnIndex == View.this.getEditingColumn() ? true : View.this.editCellAt(this.rowIndex, this.columnIndex);
            if (proceed) {
                this.baseEdit.undo();
            }
        }
    }

    public static interface SelectionListener {
        public void selectionMayHaveChanged(boolean var1);
    }

    public static interface SizeChangedListener {
        public void sizeChanged();
    }

    public class CellEditor
    extends DefaultCellEditor {
        ViewFormat format;

        public CellEditor(JTextField prototype, ViewFormat aFormat) {
            super(prototype);
            this.format = aFormat;
        }

        public CellEditor(JCheckBox prototype, ViewFormat aFormat) {
            super(prototype);
            this.format = aFormat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex) {
            if (!((ViewModel)View.this.getModel()).isLabelColumn(columnIndex)) {
                Map map = View.this.highlights;
                synchronized (map) {
                    TableCellIndex cell = new TableCellIndex(rowIndex, columnIndex);
                    ViewFormat.HighlightCell hc = (ViewFormat.HighlightCell)View.this.highlights.get(cell);
                    this.format.clearEditorPrototypeHighlight();
                    if (hc != null) {
                        this.format.setEditorPrototypeHighlight(hc);
                    }
                }
            }
            JComponent component = this.format.getEditorPrototype();
            View.this.setBorderSelected(component);
            View.this.fireSelectionMayHaveChanged(true);
            this.format.setEditorPrototypeValue(value);
            return component;
        }

        public Object getCellEditorValue() {
            return this.format.getEditorPrototypeValue();
        }

        public boolean stopCellEditing() {
            String errorMessage = this.format.checkEditorPrototypeValidity();
            if (errorMessage != null) {
                this.format.setEditorPrototypeError(true);
                View.this.messageBoard.showMessage(errorMessage);
                return false;
            }
            this.format.setEditorPrototypeError(false);
            View.this.messageBoard.showMessage("");
            return super.stopCellEditing();
        }

        public void cancelCellEditing() {
            View.this.messageBoard.showMessage("");
            super.cancelCellEditing();
        }
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            ViewFormat columnFormat = (ViewFormat)View.this.columnFormats.get(columnIndex);
            JComponent component = columnFormat.getRendererPrototype();
            columnFormat.setRendererPrototypeValue(value, isSelected);
            if (!((ViewModel)View.this.getModel()).isLabelColumn(columnIndex)) {
                Map map = View.this.highlights;
                synchronized (map) {
                    TableCellIndex cell = new TableCellIndex(rowIndex, columnIndex);
                    ViewFormat.HighlightCell hc = (ViewFormat.HighlightCell)View.this.highlights.get(cell);
                    columnFormat.clearRendererPrototypeHighlight();
                    if (hc != null) {
                        columnFormat.setRendererPrototypeHighlight(hc);
                    }
                }
                if (View.this.isCellEditable(rowIndex, columnIndex) && columnFormat.checkRendererPrototypeValidity() != null) {
                    columnFormat.setRendererPrototypeError(true);
                }
            }
            View.this.fireSelectionMayHaveChanged(isSelected);
            return component;
        }
    }

    public static interface AccessListener {
        public void access(Type var1, int var2, int var3, int var4);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            READ,
            WRITE,
            CURSOR_SET;


            static Type valueOf(DataModelEvent.Type t) {
                switch (t) {
                    case READ: {
                        return READ;
                    }
                    case WRITE: {
                        return WRITE;
                    }
                    case CURSOR_SET: {
                        return CURSOR_SET;
                    }
                }
                return null;
            }
        }
    }
}

