/*
 * Decompiled with CFR 0.152.
 */
package ui;

import isa.Memory;
import isa.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.SortedSet;
import java.util.TreeSet;
import machine.AbstractCPU;
import machine.AbstractMainMemory;
import machine.Register;
import machine.RegisterSet;
import util.DataModel;
import util.DataModelEvent;
import util.TableCellIndex;
import util.UserVisibleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Machine
extends Observable
implements Observer {
    private final AbstractCPU cpu;
    public final RegisterSet registerFile;
    public final AbstractMainMemory mainMemory;
    public final DataModel pc;
    public final List<RegisterSet> processorState;
    public final String curInsAddrRegName;
    public final Memory memory;
    public final String options;
    private boolean isRunning = false;
    private int pauseMilliseconds = 0;
    private boolean isFirstInstruction;
    private boolean isSingleStepEnabled;
    private boolean isAtBreakPoint;
    private boolean isAtEndOfSingleStep;
    private Status status;
    private DebugPointSetObservable debugPointSetObservable = new DebugPointSetObservable();
    private DebugPointMonitor debugPointMonitor;
    private EnumMap<DebugType, EnumMap<DebugPoint, SortedSet<Integer>>> debugPointSet = new EnumMap(DebugType.class);
    private int prevInsAddr;
    Thread pausedThread;

    public Machine(AbstractCPU aCPU, Memory aMemory, String anOptions) {
        for (DebugType type : DebugType.values()) {
            this.debugPointSet.put(type, new EnumMap(DebugPoint.class));
            for (DebugPoint point : DebugPoint.values()) {
                this.debugPointSet.get((Object)type).put(point, new TreeSet());
            }
        }
        this.pausedThread = null;
        this.cpu = aCPU;
        this.registerFile = this.cpu.getRegisterFile();
        this.mainMemory = this.cpu.getMainMemory();
        this.pc = this.cpu.getPC();
        this.processorState = this.cpu.getProcessorState();
        this.curInsAddrRegName = "CurrentInstructionAddress";
        this.memory = aMemory;
        this.options = anOptions;
        this.cpu.addObserver(this);
        this.cpu.getRegisterFile().addObserver(this);
        this.cpu.getMainMemory().addObserver(this);
        this.debugPointMonitor = new DebugPointMonitor();
    }

    public static Machine newInstance(Machine aMachine) {
        AbstractCPU newCPU = AbstractCPU.newInstance(aMachine.cpu);
        Memory newMemory = new Memory(aMachine.memory, (DataModel)newCPU.getMainMemory(), newCPU.getPC());
        return new Machine(newCPU, newMemory, aMachine.options);
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(boolean isSingleStep, int aMilliseconds) {
        try {
            this.isRunning = true;
            this.isSingleStepEnabled = isSingleStep;
            this.isFirstInstruction = true;
            this.isAtBreakPoint = false;
            this.isAtEndOfSingleStep = false;
            this.pauseMilliseconds = aMilliseconds;
            this.cpu.start();
            if (this.isAtEndOfSingleStep) {
                this.status = Status.SINGLE_STEP;
                String string = "";
                return string;
            }
            if (this.isAtBreakPoint) {
                this.status = Status.BREAK_POINT;
                String string = "";
                return string;
            }
            this.status = Status.INTERRUPT;
            String string = String.format("Stopped at pc 0x%x\n", (Integer)this.pc.getValueAt(0, 1));
            return string;
        }
        catch (UserVisibleException e) {
            this.status = e instanceof AbstractCPU.MachineHaltException ? Status.HALT : (e instanceof AbstractCPU.InvalidInstructionException ? Status.INVALID_INSTRUCTION : (e instanceof AbstractMainMemory.InvalidAddressException ? Status.INVALID_ADDRESS : (e instanceof Register.TimingException ? Status.REGISTER_TIMING_ERROR : Status.IMPLEMENTATION_ERROR)));
            String string = e.getMessage();
            return string;
        }
        finally {
            this.isRunning = false;
        }
    }

    public int getPauseMilliseconds() {
        return this.pauseMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPauseMilliseconds(int aMilliseconds) {
        Machine machine = this;
        synchronized (machine) {
            this.pauseMilliseconds = aMilliseconds;
            this.notifyAll();
        }
    }

    public String getName() {
        return this.cpu.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Machine machine = this;
        synchronized (machine) {
            this.cpu.triggerInterrupt();
            if (this.pausedThread != null) {
                this.pausedThread.interrupt();
            }
            this.notifyAll();
        }
    }

    public void gotoPC(int anAddress) {
        this.cpu.setPC(anAddress);
    }

    public Integer getFirstInstructionAddress() {
        Integer startPC = null;
        for (Region r : this.memory.getRegions()) {
            if (r.getType() != Region.Type.INSTRUCTIONS) continue;
            startPC = r.getAddress();
            break;
        }
        return startPC;
    }

    private Register findRegInList(List<RegisterSet> rsl, String regName) {
        for (RegisterSet rs : rsl) {
            Register r = rs.getRegister(regName);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public EnumSet<ComparisonFailure> compareTo(Machine anotherMachine, List<String> checkedState) {
        EnumSet<ComparisonFailure> cmp = EnumSet.noneOf(ComparisonFailure.class);
        if (!this.registerFile.valueEquals(anotherMachine.registerFile)) {
            cmp.add(ComparisonFailure.REGISTER_FILE_MISMATCH);
        }
        if (!this.memory.valueEquals(anotherMachine.memory)) {
            cmp.add(ComparisonFailure.MAIN_MEMORY_MISMATCH);
        }
        for (String state : checkedState) {
            Register aReg = this.findRegInList(this.processorState, state);
            Register bReg = this.findRegInList(anotherMachine.processorState, state);
            if (aReg == null && bReg == null || aReg != null && bReg != null && aReg.valueEquals(bReg)) continue;
            cmp.add(ComparisonFailure.PROCESSOR_STATE_MISMATCH);
            break;
        }
        return cmp;
    }

    public boolean isDebugPointEnabled(DebugType debugType, DebugPoint debugPoint, int value) {
        SortedSet<Integer> dpSet = this.debugPointSet.get((Object)debugType).get((Object)debugPoint);
        return dpSet.contains(value);
    }

    public void setDebugPoint(DebugType debugType, DebugPoint debugPoint, int value, boolean isEnabled) {
        SortedSet<Integer> dpSet = this.debugPointSet.get((Object)debugType).get((Object)debugPoint);
        if (isEnabled) {
            dpSet.add(value);
        } else {
            dpSet.remove(value);
        }
        this.debugPointSetObservable.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, value, 0));
    }

    public void clearAllDebugPoints(DebugType debugType) {
        ArrayList<TableCellIndex> bpList = new ArrayList<TableCellIndex>();
        for (SortedSet<Integer> dpSet : this.debugPointSet.get((Object)debugType).values()) {
            for (Integer adr : dpSet) {
                bpList.add(new TableCellIndex(adr, 0));
            }
            dpSet.clear();
        }
        this.debugPointSetObservable.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, bpList));
    }

    public Collection<Integer> getDebugPoints(DebugType type, DebugPoint point) {
        return this.debugPointSet.get((Object)type).get((Object)point);
    }

    public void addDebugPointObserver(Observer o) {
        this.debugPointSetObservable.addObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        block21: {
            if (this.isRunning) {
                try {
                    this.isRunning = false;
                    if (o == this.cpu) {
                        if (!this.isFirstInstruction && this.isSingleStepEnabled) {
                            this.isAtEndOfSingleStep = true;
                            this.cpu.triggerInterrupt();
                        } else if (!this.isFirstInstruction && this.debugPointSet.get((Object)DebugType.BREAK).get((Object)DebugPoint.INSTRUCTION).contains(this.pc.getValueAt(0, 1))) {
                            this.setChanged();
                            this.notifyObservers(new DebugEvent(DebugType.BREAK, DebugPoint.INSTRUCTION, (Integer)this.pc.getValueAt(0, 1)));
                            this.isAtBreakPoint = true;
                            this.cpu.triggerInterrupt();
                        } else if (!this.isFirstInstruction && !this.isSingleStepEnabled) {
                            this.pausedThread = Thread.currentThread();
                            try {
                                Thread.sleep(this.pauseMilliseconds);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            this.pausedThread = null;
                        }
                        if (!this.cpu.isInterrupt()) {
                            this.setChanged();
                            this.notifyObservers(new Event(EventType.INSTRUCTION_PROLOG));
                            if (!this.isFirstInstruction && this.debugPointSet.get((Object)DebugType.TRACE).get((Object)DebugPoint.INSTRUCTION).contains(this.prevInsAddr)) {
                                this.setChanged();
                                this.notifyObservers(new DebugEvent(DebugType.TRACE, DebugPoint.INSTRUCTION, (Integer)this.pc.getValueAt(0, 1)));
                            }
                        }
                        this.prevInsAddr = (Integer)this.pc.getValueAt(0, 1);
                        this.isFirstInstruction = false;
                        break block21;
                    }
                    if (o == this.cpu.getRegisterFile()) {
                        DebugPoint access;
                        DataModelEvent event = (DataModelEvent)arg;
                        int regNum = event.getRowIndex();
                        DebugPoint debugPoint = access = event.getType() == DataModelEvent.Type.READ ? DebugPoint.REGISTER_READ : DebugPoint.REGISTER_WRITE;
                        if (this.debugPointSet.get((Object)DebugType.TRACE).get((Object)access).contains(regNum)) {
                            this.setChanged();
                            this.notifyObservers(new DebugEvent(DebugType.TRACE, access, regNum));
                        }
                        if (this.debugPointSet.get((Object)DebugType.BREAK).get((Object)access).contains(regNum)) {
                            this.setChanged();
                            this.notifyObservers(new DebugEvent(DebugType.BREAK, access, regNum));
                            this.isAtBreakPoint = true;
                            this.cpu.triggerInterrupt();
                        }
                    } else if (o == this.cpu.getMainMemory()) {
                        DebugPoint access;
                        DataModelEvent event = (DataModelEvent)arg;
                        int memAddr = event.getCells().get((int)0).rowIndex;
                        DebugPoint debugPoint = access = event.getType() == DataModelEvent.Type.READ ? DebugPoint.MEMORY_READ : DebugPoint.MEMORY_WRITE;
                        if (this.debugPointSet.get((Object)DebugType.TRACE).get((Object)access).contains(memAddr)) {
                            this.setChanged();
                            this.notifyObservers(new DebugEvent(DebugType.TRACE, access, memAddr));
                        }
                        if (this.debugPointSet.get((Object)DebugType.BREAK).get((Object)access).contains(memAddr)) {
                            this.setChanged();
                            this.notifyObservers(new DebugEvent(DebugType.BREAK, access, memAddr));
                            this.isAtBreakPoint = true;
                            this.cpu.triggerInterrupt();
                        }
                    }
                }
                finally {
                    this.isRunning = true;
                }
            }
        }
    }

    private class DebugPointMonitor
    implements Memory.LengthChangedListener {
        DebugPointMonitor() {
            Machine.this.memory.addLengthChangedListener(this);
        }

        public void changed(int address, int length, int lastAddress, Memory.LengthChangedListener.Type type) {
            for (EnumMap dType : Machine.this.debugPointSet.values()) {
                for (SortedSet dPoint : dType.values()) {
                    ArrayList<Integer> chg = new ArrayList<Integer>();
                    for (Integer dAdr : dPoint) {
                        if (dAdr < address || dAdr > lastAddress) continue;
                        chg.add(dAdr);
                    }
                    for (Integer dAdr : chg) {
                        dPoint.remove(dAdr);
                    }
                    for (Integer dAdr : chg) {
                        if (type == Memory.LengthChangedListener.Type.DELETED) {
                            if (dAdr <= address) continue;
                            dPoint.add(dAdr - length);
                            continue;
                        }
                        if (type == Memory.LengthChangedListener.Type.INSERTED) {
                            dPoint.add(dAdr + length);
                            continue;
                        }
                        throw new AssertionError((Object)type);
                    }
                }
            }
        }
    }

    private class DebugPointSetObservable
    extends Observable {
        private DebugPointSetObservable() {
        }

        void tellObservers(DataModelEvent event) {
            this.setChanged();
            this.notifyObservers(event);
        }
    }

    public class DebugEvent
    extends Event {
        public final DebugType debugType;
        public final DebugPoint point;
        public final int value;

        public DebugEvent(DebugType aDebugType, DebugPoint aPoint, int aValue) {
            super(EventType.TRACE_POINT);
            this.debugType = aDebugType;
            this.point = aPoint;
            this.value = aValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugPoint {
        INSTRUCTION,
        MEMORY_READ,
        MEMORY_WRITE,
        REGISTER_READ,
        REGISTER_WRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugType {
        BREAK,
        TRACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComparisonFailure {
        REGISTER_FILE_MISMATCH,
        PROCESSOR_STATE_MISMATCH,
        MAIN_MEMORY_MISMATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        INTERRUPT,
        SINGLE_STEP,
        BREAK_POINT,
        HALT,
        INVALID_ADDRESS,
        INVALID_INSTRUCTION,
        REGISTER_TIMING_ERROR,
        IMPLEMENTATION_ERROR;

    }

    public class Event {
        public final EventType type;

        public Event(EventType aType) {
            this.type = aType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        INSTRUCTION_PROLOG,
        TRACE_POINT;

    }
}

